/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config.tasks;

import com.sun.portal.config.context.DebugContext;
import com.sun.portal.config.context.GWWindowsFileContext;
import com.sun.portal.config.context.SRAFileContext;
import com.sun.portal.config.context.SRAPropertyContext;
import com.sun.portal.config.tasks.GWTasks;
import com.sun.portal.config.tasks.GWTasksImpl;
import com.sun.portal.config.tasks.SRAWindowsTasks;
import java.io.IOException;

public class GWWindowsTasks
extends GWTasksImpl
implements GWTasks {
    public GWWindowsTasks() {
    }

    public GWWindowsTasks(SRAPropertyContext sRAPropertyContext, SRAFileContext sRAFileContext) {
        super(sRAPropertyContext, sRAFileContext);
    }

    public Boolean createLoggingUserAuthenticationEntry() {
        return new SRAWindowsTasks(this.pc, this.fc).createLoggingUserAuthenticationEntry();
    }

    public Boolean createSelfSignedCertificate() {
        return new SRAWindowsTasks(this.pc, this.fc).createSelfSignedCertificate();
    }

    protected Boolean createInstanceWindowsService() {
        Boolean bl = Boolean.TRUE;
        GWWindowsFileContext gWWindowsFileContext = (GWWindowsFileContext)this.fc;
        try {
            int n = this.exec(gWWindowsFileContext.getInstanceInstallCmdFile());
            if (n != 0) {
                DebugContext.error("Install gateway instance Windows service command returned <" + n + ">");
                bl = Boolean.FALSE;
            } else {
                DebugContext.message("Installed gateway instance Windows service.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            DebugContext.error("Confiugration Error: Could not install gateway instance Windows service!");
            bl = Boolean.FALSE;
        }
        return bl;
    }

    public Boolean createInstanceSignature() {
        Boolean bl = Boolean.TRUE;
        GWWindowsFileContext gWWindowsFileContext = (GWWindowsFileContext)this.fc;
        Boolean bl2 = this.fc.existsGWInstance(this.pc.getInstanceName()) != false || this.fc.existsNLPInstance(this.pc.getInstanceName()) != false || this.fc.existsRWPInstance(this.pc.getInstanceName()) != false ? Boolean.FALSE : Boolean.TRUE;
        this.copyFile(gWWindowsFileContext.getTemplateEnvSetupFile(), gWWindowsFileContext.getEnvSetupFile(), bl2);
        new SRAWindowsTasks(this.pc, this.fc).createSRAIMCmdFile();
        this.copyFile(gWWindowsFileContext.getTemplateInstanceEnvSetupFile(), gWWindowsFileContext.getInstanceEnvSetupFile(), Boolean.TRUE);
        this.copyFile(gWWindowsFileContext.getTemplateCmdFile(), gWWindowsFileContext.getInstanceCmdFile(), Boolean.TRUE);
        this.copyFile(gWWindowsFileContext.getTemplateInstallCmdFile(), gWWindowsFileContext.getInstanceInstallCmdFile(), Boolean.TRUE);
        this.copyFile(gWWindowsFileContext.getTemplateUninstallCmdFile(), gWWindowsFileContext.getInstanceUninstallCmdFile(), Boolean.TRUE);
        this.copyFile(gWWindowsFileContext.getTemplateStartCmdFile(), gWWindowsFileContext.getInstanceStartCmdFile(), Boolean.TRUE);
        this.copyFile(gWWindowsFileContext.getTemplateStopCmdFile(), gWWindowsFileContext.getInstanceStopCmdFile(), Boolean.TRUE);
        new SRAWindowsTasks(this.pc, this.fc).createCertAdminCmdFile();
        String[][] stringArray = new String[][]{{"JAVA_HOME_TOKEN", this.replaceBackSlash(this.fc.getJavaHome())}, {"SRA_HOME_TOKEN", this.pc.getInstallDirectory()}, {"IDENTITY_HOME_TOKEN", this.pc.getIdentityInstallDirectory()}, {"SRA_INSTANCE_TOKEN", this.pc.getInstanceName()}, {"PROTOCOL_TOKEN", this.pc.getProtocol()}, {"HOSTNAME_TOKEN", this.pc.getHost()}, {"PORT_TOKEN", this.pc.getPort()}};
        try {
            this.replaceTokens(gWWindowsFileContext.getEnvSetupFile(), stringArray);
            this.replaceTokens(gWWindowsFileContext.getInstanceEnvSetupFile(), stringArray);
            this.replaceTokens(gWWindowsFileContext.getInstanceCmdFile(), stringArray);
            this.replaceTokens(gWWindowsFileContext.getInstanceInstallCmdFile(), stringArray);
            this.replaceTokens(gWWindowsFileContext.getInstanceUninstallCmdFile(), stringArray);
            this.replaceTokens(gWWindowsFileContext.getInstanceStartCmdFile(), stringArray);
            this.replaceTokens(gWWindowsFileContext.getInstanceStopCmdFile(), stringArray);
            this.addToWindowsRegistry();
            if (this.pc.doStartAtSystemBoot().booleanValue()) {
                bl = this.createInstanceWindowsService();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = Boolean.FALSE;
        }
        return bl;
    }

    protected Boolean startInstance() {
        Boolean bl = Boolean.TRUE;
        GWWindowsFileContext gWWindowsFileContext = (GWWindowsFileContext)this.fc;
        try {
            int n = this.exec(gWWindowsFileContext.getInstanceStartCmdFile());
            if (n != 0) {
                DebugContext.error("Start gateway instance command returned <" + n + ">");
                bl = Boolean.FALSE;
            } else {
                DebugContext.message("Started gateway instance.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            DebugContext.error("Confiugration Error: Could not start gateway instance!");
            bl = Boolean.FALSE;
        }
        return bl;
    }

    public Boolean startGateway() {
        return this.startInstance();
    }

    protected Boolean removeInstanceWindowsService() {
        Boolean bl = Boolean.TRUE;
        GWWindowsFileContext gWWindowsFileContext = (GWWindowsFileContext)this.fc;
        try {
            int n = this.exec(gWWindowsFileContext.getInstanceUninstallCmdFile());
            if (n != 0) {
                DebugContext.error("Uninstall gateway instance Windows service command returned <" + n + ">");
                bl = Boolean.FALSE;
            } else {
                DebugContext.message("Uninstalled gateway instance Windows service.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            DebugContext.error("Confiugration Error: Could not Uninstall gateway instance Windows service!");
            bl = Boolean.FALSE;
        }
        return bl;
    }

    public Boolean stopGateway() {
        return this.removeInstanceWindowsService();
    }

    public Boolean removeInstanceSignature() {
        Boolean bl;
        Boolean bl2 = Boolean.TRUE;
        GWWindowsFileContext gWWindowsFileContext = (GWWindowsFileContext)this.fc;
        this.removeFromWindowsRegistry();
        this.removeFile(gWWindowsFileContext.getInstanceStopCmdFile());
        this.removeFile(gWWindowsFileContext.getInstanceStartCmdFile());
        this.removeFile(gWWindowsFileContext.getInstanceUninstallCmdFile());
        this.removeFile(gWWindowsFileContext.getInstanceInstallCmdFile());
        this.removeFile(gWWindowsFileContext.getInstanceCmdFile());
        this.removeFile(gWWindowsFileContext.getInstanceEnvSetupFile());
        this.removeFile(gWWindowsFileContext.getInstanceGWConfigurationPropertiesFile());
        if (!this.fc.existsRWPInstance(this.pc.getInstanceName()).booleanValue() && !this.fc.existsNLPInstance(this.pc.getInstanceName()).booleanValue()) {
            this.removeDirectory(this.fc.getInstanceDirectory());
        }
        String[] stringArray = this.fc.getGWInstanceNames();
        String[] stringArray2 = this.fc.getRWPInstanceNames();
        String[] stringArray3 = this.fc.getNLPInstanceNames();
        Boolean bl3 = bl = stringArray == null && stringArray2 == null && stringArray3 == null ? Boolean.TRUE : Boolean.FALSE;
        if (bl.booleanValue()) {
            this.removeFile(gWWindowsFileContext.getEnvSetupFile());
            this.removeFile(gWWindowsFileContext.getSRAIMFile());
        }
        return bl2;
    }

    protected Boolean addToWindowsRegistry() {
        Boolean bl = Boolean.TRUE;
        GWWindowsFileContext gWWindowsFileContext = (GWWindowsFileContext)this.fc;
        SRAWindowsTasks sRAWindowsTasks = new SRAWindowsTasks(this.pc, this.fc);
        sRAWindowsTasks.addToWindowsRegistry(gWWindowsFileContext.getInstanceCmdFile(), this.pc.getInstallDirectory());
        sRAWindowsTasks.addToWindowsRegistry(gWWindowsFileContext.getInstanceInstallCmdFile(), this.pc.getInstallDirectory());
        sRAWindowsTasks.addToWindowsRegistry(gWWindowsFileContext.getInstanceUninstallCmdFile(), this.pc.getInstallDirectory());
        sRAWindowsTasks.addToWindowsRegistry(gWWindowsFileContext.getInstanceStartCmdFile(), this.pc.getInstallDirectory());
        sRAWindowsTasks.addToWindowsRegistry(gWWindowsFileContext.getInstanceStopCmdFile(), this.pc.getInstallDirectory());
        if (!this.fc.existsRWPInstance(this.pc.getInstanceName()).booleanValue() && !this.fc.existsNLPInstance(this.pc.getInstanceName()).booleanValue()) {
            sRAWindowsTasks.addToWindowsRegistry(gWWindowsFileContext.getInstanceCertAdminCmdFile(), this.pc.getInstallDirectory());
        }
        if (sRAWindowsTasks.doUpdateWindowsRegistryForSRAIMCmd().booleanValue()) {
            sRAWindowsTasks.addToWindowsRegistry(gWWindowsFileContext.getSRAIMFile(), this.pc.getInstallDirectory());
        }
        return bl;
    }

    protected Boolean removeFromWindowsRegistry() {
        Boolean bl = Boolean.TRUE;
        GWWindowsFileContext gWWindowsFileContext = (GWWindowsFileContext)this.fc;
        SRAWindowsTasks sRAWindowsTasks = new SRAWindowsTasks(this.pc, this.fc);
        sRAWindowsTasks.removeFromWindowsRegistry(gWWindowsFileContext.getInstanceCmdFile());
        sRAWindowsTasks.removeFromWindowsRegistry(gWWindowsFileContext.getInstanceInstallCmdFile());
        sRAWindowsTasks.removeFromWindowsRegistry(gWWindowsFileContext.getInstanceUninstallCmdFile());
        sRAWindowsTasks.removeFromWindowsRegistry(gWWindowsFileContext.getInstanceStartCmdFile());
        sRAWindowsTasks.removeFromWindowsRegistry(gWWindowsFileContext.getInstanceStopCmdFile());
        if (!this.fc.existsRWPInstance(this.pc.getInstanceName()).booleanValue() && !this.fc.existsNLPInstance(this.pc.getInstanceName()).booleanValue()) {
            sRAWindowsTasks.removeFromWindowsRegistry(gWWindowsFileContext.getInstanceCertAdminCmdFile());
        }
        if (sRAWindowsTasks.doUpdateWindowsRegistryForSRAIMCmd().booleanValue()) {
            sRAWindowsTasks.removeFromWindowsRegistry(gWWindowsFileContext.getSRAIMFile());
        }
        return bl;
    }
}

