/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config.context;

import com.sun.portal.config.context.ConfigurationFileFilter;
import com.sun.portal.config.context.DebugContext;
import com.sun.portal.config.context.IdentityPropertyContext;
import com.sun.portal.config.context.IdentityPropertyContextImpl;
import com.sun.portal.config.context.SRAFileContext;
import com.sun.portal.config.context.SRAPropertyContext;
import com.sun.portal.config.tasks.TasksImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class SRAWindowsFileContext
implements SRAFileContext {
    protected SRAPropertyContext pc = null;
    protected static final String GW_CONFIG_FILE_PREFIX = "GWConfig";
    protected static final String RWP_CONFIG_FILE_PREFIX = "RWPConfig";
    protected static final String NLP_CONFIG_FILE_PREFIX = "NLPConfig";
    protected static final String DOT_PROPERTIES = ".properties";
    protected static final String DOT_TEMPLATE = ".template";
    protected static final String PLATFORM_CONFIGURATION_FILE_PREFIX = "platform";
    protected static final String DOT_CONF = ".conf";
    protected static final String TEMPLATE_PLATFORM_CONFIGURATION_FILE = "platform.conf-orig";
    protected static final String IDENTITY_PROPERTIES_FILE_NAME = "AMConfig";
    protected static final String TEMPLATE_IDENTITY_PROPERTIES_FILE = "AMConfig.properties.template";
    protected static final String LOGGING_USER_AUTHENTICATION_FILE_PREFIX = ".auth_password";
    protected static final String CERTIFICATES_DIRECTORY = "certificates";
    protected static final String DOT_CMD = ".cmd";
    protected static final String DOT_CMD_DOT_TEMPLATE = ".cmd.template";
    protected static final String ENV_SETUP = "envSetup";
    protected static final String SRA_IM = "sraIM";
    protected static final String DOT_INSTANCE = ".instance";
    protected static final String DOT_INSTALL = ".install";
    protected static final String DOT_UNINSTALL = ".uninstall";
    protected static final String DOT_START = ".start";
    protected static final String DOT_STOP = ".stop";
    protected static final String CERTADMIN_CMD_FILE_PREFIX = "certadmin";
    protected static final String TEMPLATE_CERTADMIN_CMD_FILE = "certadmin.cmd.template";
    protected static final String JSS_DIRECTORY = "jss";
    protected static final String ROOT_CA_CERTIFICATES_FILE = "nssckbi.dll";
    protected static final String JSS_NSS_NSPR_CLASSPATH = "lib/jss311.jar";
    protected static final String JSS_NSS_NSPR_PATH = "lib/jss";

    public SRAWindowsFileContext(SRAPropertyContext sRAPropertyContext) {
        this.pc = sRAPropertyContext;
    }

    public final String getTemplateEnvSetupFile() {
        return this.pc.getInstallDirectory() + "/" + "templates" + "/" + ENV_SETUP + DOT_CMD_DOT_TEMPLATE;
    }

    public final String getEnvSetupFile() {
        return this.pc.getInstallDirectory() + "/" + ENV_SETUP + DOT_CMD;
    }

    public final String getTemplateSRAIMFile() {
        return this.pc.getInstallDirectory() + "/" + "templates" + "/" + SRA_IM + DOT_CMD_DOT_TEMPLATE;
    }

    public final String getSRAIMFile() {
        return this.pc.getInstallDirectory() + "/" + SRA_IM + DOT_CMD;
    }

    public String getConfigurationDirectory() {
        return this.pc.getInstallDirectory() + "/" + "config";
    }

    public String getGWConfigurationPropertiesFile() {
        return this.pc.getInstallDirectory() + "/" + GW_CONFIG_FILE_PREFIX + DOT_PROPERTIES;
    }

    public String getRWPConfigurationPropertiesFile() {
        return this.pc.getInstallDirectory() + "/" + RWP_CONFIG_FILE_PREFIX + DOT_PROPERTIES;
    }

    public String getNLPConfigurationPropertiesFile() {
        return this.pc.getInstallDirectory() + "/" + NLP_CONFIG_FILE_PREFIX + DOT_PROPERTIES;
    }

    public String getInstanceGWConfigurationPropertiesFile() {
        return this.getConfigurationDirectory() + "/" + GW_CONFIG_FILE_PREFIX + "-" + this.pc.getInstanceName() + DOT_PROPERTIES;
    }

    public String getInstanceRWPConfigurationPropertiesFile() {
        return this.getConfigurationDirectory() + "/" + RWP_CONFIG_FILE_PREFIX + "-" + this.pc.getInstanceName() + DOT_PROPERTIES;
    }

    public String getInstanceNLPConfigurationPropertiesFile() {
        return this.getConfigurationDirectory() + "/" + NLP_CONFIG_FILE_PREFIX + "-" + this.pc.getInstanceName() + DOT_PROPERTIES;
    }

    public String getTemplatesDirectory() {
        return this.pc.getInstallDirectory() + "/" + "templates";
    }

    public String getInstanceDirectory() {
        return this.pc.getInstallDirectory() + "/" + this.pc.getInstanceName();
    }

    public String getTemplatePlatformConfigurationFile() {
        return this.getTemplatesDirectory() + "/" + TEMPLATE_PLATFORM_CONFIGURATION_FILE;
    }

    public String getInstancePlatformConfigurationFile() {
        return this.getInstanceDirectory() + "/" + PLATFORM_CONFIGURATION_FILE_PREFIX + DOT_CONF + "." + this.pc.getInstanceName();
    }

    public String getDefaultIdentityPropertiesFile() {
        return this.pc.getIdentityInstallDirectory() + "/" + "lib" + "/" + IDENTITY_PROPERTIES_FILE_NAME + DOT_PROPERTIES;
    }

    public String getTemplateIdentityPropertiesFile() {
        return this.pc.getIdentityInstallDirectory() + "/" + "lib" + "/" + TEMPLATE_IDENTITY_PROPERTIES_FILE;
    }

    public String getInstanceIdentityPropertiesFile() {
        return this.pc.getIdentityInstallDirectory() + "/" + "lib" + "/" + IDENTITY_PROPERTIES_FILE_NAME + "-" + this.pc.getInstanceName() + DOT_PROPERTIES;
    }

    public String getInstanceDebugDirectory() {
        return this.getInstanceDirectory() + "/" + "debug";
    }

    public String getInstanceLoggingUserAuthenticationFile() {
        return this.getInstanceDirectory() + "/" + LOGGING_USER_AUTHENTICATION_FILE_PREFIX + "." + this.pc.getInstanceName();
    }

    public String getInstanceCertificatesDirectory() {
        return this.getInstanceDirectory() + "/" + CERTIFICATES_DIRECTORY;
    }

    public String getSourceRootCACertificatesFile() {
        return this.pc.getIdentityInstallDirectory() + "/" + "lib" + "/" + JSS_DIRECTORY + "/" + ROOT_CA_CERTIFICATES_FILE;
    }

    public String getDestinationRootCACertificatesFile() {
        return this.getInstanceCertificatesDirectory() + "/" + ROOT_CA_CERTIFICATES_FILE;
    }

    public String getCreateSelfSignedCertificateLibraryPath() {
        String string = this.pc.getIdentityInstallDirectory() + "/" + JSS_NSS_NSPR_PATH;
        String string2 = this.pc.getInstallDirectory() + "/" + "lib";
        return string2 + File.pathSeparator + string;
    }

    public String getCreateSelfSignedCertificatePath() {
        return this.getCreateSelfSignedCertificateLibraryPath();
    }

    public String getJARLocation() {
        return this.pc.getInstallDirectory() + "/" + "lib";
    }

    public String getLocaleLocation() {
        return this.pc.getInstallDirectory() + "/" + "locale";
    }

    public String getJSSJARFile() {
        return this.pc.getIdentityInstallDirectory() + "/" + JSS_NSS_NSPR_CLASSPATH;
    }

    public String getCreateSelfSignedCertificateClassPath() {
        String string = null;
        String string2 = this.getJARLocation();
        String string3 = this.getLocaleLocation();
        String string4 = this.getJSSJARFile();
        string = string2 + "/" + "certadmin.jar" + File.pathSeparator + string4 + File.pathSeparator + string2 + "/" + "jce1_2_1.jar" + File.pathSeparator + string2 + "/" + "sunjce_provider.jar" + File.pathSeparator + string2 + "/" + "local_policy.jar" + File.pathSeparator + string2 + "/" + "US_export_policy.jar" + File.pathSeparator + string3;
        return string;
    }

    public final String getJavaHome() {
        return System.getProperty("java.home");
    }

    private void print(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            DebugContext.message(i + " = " + arrayList.get(i));
        }
    }

    protected String[] getInstanceNames(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(this.getConfigurationDirectory());
        File[] fileArray = file.listFiles(new ConfigurationFileFilter(string, string2));
        if (fileArray != null && fileArray.length != 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string3 = fileArray[i].getName();
                string3 = string3.substring(string.length(), string3.lastIndexOf(string2));
                arrayList.add(string3);
            }
            this.print(arrayList);
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getGWInstanceNames() {
        return this.getInstanceNames("GWConfig-", DOT_PROPERTIES);
    }

    public String[] getRWPInstanceNames() {
        return this.getInstanceNames("RWPConfig-", DOT_PROPERTIES);
    }

    public String[] getNLPInstanceNames() {
        return this.getInstanceNames("NLPConfig-", DOT_PROPERTIES);
    }

    protected String[] getInstanceConfigurationFiles(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(this.getConfigurationDirectory());
        File[] fileArray = file.listFiles(new ConfigurationFileFilter(string, string2));
        if (fileArray != null && fileArray.length != 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                arrayList.add(fileArray[i].getAbsolutePath());
            }
            this.print(arrayList);
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getGWInstanceConfigurationFiles() {
        return this.getInstanceConfigurationFiles("GWConfig-", DOT_PROPERTIES);
    }

    public String[] getRWPInstanceConfigurationFiles() {
        return this.getInstanceConfigurationFiles("RWPConfig-", DOT_PROPERTIES);
    }

    public String[] getNLPInstanceConfigurationFiles() {
        return this.getInstanceConfigurationFiles("NLPConfig-", DOT_PROPERTIES);
    }

    protected Boolean existsInstance(String string, String[] stringArray) {
        Boolean bl = Boolean.FALSE;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                bl = Boolean.TRUE;
                break;
            }
        }
        return bl;
    }

    public Boolean existsGWInstance(String string) {
        return this.existsInstance(string, this.getGWInstanceNames());
    }

    public Boolean existsRWPInstance(String string) {
        return this.existsInstance(string, this.getRWPInstanceNames());
    }

    public Boolean existsNLPInstance(String string) {
        return this.existsInstance(string, this.getNLPInstanceNames());
    }

    public String getTemplateCertAdminCmdFile() {
        return this.getTemplatesDirectory() + "/" + TEMPLATE_CERTADMIN_CMD_FILE;
    }

    public String getInstanceCertAdminCmdFile() {
        return this.getInstanceDirectory() + "/" + CERTADMIN_CMD_FILE_PREFIX + "." + this.pc.getInstanceName() + DOT_CMD;
    }

    protected String getInstanceConfigurationFile(String string, String string2, String string3) {
        String string4 = null;
        String[] stringArray = this.getInstanceConfigurationFiles(string, string2);
        if (stringArray == null) {
            DebugContext.message("No configuration file exists for instance <" + string3 + ">");
        } else if (stringArray.length != 1) {
            DebugContext.message("Found more than one configuration file for instance <" + string3 + ">");
            string4 = stringArray[0];
            DebugContext.message("Returning the first one <" + string4 + ">");
        } else {
            string4 = stringArray[0];
        }
        return string4;
    }

    public String getGWInstanceConfigurationFile(String string) {
        return this.getInstanceConfigurationFile("GWConfig-" + string, DOT_PROPERTIES, string);
    }

    public String getRWPInstanceConfigurationFile(String string) {
        return this.getInstanceConfigurationFile("RWPConfig-" + string, DOT_PROPERTIES, string);
    }

    public String getNLPInstanceConfigurationFile(String string) {
        return this.getInstanceConfigurationFile("NLPConfig-" + string, DOT_PROPERTIES, string);
    }

    protected String getIdentityPropertiesFile() {
        String string;
        File file;
        Boolean bl = Boolean.TRUE;
        String[] stringArray = this.getGWInstanceNames();
        String[] stringArray2 = this.getRWPInstanceNames();
        String[] stringArray3 = this.getNLPInstanceNames();
        if (stringArray != null && stringArray.length > 1) {
            bl = Boolean.FALSE;
        }
        if (bl.booleanValue() && stringArray2 != null && stringArray2.length > 1) {
            bl = Boolean.FALSE;
        }
        if (bl.booleanValue() && stringArray3 != null && stringArray3.length > 1) {
            bl = Boolean.FALSE;
        }
        if (!bl.booleanValue() && !(file = new File(string = this.getInstanceIdentityPropertiesFile())).exists()) {
            bl = Boolean.TRUE;
        }
        return bl != false ? this.getDefaultIdentityPropertiesFile() : this.getInstanceIdentityPropertiesFile();
    }

    public IdentityPropertyContext getIdentityPropertyContext() throws IOException {
        String string = this.getIdentityPropertiesFile();
        TasksImpl tasksImpl = new TasksImpl();
        Properties properties = tasksImpl.load(tasksImpl.replaceBackSlash(string));
        return new IdentityPropertyContextImpl(properties);
    }
}

