/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config.component;

import com.sun.portal.config.ConfigurationConstants;
import com.sun.portal.config.ConfigurationContext;
import com.sun.portal.config.ConfigurationException;
import com.sun.portal.config.ConfigurationInterface;
import com.sun.portal.config.util.PortalServerTasks;
import com.sun.portal.config.util.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class Yahoo_Windows
implements ConfigurationInterface,
ConfigurationConstants {
    private static String PS_SUFFIX = "";
    private static String IS_SUFFIX = "";
    private ConfigurationContext context;
    private PortalServerTasks PSTasks;

    public Yahoo_Windows(ConfigurationContext configurationContext) {
        this.context = configurationContext;
        this.PSTasks = new PortalServerTasks(configurationContext);
    }

    public void init() throws ConfigurationException {
        String string = this.context.getPSBaseDir() + PS_SUFFIX;
        if (!Util.directoryExists(string)) {
            throw new ConfigurationException(string + " doesn't exist.");
        }
    }

    public void postinstall() throws ConfigurationException {
    }

    public void isconfig() throws ConfigurationException {
        this.PSTasks.isconfig();
    }

    public void config() throws ConfigurationException {
        String[] stringArray = new String[]{"modify", "-m -u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "-g", Util.decoratePath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "yahoo" + ConfigurationConstants.fs + "dp-providers.xml")};
        Util.debug("Loading :" + stringArray[6]);
        PortalServerTasks.loadDisplayProfile(stringArray);
        stringArray = new String[]{"modify", "-m -u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "-d", this.context.getDefaultOrgDN(), Util.decoratePath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "yahoo" + ConfigurationConstants.fs + "dp-org.xml")};
        Util.debug("Loading :" + stringArray[7]);
        PortalServerTasks.loadDisplayProfile(stringArray);
    }

    public void special() throws ConfigurationException {
        String string = System.getProperty("DEPLOY_ADMIN_PASSWORD");
        if (string == null || string.equals("")) {
            string = "not_set";
            System.setProperty("DEPLOY_ADMIN_PASSWORD", string);
        }
        try {
            PortalServerTasks.redeploy(this.context.getDeployInstance());
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    public void scrubds() throws ConfigurationException {
        try {
            File file = File.createTempFile("scrubds", ".xml");
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fileWriter.write("<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\" \"file:" + this.context.getISBaseDir() + IS_SUFFIX + "/dtd/amAdmin.dtd\">\n");
            fileWriter.write("<Requests>\n");
            fileWriter.write("<OrganizationRequests DN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<DeletePolicy deleteDN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<PolicyName name=\"Ability to execute Portal Server My Yahoo! EE Provider\" />\n");
            fileWriter.write("</DeletePolicy>\n");
            fileWriter.write("</OrganizationRequests>\n");
            fileWriter.write("</Requests>\n");
            fileWriter.close();
            PortalServerTasks.loadServiceData(file);
            file.delete();
            PortalServerTasks.deleteService("SunPortalYahooService");
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
    }

    public void remove() throws ConfigurationException {
    }

    static {
        if (!Util.is_windows()) {
            PS_SUFFIX = ConfigurationConstants.fs + "SUNWps";
            IS_SUFFIX = ConfigurationConstants.fs + "SUNWam";
        }
    }
}

