/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config.component;

import com.sun.portal.config.ConfigurationConstants;
import com.sun.portal.config.ConfigurationContext;
import com.sun.portal.config.ConfigurationException;
import com.sun.portal.config.ConfigurationInterface;
import com.sun.portal.config.util.Util;

public class Wireless_SunOS_scripts
implements ConfigurationInterface,
ConfigurationConstants {
    private String name = "Mobile Access Support";
    private ConfigurationContext context;

    public Wireless_SunOS_scripts(ConfigurationContext configurationContext) {
        this.context = configurationContext;
    }

    public void init() throws ConfigurationException {
        String string = this.context.getPSBaseDir() + "/SUNWps";
        if (!Util.directoryExists(string)) {
            throw new ConfigurationException(string + " doesn't exist.");
        }
    }

    public void postinstall() throws ConfigurationException {
        try {
            Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/lib/postinstall_Wireless");
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    public void isconfig() throws ConfigurationException {
        try {
            Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/lib/isconfig");
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    public void config() throws ConfigurationException {
        try {
            Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/lib/config_Wireless");
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    public void special() throws ConfigurationException {
        String string = System.getProperty("DEPLOY_ADMIN_PASSWORD");
        if (string == null || string.equals("")) {
            string = "not_set";
        }
        if (!this.context.getDeployType().equals("WEBLOGIC") && !this.context.getDeployType().equals("WEBSPHERE")) {
            try {
                String[] stringArray = new String[]{"redeploy", "-deploy_admin_password", string};
                Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/bin/deploy", stringArray);
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception.toString());
            }
        }
    }

    public void scrubds() throws ConfigurationException {
        try {
            Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/lib/scrubds_Wireless");
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    public void remove() throws ConfigurationException {
        try {
            Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/lib/remove_Wireless");
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }
}

