/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config.component;

import com.sun.portal.config.ConfigurationConstants;
import com.sun.portal.config.ConfigurationContext;
import com.sun.portal.config.ConfigurationException;
import com.sun.portal.config.ConfigurationInterface;
import com.sun.portal.config.util.PortalServerTasks;
import com.sun.portal.config.util.Util;
import java.io.File;
import java.io.IOException;

public class SamplePortal_Windows
implements ConfigurationInterface,
ConfigurationConstants {
    private String name = "Sample Portal";
    private ConfigurationContext context;
    private PortalServerTasks PSTasks;
    private static String IS_SUFFIX = null;
    private static String PS_SUFFIX = null;
    private String PS_VAR_OPT_DIR = null;

    public SamplePortal_Windows(ConfigurationContext configurationContext) {
        this.context = configurationContext;
        this.PSTasks = new PortalServerTasks(configurationContext);
        this.PS_VAR_OPT_DIR = Util.is_windows() ? this.context.getPSBaseDir() : "/var/opt/SUNWps";
    }

    public void init() throws ConfigurationException {
        String[] stringArray = new String[]{"DEPLOY_URI", "DS_DIRMGR_DN", "DS_HOST", "DS_PORT", "IDSAME_BASEDIR", "BASEDIR"};
        if (!this.context.checkRequiredAttributes(stringArray)) {
            throw new ConfigurationException("Required Keys missing");
        }
        String string = this.context.getPSBaseDir() + PS_SUFFIX;
        if (!Util.directoryExists(string)) {
            throw new ConfigurationException(string + " doesn't exist.");
        }
    }

    public void postinstall() throws ConfigurationException {
        this.postinstallPortletSamples();
    }

    private void postinstallPortletSamples() throws ConfigurationException {
        Util.debug("Calling pdeploy for portletsamples.war");
        String string = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "config" + ConfigurationConstants.fs + "portlet" + ConfigurationConstants.fs + "userInfoMapping.properties";
        String string2 = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "portlet" + ConfigurationConstants.fs + "original" + ConfigurationConstants.fs + "portletsamples.war";
        String[] stringArray = new String[10];
        stringArray[0] = "-u";
        stringArray[1] = this.context.getAmAdminDN();
        stringArray[2] = "-w";
        stringArray[3] = this.context.getISAdminPassword();
        stringArray[4] = "-p";
        String string3 = this.context.getDeployAdminPassword();
        if (string3 == null) {
            string3 = "";
        }
        stringArray[5] = string3;
        stringArray[6] = "-g -v";
        stringArray[7] = "-f";
        stringArray[8] = Util.decoratePath(string);
        stringArray[9] = Util.decoratePath(string2);
        PortalServerTasks.pdeploy("deploy", stringArray);
    }

    public void isconfig() throws ConfigurationException {
        this.PSTasks.isconfig();
    }

    public void config() throws ConfigurationException {
        this.configSamplePortal();
        this.configPortletSamples();
    }

    private void configSamplePortal() throws ConfigurationException {
        CharSequence charSequence;
        CharSequence charSequence2;
        String[] stringArray;
        CharSequence charSequence3;
        if (Util.is_windows()) {
            Util.debug("Replace /etc/opt/SUNWps in IPS_BASEDIR/samples/desktop/dp-org.xml");
            try {
                charSequence3 = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "desktop" + ConfigurationConstants.fs + "dp-org.xml";
                stringArray = new File((String)charSequence3);
                if (stringArray.exists()) {
                    charSequence2 = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "config";
                    charSequence2 = ((String)charSequence2).replace('\\', '/');
                    Util.debug("Replacing token:/etc/opt/SUNWps with:" + (String)charSequence2);
                    Util.replaceTokenInFile((File)stringArray, "/etc/opt/SUNWps", (String)charSequence2);
                }
            }
            catch (IOException iOException) {
                throw new ConfigurationException(iOException.toString());
            }
        }
        charSequence3 = new StringBuffer();
        ((StringBuffer)charSequence3).append(Util.decoratePath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "desktop" + ConfigurationConstants.fs + "dp-org.xml") + " ");
        ((StringBuffer)charSequence3).append(Util.decoratePath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "discussions" + ConfigurationConstants.fs + "dp-org.xml") + " ");
        ((StringBuffer)charSequence3).append(Util.decoratePath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "Subscriptions" + ConfigurationConstants.fs + "dp-org.xml") + " ");
        ((StringBuffer)charSequence3).append(Util.decoratePath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "AddressBook" + ConfigurationConstants.fs + "addressBookChannels.xml") + " ");
        ((StringBuffer)charSequence3).append(Util.decoratePath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "Calendar" + ConfigurationConstants.fs + "calendarChannels.xml") + " ");
        ((StringBuffer)charSequence3).append(Util.decoratePath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "Mail" + ConfigurationConstants.fs + "mailChannels.xml") + " ");
        ((StringBuffer)charSequence3).append(Util.decoratePath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "InstantMessaging" + ConfigurationConstants.fs + "dp-IMChannel.xml"));
        stringArray = new String[]{"modify", "-m -u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "-d", this.context.getDefaultOrgDN(), ((StringBuffer)charSequence3).toString()};
        Util.debug("Loading DisplayProfiles:" + ((StringBuffer)charSequence3).toString());
        PortalServerTasks.loadDisplayProfile(stringArray);
        Util.debug("Modifying searchServer attribute in Search channel");
        stringArray = new String[]{"modify", "-m", "-u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "-d", this.context.getDefaultOrgDN(), "-p", "Search"};
        charSequence2 = new StringBuffer();
        ((StringBuffer)charSequence2).append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>");
        ((StringBuffer)charSequence2).append("<!DOCTYPE DisplayProfile SYSTEM \"jar://resources/psdp.dtd\">");
        ((StringBuffer)charSequence2).append("<Properties>");
        ((StringBuffer)charSequence2).append("<String name=\"searchServer\" value=\"" + this.context.getServerProtocol() + "://" + this.context.getServerHost() + ":" + this.context.getServerPort() + this.context.getDeployURI() + "/search" + "\"/>");
        ((StringBuffer)charSequence2).append("</Properties>");
        PortalServerTasks.loadDisplayProfile(stringArray, (StringBuffer)charSequence2);
        Util.debug("Modifying searchServer attribute in Discussions channel");
        stringArray = new String[]{"modify", "-m", "-u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "-d", this.context.getDefaultOrgDN(), "-p", "Discussions"};
        charSequence2 = new StringBuffer();
        ((StringBuffer)charSequence2).append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>");
        ((StringBuffer)charSequence2).append("<!DOCTYPE DisplayProfile SYSTEM \"jar://resources/psdp.dtd\">");
        ((StringBuffer)charSequence2).append("<Properties>");
        ((StringBuffer)charSequence2).append("<String name=\"searchServer\" value=\"" + this.context.getServerProtocol() + "://" + this.context.getServerHost() + ":" + this.context.getServerPort() + this.context.getDeployURI() + "/search" + "\"/>");
        ((StringBuffer)charSequence2).append("</Properties>");
        PortalServerTasks.loadDisplayProfile(stringArray, (StringBuffer)charSequence2);
        Util.debug("Modifying searchServer attribute in DiscussionLite channel");
        stringArray = new String[]{"modify", "-m", "-u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "-d", this.context.getDefaultOrgDN(), "-p", "DiscussionLite"};
        charSequence2 = new StringBuffer();
        ((StringBuffer)charSequence2).append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>");
        ((StringBuffer)charSequence2).append("<!DOCTYPE DisplayProfile SYSTEM \"jar://resources/psdp.dtd\">");
        ((StringBuffer)charSequence2).append("<Properties>");
        ((StringBuffer)charSequence2).append("<String name=\"searchServer\" value=\"" + this.context.getServerProtocol() + "://" + this.context.getServerHost() + ":" + this.context.getServerPort() + this.context.getDeployURI() + "/search" + "\"/>");
        ((StringBuffer)charSequence2).append("</Properties>");
        PortalServerTasks.loadDisplayProfile(stringArray, (StringBuffer)charSequence2);
        Util.debug("Updating App Channel with Netmail");
        stringArray = new String[]{"modify", "-m", "-u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "-d", this.context.getDefaultOrgDN(), "-p", "App"};
        charSequence2 = new StringBuffer();
        ((StringBuffer)charSequence2).append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>");
        ((StringBuffer)charSequence2).append("<!DOCTYPE DisplayProfile SYSTEM \"jar://resources/psdp.dtd\">");
        ((StringBuffer)charSequence2).append("\n");
        ((StringBuffer)charSequence2).append("<Properties>");
        ((StringBuffer)charSequence2).append("<Collection name=\"targets\">");
        ((StringBuffer)charSequence2).append("<String value=\"NetMail Lite|" + this.context.getDeployURI() + "/NetMailServlet?nsid=newHTMLSession\"/>");
        ((StringBuffer)charSequence2).append("<String value=\"NetMail|NetMailServlet?nsid=newAppletSession\"/>");
        ((StringBuffer)charSequence2).append("</Collection>");
        ((StringBuffer)charSequence2).append("<Collection name=\"userApps\">");
        ((StringBuffer)charSequence2).append("<String value=\"NetMail Lite\"/>");
        ((StringBuffer)charSequence2).append("<String value=\"NetMail\"/>");
        ((StringBuffer)charSequence2).append("</Collection>");
        ((StringBuffer)charSequence2).append("</Properties>");
        PortalServerTasks.loadDisplayProfile(stringArray, (StringBuffer)charSequence2);
        Util.debug("Updating Bookmark Channel with Netmail");
        stringArray = new String[]{"modify", "-m", "-u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "-d", this.context.getDefaultOrgDN(), "-p", "Bookmark"};
        charSequence2 = new StringBuffer();
        ((StringBuffer)charSequence2).append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>");
        ((StringBuffer)charSequence2).append("<!DOCTYPE DisplayProfile SYSTEM \"jar://resources/psdp.dtd\">");
        ((StringBuffer)charSequence2).append("<Properties>");
        ((StringBuffer)charSequence2).append("<Collection name=\"targets\">");
        ((StringBuffer)charSequence2).append("<String value=\"NetMail Local Installer|" + this.context.getDeployURI() + "/NetMailServlet?nsid=newInstallSession\"/>");
        ((StringBuffer)charSequence2).append("</Collection>");
        ((StringBuffer)charSequence2).append("</Properties>");
        PortalServerTasks.loadDisplayProfile(stringArray, (StringBuffer)charSequence2);
        Util.debug("Loading sample search content");
        try {
            charSequence = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "search" + ConfigurationConstants.fs + "ps-help.soif";
            Util.replaceTokenInFile(new File((String)charSequence), "%URL%", this.context.getDeployURI() + "/docs/en");
            if (Util.is_windows()) {
                Util.dos2unix(new File((String)charSequence));
            }
            stringArray = new String[]{Util.is_windows() ? "rdmgr.bat" : "rdmgr", Util.decoratePath((String)charSequence)};
            PortalServerTasks.runCsCli(stringArray);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
        Util.debug("Loading sample taxonomy content");
        try {
            charSequence = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "search" + ConfigurationConstants.fs + "ps-tax.soif";
            String string = this.PS_VAR_OPT_DIR + ConfigurationConstants.fs + "https-" + this.context.getDeployInstance() + this.context.getDeployURI() + ConfigurationConstants.fs + "config" + ConfigurationConstants.fs + "taxonomy.rdm";
            Util.copyFile((String)charSequence, string);
            stringArray = new String[]{Util.is_windows() ? "rdmgr.bat" : "rdmgr", "-T", "-I"};
            PortalServerTasks.runCsCli(stringArray);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
        Util.debug("Loading sample discussion content");
        try {
            stringArray = new String[]{Util.is_windows() ? "rdmgr.bat" : "rdmgr", "-y", "discussion", Util.decoratePath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "discussions" + ConfigurationConstants.fs + "discussions.soif")};
            PortalServerTasks.runCsCli(stringArray);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
        charSequence = new StringBuffer();
        ((StringBuffer)charSequence).append(Util.decoratePath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "desktop" + ConfigurationConstants.fs + "dp-anon.xml") + " ");
        ((StringBuffer)charSequence).append(Util.decoratePath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "discussions" + ConfigurationConstants.fs + "dp-anon.xml") + " ");
        stringArray = new String[]{"modify", "-b -m -u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "-d", this.context.getAuthlessAnonymousDN(), ((StringBuffer)charSequence).toString()};
        PortalServerTasks.loadDisplayProfile(stringArray);
    }

    private void configPortletSamples() throws ConfigurationException {
        String[] stringArray = new String[8];
        stringArray[0] = "modify";
        stringArray[1] = "-b -m -u";
        stringArray[2] = this.context.getAmAdminDN();
        stringArray[3] = "-w";
        stringArray[4] = this.context.getISAdminPassword();
        stringArray[5] = "-d";
        stringArray[6] = this.context.getAuthlessAnonymousDN();
        String string = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "portlet" + ConfigurationConstants.fs + "portletTab.xml";
        if (Util.fileExists(string)) {
            Util.debug("Loading portlet portletTab.xml");
            stringArray[7] = Util.decoratePath(string);
            PortalServerTasks.loadDisplayProfile(stringArray);
        }
        if (Util.fileExists(string = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "portlet" + ConfigurationConstants.fs + "sampleChannels.xml")) {
            Util.debug("Loading portlet sampleChannels.xml");
            stringArray[7] = Util.decoratePath(string);
            PortalServerTasks.loadDisplayProfile(stringArray);
        }
        if (Util.fileExists(string = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "portlet" + ConfigurationConstants.fs + "portletTab-anon.xml")) {
            Util.debug("Loading portlet portletTab-anon.xml");
            stringArray[7] = Util.decoratePath(string);
            PortalServerTasks.loadDisplayProfile(stringArray);
        }
        if (Util.fileExists(string = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "portlet" + ConfigurationConstants.fs + "sampleChannels-anon.xml")) {
            Util.debug("Loading portlet sampleChannels-anon.xml");
            stringArray[7] = Util.decoratePath(string);
            PortalServerTasks.loadDisplayProfile(stringArray);
        }
    }

    public void special() throws ConfigurationException {
        String string = this.context.getDeployNow();
        if (string.equals("y")) {
            try {
                String string2 = this.context.getDeployInstance();
                String string3 = this.context.getDeployURI();
                PortalServerTasks.undeploy(string2);
                Util.debug("Deploying to " + string2);
                PortalServerTasks.deploy(string2, string3);
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception.toString());
            }
        }
    }

    public void scrubds() throws ConfigurationException {
        File file;
        Util.debug("Deleting $AUTHLESS_DN user...");
        String string = this.context.getISBaseDir();
        string.replace('\\', '/');
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        stringBuffer.append("<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\" \"file:" + string + IS_SUFFIX + "/dtd/amAdmin.dtd\">");
        stringBuffer.append("<Requests>");
        stringBuffer.append("  <PeopleContainerRequests DN=\"" + this.context.getPeopleDN() + "\">");
        stringBuffer.append("    <DeleteUsers>");
        stringBuffer.append("      <DN>" + this.context.getAuthlessAnonymousDN() + "</DN>");
        stringBuffer.append("    </DeleteUsers>");
        stringBuffer.append("  </PeopleContainerRequests>");
        stringBuffer.append("</Requests>");
        try {
            file = File.createTempFile("scrubds", ".xml");
            Util.appendLineEof(file, stringBuffer.toString(), false);
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        String string2 = null;
        string2 = Util.is_windows() ? this.context.getISBaseDir() + IS_SUFFIX + ConfigurationConstants.fs + "bin" + ConfigurationConstants.fs + "amadmin.bat" : this.context.getISBaseDir() + IS_SUFFIX + ConfigurationConstants.fs + "bin" + ConfigurationConstants.fs + "amadmin";
        String[] stringArray = new String[]{"--runasdn", this.context.getAmAdminDN(), "--password", this.context.getISAdminPassword(), "--data", Util.decoratePath(file.getAbsolutePath())};
        try {
            Util.runCommandLine(string2, stringArray);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
        file.delete();
    }

    public void remove() throws ConfigurationException {
    }

    static {
        if (!Util.is_windows()) {
            IS_SUFFIX = ConfigurationConstants.fs + "SUNWam";
            PS_SUFFIX = ConfigurationConstants.fs + "SUNWps";
        } else {
            IS_SUFFIX = "";
            PS_SUFFIX = "";
        }
    }
}

