/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config.component;

import com.sun.portal.config.ConfigurationConstants;
import com.sun.portal.config.ConfigurationContext;
import com.sun.portal.config.ConfigurationException;
import com.sun.portal.config.ConfigurationInterface;
import com.sun.portal.config.util.PortalServerTasks;
import com.sun.portal.config.util.Util;

public class SamplePortal_SunOS_scripts
implements ConfigurationInterface,
ConfigurationConstants {
    private String name = "Sample Portal";
    private ConfigurationContext context;
    private PortalServerTasks PSTasks;

    public SamplePortal_SunOS_scripts(ConfigurationContext configurationContext) {
        this.context = configurationContext;
        this.PSTasks = new PortalServerTasks(configurationContext);
    }

    public void init() throws ConfigurationException {
        String string = this.context.getPSBaseDir() + "/SUNWps";
        if (!Util.directoryExists(string)) {
            throw new ConfigurationException(string + " doesn't exist.");
        }
    }

    public void postinstall() throws ConfigurationException {
        if (!this.context.getDeployType().equals("WEBLOGIC") && !this.context.getDeployType().equals("WEBSPHERE")) {
            try {
                Util.debug("Running postinstall_PortletSamples");
                Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/lib/postinstall_PortletSamples");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void isconfig() throws ConfigurationException {
        try {
            Util.debug("Running isconfig");
            Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/lib/isconfig");
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    public void config() throws ConfigurationException {
        try {
            Util.debug("Running config_SamplePortal");
            Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/lib/config_SamplePortal");
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
        try {
            Util.debug("Running config_PortletSamples");
            Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/lib/config_PortletSamples");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Util.debug("Running config_WSRPConsumer");
            Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/lib/config_WSRPConsumer");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void special() throws ConfigurationException {
        String string = System.getProperty("DEPLOY_ADMIN_PASSWORD");
        if (string == null || string.equals("")) {
            string = "not_set";
        }
        if (!this.context.getDeployType().equals("WEBLOGIC") && !this.context.getDeployType().equals("WEBSPHERE")) {
            try {
                Util.debug("Running deploy (redeploy)");
                String[] stringArray = new String[]{"redeploy", "-deploy_admin_password", string};
                Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/bin/deploy", stringArray);
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception.toString());
            }
        }
    }

    public void scrubds() throws ConfigurationException {
        try {
            Util.debug("Running scrubds_SamplePortal");
            Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/lib/scrubds_SamplePortal");
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    public void remove() throws ConfigurationException {
        String string = System.getProperty("DEPLOY_ADMIN_PASSWORD");
        if (string == null || string.equals("")) {
            string = "not_set";
        }
        try {
            Util.debug("Running deploy (redeploy)");
            String[] stringArray = new String[]{"redeploy", "-deploy_admin_password", string};
            Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/bin/deploy", stringArray);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }
}

