/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config.component;

import com.sun.portal.config.ConfigurationConstants;
import com.sun.portal.config.ConfigurationContext;
import com.sun.portal.config.ConfigurationException;
import com.sun.portal.config.ConfigurationInterface;
import com.sun.portal.config.util.PortalServerTasks;
import com.sun.portal.config.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class SRA_Windows
implements ConfigurationInterface,
ConfigurationConstants {
    private ConfigurationContext context;
    private PortalServerTasks PSTasks;
    private static String IS_SUFFIX = "";
    private static String PS_SUFFIX = "";

    public SRA_Windows(ConfigurationContext configurationContext) {
        this.context = configurationContext;
        this.PSTasks = new PortalServerTasks(configurationContext);
    }

    public void init() throws ConfigurationException {
        String string = this.context.getPSBaseDir() + PS_SUFFIX;
        if (!Util.directoryExists(string)) {
            throw new ConfigurationException(string + " doesn't exist.");
        }
    }

    protected void addNetletProviderToDP() {
        String[] stringArray = new String[]{"add", "-u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "-g", Util.decoratePath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "netlet" + ConfigurationConstants.fs + "netletProvider.xml")};
        Util.debug("Adding Netlet provider to display profile...");
        try {
            PortalServerTasks.loadDisplayProfile(stringArray);
        }
        catch (ConfigurationException configurationException) {
            Util.debug("Configuration Error: Netlet provider not added to display profile!");
        }
    }

    protected void addNetFilePermissionsToServerPolicy() {
        if (this.context.getDeployType().equals("SUNONE")) {
            try {
                File file = new File(this.context.getDeployDomain() + ConfigurationConstants.fs + this.context.getDeployInstance() + ConfigurationConstants.fs + "config" + ConfigurationConstants.fs + "server.policy");
                if (!file.exists()) {
                    throw new ConfigurationException("Server Policy file for SunOne AppServer missing:" + file.getAbsolutePath());
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("// S1PS - SRA NetFile\n");
                stringBuffer.append("grant {\n");
                stringBuffer.append("      permission java.net.SocketPermission    \"*\", \"connect,accept,listen,resolve\";\n");
                stringBuffer.append("      permission java.net.NetPermission \"*\", \"specifyStreamHandler\";\n");
                stringBuffer.append("};\n");
                stringBuffer.append("// END OF S1PS - SRA NetFile\n");
                stringBuffer.append("\n");
                Util.appendLineEof(file, stringBuffer.toString(), false);
            }
            catch (Exception exception) {
                Util.debug("Configuration Error: Net File permissions not added to server.policy file!");
            }
        }
    }

    protected void removeNetletProviderFromDP() {
        String[] stringArray = new String[]{"remove", "-t", "provider", "-n", "NetletProvider", "-u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "-g"};
        Util.debug("Removing Netlet provider from display profile...");
        try {
            PortalServerTasks.loadDisplayProfile(stringArray);
        }
        catch (ConfigurationException configurationException) {
            Util.debug("Configuration Error: Netlet provider not removed from display profile!");
        }
    }

    public void postinstall() throws ConfigurationException {
        this.addNetletProviderToDP();
        this.addNetFilePermissionsToServerPolicy();
    }

    public void isconfig() throws ConfigurationException {
        this.PSTasks.isconfig();
    }

    protected void addRuleSet(File file) {
        if (file.exists()) {
            Util.debug("Loading <" + file.getAbsolutePath() + ">");
            try {
                PortalServerTasks.loadRewriterRules(file);
            }
            catch (ConfigurationException configurationException) {
                Util.debug("Configuration Error: RuleSet not loaded!");
            }
        } else {
            Util.debug("Install Error: File <" + file.getAbsolutePath() + "> doesn't exist!");
        }
    }

    protected void addRuleSets() {
        String string = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "export" + ConfigurationConstants.fs + "rewriter_rule" + ConfigurationConstants.fs;
        this.addRuleSet(new File(string + "DefaultGatewayRuleSet.xml"));
        this.addRuleSet(new File(string + "OWASP3RuleSet.xml"));
        this.addRuleSet(new File(string + "WMLRuleSet.xml"));
        this.addRuleSet(new File(string + "iNotesRuleSet.xml"));
        this.addRuleSet(new File(string + "iPlanetMailExpressRuleSet.xml"));
    }

    protected void deleteRuleSets() {
        try {
            this.PSTasks.deleteRuleSet("default_gateway_ruleset");
        }
        catch (ConfigurationException configurationException) {
            Util.debug("Configuration Error: default_gateway_ruleset not deleted!");
        }
        try {
            this.PSTasks.deleteRuleSet("exchange_2000sp3_owa_ruleset");
        }
        catch (ConfigurationException configurationException) {
            Util.debug("Configuration Error: exchange_2000sp3_owa_ruleset not deleted!");
        }
        try {
            this.PSTasks.deleteRuleSet("wml_ruleset");
        }
        catch (ConfigurationException configurationException) {
            Util.debug("Configuration Error: wml_ruleset not deleted!");
        }
        try {
            this.PSTasks.deleteRuleSet("inotes_ruleset");
        }
        catch (ConfigurationException configurationException) {
            Util.debug("Configuration Error: inotes_ruleset not deleted!");
        }
        try {
            this.PSTasks.deleteRuleSet("iplanet_mail_ruleset");
        }
        catch (ConfigurationException configurationException) {
            Util.debug("Configuration Error: iplanet_mail_ruleset not deleted!");
        }
    }

    protected void assignGatewayAccessToAMAdmin() {
        String string = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "export" + ConfigurationConstants.fs;
        String string2 = System.getProperty("line.separator", "\n");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("dn:").append(this.context.getAmAdminDN()).append(string2);
        stringBuffer.append("changetype:modify").append(string2);
        stringBuffer.append("add: objectclass").append(string2);
        stringBuffer.append("objectclass:sunPortalGatewayAccessService").append(string2);
        String string3 = string + "sra-assignService.ldif";
        try {
            File file = new File(string3);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            outputStreamWriter.write(stringBuffer.toString());
            outputStreamWriter.close();
            PortalServerTasks.ldapModify(file, false);
        }
        catch (IOException iOException) {
            Util.debug("Configuration Error: Exception when assigning Gateway Access to AMAdmin!" + string2 + iOException.toString());
        }
        catch (ConfigurationException configurationException) {
            Util.debug("Configuration Error: Exception when assigning Gateway Access to AMAdmin!" + string2 + configurationException.toString());
        }
    }

    protected boolean doAssignServices(String string) {
        boolean bl = true;
        if (string.indexOf("amService-srapGateway") != -1) {
            bl = false;
        } else if (string.indexOf(this.context.getAmAdminDN()) != -1) {
            bl = false;
        }
        return bl;
    }

    protected void assignGatewayServicesToAllDefaultOrgUsers() {
        String string = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "export" + ConfigurationConstants.fs;
        String string2 = System.getProperty("line.separator", "\n");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append("changetype:modify").append(string2);
        stringBuffer.append("add: objectclass").append(string2);
        stringBuffer.append("objectclass:sunPortalGatewayAccessService").append(string2);
        stringBuffer.append("objectclass:sunPortalNetFileService").append(string2);
        stringBuffer.append("objectclass:sunPortalNetletService").append(string2);
        try {
            String string3;
            String string4 = this.context.getISBaseDir() + IS_SUFFIX + ConfigurationConstants.fs + "tools" + ConfigurationConstants.fs + "ldapsearch";
            String[] stringArray = new String[]{"-h", this.context.getDSHost(), "-p", this.context.getDSPort(), "-b", "\"" + this.context.getPeopleDN() + "\"", "-D", "\"" + this.context.getDSDirMgrDN() + "\"", "-w", "\"" + this.context.getDirMgrPassword() + "\"", "objectclass=iplanet-am-managed-person", "-s one dn"};
            InputStream inputStream = Util.runCommandLine(string4, stringArray, null, null);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer2 = new StringBuffer();
            while ((string3 = bufferedReader.readLine()) != null) {
                if (!this.doAssignServices(string3)) continue;
                stringBuffer2.append(string3);
                if (!string3.equals("") && !string3.equals("version: 1")) {
                    stringBuffer2.append(stringBuffer.toString()).append(string2);
                    continue;
                }
                stringBuffer2.append(string2);
            }
            String string5 = string + "sra-assignServices.ldif";
            File file = new File(string5);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            outputStreamWriter.write(stringBuffer2.toString());
            outputStreamWriter.close();
            PortalServerTasks.ldapModify(file, false);
        }
        catch (Exception exception) {
            Util.debug("Configuration Error: Exception when assigning Gateway Services to Default Org Users!" + string2 + exception.toString());
        }
    }

    public void config() throws ConfigurationException {
        this.addRuleSets();
        this.assignGatewayAccessToAMAdmin();
        this.assignGatewayServicesToAllDefaultOrgUsers();
    }

    public void special() throws ConfigurationException {
        String string = this.context.getDeployNow();
        if (string.equals("y")) {
            String string2 = this.context.getDeployInstance();
            String string3 = this.context.getDeployURI();
            Util.debug("Deploying  (redeploy) to " + string2);
            PortalServerTasks.undeploy(string2);
            PortalServerTasks.deploy(string2, string3);
        }
    }

    public void remove() throws ConfigurationException {
        this.removeNetletProviderFromDP();
    }

    protected String getAMAdminCommand() {
        String string = null;
        string = Util.is_windows() ? this.context.getISBaseDir() + IS_SUFFIX + ConfigurationConstants.fs + "bin" + ConfigurationConstants.fs + "amadmin.bat" : this.context.getISBaseDir() + IS_SUFFIX + ConfigurationConstants.fs + "bin" + ConfigurationConstants.fs + "amadmin";
        return string;
    }

    protected void scrubGateway() {
        String string = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "export" + ConfigurationConstants.fs + "scrubds" + ConfigurationConstants.fs;
        File file = new File(string + "srapGateway.scrubds");
        File file2 = new File(string + "srapGateway.scrubds.xml");
        try {
            PortalServerTasks.replaceTokenInFile(file, file2, "%GW_DOMAIN%", this.context.getGWDomain());
            PortalServerTasks.replaceTokenInFile(file2, "%ORG_DN%", this.context.getDefaultOrgDN());
            PortalServerTasks.replaceTokenInFile(file2, "%PEOPLE_DN%", this.context.getPeopleDN());
            PortalServerTasks.replaceTokenInFile(file2, "%USER_NAMING_ATTR%", this.context.getISUserNaming());
            PortalServerTasks.replaceTokenInFile(file2, "%IDSAME_BASEDIR%/SUNWam", this.context.getISBaseDir());
            String string2 = this.getAMAdminCommand();
            String[] stringArray = new String[]{"-u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "--verbose", "--continue", "--data", Util.decoratePath(file2.getAbsolutePath())};
            Util.runCommandLine(string2, stringArray);
        }
        catch (IOException iOException) {
            Util.debug("Configuration Error: " + iOException.toString());
        }
        catch (Exception exception) {
            Util.debug("Configuration Error: " + exception.toString());
        }
    }

    protected void scrubNetlet() {
        String string = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "export" + ConfigurationConstants.fs + "scrubds" + ConfigurationConstants.fs;
        File file = new File(string + "srapNetlet.scrubds");
        File file2 = new File(string + "srapNetlet.scrubds.xml");
        try {
            PortalServerTasks.replaceTokenInFile(file, file2, "%IDSAME_BASEDIR%/SUNWam", this.context.getISBaseDir());
            PortalServerTasks.replaceTokenInFile(file2, "%ORG_DN%", this.context.getDefaultOrgDN());
            PortalServerTasks.replaceTokenInFile(file2, "%DEPLOY_URI%", this.context.getDeployURI());
            String string2 = this.getAMAdminCommand();
            String[] stringArray = new String[]{"-u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "--verbose", "--continue", "--data", Util.decoratePath(file2.getAbsolutePath())};
            Util.runCommandLine(string2, stringArray);
        }
        catch (IOException iOException) {
            Util.debug("Configuration Error: " + iOException.toString());
        }
        catch (Exception exception) {
            Util.debug("Configuration Error: " + exception.toString());
        }
    }

    protected void scrubNetFile() {
        String string = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "export" + ConfigurationConstants.fs + "scrubds" + ConfigurationConstants.fs;
        File file = new File(string + "srapNetfile.scrubds");
        File file2 = new File(string + "srapNetfile.scrubds.xml");
        try {
            PortalServerTasks.replaceTokenInFile(file, file2, "%IDSAME_BASEDIR%/SUNWam", this.context.getISBaseDir());
            PortalServerTasks.replaceTokenInFile(file2, "%ORG_DN%", this.context.getDefaultOrgDN());
            PortalServerTasks.replaceTokenInFile(file2, "%DEPLOY_URI%", this.context.getDeployURI());
            String string2 = this.getAMAdminCommand();
            String[] stringArray = new String[]{"-u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "--verbose", "--continue", "--data", Util.decoratePath(file2.getAbsolutePath())};
            Util.runCommandLine(string2, stringArray);
        }
        catch (IOException iOException) {
            Util.debug("Configuration Error: " + iOException.toString());
        }
        catch (Exception exception) {
            Util.debug("Configuration Error: " + exception.toString());
        }
    }

    protected void deleteServices() {
        try {
            PortalServerTasks.deleteService("srapGatewayAccessService");
        }
        catch (ConfigurationException configurationException) {
            Util.debug("Configuration Error: srapGatewayAccessService not deleted!");
        }
        try {
            PortalServerTasks.deleteService("srapGatewayService");
        }
        catch (ConfigurationException configurationException) {
            Util.debug("Configuration Error: srapGatewayService not deleted!");
        }
        try {
            PortalServerTasks.deleteService("srapNetletService");
        }
        catch (ConfigurationException configurationException) {
            Util.debug("Configuration Error: srapNetletService not deleted!");
        }
        try {
            PortalServerTasks.deleteService("srapNetFileService");
        }
        catch (ConfigurationException configurationException) {
            Util.debug("Configuration Error: srapNetFileService not deleted!");
        }
    }

    public void scrubds() throws ConfigurationException {
        this.deleteRuleSets();
        this.scrubGateway();
        this.scrubNetlet();
        this.scrubNetFile();
        this.deleteServices();
    }

    static {
        if (!Util.is_windows()) {
            IS_SUFFIX = ConfigurationConstants.fs + "SUNWam";
            PS_SUFFIX = ConfigurationConstants.fs + "SUNWps";
        }
    }
}

