/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config.component;

import com.sun.portal.config.ConfigurationConstants;
import com.sun.portal.config.ConfigurationContext;
import com.sun.portal.config.ConfigurationException;
import com.sun.portal.config.ConfigurationInterface;
import com.sun.portal.config.util.SRATasks;
import com.sun.portal.config.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Properties;

public class RewriterProxy_SunOS
implements ConfigurationInterface,
ConfigurationConstants {
    private String name = "Rewriter Proxy";
    private ConfigurationContext context;

    public RewriterProxy_SunOS(ConfigurationContext configurationContext) {
        this.context = configurationContext;
    }

    public void init() throws ConfigurationException {
        String string = this.context.getRWPBaseDir() + "/SUNWps";
        if (!Util.directoryExists(string)) {
            throw new ConfigurationException(string + " doesn't exist.");
        }
    }

    public void postinstall() throws ConfigurationException {
        String string;
        Object object;
        Object object2;
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        Object object3;
        Util.debug("Write Authentication Password file");
        try {
            object3 = new File("/etc/opt/SUNWps/.auth_password." + this.context.getRWPGatewayProfile());
            if (!((File)object3).exists()) {
                ((File)object3).createNewFile();
                Util.appendLineEof((File)object3, "uid=amService-srapGateway", true);
                Util.appendLineEof((File)object3, "ldap_passwd=" + this.context.getSRALogUserPassword(), true);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object3 = "/etc/opt/SUNWps/platform.conf." + this.context.getRWPGatewayProfile();
        boolean bl = false;
        if (Util.fileExists((String)object3)) {
            Util.debug("Comparing existing platform.conf");
            stringArray3 = this.context.getServerProtocol() + "://" + this.context.getServerHost() + ":" + this.context.getServerPort();
            stringArray2 = new Properties();
            try {
                stringArray2.load(new FileInputStream((String)object3));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            stringArray = (String)stringArray2.get("portal.server.protocol") + "://" + (String)stringArray2.get("portal.server.host") + ":" + (String)stringArray2.get("portal.server.port");
            if (!stringArray3.equals(stringArray)) {
                Util.debug("Existing platform.conf is invalid");
                throw new ConfigurationException("Existing platform.conf is invalid");
            }
            Util.debug("Using existing platform.conf");
            bl = true;
        }
        if (bl) {
            stringArray2 = this.context.getRWPBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "bin";
            stringArray3 = new String[]{(String)stringArray2 + ConfigurationConstants.fs + "rwproxyd", (String)stringArray2 + ConfigurationConstants.fs + "gwcertutil", (String)stringArray2 + ConfigurationConstants.fs + "certadmin", (String)stringArray2 + ConfigurationConstants.fs + "certtool", (String)stringArray2 + ConfigurationConstants.fs + "checkgw", "/etc/init.d/rwproxyd"};
        } else {
            Util.debug("Creating platform.conf");
            try {
                stringArray2 = "/etc/opt/SUNWps/platform.conf-orig";
                stringArray = "/etc/opt/SUNWps/platform.conf." + this.context.getRWPGatewayProfile();
                Util.copyFile((String)stringArray2, (String)stringArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            stringArray2 = this.context.getRWPBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "bin";
            stringArray3 = new String[]{(String)stringArray2 + ConfigurationConstants.fs + "rwproxyd", (String)stringArray2 + ConfigurationConstants.fs + "gwcertutil", (String)stringArray2 + ConfigurationConstants.fs + "certadmin", (String)stringArray2 + ConfigurationConstants.fs + "certtool", (String)stringArray2 + ConfigurationConstants.fs + "checkgw", "/etc/init.d/rwproxyd", "/etc/opt/SUNWps/platform.conf." + this.context.getRWPGatewayProfile()};
        }
        stringArray2 = new String[]{"${BASE_DIR}", "${IDSAME_BASE_DIR}", "${PRODUCT_DIR}", "${JAVA_BASE_DIR}", "SERVER_PROTO", "SERVER_HOST", "SERVER_PORT", "SERVER_URL", "DEPLOY_URI", "GW_PROTOCOL", "GW_HOST", "GW_PORT", "GATEWAY_IPADDR", "GW_VIRTUAL_HOST", "SSL_CONNECTION", "CERT_DB_DIR", "WEBSERVER_HOST"};
        stringArray = new String[]{this.context.getRWPBaseDir(), this.context.getISBaseDir(), "SUNWps", this.context.getJDKDir(), this.context.getServerProtocol(), this.context.getServerHost(), this.context.getServerPort(), this.context.getServerProtocol() + "://" + this.context.getServerHost() + ":" + this.context.getServerPort(), this.context.getDeployURI(), this.context.getRWPProtocol(), this.context.getRWPHost(), this.context.getRWPPort(), this.context.getRWPIPAddress(), this.context.getRWPHost() + " " + this.context.getRWPIPAddress(), "true", "/etc/opt/SUNWps/cert/" + this.context.getRWPGatewayProfile(), this.context.getServerHost()};
        Util.debug("Performing token substitution on files");
        for (int i = 0; i < stringArray3.length; ++i) {
            try {
                Util.debug("Processing " + stringArray3[i]);
                Util.replaceTokenInFile(new File(stringArray3[i]), stringArray2, stringArray);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        String string2 = this.context.getRWPBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "bin";
        String[] stringArray4 = new String[]{string2 + ConfigurationConstants.fs + "rwproxyd", string2 + ConfigurationConstants.fs + "gwcertutil", string2 + ConfigurationConstants.fs + "certadmin", string2 + ConfigurationConstants.fs + "certtool", string2 + ConfigurationConstants.fs + "checkgw", "/etc/init.d/rwproxyd"};
        for (int i = 0; i < stringArray4.length; ++i) {
            try {
                Util.changeFilePermission(stringArray4[i], "755");
                continue;
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception.toString());
            }
        }
        if (bl) {
            try {
                File file = new File((String)object3);
                Util.debug("Replacing gateway.certdir in platform.conf");
                Util.replaceLineInFile(file, "gateway.certdir=", new StringBuffer("gateway.certdir=/etc/opt/SUNWps/cert/" + this.context.getRWPGatewayProfile()));
                Util.debug("Replacing gateway.protocol in platform.conf");
                Util.replaceLineInFile(file, "gateway.protocol=", new StringBuffer("gateway.protocol=" + this.context.getRWPProtocol()));
                Util.debug("Replacing gateway.port in platform.conf");
                Util.replaceLineInFile(file, "gateway.port=", new StringBuffer("gateway.port=" + this.context.getServerPort()));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        Util.debug("Updating platform.conf with gateway.bindipaddress");
        String string3 = this.context.getRWPIPAddress();
        if (string3 != null && string3.trim().length() != 0) {
            try {
                object2 = new File((String)object3);
                object = Util.findTextInFile((File)object2, "gateway.bindipaddress=");
                if (object != null && ((String)object).trim().length() != 0) {
                    Util.replaceLineInFile((File)object2, "gateway.bindipaddress=", new StringBuffer("gateway.bindipaddress=" + string3));
                } else {
                    Util.appendLineEof((File)object2, "gateway.bindipaddress=" + string3, false);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        Util.debug("Updating platform.conf with rewriterproxy.port");
        object2 = this.context.getRWPPort();
        if (object2 != null && ((String)object2).trim().length() != 0) {
            try {
                object = new File((String)object3);
                string = Util.findTextInFile((File)object, "rewriterproxy.port=");
                if (string != null && string.trim().length() != 0) {
                    Util.replaceLineInFile((File)object, "rewriterproxy.port=", new StringBuffer("rewriterproxy.port=" + (String)object2));
                } else {
                    Util.appendLineEof((File)object, "rewriterproxy.port=" + (String)object2, false);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        Util.debug("Updating platform.conf with gateway.sockretries");
        try {
            object = new File((String)object3);
            string = Util.findTextInFile((File)object, "gateway.sockretries=");
            if (string != null && string.trim().length() != 0) {
                Util.replaceLineInFile((File)object, "gateway.sockretries=", new StringBuffer("gateway.sockretries=3"));
            } else {
                Util.appendLineEof((File)object, "gateway.sockretries=3", false);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Util.debug("Generating certificate");
        try {
            object = "/etc/opt/SUNWps/cert/" + this.context.getRWPGatewayProfile();
            string = this.context.getRWPBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "lib";
            Util.makeDir((String)object);
            SRATasks.generateCert((String)object, string, this.context.getRWPBaseDir());
        }
        catch (ConfigurationException configurationException) {
            configurationException.printStackTrace();
        }
    }

    public void isconfig() throws ConfigurationException {
    }

    public void config() throws ConfigurationException {
    }

    public void special() throws ConfigurationException {
    }

    public void scrubds() throws ConfigurationException {
    }

    public void remove() throws ConfigurationException {
        Object object;
        Object object2;
        try {
            Util.debug("Stopping rwproxyd watchdog");
            object2 = ConfigurationConstants.fs + "etc" + ConfigurationConstants.fs + "inet.d" + ConfigurationConstants.fs + "rwproxyd";
            object = new String[]{"watchdog", "off"};
            Util.runCommandLine((String)object2, object);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
        try {
            Util.debug("Stopping rwproxyd");
            object2 = ConfigurationConstants.fs + "etc" + ConfigurationConstants.fs + "inet.d" + ConfigurationConstants.fs + "rwproxyd";
            object = new String[]{"stop"};
            Util.runCommandLine((String)object2, object);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
        object2 = new File(ConfigurationConstants.fs + "etc" + ConfigurationConstants.fs + "opt" + ConfigurationConstants.fs + "SUNWps");
        object = Util.getExtensionFilter("conf");
        File[] fileArray = ((File)object2).listFiles((FilenameFilter)object);
        for (int i = 0; i < fileArray.length; ++i) {
            Util.debug("Deleting " + fileArray[i].getName());
            Util.deleteFile(fileArray[i].getAbsoluteFile());
        }
        try {
            Util.debug("Saving cert directory");
            String string = "/etc/opt/SUNWps/cert";
            String string2 = "/etc/opt/SUNWps/SAVE-cert";
            Util.moveFile(string, string2);
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
    }
}

