/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config.component;

import com.sun.portal.config.ConfigurationConstants;
import com.sun.portal.config.ConfigurationContext;
import com.sun.portal.config.ConfigurationException;
import com.sun.portal.config.ConfigurationInterface;
import com.sun.portal.config.util.PortalServerTasks;
import com.sun.portal.config.util.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;

public class PortalServer_Windows
implements ConfigurationInterface,
ConfigurationConstants {
    private static String IS_SUFFIX = "";
    private static String PS_SUFFIX = "";
    private static String PS_TMP_DIR_SUFFIX = ConfigurationConstants.fs + "tmp";
    private String name = "Portal Server";
    private ConfigurationContext context;
    private PortalServerTasks PSTasks;

    public PortalServer_Windows(ConfigurationContext configurationContext) {
        this.context = configurationContext;
        this.PSTasks = new PortalServerTasks(configurationContext);
    }

    public void init() throws ConfigurationException {
        String[] stringArray = new String[]{"DEPLOY_URI", "DS_HOST", "DS_PORT", "DS_DIRMGR_DN", "IDSAME_BASEDIR", "BASEDIR", "com.iplanet.am.server.host"};
        if (!this.context.checkRequiredAttributes(stringArray)) {
            throw new ConfigurationException("Required Keys missing");
        }
        String string = this.context.getISBaseDir() + IS_SUFFIX;
        if (!Util.directoryExists(string)) {
            throw new ConfigurationException(string + " doesn't exist.");
        }
        string = this.context.getPSBaseDir() + PS_SUFFIX;
        if (!Util.directoryExists(string)) {
            throw new ConfigurationException(string + " doesn't exist.");
        }
    }

    public void postinstall() throws ConfigurationException {
        this.postinstallBase();
        this.postinstallContainer();
        this.postinstallPortlet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void postinstallBase() throws ConfigurationException {
        Object object;
        try {
            object = new File(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "web-src" + ConfigurationConstants.fs + "docs" + ConfigurationConstants.fs + "en");
            File[] fileArray = ((File)object).listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                Util.debug("Copying " + fileArray[i].getName());
                Util.copyDir(fileArray[i].getAbsolutePath(), this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "web-src" + ConfigurationConstants.fs + "docs" + ConfigurationConstants.fs + fileArray[i].getName());
            }
        }
        catch (IOException iOException) {
            Util.debug("Error copying:" + iOException);
        }
        try {
            Util.debug("Replacing jssproxy.resolveIPAddress in AMConfig.properties");
            object = null;
            object = Util.is_windows() ? this.context.getISBaseDir() + IS_SUFFIX + ConfigurationConstants.fs + ConfigurationConstants.AMCONFIG_WINDOWS : this.context.getISBaseDir() + IS_SUFFIX + ConfigurationConstants.fs + ConfigurationConstants.AMCONFIG;
            Util.replaceTokenInFile(new File((String)object), "com.iplanet.am.jssproxy.resolveIPAddress=false", "com.iplanet.am.jssproxy.resolveIPAddress=true");
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        object = this.context.getDeployType();
        if (((String)object).equals("IWS")) {
            Util.debug("Removing WS ClassCache");
            Util.deleteDir(this.context.getDeployDir() + ConfigurationConstants.fs + "https-" + this.context.getDeployInstance() + ConfigurationConstants.fs + "ClassCache" + ConfigurationConstants.fs + "https-" + this.context.getDeployInstance());
            Util.debug("Updating WS obj.conf");
            try {
                String string = this.context.getDeployDir() + ConfigurationConstants.fs + "https-" + this.context.getServerHost() + ConfigurationConstants.fs + "config" + ConfigurationConstants.fs + "obj.conf";
                String string2 = "fn=index-common";
                Util.deleteLineInFile(new File(string), string2);
            }
            catch (IOException iOException) {
                throw new ConfigurationException(iOException.toString());
            }
        } else if (((String)object).equals("SUNONE")) {
            this.postinstallBaseSunOne();
        } else if (((String)object).equals("WEBLOGIC") || ((String)object).equals("WEBSPHERE")) {
            // empty if block
        }
        Util.debug("Replace Deploy URI in index.html");
        try {
            String string = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "web-src" + ConfigurationConstants.fs + "index.html";
            Util.replaceTokenInFile(new File(string), "%URL%", this.context.getDeployURI() + "/dt");
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        PortalServerTasks.updateServerClassPath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "lib" + ConfigurationConstants.fs + "psimapprovider.jar");
        if (Util.is_windows()) {
            String string;
            String string3;
            Object object2;
            File file;
            Util.debug("Replace tokens in rwadmin.bat");
            try {
                String string4 = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "bin" + ConfigurationConstants.fs + "rwadmin.bat";
                file = new File(string4);
                Util.replaceTokenInFile(file, "%IDSAME_BASEDIR_TOKEN%", this.context.getISBaseDir());
                Util.replaceTokenInFile(file, "%PS_BASEDIR_TOKEN%", this.context.getPSBaseDir());
                Util.replaceTokenInFile(file, "%JAVA_HOME_TOKEN%", this.context.getJDKDir());
            }
            catch (IOException iOException) {
                throw new ConfigurationException(iOException.toString());
            }
            Util.debug("Replace tokens in dpadmin.bat");
            try {
                String string5 = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "bin" + ConfigurationConstants.fs + "dpadmin.bat";
                file = new File(string5);
                Util.replaceTokenInFile(file, "%IDSAME_BASEDIR_TOKEN%", this.context.getISBaseDir());
                Util.replaceTokenInFile(file, "%PS_BASEDIR_TOKEN%", this.context.getPSBaseDir());
                Util.replaceTokenInFile(file, "%JAVA_HOME_TOKEN%", this.context.getJDKDir());
                Util.replaceTokenInFile(file, "%DEPLOY_TYPE_TOKEN%", this.context.getDeployType());
                Util.replaceTokenInFile(file, "%DEPLOY_DIR_TOKEN%", this.context.getDeployDir());
            }
            catch (IOException iOException) {
                throw new ConfigurationException(iOException.toString());
            }
            Util.debug("Replace tokens in compass search rdmgr.bat");
            try {
                String string6 = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "bin" + ConfigurationConstants.fs + "rdmgr.bat";
                file = new File(string6);
                Util.replaceTokenInFile(file, "%JAVA_HOME_TOKEN%", this.context.getJDKDir());
                Util.replaceTokenInFile(file, "%PS_BASEDIR_TOKEN%", this.context.getPSBaseDir());
            }
            catch (IOException iOException) {
                throw new ConfigurationException(iOException.toString());
            }
            Util.debug("Creating Portal command line utilities");
            this.createPortalCommandFile("deploy");
            this.createPortalCommandFile("undeploy");
            this.createPortalCommandFile("multiserverinstance");
            this.createPortalCommandFile("pdeploy");
            this.createPortalCommandFile("par");
            Util.debug("Create IPS_BASEDIR/config/desktop/classes directory ");
            Util.makeDir(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "config" + ConfigurationConstants.fs + "desktop" + ConfigurationConstants.fs + "classes");
            try {
                String string7 = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "desktop" + ConfigurationConstants.fs + "dp-providers.xml";
                file = new File(string7);
                if (file.exists()) {
                    Util.debug("Notes Provider hardcodes location /var/tmp in IPS_BASEDIR/samples/desktop/dp-providers.xml");
                    object2 = File.createTempFile("findTmpDir", ".tmp");
                    string3 = ((File)object2).getParentFile().getAbsolutePath();
                    string3 = string3.replace('\\', '/');
                    Util.replaceTokenInFile(file, "/var/tmp", string3);
                    Util.deleteFile((File)object2);
                    Util.debug("Replace /etc/opt/SUNWps in IPS_BASEDIR/samples/desktop/dp-providers.xml");
                    string = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "config";
                    string = string.replace('\\', '/');
                    Util.replaceTokenInFile(file, "/etc/opt/SUNWps", string);
                }
            }
            catch (IOException iOException) {
                throw new ConfigurationException(iOException.toString());
            }
            Util.debug("Replace /var/opt/SUNWam in IPS_BASEDIR/web-src/WEB-INF/xml/portletcontainerweb.xml");
            try {
                String string8 = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "web-src" + ConfigurationConstants.fs + "WEB-INF" + ConfigurationConstants.fs + "xml" + ConfigurationConstants.fs + "portletcontainerweb.xml";
                file = new File(string8);
                if (file.exists()) {
                    object2 = this.context.getISBaseDir() + IS_SUFFIX;
                    object2 = ((String)object2).replace('\\', '/');
                    Util.replaceTokenInFile(file, "/var/opt/SUNWam", (String)object2);
                }
            }
            catch (IOException iOException) {
                throw new ConfigurationException(iOException.toString());
            }
            Util.debug("Replace /var/opt/SUNWam, var/opt/SUNWps, /etc/opt/SUNWps  in IPS_BASEDIR/config/portlet/PDConfig.properties");
            try {
                String string9 = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "config" + ConfigurationConstants.fs + "portlet" + ConfigurationConstants.fs + "xml" + ConfigurationConstants.fs + "PDConfig.properties";
                file = new File(string9);
                if (file.exists()) {
                    object2 = this.context.getISBaseDir() + IS_SUFFIX;
                    object2 = ((String)object2).replace('\\', '/');
                    Util.replaceTokenInFile(file, "/var/opt/SUNWam", (String)object2);
                    string3 = this.context.getPSBaseDir() + PS_SUFFIX;
                    string3 = string3.replace('\\', '/');
                    Util.replaceTokenInFile(file, "/var/opt/SUNWps", string3);
                    string = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "config";
                    string = string.replace('\\', '/');
                    Util.replaceTokenInFile(file, "/etc/opt/SUNWps", string);
                }
            }
            catch (IOException iOException) {
                throw new ConfigurationException(iOException.toString());
            }
            PortalServerTasks.updateServerClassPath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "lib" + ConfigurationConstants.fs + "ktsearch.jar");
        }
    }

    public void postinstallBaseSunOne() throws ConfigurationException {
        try {
            CharSequence charSequence;
            File file = new File(this.context.getDeployDomain() + ConfigurationConstants.fs + this.context.getDeployInstance() + ConfigurationConstants.fs + "config" + ConfigurationConstants.fs + "server.policy");
            if (!file.exists()) {
                throw new ConfigurationException("Server Policy file for SunOne AppServer missing:" + file.getAbsolutePath());
            }
            String string = Util.findTextInFile(file, "permission java.io.FilePermission \"\\${/}-\"");
            boolean bl = true;
            if (string != null && !string.equals("") && string.indexOf("read,write,execute,delete") != -1) {
                bl = false;
            }
            if (bl) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("// S1PS\n");
                ((StringBuffer)charSequence).append("grant {\n");
                ((StringBuffer)charSequence).append("      permission java.util.PropertyPermission \"*\", \"read,write\";\n");
                ((StringBuffer)charSequence).append("      permission java.lang.RuntimePermission \"writeFileDescriptor\";\n");
                ((StringBuffer)charSequence).append("      permission java.lang.RuntimePermission \"createClassLoader\";\n");
                ((StringBuffer)charSequence).append("      permission java.io.FilePermission \"\\${/}-\", \"read,write,execute,delete\";\n");
                ((StringBuffer)charSequence).append("};\n");
                ((StringBuffer)charSequence).append("\n");
                Util.appendLineEof(file, ((StringBuffer)charSequence).toString(), false);
            }
            charSequence = null;
            charSequence = Util.is_windows() ? this.context.getDeployDir() + ConfigurationConstants.fs + "bin" + ConfigurationConstants.fs + "asadmin.bat" : this.context.getDeployDir() + ConfigurationConstants.fs + "bin" + ConfigurationConstants.fs + "asadmin";
            File file2 = new File((String)charSequence);
            if (!file2.exists()) {
                throw new ConfigurationException("Asadmin utility for SunOne AppServer missing:" + (String)charSequence);
            }
            String string2 = Util.is_windows() ? ";" : ":";
            String string3 = this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "lib";
            String string4 = Util.is_windows() ? string3.replace('\\', '/') : string3;
            String string5 = this.context.getDeployInstance() + ".java-config.libpathprefix=." + string2 + string4;
            String[] stringArray = new String[]{"set", string5, "-u", this.context.getDeployAdmin(), "-w", this.context.getDeployAdminPassword(), "-p", this.context.getDeployAdminPort()};
            try {
                Util.runCommandLine((String)charSequence, stringArray);
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception.toString());
            }
            stringArray = new String[]{"reconfig", "-u", this.context.getDeployAdmin(), "-w", this.context.getDeployAdminPassword(), "-p", this.context.getDeployAdminPort(), this.context.getDeployInstance()};
            try {
                Util.runCommandLine((String)charSequence, stringArray);
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception.toString());
            }
            PortalServerTasks.updateServerClassPath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "lib" + ConfigurationConstants.fs + "psimapprovider.jar");
            this.reconfigureSunOne();
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
    }

    private void reconfigureSunOne() throws ConfigurationException {
        String string = null;
        string = Util.is_windows() ? this.context.getDeployDir() + ConfigurationConstants.fs + "bin" + ConfigurationConstants.fs + "asadmin.bat" : this.context.getDeployDir() + ConfigurationConstants.fs + "bin" + ConfigurationConstants.fs + "asadmin";
        File file = new File(string);
        if (!file.exists()) {
            throw new ConfigurationException("Asadmin utility for SunOne AppServer missing:" + string);
        }
        String[] stringArray = new String[]{"reconfig", "-u", this.context.getDeployAdmin(), "-w", this.context.getDeployAdminPassword(), "-p", this.context.getDeployAdminPort(), "--keepmanualchanges=true", this.context.getDeployInstance()};
        try {
            Util.runCommandLine(string, stringArray);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    private void postinstallContainer() throws ConfigurationException {
        PortalServerTasks.updateServerClassPath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "lib" + ConfigurationConstants.fs + "container.jar");
        if (this.context.getDeployType().equals("SUNONE")) {
            this.reconfigureSunOne();
        }
    }

    private void postinstallPortlet() throws ConfigurationException {
        PortalServerTasks.updateServerClassPath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "lib" + ConfigurationConstants.fs + "portletcommon.jar");
        PortalServerTasks.updateServerClassPath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "lib" + ConfigurationConstants.fs + "portletcontainercommon.jar");
        PortalServerTasks.updateServerClassPath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "lib" + ConfigurationConstants.fs + "portlet.jar");
        PortalServerTasks.updateServerClassPath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "lib" + ConfigurationConstants.fs + "portlettl.jar");
        PortalServerTasks.updateServerClassPath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "lib" + ConfigurationConstants.fs + "jdom.jar");
        if (this.context.getDeployType().equals("SUNONE")) {
            this.reconfigureSunOne();
        }
    }

    public void isconfig() throws ConfigurationException {
        this.PSTasks.isconfig();
    }

    public void config() throws ConfigurationException {
        File file = new File(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "export" + ConfigurationConstants.fs + "rewriter_rule" + ConfigurationConstants.fs + "GenericRuleSet.xml");
        if (!file.exists()) {
            throw new ConfigurationException(file.getName() + " doesn't exist\n");
        }
        Util.debug("Loading " + file);
        PortalServerTasks.loadRewriterRules(file);
        file = new File(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "export" + ConfigurationConstants.fs + "rewriter_rule" + ConfigurationConstants.fs + "DefaultRuleSet.xml");
        if (!file.exists()) {
            throw new ConfigurationException(file.getName() + " doesn't exist\n");
        }
        Util.debug("Loading " + file);
        PortalServerTasks.loadRewriterRules(file);
        String[] stringArray = new String[7];
        stringArray[0] = "modify";
        stringArray[1] = "-m -u";
        stringArray[2] = this.context.getAmAdminDN();
        stringArray[3] = "-w";
        stringArray[4] = this.context.getISAdminPassword();
        stringArray[5] = "-g";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Util.decoratePath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "desktop" + ConfigurationConstants.fs + "dp-providers.xml") + " ");
        stringBuffer.append(Util.decoratePath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "discussions" + ConfigurationConstants.fs + "dp-providers.xml") + " ");
        stringBuffer.append(Util.decoratePath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "Subscriptions" + ConfigurationConstants.fs + "dp-providers.xml") + " ");
        stringBuffer.append(Util.decoratePath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "AddressBook" + ConfigurationConstants.fs + "addressBookProvider.xml") + " ");
        stringBuffer.append(Util.decoratePath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "Calendar" + ConfigurationConstants.fs + "calendarProvider.xml") + " ");
        stringBuffer.append(Util.decoratePath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "Mail" + ConfigurationConstants.fs + "mailProvider.xml") + " ");
        stringBuffer.append(Util.decoratePath(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "InstantMessaging" + ConfigurationConstants.fs + "dp-IMProvider.xml"));
        stringArray[6] = stringBuffer.toString();
        Util.debug("Loading Display Profile:" + stringBuffer);
        PortalServerTasks.loadDisplayProfile(stringArray);
    }

    public void special() throws ConfigurationException {
        String string = this.context.getDeployInstance();
        String string2 = this.context.getDeployURI();
        String string3 = this.context.getServerPort();
        String string4 = this.context.getDeployNow();
        if (string4.equals("y")) {
            try {
                PortalServerTasks.undeploy(string, string2);
                Util.debug("Running deploy");
                PortalServerTasks.deploy(string, string2);
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception.toString());
            }
        }
        try {
            Util.debug("Running seachconfig on " + string + ", " + string3);
            PortalServerTasks.searchConfig(string, string3);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    public void scrubds() throws ConfigurationException {
        FileWriter fileWriter;
        File file;
        Util.debug("Running scrubds_Base");
        try {
            file = File.createTempFile("tmpfile", ".request");
            fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fileWriter.write("<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\" \"file:" + this.context.getISBaseDir() + IS_SUFFIX + "/dtd/amAdmin.dtd\">\n");
            fileWriter.write("<Requests>\n");
            fileWriter.write("  <OrganizationRequests DN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("    <RemoveServiceTemplateAttributeValues serviceName=\"iPlanetAMAuthService\" schemaType=\"Organization\">\n");
            fileWriter.write("      <AttributeValuePair>\n");
            fileWriter.write("        <Attribute name=\"iplanet-am-auth-login-success-url\"/>\n");
            fileWriter.write("        <Value>/amserver</Value>\n");
            fileWriter.write("      </AttributeValuePair>\n");
            fileWriter.write("    </RemoveServiceTemplateAttributeValues>\n");
            fileWriter.write("  </OrganizationRequests>\n");
            fileWriter.write("  <OrganizationRequests DN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("    <RemoveServiceTemplateAttributeValues serviceName=\"iPlanetAMAdminConsoleService\" schemaType=\"Organization\">\n");
            fileWriter.write("      <AttributeValuePair>\n");
            fileWriter.write("        <Attribute name=\"iplanet-am-required-services\"/>\n");
            fileWriter.write("        <Value>SunPortalDesktopService</Value>\n");
            fileWriter.write("        <Value>SunPortalSubscriptionsService</Value>\n");
            fileWriter.write("        <Value>SunPortalNetmailService</Value>\n");
            fileWriter.write("        <Value>SunSSOAdapterService</Value>\n");
            fileWriter.write("      </AttributeValuePair>\n");
            fileWriter.write("    </RemoveServiceTemplateAttributeValues>\n");
            fileWriter.write("  </OrganizationRequests>\n");
            fileWriter.write("</Requests>\n");
            fileWriter.close();
            PortalServerTasks.loadRequest(file);
            file.delete();
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        try {
            file = File.createTempFile("tmpfile", ".request");
            fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fileWriter.write("<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\" \"file:" + this.context.getISBaseDir() + IS_SUFFIX + "/dtd/amAdmin.dtd\">\n");
            fileWriter.write("<Requests>\n");
            fileWriter.write("  <SchemaRequests serviceName=\"iPlanetAMAdminConsoleService\" SchemaType=\"Global\">\n");
            fileWriter.write("    <RemovePartialDefaultValues>\n");
            fileWriter.write("      <AttributeValuePair>\n");
            fileWriter.write("        <Attribute name=\"iplanet-am-console-service-view-bean\"/>\n");
            fileWriter.write("        <Value>SunPortalDesktopService|/portal/dtadmin/DesktopAdminUserProfile</Value>\n");
            fileWriter.write("      </AttributeValuePair>\n");
            fileWriter.write("    </RemovePartialDefaultValues>\n");
            fileWriter.write("  </SchemaRequests>\n");
            fileWriter.write("  <SchemaRequests serviceName=\"iPlanetAMAdminConsoleService\" SchemaType=\"Organization\">\n");
            fileWriter.write("    <RemovePartialDefaultValues>\n");
            fileWriter.write("      <AttributeValuePair>\n");
            fileWriter.write("        <Attribute name=\"iplanet-am-admin-console-online-help\"/>\n");
            fileWriter.write("        <Value>Portal Help|/ps/pshelp.htm|psDesktop</Value>\n");
            fileWriter.write("      </AttributeValuePair>\n");
            fileWriter.write("    </RemovePartialDefaultValues>\n");
            fileWriter.write("  </SchemaRequests>\n");
            fileWriter.write("</Requests>\n");
            fileWriter.close();
            PortalServerTasks.loadRequest(file);
            file.delete();
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        try {
            file = File.createTempFile("tmpfile", ".request");
            fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fileWriter.write("<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\" \"file:" + this.context.getISBaseDir() + IS_SUFFIX + "/dtd/amAdmin.dtd\">\n");
            fileWriter.write("<Requests>\n");
            fileWriter.write("<OrganizationRequests DN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<DeletePolicy deleteDN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<PolicyName name=\"Ability to execute Portal Server Desktop\" />\n");
            fileWriter.write("</DeletePolicy>\n");
            fileWriter.write("</OrganizationRequests>\n");
            fileWriter.write("</Requests>\n");
            fileWriter.close();
            PortalServerTasks.loadRequest(file);
            file.delete();
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        try {
            file = File.createTempFile("tmpfile", ".request");
            fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fileWriter.write("<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\" \"file:" + this.context.getISBaseDir() + IS_SUFFIX + "/dtd/amAdmin.dtd\">\n");
            fileWriter.write("<Requests>\n");
            fileWriter.write("<OrganizationRequests DN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<UnregisterServices>\n");
            fileWriter.write("<Service_Name>SunPortalDesktopService</Service_Name>\n");
            fileWriter.write("</UnregisterServices>\n");
            fileWriter.write("</OrganizationRequests>\n");
            fileWriter.write("</Requests>\n");
            fileWriter.close();
            PortalServerTasks.loadRequest(file);
            file.delete();
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        try {
            file = File.createTempFile("tmpfile", ".request");
            fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fileWriter.write("<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\" \"file:" + this.context.getISBaseDir() + IS_SUFFIX + "/dtd/amAdmin.dtd\">\n");
            fileWriter.write("<Requests>\n");
            fileWriter.write("<OrganizationRequests DN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<DeletePolicy deleteDN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<PolicyName name=\"Ability to execute Portal Server Netmail\" />\n");
            fileWriter.write("</DeletePolicy>\n");
            fileWriter.write("</OrganizationRequests>\n");
            fileWriter.write("</Requests>\n");
            fileWriter.close();
            PortalServerTasks.loadRequest(file);
            file.delete();
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        try {
            file = File.createTempFile("tmpfile", ".request");
            fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fileWriter.write("<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\" \"file:" + this.context.getISBaseDir() + IS_SUFFIX + "/dtd/amAdmin.dtd\">\n");
            fileWriter.write("<Requests>\n");
            fileWriter.write("<OrganizationRequests DN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<UnregisterServices>\n");
            fileWriter.write("<Service_Name>SunPortalNetMailService</Service_Name>\n");
            fileWriter.write("</UnregisterServices>\n");
            fileWriter.write("</OrganizationRequests>\n");
            fileWriter.write("</Requests>\n");
            fileWriter.close();
            PortalServerTasks.loadRequest(file);
            file.delete();
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        try {
            file = File.createTempFile("tmpfile", ".request");
            fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fileWriter.write("<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\" \"file:" + this.context.getISBaseDir() + IS_SUFFIX + "/dtd/amAdmin.dtd\">\n");
            fileWriter.write("<Requests>\n");
            fileWriter.write("<OrganizationRequests DN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<DeletePolicy deleteDN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<PolicyName name=\"Ability to execute Portal Server Subscriptions\" />\n");
            fileWriter.write("</DeletePolicy>\n");
            fileWriter.write("</OrganizationRequests>\n");
            fileWriter.write("</Requests>\n");
            fileWriter.close();
            PortalServerTasks.loadRequest(file);
            file.delete();
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        try {
            file = File.createTempFile("tmpfile", ".request");
            fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fileWriter.write("<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\" \"file:" + this.context.getISBaseDir() + IS_SUFFIX + "/dtd/amAdmin.dtd\">\n");
            fileWriter.write("<Requests>\n");
            fileWriter.write("<OrganizationRequests DN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<UnregisterServices>\n");
            fileWriter.write("<Service_Name>SunPortalSubscriptionsService</Service_Name>\n");
            fileWriter.write("</UnregisterServices>\n");
            fileWriter.write("</OrganizationRequests>\n");
            fileWriter.write("</Requests>\n");
            fileWriter.close();
            PortalServerTasks.loadRequest(file);
            file.delete();
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        try {
            file = File.createTempFile("tmpfile", ".request");
            fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fileWriter.write("<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\" \"file:" + this.context.getISBaseDir() + IS_SUFFIX + "/dtd/amAdmin.dtd\">\n");
            fileWriter.write("<Requests>\n");
            fileWriter.write("<OrganizationRequests DN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<UnregisterServices>\n");
            fileWriter.write("<Service_Name>SunSSOAdapterService</Service_Name>\n");
            fileWriter.write("</UnregisterServices>\n");
            fileWriter.write("</OrganizationRequests>\n");
            fileWriter.write("</Requests>\n");
            fileWriter.close();
            PortalServerTasks.loadRequest(file);
            file.delete();
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        PortalServerTasks.deleteService("sunPortalDesktopService");
        PortalServerTasks.deleteService("sunPortalRewriterService");
        PortalServerTasks.deleteService("sunPortalSearchService");
        PortalServerTasks.deleteService("sunPortalNetmailService");
        PortalServerTasks.deleteService("sunPortalSubscriptionsService");
        PortalServerTasks.deleteService("SunSSOAdapterService");
    }

    public void remove() throws ConfigurationException {
        String string = System.getProperty("DEPLOY_ADMIN_PASSWORD");
        if (string == null || string.equals("")) {
            string = "not_set";
            System.setProperty("DEPLOY_ADMIN_PASSWORD", string);
        }
        String string2 = this.context.getDeployInstance();
        PortalServerTasks.undeploy(string2);
        this.removePortlet(string2);
        PortalServerTasks.removeBase(string2);
        this.cleanupInstance(string2);
    }

    private void removePortlet(String string) throws ConfigurationException {
        File file = new File(this.context.getPSBaseDir() + PS_SUFFIX + ConfigurationConstants.fs + "tmp" + ConfigurationConstants.fs + "portlet");
        if (!file.exists()) {
            return;
        }
        FilenameFilter filenameFilter = Util.getExtensionFilter("xml");
        File[] fileArray = file.listFiles(filenameFilter);
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            String string2 = fileArray[i].getName();
            if (!string2.endsWith("_portlet.xml")) continue;
            String string3 = "/" + string2.substring(0, string2.indexOf("_portlet.xml"));
            Util.debug("Undeploying Portlet war:" + string3);
            PortalServerTasks.undeploy(string, string3);
        }
    }

    private void createPortalCommandFile(String string) throws ConfigurationException {
        try {
            String string2 = this.context.getPSBaseDir() + PS_SUFFIX;
            String string3 = string2 + ConfigurationConstants.fs + "bin" + ConfigurationConstants.fs;
            String string4 = string2 + ConfigurationConstants.fs + "lib" + ConfigurationConstants.fs;
            String string5 = string2 + ConfigurationConstants.fs + "locale";
            String string6 = string2 + ConfigurationConstants.fs + "web-src" + ConfigurationConstants.fs + "WEB-INF" + ConfigurationConstants.fs + "lib" + ConfigurationConstants.fs;
            String string7 = Util.decoratePath(this.context.getJDKDir() + ConfigurationConstants.fs + "bin" + ConfigurationConstants.fs + "java");
            File file = new File(string3, string + ".bat");
            file.createNewFile();
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("@echo off\n\n");
            fileWriter.write("cd " + Util.decoratePath(string3) + "\n");
            fileWriter.write("set PORTAL_CONFIG_JAR=" + string4 + "config.jar\n");
            fileWriter.write("set PORTAL_DESKTOP_JAR=" + string6 + "desktop.jar\n");
            fileWriter.write("set PORTAL_LOCALE=" + string5 + "\n");
            fileWriter.write("set PS_CONFIG_DEBUG=n\n");
            fileWriter.write("set PS_CMDLINE_OUTPUT=y\n");
            fileWriter.write("set PORTAL_CLASSPATH=%PORTAL_CONFIG_JAR%;%PORTAL_DESKTOP_JAR%;%PORTAL_LOCALE%\n");
            fileWriter.write(string7 + " -cp \"%PORTAL_CLASSPATH%\" -DPS_CONFIG_DEBUG=%PS_CONFIG_DEBUG% -DPS_CMDLINE_OUTPUT=%PS_CMDLINE_OUTPUT% -DSYSTEMROOT=%SYSTEMROOT% -DCOMSPEC=%COMSPEC% com.sun.portal.config.util.PortalServerCommand " + string + " %*\n");
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
    }

    private void cleanupInstance(String string) throws ConfigurationException {
        String string2 = this.context.getPSBaseDir() + PS_SUFFIX;
        Util.deleteDir(string2 + ConfigurationConstants.fs + "locale");
        Util.deleteDir(string2 + ConfigurationConstants.fs + "bin");
        Util.deleteDir(string2 + ConfigurationConstants.fs + "tmp");
        Util.deleteDir(string2 + ConfigurationConstants.fs + "export");
        String string3 = string2 + ConfigurationConstants.fs + "https-" + string;
        Util.deleteDir(string3);
        Util.deleteDir(string2 + ConfigurationConstants.fs + "lib");
        Util.deleteDir(string2 + ConfigurationConstants.fs + "web-src");
        Util.deleteDir(string2 + ConfigurationConstants.fs + "config");
        File file = new File(string2 + ConfigurationConstants.fs + "uninstall.bat");
        file.deleteOnExit();
    }

    static {
        if (!Util.is_windows()) {
            IS_SUFFIX = ConfigurationConstants.fs + "SUNWam";
            PS_SUFFIX = ConfigurationConstants.fs + "SUNWps";
            PS_TMP_DIR_SUFFIX = ConfigurationConstants.fs + "var" + ConfigurationConstants.fs + "opt" + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "tmp";
        }
    }
}

