/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config.component;

import com.sun.portal.config.ConfigurationConstants;
import com.sun.portal.config.ConfigurationContext;
import com.sun.portal.config.ConfigurationException;
import com.sun.portal.config.ConfigurationInterface;
import com.sun.portal.config.util.PortalServerTasks;
import com.sun.portal.config.util.Util;

public class PortalServer_SunOS_scripts
implements ConfigurationInterface,
ConfigurationConstants {
    private String name = "Portal Server";
    private ConfigurationContext context;
    private PortalServerTasks PSTasks;

    public PortalServer_SunOS_scripts(ConfigurationContext configurationContext) {
        this.context = configurationContext;
        this.PSTasks = new PortalServerTasks(configurationContext);
    }

    public void init() throws ConfigurationException {
        String string = this.context.getPSBaseDir() + "/SUNWps";
        if (!Util.directoryExists(string)) {
            throw new ConfigurationException(string + " doesn't exist.");
        }
    }

    public void postinstall() throws ConfigurationException {
        try {
            Util.debug("Running postinstall_Base");
            Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/lib/postinstall_Base");
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
        try {
            Util.debug("Running postinstall_Container");
            Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/lib/postinstall_Container");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Util.debug("Running postinstall_Portlet");
            Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/lib/postinstall_Portlet");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void isconfig() throws ConfigurationException {
        try {
            Util.debug("Running isconfig");
            Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/lib/isconfig");
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    public void config() throws ConfigurationException {
        try {
            Util.debug("Running config_Base");
            Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/lib/config_Base");
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    public void special() throws ConfigurationException {
        String[] stringArray;
        String string;
        String string2 = System.getProperty("DEPLOY_ADMIN_PASSWORD");
        if (string2 == null || string2.equals("")) {
            string2 = "not_set";
        }
        try {
            Util.debug("Running wcconfig");
            string = this.context.getPSBaseDir() + "/SUNWps/lib/wcconfig";
            stringArray = new String[]{"config", "-instance", this.context.getProperty("DEPLOY_INSTANCE"), "-deploy_admin_password", string2};
            Util.runCommandLine(string, stringArray);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
        if (!this.context.getDeployType().equals("WEBLOGIC") && !this.context.getDeployType().equals("WEBSPHERE")) {
            try {
                Util.debug("Running deploy");
                string = this.context.getPSBaseDir() + "/SUNWps/bin/deploy";
                stringArray = new String[]{"deploy", "-instance", this.context.getProperty("DEPLOY_INSTANCE"), "-uri", this.context.getProperty("DEPLOY_URI"), "-deploy_admin_password", string2};
                Util.runCommandLine(string, stringArray);
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception.toString());
            }
        }
        try {
            Util.debug("Running searchconfig");
            string = this.context.getPSBaseDir() + "/SUNWps/lib/searchconfig";
            stringArray = new String[]{"-instance", this.context.getProperty("DEPLOY_INSTANCE"), "-port", this.context.getProperty("SERVER_PORT"), "-is_admin_password", System.getProperty("IDSAME_ADMIN_PASSWORD")};
            Util.runCommandLine(string, stringArray);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    public void scrubds() throws ConfigurationException {
        try {
            Util.debug("Running scrubds_Base");
            Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/lib/scrubds_Base");
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    public void remove() throws ConfigurationException {
        String string = System.getProperty("DEPLOY_ADMIN_PASSWORD");
        if (string == null || string.equals("")) {
            string = "not_set";
        }
        try {
            Util.debug("Running undeploy");
            String string2 = this.context.getPSBaseDir() + "/SUNWps/bin/undeploy";
            String[] stringArray = new String[]{"undeploy", "-deploy_admin_password", string};
            Util.runCommandLine(string2, stringArray);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
        try {
            Util.debug("Running remove_Portlet");
            Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/lib/remove_Portlet");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Util.debug("Running remove_Base");
            Util.runCommandLine(this.context.getPSBaseDir() + "/SUNWps/lib/remove_Base");
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }
}

