/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config.component;

import com.sun.portal.config.ConfigurationConstants;
import com.sun.portal.config.ConfigurationContext;
import com.sun.portal.config.ConfigurationException;
import com.sun.portal.config.ConfigurationInterface;
import com.sun.portal.config.util.PortalServerTasks;
import com.sun.portal.config.util.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class PortalServer_SunOS
implements ConfigurationInterface,
ConfigurationConstants {
    private String name = "Portal Server";
    private ConfigurationContext context;
    private PortalServerTasks PSTasks;

    public PortalServer_SunOS(ConfigurationContext configurationContext) {
        this.context = configurationContext;
        this.PSTasks = new PortalServerTasks(configurationContext);
    }

    public void init() throws ConfigurationException {
        String[] stringArray = new String[]{"DEPLOY_URI", "DS_HOST", "DS_PORT", "DS_DIRMGR_DN", "DS_DIRMGR_PASSWORD", "IDSAME_BASEDIR", "IDSAME_ADMIN_PASSWORD", "BASEDIR", "com.iplanet.am.server.host"};
        if (!this.context.checkRequiredAttributes(stringArray)) {
            throw new ConfigurationException("Required Keys missing");
        }
        String string = this.context.getPSBaseDir() + "/SUNWps";
        if (!Util.directoryExists(string)) {
            throw new ConfigurationException(string + " doesn't exist.");
        }
    }

    public void postinstall() throws ConfigurationException {
        String string;
        String string2 = this.context.getDeployType();
        if (string2.equals("IWS")) {
            Util.debug("Removing WS ClassCache");
            Util.deleteDir(this.context.getDeployDir() + ConfigurationConstants.fs + "https-" + this.context.getDeployInstance() + ConfigurationConstants.fs + "ClassCache" + ConfigurationConstants.fs + "https-" + this.context.getDeployInstance());
            Util.debug("Updating WS obj.conf");
            try {
                string = this.context.getDeployDir() + ConfigurationConstants.fs + "https-" + this.context.getServerHost() + ConfigurationConstants.fs + "config" + ConfigurationConstants.fs + "obj.conf";
                String string3 = "fn=index-common";
                Util.deleteLineInFile(new File(string), string3);
            }
            catch (IOException iOException) {
                throw new ConfigurationException(iOException.toString());
            }
        } else if (string2.equals("SUNONE") || string2.equals("WEBLOGIC") || string2.equals("WEBSPHERE")) {
            // empty if block
        }
        Util.debug("Replace Deploy URI in index.html");
        try {
            string = this.context.getPSBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "web-src" + ConfigurationConstants.fs + "index.html";
            Util.replaceTokenInFile(new File(string), "%URL%", this.context.getDeployURI() + ConfigurationConstants.fs + "dt");
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
    }

    public void isconfig() throws ConfigurationException {
        File file = new File(this.context.getPSBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "export" + ConfigurationConstants.fs + "ldif");
        File[] fileArray = file.listFiles(Util.getExtensionFilter("ldif"));
        for (int i = 0; i < fileArray.length; ++i) {
            Util.debug("Loading " + fileArray[i].getName());
            PortalServerTasks.loadSchema(fileArray[i]);
        }
        file = new File(this.context.getPSBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "export" + ConfigurationConstants.fs + "service");
        File[] fileArray2 = file.listFiles(Util.getExtensionFilter("xml"));
        for (int i = 0; i < fileArray2.length; ++i) {
            Util.debug("Loading " + fileArray2[i].getName());
            PortalServerTasks.loadService(fileArray2[i]);
        }
        file = new File(this.context.getPSBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "export" + ConfigurationConstants.fs + "request");
        File[] fileArray3 = file.listFiles(Util.getExtensionFilter("request"));
        for (int i = 0; i < fileArray3.length; ++i) {
            Util.debug("Loading " + fileArray3[i].getName());
            PortalServerTasks.loadRequest(fileArray3[i]);
        }
    }

    public void config() throws ConfigurationException {
        File file = new File(this.context.getPSBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "export" + ConfigurationConstants.fs + "rewriter_rule" + ConfigurationConstants.fs + "RuleSet1.xml");
        if (!file.exists()) {
            throw new ConfigurationException(file.getName() + " doesn't exist\n");
        }
        Util.debug("Loading " + file);
        PortalServerTasks.loadRewriterRules(file);
        file = new File(this.context.getPSBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "export" + ConfigurationConstants.fs + "rewriter_rule" + ConfigurationConstants.fs + "RuleSet2.xml");
        if (!file.exists()) {
            throw new ConfigurationException(file.getName() + " doesn't exist\n");
        }
        Util.debug("Loading " + file);
        PortalServerTasks.loadRewriterRules(file);
        Util.debug("Loading dp-providers.xml");
        String[] stringArray = new String[]{"modify", "-u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "-g", this.context.getPSBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "desktop" + ConfigurationConstants.fs + "dp-providers.xml"};
        PortalServerTasks.loadDisplayProfile(stringArray);
        Util.debug("Loading yahoo dp-providers.xml");
        stringArray = new String[]{"modify", "-m", "-u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "-g", this.context.getPSBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "discussions" + ConfigurationConstants.fs + "dp-providers.xml"};
        PortalServerTasks.loadDisplayProfile(stringArray);
        Util.debug("Loading discussions dp-providers.xml");
        stringArray = new String[]{"modify", "-m", "-u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "-g", this.context.getPSBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "discussions" + ConfigurationConstants.fs + "dp-providers.xml"};
        PortalServerTasks.loadDisplayProfile(stringArray);
        Util.debug("Loading subscriptions dp-providers.xml");
        stringArray = new String[]{"modify", "-m", "-u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "-g", this.context.getPSBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "Subscriptions" + ConfigurationConstants.fs + "dp-providers.xml"};
        PortalServerTasks.loadDisplayProfile(stringArray);
        Util.debug("Loading addressBookProvider.xml");
        stringArray = new String[]{"modify", "-m", "-u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "-g", this.context.getPSBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "AddressBook" + ConfigurationConstants.fs + "addressBookProvider.xml"};
        PortalServerTasks.loadDisplayProfile(stringArray);
        Util.debug("Loading calendarProvider.xml");
        stringArray = new String[]{"modify", "-m", "-u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "-g", this.context.getPSBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "Calendar" + ConfigurationConstants.fs + "calendarProvider.xml"};
        PortalServerTasks.loadDisplayProfile(stringArray);
        Util.debug("Loading mailProvider.xml");
        stringArray = new String[]{"modify", "-m", "-u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "-g", this.context.getPSBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "Mail" + ConfigurationConstants.fs + "mailProvider.xml"};
        PortalServerTasks.loadDisplayProfile(stringArray);
        Util.debug("Loading dp-IMProvider.xml");
        stringArray = new String[]{"modify", "-m", "-u", this.context.getAmAdminDN(), "-w", this.context.getISAdminPassword(), "-g", this.context.getPSBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "samples" + ConfigurationConstants.fs + "InstantMessaging" + ConfigurationConstants.fs + "dp-IMProvider.xml"};
        PortalServerTasks.loadDisplayProfile(stringArray);
    }

    public void special() throws ConfigurationException {
        String string = this.context.getDeployNow();
        if (string.equals("y")) {
            Util.debug("Deploying to " + this.context.getDeployInstance());
            PortalServerTasks.undeploy(this.context.getDeployInstance());
            PortalServerTasks.deploy(this.context.getDeployInstance(), this.context.getDeployURI());
            Util.debug("Calling seachconfig on " + this.context.getDeployInstance() + ", " + this.context.getServerPort());
            try {
                String string2 = this.context.getPSBaseDir() + "/SUNWps/lib/searchconfig";
                String[] stringArray = new String[]{"-instance", this.context.getDeployInstance(), "-port", this.context.getServerPort()};
                Util.runCommandLine(string2, stringArray);
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception.toString());
            }
        }
    }

    public void scrubds() throws ConfigurationException {
        FileWriter fileWriter;
        File file;
        try {
            file = File.createTempFile("tmpfile", ".request");
            fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fileWriter.write("<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\" \"file:" + this.context.getISBaseDir() + "/SUNWam/dtd/amAdmin.dtd\">\n");
            fileWriter.write("<Requests>\n");
            fileWriter.write("<OrganizationRequests DN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<ModifyServiceTemplate serviceName=\"iPlanetAMAuthService\" schemaType=\"Organization\">\n");
            fileWriter.write("<AttributeValuePair>\n");
            fileWriter.write("<Attribute name=\"iplanet-am-auth-login-success-url\"/>\n");
            fileWriter.write("<Value>/amserver</Value>\n");
            fileWriter.write("</AttributeValuePair>\n");
            fileWriter.write("</ModifyServiceTemplate>\n");
            fileWriter.write("</OrganizationRequests>\n");
            fileWriter.write("</Requests>\n");
            fileWriter.close();
            PortalServerTasks.loadRequest(file);
            file.delete();
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        try {
            file = File.createTempFile("tmpfile", ".request");
            fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fileWriter.write("<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\" \"file:" + this.context.getISBaseDir() + "/SUNWam/dtd/amAdmin.dtd\">\n");
            fileWriter.write("<Requests>\n");
            fileWriter.write("<OrganizationRequests DN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<DeletePolicy deleteDN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<PolicyName name=\"Ability to execute Portal Server Desktop\" />\n");
            fileWriter.write("</DeletePolicy>\n");
            fileWriter.write("</OrganizationRequests>\n");
            fileWriter.write("</Requests>\n");
            fileWriter.close();
            PortalServerTasks.loadRequest(file);
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        try {
            file = File.createTempFile("tmpfile", ".request");
            fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fileWriter.write("<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\" \"file:" + this.context.getISBaseDir() + "/SUNWam/dtd/amAdmin.dtd\">\n");
            fileWriter.write("<Requests>\n");
            fileWriter.write("<OrganizationRequests DN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<UnregisterServices>\n");
            fileWriter.write("<Service_Name>SunPortalDesktopService</Service_Name>\n");
            fileWriter.write("</UnregisterServices>\n");
            fileWriter.write("</OrganizationRequests>\n");
            fileWriter.write("</Requests>\n");
            fileWriter.close();
            PortalServerTasks.loadRequest(file);
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        try {
            file = File.createTempFile("tmpfile", ".request");
            fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fileWriter.write("<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\" \"file:" + this.context.getISBaseDir() + "/SUNWam/dtd/amAdmin.dtd\">\n");
            fileWriter.write("<Requests>\n");
            fileWriter.write("<OrganizationRequests DN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<DeletePolicy deleteDN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<PolicyName name=\"Ability to execute Portal Server Netmail\" />\n");
            fileWriter.write("</DeletePolicy>\n");
            fileWriter.write("</OrganizationRequests>\n");
            fileWriter.write("</Requests>\n");
            fileWriter.close();
            PortalServerTasks.loadRequest(file);
            file.delete();
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        try {
            file = File.createTempFile("tmpfile", ".request");
            fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fileWriter.write("<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\" \"file:" + this.context.getISBaseDir() + "/SUNWam/dtd/amAdmin.dtd\">\n");
            fileWriter.write("<Requests>\n");
            fileWriter.write("<OrganizationRequests DN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<UnregisterServices>\n");
            fileWriter.write("<Service_Name>SunPortalNetMailService</Service_Name>\n");
            fileWriter.write("</UnregisterServices>\n");
            fileWriter.write("</OrganizationRequests>\n");
            fileWriter.write("</Requests>\n");
            fileWriter.close();
            PortalServerTasks.loadRequest(file);
            file.delete();
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        try {
            file = File.createTempFile("tmpfile", ".request");
            fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fileWriter.write("<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\" \"file:" + this.context.getISBaseDir() + "/SUNWam/dtd/amAdmin.dtd\">\n");
            fileWriter.write("<Requests>\n");
            fileWriter.write("<OrganizationRequests DN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<DeletePolicy deleteDN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<PolicyName name=\"Ability to execute Portal Server My Yahoo! EE Provider\" />\n");
            fileWriter.write("</DeletePolicy>\n");
            fileWriter.write("</OrganizationRequests>\n");
            fileWriter.write("</Requests>\n");
            fileWriter.close();
            PortalServerTasks.loadRequest(file);
            file.delete();
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        try {
            file = File.createTempFile("tmpfile", ".request");
            fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fileWriter.write("<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\" \"file:" + this.context.getISBaseDir() + "/SUNWam/dtd/amAdmin.dtd\">\n");
            fileWriter.write("<Requests>\n");
            fileWriter.write("<OrganizationRequests DN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<UnregisterServices>\n");
            fileWriter.write("<Service_Name>SunPortalYahooService</Service_Name>\n");
            fileWriter.write("</UnregisterServices>\n");
            fileWriter.write("</OrganizationRequests>\n");
            fileWriter.write("</Requests>\n");
            fileWriter.close();
            PortalServerTasks.loadRequest(file);
            file.delete();
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        try {
            file = File.createTempFile("tmpfile", ".request");
            fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fileWriter.write("<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\" \"file:" + this.context.getISBaseDir() + "/SUNWam/dtd/amAdmin.dtd\">\n");
            fileWriter.write("<Requests>\n");
            fileWriter.write("<OrganizationRequests DN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<DeletePolicy deleteDN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<PolicyName name=\"Ability to execute Portal Server Subscriptions\" />\n");
            fileWriter.write("</DeletePolicy>\n");
            fileWriter.write("</OrganizationRequests>\n");
            fileWriter.write("</Requests>\n");
            fileWriter.close();
            PortalServerTasks.loadRequest(file);
            file.delete();
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        try {
            file = File.createTempFile("tmpfile", ".request");
            fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fileWriter.write("<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\" \"file:" + this.context.getISBaseDir() + "/SUNWam/dtd/amAdmin.dtd\">\n");
            fileWriter.write("<Requests>\n");
            fileWriter.write("<OrganizationRequests DN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<UnregisterServices>\n");
            fileWriter.write("<Service_Name>SunPortalSubscriptionsService</Service_Name>\n");
            fileWriter.write("</UnregisterServices>\n");
            fileWriter.write("</OrganizationRequests>\n");
            fileWriter.write("</Requests>\n");
            fileWriter.close();
            PortalServerTasks.loadRequest(file);
            file.delete();
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        try {
            file = File.createTempFile("tmpfile", ".request");
            fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fileWriter.write("<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\" \"file:" + this.context.getISBaseDir() + "/SUNWam/dtd/amAdmin.dtd\">\n");
            fileWriter.write("<Requests>\n");
            fileWriter.write("<OrganizationRequests DN=\"" + this.context.getDefaultOrgDN() + "\">\n");
            fileWriter.write("<UnregisterServices>\n");
            fileWriter.write("<Service_Name>SunSSOAdapterService</Service_Name>\n");
            fileWriter.write("</UnregisterServices>\n");
            fileWriter.write("</OrganizationRequests>\n");
            fileWriter.write("</Requests>\n");
            fileWriter.close();
            PortalServerTasks.loadRequest(file);
            file.delete();
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        PortalServerTasks.deleteService("sunPortalDesktopService");
        PortalServerTasks.deleteService("sunPortalRewriterService");
        PortalServerTasks.deleteService("sunPortalSearchService");
        PortalServerTasks.deleteService("sunPortalNetmailService");
        PortalServerTasks.deleteService("sunPortalYahooService");
        PortalServerTasks.deleteService("sunPortalSubscriptionsService");
        PortalServerTasks.deleteService("SunSSOAdapterService");
    }

    public void remove() throws ConfigurationException {
        Object object;
        Util.debug("Deploying to " + this.context.getDeployInstance());
        PortalServerTasks.undeploy(this.context.getDeployInstance());
        String string = this.context.getDeployType();
        if (string.equals("IWS")) {
            object = this.context.getISBaseDir() + ConfigurationConstants.fs + "SUNWam" + ConfigurationConstants.fs + "servers" + ConfigurationConstants.fs + "https-" + this.context.getDeployInstance() + ConfigurationConstants.fs + "ClassCache" + ConfigurationConstants.fs + "https-" + this.context.getDeployInstance();
            Util.deleteDir((String)object);
        }
        object = new String[]{this.context.getPSBaseDir() + "/SUNWps/lib/filter", this.context.getPSBaseDir() + "/SUNWps/web-src/docs", "/var/opt/SUNWps/tmp"};
        for (int i = 0; i < ((String[])object).length; ++i) {
            Util.deleteDir(object[i]);
        }
    }
}

