/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config.component;

import com.sun.portal.config.ConfigurationConstants;
import com.sun.portal.config.ConfigurationContext;
import com.sun.portal.config.ConfigurationException;
import com.sun.portal.config.ConfigurationInterface;
import com.sun.portal.config.util.SRATasks;
import com.sun.portal.config.util.Util;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class NetletProxy_SunOS
implements ConfigurationInterface,
ConfigurationConstants {
    private String name = "Netlet Proxy";
    private ConfigurationContext context;

    public NetletProxy_SunOS(ConfigurationContext configurationContext) {
        this.context = configurationContext;
    }

    public void init() throws ConfigurationException {
        String string = this.context.getNLPBaseDir() + "/SUNWps";
        if (!Util.directoryExists(string)) {
            throw new ConfigurationException(string + " doesn't exist.");
        }
    }

    public void postinstall() throws ConfigurationException {
        String[] stringArray;
        String[] stringArray2;
        Object object;
        Object object2;
        Util.debug("Write Authentication Password file");
        try {
            object2 = new File("/etc/opt/SUNWps/.auth_password." + this.context.getNLPGatewayProfile());
            if (!((File)object2).exists()) {
                ((File)object2).createNewFile();
                Util.appendLineEof((File)object2, "uid=amService-srapGateway", true);
                Util.appendLineEof((File)object2, "ldap_passwd=" + this.context.getSRALogUserPassword(), true);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Util.debug("Creating platform.conf");
        try {
            object2 = "/etc/opt/SUNWps/platform.conf-orig";
            object = "/etc/opt/SUNWps/platform.conf." + this.context.getNLPGatewayProfile();
            Util.copyFile((String)object2, (String)object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Util.debug("Updating platform.conf with netletproxy.port");
        object2 = this.context.getNLPPort();
        if (object2 != null && ((String)object2).trim().length() != 0) {
            try {
                object = new File("/etc/opt/SUNWps/platform.conf." + this.context.getNLPGatewayProfile());
                stringArray2 = Util.findTextInFile((File)object, "netletproxy.port=");
                if (stringArray2 != null && stringArray2.trim().length() != 0) {
                    Util.replaceLineInFile((File)object, "netletproxy.port=", new StringBuffer("netletproxy.port=" + (String)object2));
                } else {
                    Util.appendLineEof((File)object, "netletproxy.port=" + (String)object2, false);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.context.getCreateISInstance().equals("y")) {
            Util.debug("Updating platform.conf with portal.server.instance");
            object = this.context.getServerInstance();
            if (object != null && ((String)object).trim().length() != 0) {
                try {
                    stringArray2 = new File("/etc/opt/SUNWps/platform.conf." + this.context.getNLPGatewayProfile());
                    stringArray = Util.findTextInFile((File)stringArray2, "portal.server.instance=");
                    if (stringArray != null && stringArray.trim().length() != 0) {
                        Util.replaceLineInFile((File)stringArray2, "portal.server.instance=", new StringBuffer("portal.server.instance=" + (String)object));
                    } else {
                        Util.appendLineEof((File)stringArray2, "portal.server.instance=" + (String)object, false);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        object = this.context.getNLPBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "bin";
        stringArray2 = new String[]{(String)object + ConfigurationConstants.fs + "netletd", (String)object + ConfigurationConstants.fs + "gwcertutil", (String)object + ConfigurationConstants.fs + "certadmin", (String)object + ConfigurationConstants.fs + "certtool", (String)object + ConfigurationConstants.fs + "checknetletd", "/etc/init.d/netletd", "/etc/opt/SUNWps/platform.conf." + this.context.getNLPGatewayProfile()};
        stringArray = new String[]{"${BASE_DIR}", "${IDSAME_BASE_DIR}", "${PRODUCT_DIR}", "${JAVA_BASE_DIR}", "SERVER_PROTO", "SERVER_HOST", "SERVER_PORT", "SERVER_URL", "DEPLOY_URI", "GW_PROTOCOL", "GW_HOST", "GW_PORT", "GATEWAY_IPADDR", "GW_VIRTUAL_HOST", "SSL_CONNECTION", "CERT_DB_DIR", "WEBSERVER_HOST"};
        String[] stringArray3 = new String[]{this.context.getNLPBaseDir(), this.context.getISBaseDir(), "SUNWps", this.context.getJDKDir(), this.context.getServerProtocol(), this.context.getServerHost(), this.context.getServerPort(), this.context.getServerProtocol() + "://" + this.context.getServerHost() + ":" + this.context.getServerPort(), this.context.getDeployURI(), this.context.getNLPProtocol(), this.context.getNLPHost(), this.context.getNLPPort(), this.context.getNLPIPAddress(), this.context.getNLPHost() + " " + this.context.getNLPIPAddress(), "true", "/etc/opt/SUNWps/cert/" + this.context.getNLPGatewayProfile(), this.context.getServerHost()};
        Util.debug("Performing token substitution on files");
        for (int i = 0; i < stringArray2.length; ++i) {
            try {
                Util.debug("Processing " + stringArray2[i]);
                Util.replaceTokenInFile(new File(stringArray2[i]), stringArray, stringArray3);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new ConfigurationException(iOException.toString());
            }
        }
        String[] stringArray4 = new String[]{(String)object + ConfigurationConstants.fs + "netletd", (String)object + ConfigurationConstants.fs + "gwcertutil", (String)object + ConfigurationConstants.fs + "certadmin", (String)object + ConfigurationConstants.fs + "certtool", (String)object + ConfigurationConstants.fs + "checknetletd", "/etc/init.d/netletd"};
        for (int i = 0; i < stringArray4.length; ++i) {
            try {
                Util.changeFilePermission(stringArray4[i], "755");
                continue;
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception.toString());
            }
        }
        Util.debug("Generating certificate");
        try {
            String string = "/etc/opt/SUNWps/cert/" + this.context.getNLPGatewayProfile();
            String string2 = this.context.getNLPBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "lib";
            Util.makeDir(string);
            SRATasks.generateCert(string, string2, this.context.getNLPBaseDir());
        }
        catch (ConfigurationException configurationException) {
            configurationException.printStackTrace();
        }
    }

    public void isconfig() throws ConfigurationException {
    }

    public void config() throws ConfigurationException {
    }

    public void special() throws ConfigurationException {
    }

    public void scrubds() throws ConfigurationException {
    }

    public void remove() throws ConfigurationException {
        Object object;
        Object object2;
        try {
            Util.debug("Stop netletd watchdog");
            object2 = ConfigurationConstants.fs + "etc" + ConfigurationConstants.fs + "inet.d" + ConfigurationConstants.fs + "netletd";
            object = new String[]{"watchdog", "off"};
            Util.runCommandLine((String)object2, object);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
        try {
            Util.debug("Stop netletd");
            object2 = ConfigurationConstants.fs + "etc" + ConfigurationConstants.fs + "inet.d" + ConfigurationConstants.fs + "netletd";
            object = new String[]{"stop"};
            Util.runCommandLine((String)object2, object);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
        object2 = new File(ConfigurationConstants.fs + "etc" + ConfigurationConstants.fs + "opt" + ConfigurationConstants.fs + "SUNWps");
        object = Util.getExtensionFilter("conf");
        File[] fileArray = ((File)object2).listFiles((FilenameFilter)object);
        for (int i = 0; i < fileArray.length; ++i) {
            Util.debug("Deleting " + fileArray[i].getName());
            Util.deleteFile(fileArray[i].getAbsoluteFile());
        }
        try {
            Util.debug("Saving cert directory");
            String string = "/etc/opt/SUNWps/cert";
            String string2 = "/etc/opt/SUNWps/SAVE-cert";
            Util.moveFile(string, string2);
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
    }
}

