/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config.component;

import com.sun.portal.config.ConfigurationConstants;
import com.sun.portal.config.ConfigurationContext;
import com.sun.portal.config.ConfigurationException;
import com.sun.portal.config.ConfigurationInterface;
import com.sun.portal.config.util.SRATasks;
import com.sun.portal.config.util.Util;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class Gateway_SunOS
implements ConfigurationInterface,
ConfigurationConstants {
    private String name = "Gateway";
    private ConfigurationContext context;

    public Gateway_SunOS(ConfigurationContext configurationContext) {
        this.context = configurationContext;
    }

    public void init() throws ConfigurationException {
        String string = this.context.getGWBaseDir() + "/SUNWps";
        if (!Util.directoryExists(string)) {
            throw new ConfigurationException(string + " doesn't exist.");
        }
    }

    public void postinstall() throws ConfigurationException {
        String string;
        String string2;
        String[] stringArray;
        Object object;
        Object object2;
        Util.debug("Write Authentication Password file");
        try {
            object2 = new File("/etc/opt/SUNWps/.auth_password." + this.context.getGWGatewayProfile());
            if (!((File)object2).exists()) {
                ((File)object2).createNewFile();
                Util.appendLineEof((File)object2, "uid=amService-srapGateway", true);
                Util.appendLineEof((File)object2, "ldap_passwd=" + this.context.getSRALogUserPassword(), true);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Util.debug("Creating platform.conf");
        try {
            object2 = "/etc/opt/SUNWps/platform.conf-orig";
            object = "/etc/opt/SUNWps/platform.conf." + this.context.getGWGatewayProfile();
            Util.copyFile((String)object2, (String)object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Util.debug("Updating platform.conf with gateway.bindipaddress");
        object2 = this.context.getGWIPAddress();
        if (object2 != null && ((String)object2).trim().length() != 0) {
            try {
                object = new File("/etc/opt/SUNWps/platform.conf." + this.context.getGWGatewayProfile());
                stringArray = Util.findTextInFile((File)object, "gateway.bindipaddress=");
                if (stringArray != null && stringArray.trim().length() != 0) {
                    Util.replaceLineInFile((File)object, "gateway.bindipaddress=", new StringBuffer("gateway.bindipaddress=" + (String)object2));
                } else {
                    Util.appendLineEof((File)object, "gateway.bindipaddress=" + (String)object2, false);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        Util.debug("Updating platform.conf with gateway.sockretries");
        try {
            object = new File("/etc/opt/SUNWps/platform.conf." + this.context.getGWGatewayProfile());
            stringArray = Util.findTextInFile((File)object, "gateway.sockretries=");
            if (stringArray != null && stringArray.trim().length() != 0) {
                Util.replaceLineInFile((File)object, "gateway.sockretries=", new StringBuffer("gateway.sockretries=3"));
            } else {
                Util.appendLineEof((File)object, "gateway.sockretries=3", false);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object = this.context.getGWBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "bin";
        stringArray = new String[]{(String)object + ConfigurationConstants.fs + "gateway", (String)object + ConfigurationConstants.fs + "gwcertutil", (String)object + ConfigurationConstants.fs + "certadmin", (String)object + ConfigurationConstants.fs + "certtool", (String)object + ConfigurationConstants.fs + "checkgw", "/etc/init.d/gateway", "/etc/opt/SUNWps/platform.conf." + this.context.getGWGatewayProfile()};
        String[] stringArray2 = new String[]{"${BASE_DIR}", "${IDSAME_BASE_DIR}", "${PRODUCT_DIR}", "${JAVA_BASE_DIR}", "SERVER_PROTO", "SERVER_HOST", "SERVER_PORT", "SERVER_URL", "DEPLOY_URI", "GW_PROTOCOL", "GW_HOST", "GW_PORT", "GATEWAY_IPADDR", "GW_VIRTUAL_HOST", "SSL_CONNECTION", "CERT_DB_DIR", "WEBSERVER_HOST"};
        String[] stringArray3 = new String[]{this.context.getGWBaseDir(), this.context.getISBaseDir(), "SUNWps", this.context.getJDKDir(), this.context.getServerProtocol(), this.context.getServerHost(), this.context.getServerPort(), this.context.getServerProtocol() + "://" + this.context.getServerHost() + ":" + this.context.getServerPort(), this.context.getDeployURI(), this.context.getGWProtocol(), this.context.getGWHost(), this.context.getGWPort(), this.context.getGWIPAddress(), this.context.getGWHost() + " " + this.context.getGWIPAddress(), "true", "/etc/opt/SUNWps/cert/" + this.context.getGWGatewayProfile(), this.context.getServerHost()};
        Util.debug("Performing token substitution on files");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Util.debug("Processing " + stringArray[i]);
                Util.replaceTokenInFile(new File(stringArray[i]), stringArray2, stringArray3);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        String[] stringArray4 = new String[]{(String)object + ConfigurationConstants.fs + "gateway", (String)object + ConfigurationConstants.fs + "gwcertutil", (String)object + ConfigurationConstants.fs + "certadmin", (String)object + ConfigurationConstants.fs + "certtool", (String)object + ConfigurationConstants.fs + "checkgw", "/etc/init.d/gateway"};
        for (int i = 0; i < stringArray4.length; ++i) {
            try {
                Util.changeFilePermission(stringArray4[i], "755");
                continue;
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception.toString());
            }
        }
        Util.debug("Generating certificate");
        try {
            string2 = "/etc/opt/SUNWps/cert/" + this.context.getGWGatewayProfile();
            string = this.context.getGWBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "lib";
            Util.makeDir(string2);
            SRATasks.generateCert(string2, string, this.context.getGWBaseDir());
        }
        catch (ConfigurationException configurationException) {
            configurationException.printStackTrace();
        }
        string2 = this.context.getGWStart();
        if (string2 != null && string2.equals("y")) {
            Util.debug("Starting gateway");
            try {
                string = this.context.getGWBaseDir() + ConfigurationConstants.fs + "SUNWps" + ConfigurationConstants.fs + "bin" + ConfigurationConstants.fs + "gateway";
                String[] stringArray5 = new String[]{"-n", this.context.getGWGatewayProfile(), "start"};
                Util.runCommandLine(string, stringArray5);
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception.toString());
            }
        }
    }

    public void isconfig() throws ConfigurationException {
    }

    public void config() throws ConfigurationException {
    }

    public void special() throws ConfigurationException {
    }

    public void scrubds() throws ConfigurationException {
    }

    public void remove() throws ConfigurationException {
        File file = new File(ConfigurationConstants.fs + "etc" + ConfigurationConstants.fs + "opt" + ConfigurationConstants.fs + "SUNWps");
        FilenameFilter filenameFilter = Util.getExtensionFilter("conf");
        File[] fileArray = file.listFiles(filenameFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            Util.debug("Deleting " + fileArray[i].getName());
            Util.deleteFile(fileArray[i].getAbsoluteFile());
        }
        try {
            Util.debug("Saving cert directory");
            String string = "/etc/opt/SUNWps/cert";
            String string2 = "/etc/opt/SUNWps/SAVE-cert";
            Util.moveFile(string, string2);
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
    }
}

