/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config;

import com.sun.portal.config.ConfigurationConstants;
import com.sun.portal.config.ConfigurationContext;
import com.sun.portal.config.ConfigurationException;
import com.sun.portal.config.ConfigurationInterface;
import com.sun.portal.config.component.Gateway;
import com.sun.portal.config.component.Gateway_SunOS_scripts;
import com.sun.portal.config.component.NetletProxy;
import com.sun.portal.config.component.NetletProxy_SunOS_scripts;
import com.sun.portal.config.component.PortalServer_SunOS_scripts;
import com.sun.portal.config.component.PortalServer_Windows;
import com.sun.portal.config.component.RewriterProxy;
import com.sun.portal.config.component.RewriterProxy_SunOS_scripts;
import com.sun.portal.config.component.SRA_SunOS_scripts;
import com.sun.portal.config.component.SRA_Windows;
import com.sun.portal.config.component.SamplePortal_SunOS_scripts;
import com.sun.portal.config.component.SamplePortal_Windows;
import com.sun.portal.config.component.SampleSRA_SunOS_scripts;
import com.sun.portal.config.component.SampleSRA_Windows;
import com.sun.portal.config.component.Wireless_SunOS_scripts;
import com.sun.portal.config.component.Yahoo_SunOS_scripts;
import com.sun.portal.config.component.Yahoo_Windows;
import com.sun.portal.config.util.Util;
import java.io.IOException;
import java.util.StringTokenizer;

public class ConfigurationManager
implements ConfigurationConstants {
    private static ConfigurationContext context;

    public ConfigurationManager(String string) {
        context = new ConfigurationContext(string);
    }

    public void init() throws ConfigurationException {
        if (!Util.isRoot()) {
            throw new ConfigurationException("You must be a root user.");
        }
    }

    public void setComponent(String string) throws IOException {
        context.setComponent(string);
    }

    public void configure() throws ConfigurationException {
        this.init();
        String[] stringArray = this.getComponentsToConfigure();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            ConfigurationInterface configurationInterface = this.getComponentClass(string);
            if (configurationInterface == null) {
                throw new ConfigurationException("Missing class for " + string);
            }
            try {
                configurationInterface.init();
                configurationInterface.postinstall();
                String string2 = System.getProperty("PS_UPGRADE_MODE");
                if (string2 == null || !string2.equals("y")) {
                    configurationInterface.isconfig();
                    configurationInterface.config();
                }
                configurationInterface.special();
                continue;
            }
            catch (ConfigurationException configurationException) {
                throw new ConfigurationException(configurationException.toString());
            }
        }
    }

    public void scrubds() throws ConfigurationException {
        String string = System.getProperty("PS_UPGRADE_MODE");
        if (string == null || !string.equals("y")) {
            this.init();
            String[] stringArray = this.getComponentsToConfigure();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                ConfigurationInterface configurationInterface = this.getComponentClass(string2);
                if (configurationInterface == null) {
                    throw new ConfigurationException("Missing class for " + string2);
                }
                try {
                    configurationInterface.init();
                    configurationInterface.scrubds();
                    continue;
                }
                catch (ConfigurationException configurationException) {
                    throw new ConfigurationException(configurationException.toString());
                }
            }
        }
    }

    public void unconfigure() throws ConfigurationException {
        this.init();
        String[] stringArray = this.getComponentsToConfigure();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            ConfigurationInterface configurationInterface = this.getComponentClass(string);
            if (configurationInterface == null) {
                throw new ConfigurationException("Missing class for " + string);
            }
            try {
                configurationInterface.init();
                configurationInterface.remove();
                continue;
            }
            catch (ConfigurationException configurationException) {
                throw new ConfigurationException(configurationException.toString());
            }
        }
    }

    public String[] getComponentsToConfigure() throws ConfigurationException {
        String string = context.getProperty("COMPONENTS_TO_CONFIGURE");
        if (string == null || string.equals("")) {
            throw new ConfigurationException("Bad key: COMPONENTS_TO_CONFIGURE");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n] = (String)stringTokenizer.nextElement();
            ++n;
        }
        return stringArray;
    }

    public ConfigurationInterface getComponentClass(String string) {
        String string2 = System.getProperty("PS_MULTIPLATFORM");
        if (string2 != null && string2.equals("y")) {
            if (string.equals("Portal Server")) {
                return new PortalServer_Windows(context);
            }
            if (string.equals("Yahoo Support")) {
                return new Yahoo_Windows(context);
            }
            if (string.equals("Mobile Access Support")) {
                return new Wireless_SunOS_scripts(context);
            }
            if (string.equals("SRA Support")) {
                return new SRA_Windows(context);
            }
            if (string.equals("Sample Portal")) {
                return new SamplePortal_Windows(context);
            }
            if (string.equals("Sample SRA")) {
                return new SampleSRA_Windows(context);
            }
            if (string.equals("Gateway")) {
                return new Gateway(context.getBootstrapDirectory());
            }
            if (string.equals("Netlet Proxy")) {
                return new NetletProxy(context.getBootstrapDirectory());
            }
            if (string.equals("Rewriter Proxy")) {
                return new RewriterProxy(context.getBootstrapDirectory());
            }
            return null;
        }
        if (string.equals("Portal Server")) {
            return new PortalServer_SunOS_scripts(context);
        }
        if (string.equals("Yahoo Support")) {
            return new Yahoo_SunOS_scripts(context);
        }
        if (string.equals("Mobile Access Support")) {
            return new Wireless_SunOS_scripts(context);
        }
        if (string.equals("SRA Support")) {
            return new SRA_SunOS_scripts(context);
        }
        if (string.equals("Sample Portal")) {
            return new SamplePortal_SunOS_scripts(context);
        }
        if (string.equals("Sample SRA")) {
            return new SampleSRA_SunOS_scripts(context);
        }
        if (string.equals("Gateway")) {
            return new Gateway_SunOS_scripts(context);
        }
        if (string.equals("Netlet Proxy")) {
            return new NetletProxy_SunOS_scripts(context);
        }
        if (string.equals("Rewriter Proxy")) {
            return new RewriterProxy_SunOS_scripts(context);
        }
        return null;
    }
}

