/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config;

import com.sun.portal.config.ConfigurationConstants;
import com.sun.portal.config.util.Util;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class ConfigurationContext
extends Properties
implements ConfigurationConstants {
    protected String bootStrapDirectory = null;

    public String getBootstrapDirectory() {
        return this.bootStrapDirectory;
    }

    public ConfigurationContext(String string) {
        this.bootStrapDirectory = string;
        this.init(string);
    }

    public void init(String string) {
        try {
            if (Util.is_windows()) {
                this.load(new FileInputStream(string + ConfigurationConstants.fs + ConfigurationConstants.PSCONFIG_WINDOWS));
                String[] stringArray = new String[]{"DEPLOY_DIR", "com.iplanet.am.jdk.path", "IDSAME_BASEDIR", "BASEDIR"};
                this.convertToWindowsStylePaths(stringArray);
            } else {
                this.load(new FileInputStream(string + ConfigurationConstants.PSCONFIG));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (Util.is_windows()) {
                this.load(new FileInputStream(string + ConfigurationConstants.fs + ConfigurationConstants.SRACONFIG_WINDOWS));
            } else {
                this.load(new FileInputStream(string + ConfigurationConstants.SRACONFIG));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (Util.is_windows()) {
                this.load(new FileInputStream(string + ConfigurationConstants.fs + ConfigurationConstants.GWCONFIG_WINDOWS));
            } else {
                this.load(new FileInputStream(string + ConfigurationConstants.GWCONFIG));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (Util.is_windows()) {
                this.load(new FileInputStream(string + ConfigurationConstants.fs + ConfigurationConstants.NLPCONFIG_WINDOWS));
            } else {
                this.load(new FileInputStream(string + ConfigurationConstants.NLPCONFIG));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (Util.is_windows()) {
                this.load(new FileInputStream(string + ConfigurationConstants.fs + ConfigurationConstants.RWPCONFIG_WINDOWS));
            } else {
                this.load(new FileInputStream(string + ConfigurationConstants.RWPCONFIG));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (Util.is_windows()) {
                this.load(new FileInputStream(this.getISBaseDir() + ConfigurationConstants.fs + ConfigurationConstants.AMCONFIG_WINDOWS));
            } else {
                this.load(new FileInputStream(ConfigurationConstants.AMCONFIG));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void convertToWindowsStylePaths(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.getProperty(stringArray[i]);
            if (string == null) continue;
            string = string.replace('/', '\\');
            this.setProperty(stringArray[i], string);
        }
    }

    public void setComponent(String string) {
        this.setProperty("COMPONENTS_TO_CONFIGURE", string);
    }

    public boolean attributeExists(String string) {
        String string2 = this.getProperty(string);
        return string2 != null && !string2.equals("");
    }

    public boolean checkRequiredAttributes(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.attributeExists(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    public String getJDKDir() {
        return this.getProperty("com.iplanet.am.jdk.path", "");
    }

    public String getDeployType() {
        return this.getProperty("DEPLOY_TYPE", "");
    }

    public String getDeployDir() {
        return this.getProperty("DEPLOY_DIR", "");
    }

    public String getDeployVirtualHost() {
        return this.getProperty("DEPLOY_VIRTUAL_HOST", "");
    }

    public String getDeployNode() {
        return this.getProperty("DEPLOY_NODE", "");
    }

    public String getDeployDomain() {
        return this.getProperty("DEPLOY_DOMAIN", "");
    }

    public String getDeployInstance() {
        return this.getProperty("DEPLOY_INSTANCE", "");
    }

    public String getDeployDocRoot() {
        return this.getProperty("DEPLOY_DOCROOT", "");
    }

    public String getDeployAdmin() {
        return this.getProperty("DEPLOY_ADMIN", "");
    }

    public String getDeployAdminPassword() {
        return System.getProperty("DEPLOY_ADMIN_PASSWORD");
    }

    public String getDeployAdminProtocol() {
        return this.getProperty("DEPLOY_ADMIN_PROTOCOL", "");
    }

    public String getDeployAdminHost() {
        return this.getProperty("com.iplanet.am.server.host", "");
    }

    public String getDeployAdminPort() {
        return this.getProperty("DEPLOY_ADMIN_PORT", "");
    }

    public String getDeployURI() {
        return this.getProperty("DEPLOY_URI", "");
    }

    public String getDeployNow() {
        return this.getProperty("DEPLOY_NOW", "");
    }

    public String getDSHost() {
        return this.getProperty("DS_HOST", "");
    }

    public String getDSPort() {
        return this.getProperty("DS_PORT", "");
    }

    public String getDSDirMgrDN() {
        return this.getProperty("DS_DIRMGR_DN", "");
    }

    public String getDirMgrPassword() {
        return System.getProperty("DS_DIRMGR_PASSWORD");
    }

    public String getISBaseDir() {
        return this.getProperty("IDSAME_BASEDIR", "");
    }

    public String getISAmServer() {
        return this.getProperty("IDSAME_AMSERVER", "");
    }

    public String getISAmConsole() {
        return this.getProperty("com.iplanet.am.console.deploymentDescriptor", "");
    }

    public String getISUserNaming() {
        return "uid";
    }

    public String getISLdapUserPassword() {
        return System.getProperty("IDSAME_LDAPUSER_PASSWORD");
    }

    public String getISAdminPassword() {
        return System.getProperty("IDSAME_ADMIN_PASSWORD");
    }

    public String getPSBaseDir() {
        return this.getProperty("BASEDIR", "");
    }

    public String getServerProtocol() {
        return this.getProperty("com.iplanet.am.server.protocol", "");
    }

    public String getServerHost() {
        return this.getProperty("com.iplanet.am.server.host", "");
    }

    public String getServerPort() {
        return this.getProperty("com.iplanet.am.server.port", "");
    }

    public String getSRAServerDomain() {
        return this.getProperty("SERVER_DOMAIN", "");
    }

    public String getSRAGatewayProfile() {
        return this.getProperty("SRA_GATEWAY_PROFILE", "");
    }

    public String getSRAUseWebProxy() {
        return this.getProperty("USE_WEBPROXY", "");
    }

    public String getAssignService() {
        return this.getProperty("ASSIGN_SERVICE", "");
    }

    public String getSRALogUserPassword() {
        return System.getProperty("SRA_LOG_USER_PASSWORD");
    }

    public String getGWDomain() {
        return System.getProperty("GW_DOMAIN");
    }

    public String getCertSelfSigned() {
        return this.getProperty("SELF_SIGNED_CERT", "");
    }

    public String getCertPassword() {
        return System.getProperty("CERT_DB_PASSWORD");
    }

    public String getCertStart() {
        return this.getProperty("CERT_INFO", "");
    }

    public String getGWBaseDir() {
        return this.getProperty("GW_BASEDIR", "");
    }

    public String getGWProtocol() {
        return this.getProperty("GW_PROTOCOL", "");
    }

    public String getGWHost() {
        return this.getProperty("GW_HOST", "");
    }

    public String getGWPort() {
        return this.getProperty("GW_PORT", "");
    }

    public String getGWIPAddress() {
        return this.getProperty("GW_IP", "");
    }

    public String getGWGatewayProfile() {
        return this.getProperty("GW_GATEWAY_PROFILE", "");
    }

    public String getGWStart() {
        return this.getProperty("START_GATEWAY", "");
    }

    public String getNLPBaseDir() {
        return this.getProperty("NLP_BASEDIR", "");
    }

    public String getNLPProtocol() {
        return this.getProperty("NLP_PROTOCOL", "");
    }

    public String getNLPHost() {
        return this.getProperty("NLP_HOST", "");
    }

    public String getNLPPort() {
        return this.getProperty("NLP_PORT", "");
    }

    public String getNLPIPAddress() {
        return this.getProperty("NLP_IP", "");
    }

    public String getNLPGatewayProfile() {
        return this.getProperty("NLP_GATEWAY_PROFILE", "");
    }

    public String getServerInstance() {
        return this.getProperty("INSTANCE_NAME", "");
    }

    public String getRWPBaseDir() {
        return this.getProperty("RWP_BASEDIR", "");
    }

    public String getRWPProtocol() {
        return this.getProperty("RWP_PROTOCOL", "");
    }

    public String getRWPHost() {
        return this.getProperty("RWP_HOST", "");
    }

    public String getRWPPort() {
        return this.getProperty("RWP_PORT", "");
    }

    public String getRWPIPAddress() {
        return this.getProperty("RWP_IP", "");
    }

    public String getRWPGatewayProfile() {
        return this.getProperty("RWP_GATEWAY_PROFILE", "");
    }

    public String getCreateISInstance() {
        return this.getProperty("CREATE_IS_INSTANCE", "");
    }

    public String getAmAdminDN() {
        return this.getProperty("com.sun.identity.authentication.super.user");
    }

    public String getRootSuffixDN() {
        return this.getProperty("com.iplanet.am.rootsuffix");
    }

    public String getDefaultOrgDN() {
        String string = this.getProperty("com.iplanet.am.defaultOrg");
        String string2 = this.getRootSuffixDN();
        if (!string2.equals(string)) {
            string = string + "," + string2;
        }
        return string;
    }

    public String getPeopleDN() {
        String string = "ou=People," + this.getDefaultOrgDN();
        return string;
    }

    public String getAuthlessAnonymousDN() {
        String string = this.getISUserNaming() + "=authlessanonymous," + this.getPeopleDN();
        return string;
    }
}

