/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.jndi;

import com.aligo.pim.interfaces.PimSession;
import com.aligo.pim.jndi.JndiPimAddressBook;
import com.aligo.pim.jndi.JndiPimException;
import com.aligo.pim.jndi.JndiPimUserInfo;
import com.aligo.pim.jndi.util.JndiPimAddressEntryItemField;
import com.aligo.pim.jndi.util.JndiPimAddressEntryItemFieldFactory;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public class JndiPimSession
implements PimSession {
    private JndiPimUserInfo m_oPimUserInfo;
    private LdapContext _oLdapContext;
    private JndiPimAddressEntryItemField m_oPimAddressEntryItemField;

    public JndiPimSession(JndiPimUserInfo pimUserInfo) {
        this.m_oPimUserInfo = pimUserInfo;
    }

    public LdapContext getLdapContext() {
        return this._oLdapContext;
    }

    public String getAddressBookBaseDn() {
        return this.m_oPimUserInfo.getJndiLdapABBaseDn();
    }

    public void logon() throws JndiPimException {
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            String port = this.m_oPimUserInfo.getJndiLdapPort();
            if (port == null) {
                port = "389";
            }
            env.put("java.naming.provider.url", "ldap://" + this.m_oPimUserInfo.getJndiLdapServer() + ":" + port);
            String userName = this.m_oPimUserInfo.getJndiLdapUserName();
            if (userName != null && userName != "") {
                env.put("java.naming.security.authentication", "SIMPLE");
                env.put("java.naming.security.principal", this.m_oPimUserInfo.getJndiLdapUserName());
                env.put("java.naming.security.credentials", this.m_oPimUserInfo.getJndiLdapPassword());
            } else {
                env.put("java.naming.security.authentication", "NONE");
            }
            try {
                this._oLdapContext = new InitialLdapContext(env, null);
            }
            catch (AuthenticationException e) {
                boolean tryAnonymous = this.m_oPimUserInfo.getJndiLdapTryAnonymousFallBack();
                if (tryAnonymous) {
                    env.put("java.naming.security.authentication", "NONE");
                    this._oLdapContext = new InitialLdapContext(env, null);
                }
                throw e;
            }
            this.m_oPimAddressEntryItemField = JndiPimAddressEntryItemFieldFactory.get(this.m_oPimUserInfo.getPimLdapServerType());
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public JndiPimAddressEntryItemField getPimAddressEntryItemField() {
        return this.m_oPimAddressEntryItemField;
    }

    public JndiPimAddressBook getGlobalAddressBook() throws JndiPimException {
        try {
            return new JndiPimAddressBook(this);
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }
}

