/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.jndi;

import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exceptions.PimExceptionMapper;
import com.aligo.pim.jndi.JndiPimUserInfo;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import javax.naming.AuthenticationException;

public class JndiPimException
extends PimException {
    private long m_iJndiExceptionCode = -900L;
    private String m_szJndiExceptionMessage = "";
    private long m_iPimExceptionCode = -900L;
    private String m_szPimExceptionMessage = "";

    public JndiPimException(long code) {
        this.setPimExceptionCode(code);
        this.resolve();
    }

    public JndiPimException(Exception e) {
        if (JndiPimUserInfo.DEBUG) {
            e.printStackTrace();
        }
        if (e instanceof JndiPimException) {
            JndiPimException ep = (JndiPimException)((Object)e);
            this.setPimExceptionCode(ep.getCode());
            this.setPimExceptionMessage(ep.getMessage());
        } else if (e instanceof AuthenticationException) {
            this.setPimExceptionCode(1L);
        } else if (e instanceof UnknownHostException) {
            this.setPimExceptionCode(6L);
        } else if (e instanceof ConnectException) {
            this.setPimExceptionCode(6L);
        } else if (e instanceof MalformedURLException) {
            this.setPimExceptionCode(6L);
        }
        this.resolve();
    }

    private void setJndiExceptionCode(long code) {
        this.m_iJndiExceptionCode = code;
    }

    private void setJndiExceptionMessage(String message) {
        this.m_szJndiExceptionMessage = message;
    }

    private long getJndiExceptionCode() {
        return this.m_iJndiExceptionCode;
    }

    private String getJndiExceptionMessage() {
        return this.m_szJndiExceptionMessage;
    }

    private void setPimExceptionCode(long code) {
        this.m_iPimExceptionCode = code;
    }

    private void setPimExceptionMessage(String message) {
        this.m_szPimExceptionMessage = message;
    }

    private long getPimExceptionCode() {
        return this.m_iPimExceptionCode;
    }

    private String getPimExceptionMessage() {
        return this.m_szPimExceptionMessage;
    }

    public String getMessage() {
        return this.getPimExceptionMessage();
    }

    public long getCode() {
        return this.getPimExceptionCode();
    }

    private void resolve() {
        if (this.getPimExceptionCode() != -900L) {
            this.setPimExceptionMessage(PimExceptionMapper.getPimExceptionMessage((long)this.getPimExceptionCode()));
        } else if (this.getJndiExceptionCode() == -900L) {
            this.setPimExceptionMessage(this.getJndiExceptionMessage());
        }
    }
}

