/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.jndi;

import com.aligo.pim.PimFilterOperandType;
import com.aligo.pim.PimFolderType;
import com.aligo.pim.PimTimeZoneType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimAddressBook;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAddressEntryItems;
import com.aligo.pim.interfaces.PimContainer;
import com.aligo.pim.interfaces.PimFolder;
import com.aligo.pim.interfaces.PimUserInfo;
import com.aligo.pim.jndi.JndiPimAddressEntryItemFilter;
import com.aligo.pim.jndi.JndiPimException;
import com.aligo.pim.jndi.JndiPimSession;
import com.aligo.pim.jndi.JndiPimUserInfo;

public class JndiPimContainer
implements PimContainer {
    private JndiPimUserInfo m_oPimUserInfo;
    private JndiPimSession m_oPimSession;
    private boolean m_bLoggenOn = false;

    public PimUserInfo addUserInfo() throws PimException {
        this.m_oPimUserInfo = new JndiPimUserInfo();
        return this.m_oPimUserInfo;
    }

    public PimAddressEntryItem getCurrentUser() throws PimException {
        PimAddressBook pimAddressBook = (PimAddressBook)this.getFolder(PimFolderType.GLOBAL_ADDRESS_BOOK);
        PimAddressEntryItems pimAddressEntryItems = pimAddressBook.getAddressEntryItems();
        JndiPimAddressEntryItemFilter pimAddressEntryItemFilter = (JndiPimAddressEntryItemFilter)pimAddressEntryItems.getAddressEntryItemFilter();
        String userDn = this.m_oPimUserInfo.getJndiLdapUserName();
        int pos = userDn.indexOf("=");
        if (pos != -1) {
            userDn = userDn.substring(pos + 1, userDn.indexOf(","));
        }
        pimAddressEntryItemFilter.setOperand(PimFilterOperandType.OPEN);
        pimAddressEntryItemFilter.setUid(userDn);
        pimAddressEntryItemFilter.setOperand(PimFilterOperandType.CLOSE);
        PimAddressEntryItem pimAddressEntrtyItem = pimAddressEntryItems.getFirstAddressEntryItem();
        return pimAddressEntrtyItem;
    }

    public PimFolder getFolder(PimFolderType pimFolderType) throws PimException {
        return this.getFolder(pimFolderType, null);
    }

    public PimFolder getFolder(String str) throws PimException {
        return null;
    }

    public PimFolder getFolder(PimFolderType pimFolderType, String str) throws PimException {
        if (pimFolderType.equals(PimFolderType.GLOBAL_ADDRESS_BOOK)) {
            return this.m_oPimSession.getGlobalAddressBook();
        }
        return null;
    }

    public void logoff() throws PimException {
    }

    public void logon() throws PimException {
        try {
            if (this.m_oPimUserInfo == null) {
                throw new JndiPimException(2L);
            }
            if (this.m_bLoggenOn) {
                this.logoff();
            }
            this.m_oPimSession = new JndiPimSession(this.m_oPimUserInfo);
            this.m_oPimSession.logon();
            this.m_bLoggenOn = true;
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public void setTimeZone(PimTimeZoneType pimTimeZoneType) throws PimException {
    }

    public PimFolder getRootFolder() throws PimException {
        return null;
    }

    public PimFolder getPublicRootFolder() throws PimException {
        return null;
    }
}

