/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.jndi;

import com.aligo.pim.PimFieldType;
import com.aligo.pim.PimSortType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAddressEntryItemFilter;
import com.aligo.pim.interfaces.PimAddressEntryItems;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimMessageItemFilter;
import com.aligo.pim.jndi.JndiPimAddressEntryItem;
import com.aligo.pim.jndi.JndiPimAddressEntryItemFilter;
import com.aligo.pim.jndi.JndiPimException;
import com.aligo.pim.jndi.JndiPimMessageItems;
import com.aligo.pim.jndi.JndiPimSession;
import com.aligo.pim.jndi.util.JndiPimAddressEntryItemField;
import com.sun.jndi.ldap.ctl.SortControl;
import com.sun.jndi.ldap.ctl.SortKey;
import java.util.Vector;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;

public class JndiPimAddressEntryItems
extends JndiPimMessageItems
implements PimAddressEntryItems {
    private JndiPimAddressEntryItemFilter m_oPimAddressEntryItemFilter;
    private PimSortType m_oPimSortType = PimSortType.ASCENDING;
    private NamingEnumeration m_oNamingEnumeration;
    private Vector m_vDN = new Vector();
    private boolean m_bInitialized = false;
    private PimFieldType[] m_oOrderBy;

    public JndiPimAddressEntryItems(JndiPimSession pimSession) throws JndiPimException {
        super(pimSession);
        try {
            this.getAddressEntryItemFilter();
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public PimAddressEntryItem addAddressEntryItem() throws PimException {
        return null;
    }

    public void addAddressEntryItem(PimAddressEntryItem pimAddressEntryItem) throws PimException {
    }

    public void setOrderBy(PimFieldType[] pimFieldType) {
        if (pimFieldType != null) {
            this.m_oOrderBy = pimFieldType;
        }
    }

    public void delete() throws PimException {
    }

    public PimAddressEntryItemFilter getAddressEntryItemFilter() throws PimException {
        this.m_bInitialized = false;
        if (this.m_oPimAddressEntryItemFilter == null) {
            this.m_oPimAddressEntryItemFilter = new JndiPimAddressEntryItemFilter(this.getPimSession());
        }
        return this.m_oPimAddressEntryItemFilter;
    }

    public int getCount() throws PimException {
        if (!this.m_bInitialized) {
            this.initializeNamingEnumeration();
        }
        return this.m_vDN.size();
    }

    public PimAddressEntryItem getFirstAddressEntryItem() throws PimException {
        return this.getAddressEntryItem(this.getFirstIndex());
    }

    public PimAddressEntryItem getLastAddressEntryItem() throws PimException {
        return this.getAddressEntryItem(this.getLastIndex());
    }

    public PimAddressEntryItem getNextAddressEntryItem() throws PimException {
        return this.getAddressEntryItem(this.getNextIndex());
    }

    public PimAddressEntryItem getPreviousAddressEntryItem() throws PimException {
        return this.getAddressEntryItem(this.getPreviousIndex());
    }

    public void sort(PimSortType pimSortType) throws PimException {
        this.m_oPimSortType = pimSortType;
    }

    public boolean isAscending() {
        return this.m_oPimSortType.equals(PimSortType.ASCENDING);
    }

    public void initializeNamingEnumeration() throws JndiPimException {
        try {
            String filterString = ((JndiPimAddressEntryItemFilter)this.getAddressEntryItemFilter()).getFilterString();
            Vector sortVector = new Vector();
            if (this.m_oOrderBy != null) {
                int i = 0;
                while (i < this.m_oOrderBy.length) {
                    PimFieldType pimFieldType = this.m_oOrderBy[i];
                    JndiPimAddressEntryItemField pimAddressEntryItemField = this.getPimSession().getPimAddressEntryItemField();
                    if (pimFieldType.equals(PimFieldType.FIRST_NAME)) {
                        sortVector.add(pimAddressEntryItemField.getFirstName().getAttributeId());
                    } else if (pimFieldType.equals(PimFieldType.LAST_NAME)) {
                        sortVector.add(pimAddressEntryItemField.getLastName().getAttributeId());
                    } else if (pimFieldType.equals(PimFieldType.EMAIL_ADDRESS)) {
                        sortVector.add(pimAddressEntryItemField.getEmailAddress().getAttributeId());
                    } else if (pimFieldType.equals(PimFieldType.NAME)) {
                        sortVector.add(pimAddressEntryItemField.getDisplayName().getAttributeId());
                    } else if (pimFieldType.equals(PimFieldType.TITLE)) {
                        sortVector.add(pimAddressEntryItemField.getTitle().getAttributeId());
                    }
                    ++i;
                }
            } else {
                sortVector = ((JndiPimAddressEntryItemFilter)this.getAddressEntryItemFilter()).getSortVector();
            }
            SortKey[] sortKey = new SortKey[]{sortVector.size() > 0 ? new SortKey((String)sortVector.elementAt(0), this.isAscending(), null) : new SortKey(this.getPimSession().getPimAddressEntryItemField().getLastName().getAttributeId(), this.isAscending(), null)};
            LdapContext context = this.getPimSession().getLdapContext();
            context.setRequestControls(new Control[]{new SortControl(sortKey, false)});
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            String addressBaseDn = this.getPimSession().getAddressBookBaseDn();
            this.m_oNamingEnumeration = context.search(addressBaseDn, filterString, constraints);
            while (this.m_oNamingEnumeration.hasMore()) {
                String dn = ((NameClassPair)this.m_oNamingEnumeration.next()).getName();
                dn = dn + ", " + addressBaseDn;
                this.m_vDN.add(dn);
            }
            this.m_bInitialized = true;
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public PimAddressEntryItem getAddressEntryItem(int itemNumber) throws PimException {
        if (!this.m_bInitialized) {
            this.initializeNamingEnumeration();
        }
        if (itemNumber < this.getCount()) {
            String dn = (String)this.m_vDN.get(itemNumber);
            return new JndiPimAddressEntryItem(dn, this.getPimSession());
        }
        return null;
    }

    public PimAddressEntryItem getAddressEntryItem(String id) throws PimException {
        if (id != null) {
            return new JndiPimAddressEntryItem(id, this.getPimSession());
        }
        return null;
    }

    public PimItem addItem() throws PimException {
        return this.addMessageItem();
    }

    public PimMessageItem addMessageItem() throws PimException {
        return this.addAddressEntryItem();
    }

    public PimItem getFirstItem() throws PimException {
        return this.getFirstMessageItem();
    }

    public PimMessageItem getFirstMessageItem() throws PimException {
        return this.getFirstAddressEntryItem();
    }

    public PimItem getItem(String str) throws PimException {
        return this.getMessageItem(str);
    }

    public PimItem getItem(int param) throws PimException {
        return this.getMessageItem(param);
    }

    public PimItem getLastItem() throws PimException {
        return this.getLastMessageItem();
    }

    public PimMessageItem getMessageItem(int param) throws PimException {
        return this.getAddressEntryItem(param);
    }

    public PimMessageItem getMessageItem(String str) throws PimException {
        return this.getAddressEntryItem(str);
    }

    public PimMessageItemFilter getMessageItemFilter() throws PimException {
        return this.getAddressEntryItemFilter();
    }

    public PimMessageItem getLastMessageItem() throws PimException {
        return this.getLastAddressEntryItem();
    }

    public PimItem getNextItem() throws PimException {
        return this.getNextMessageItem();
    }

    public PimMessageItem getNextMessageItem() throws PimException {
        return this.getNextAddressEntryItem();
    }

    public PimItem getPreviousItem() throws PimException {
        return this.getPreviousMessageItem();
    }

    public PimMessageItem getPreviousMessageItem() throws PimException {
        return this.getPreviousAddressEntryItem();
    }
}

