/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.jndi;

import com.aligo.pim.PimBusyStatusType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAddressEntryItems;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecipientItems;
import com.aligo.pim.jndi.JndiPimDistListAddressEntryItems;
import com.aligo.pim.jndi.JndiPimException;
import com.aligo.pim.jndi.JndiPimMessageItem;
import com.aligo.pim.jndi.JndiPimSession;
import com.aligo.pim.jndi.util.JndiPimAddressEntryItemField;
import java.util.Date;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class JndiPimAddressEntryItem
extends JndiPimMessageItem
implements PimAddressEntryItem {
    private String m_szBaseDn;
    private Attributes m_oAttributes;
    private JndiPimAddressEntryItemField m_oPimAddressEntryItemField;

    public JndiPimAddressEntryItem(String dn, JndiPimSession pimSession) throws JndiPimException {
        super(pimSession);
        try {
            this.m_szBaseDn = dn;
            this.m_oAttributes = this.getPimSession().getLdapContext().getAttributes(this.m_szBaseDn);
            this.m_oPimAddressEntryItemField = this.getPimSession().getPimAddressEntryItemField();
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public String getName() throws PimException {
        try {
            Attribute attr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getDisplayName().getAttributeId());
            if (attr != null) {
                NamingEnumeration<?> e = attr.getAll();
                if (e.hasMoreElements()) {
                    return (String)e.nextElement() + "";
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public PimAddressEntryItems getMembers() throws PimException {
        try {
            Attribute attr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getObjectClass().getAttributeId());
            if (attr != null) {
                String objectClass = null;
                NamingEnumeration<?> e = attr.getAll();
                while (e.hasMoreElements()) {
                    objectClass = (String)e.nextElement() + "";
                    if (objectClass == null || !objectClass.equals(this.m_oPimAddressEntryItemField.getGroup().getAttributeId())) continue;
                    Attribute memberAttr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getMember().getAttributeId());
                    if (memberAttr != null) {
                        Vector<String> memberVector = new Vector<String>();
                        NamingEnumeration<?> f = memberAttr.getAll();
                        while (f.hasMoreElements()) {
                            memberVector.add((String)f.nextElement() + "");
                        }
                        return new JndiPimDistListAddressEntryItems(memberVector, this.getPimSession());
                    }
                    return null;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public PimAddressEntryItems addMembers() throws PimException {
        throw new JndiPimException(12L);
    }

    public String getID() throws PimException {
        try {
            return this.m_szBaseDn;
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public PimBusyStatusType getBusyStatusType(Date startTime, Date endTime, int interval) throws JndiPimException {
        try {
            return null;
        }
        catch (Exception e) {
            return PimBusyStatusType.UNKNOWN;
        }
    }

    public PimFieldItems getFieldItems() throws PimException {
        return null;
    }

    public void delete() throws PimException {
    }

    public void delete(boolean flag) throws PimException {
    }

    public void update() throws PimException {
    }

    public String getEmailAddress() throws PimException {
        try {
            Attribute attr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getEmailAddress().getAttributeId());
            if (attr != null) {
                NamingEnumeration<?> e = attr.getAll();
                if (e.hasMoreElements()) {
                    return (String)e.nextElement() + "";
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public String getLastName() throws PimException {
        try {
            Attribute attr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getLastName().getAttributeId());
            if (attr != null) {
                NamingEnumeration<?> e = attr.getAll();
                if (e.hasMoreElements()) {
                    return (String)e.nextElement() + "";
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public String getFirstName() throws PimException {
        try {
            Attribute attr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getFirstName().getAttributeId());
            if (attr != null) {
                NamingEnumeration<?> e = attr.getAll();
                if (e.hasMoreElements()) {
                    return (String)e.nextElement() + "";
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public String getAlternateFullName() throws PimException {
        return "";
    }

    public String getBusinessTelephoneNumber() throws PimException {
        try {
            Attribute attr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getBusinessTelephoneNumber().getAttributeId());
            if (attr != null) {
                NamingEnumeration<?> e = attr.getAll();
                if (e.hasMoreElements()) {
                    return (String)e.nextElement() + "";
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public String getHomeTelephoneNumber() throws PimException {
        try {
            Attribute attr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getHomeTelephoneNumber().getAttributeId());
            if (attr != null) {
                NamingEnumeration<?> e = attr.getAll();
                if (e.hasMoreElements()) {
                    return (String)e.nextElement() + "";
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public String getMobileTelephoneNumber() throws PimException {
        try {
            Attribute attr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getMobileTelephoneNumber().getAttributeId());
            if (attr != null) {
                NamingEnumeration<?> e = attr.getAll();
                if (e.hasMoreElements()) {
                    return (String)e.nextElement() + "";
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public String getBusinessFaxNumber() throws PimException {
        try {
            Attribute attr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getBusinessFaxNumber().getAttributeId());
            if (attr != null) {
                NamingEnumeration<?> e = attr.getAll();
                if (e.hasMoreElements()) {
                    return (String)e.nextElement() + "";
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public String getTitle() throws PimException {
        try {
            Attribute attr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getTitle().getAttributeId());
            if (attr != null) {
                NamingEnumeration<?> e = attr.getAll();
                if (e.hasMoreElements()) {
                    return (String)e.nextElement() + "";
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public String getCompanyName() throws PimException {
        try {
            Attribute attr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getCompanyName().getAttributeId());
            if (attr != null) {
                NamingEnumeration<?> e = attr.getAll();
                if (e.hasMoreElements()) {
                    return (String)e.nextElement() + "";
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public String getBusinessStreet() throws PimException {
        try {
            Attribute attr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getBusinessStreet().getAttributeId());
            if (attr != null) {
                NamingEnumeration<?> e = attr.getAll();
                if (e.hasMoreElements()) {
                    return (String)e.nextElement() + "";
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public String getBusinessCity() throws PimException {
        try {
            Attribute attr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getBusinessCity().getAttributeId());
            if (attr != null) {
                NamingEnumeration<?> e = attr.getAll();
                if (e.hasMoreElements()) {
                    return (String)e.nextElement() + "";
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public String getBusinessState() throws PimException {
        try {
            Attribute attr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getBusinessState().getAttributeId());
            if (attr != null) {
                NamingEnumeration<?> e = attr.getAll();
                if (e.hasMoreElements()) {
                    return (String)e.nextElement() + "";
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public String getBusinessZip() throws PimException {
        try {
            Attribute attr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getBusinessZip().getAttributeId());
            if (attr != null) {
                NamingEnumeration<?> e = attr.getAll();
                if (e.hasMoreElements()) {
                    return (String)e.nextElement() + "";
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public String getBusinessCountry() throws PimException {
        try {
            Attribute attr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getBusinessCountry().getAttributeId());
            if (attr != null) {
                NamingEnumeration<?> e = attr.getAll();
                if (e.hasMoreElements()) {
                    return (String)e.nextElement() + "";
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public String getHomeStreet() throws PimException {
        try {
            Attribute attr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getHomeStreet().getAttributeId());
            if (attr != null) {
                NamingEnumeration<?> e = attr.getAll();
                if (e.hasMoreElements()) {
                    return (String)e.nextElement() + "";
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public String getHomeCity() throws PimException {
        try {
            Attribute attr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getHomeCity().getAttributeId());
            if (attr != null) {
                NamingEnumeration<?> e = attr.getAll();
                if (e.hasMoreElements()) {
                    return (String)e.nextElement() + "";
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public String getHomeState() throws PimException {
        try {
            Attribute attr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getHomeState().getAttributeId());
            if (attr != null) {
                NamingEnumeration<?> e = attr.getAll();
                if (e.hasMoreElements()) {
                    return (String)e.nextElement() + "";
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public String getHomeZip() throws PimException {
        try {
            Attribute attr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getHomeZip().getAttributeId());
            if (attr != null) {
                NamingEnumeration<?> e = attr.getAll();
                if (e.hasMoreElements()) {
                    return (String)e.nextElement() + "";
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public String getHomeCountry() throws PimException {
        try {
            Attribute attr = this.m_oAttributes.get(this.m_oPimAddressEntryItemField.getHomeCountry().getAttributeId());
            if (attr != null) {
                NamingEnumeration<?> e = attr.getAll();
                if (e.hasMoreElements()) {
                    return (String)e.nextElement() + "";
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new JndiPimException(e);
        }
    }

    public void send() throws PimException {
    }

    public PimMessageItem forward() throws PimException {
        return null;
    }

    public PimRecipientItems getRecipientItems() throws PimException {
        return null;
    }

    public void setEmailAddress(String emailAddress) throws PimException {
    }

    public void setLastName(String lastName) throws PimException {
    }

    public void setFirstName(String firstname) throws PimException {
    }

    public void setAlternateFullName(String alternateFullName) throws PimException {
    }

    public void setBusinessTelephoneNumber(String bTelNumber) throws PimException {
    }

    public void setHomeTelephoneNumber(String hTelNumber) throws PimException {
    }

    public void setMobileTelephoneNumber(String mTelNumber) throws PimException {
    }

    public void setBusinessFaxNumber(String bFaxNumber) throws PimException {
    }

    public void setTitle(String title) throws PimException {
    }

    public void setCompanyName(String companyName) throws PimException {
    }

    public void setHomeStreet(String hStreet) throws PimException {
    }

    public void setHomeCity(String hCity) throws PimException {
    }

    public void setHomeState(String hState) throws PimException {
    }

    public void setHomeZip(String hZip) throws PimException {
    }

    public void setHomeCountry(String hCountry) throws PimException {
    }

    public void setBusinessStreet(String bStreet) throws PimException {
    }

    public void setBusinessCity(String bCity) throws PimException {
    }

    public void setBusinessState(String bState) throws PimException {
    }

    public void setBusinessZip(String bZip) throws PimException {
    }

    public void setBusinessCountry(String bCountry) throws PimException {
    }
}

