/*
 * Decompiled with CFR 0.152.
 */
import com.sun.jndi.ldap.ctl.SortControl;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;

class ResearchLdap1 {
    private static String THIS_INIT_CONT_FAC = "com.sun.jndi.ldap.LdapCtxFactory";
    private static String THIS_PROV_URL = "ldap://primary:389";
    private static String THIS_SEC_AUTH = "simple";
    private static String THIS_SEARCHBASE = "CN=Users,DC=TESTDOMAIN,DC=NET";
    private static String[] THIS_ATTRS = new String[]{"givenName", "sn"};

    ResearchLdap1() {
    }

    public static void main(String[] arguments) {
        try {
            String THIS_FILTER = "(mail=*)";
            System.out.println("Testing LDAP Program");
            System.out.println("************************************************************");
            String THIS_SEC_PRIN = "CN=hello,CN=Users,DC=TESTDOMAIN,DC=NET";
            String THIS_SEC_CRED = "hello";
            System.out.println("Cont Fac    : " + THIS_INIT_CONT_FAC);
            System.out.println("LDAP Server : " + THIS_PROV_URL);
            System.out.println("Auth Method : " + THIS_SEC_AUTH);
            System.out.println("Search Base : " + THIS_SEARCHBASE);
            System.out.println("Filter      : " + THIS_FILTER);
            System.out.println("Login       : " + THIS_SEC_PRIN);
            System.out.println("Credentials : " + THIS_SEC_CRED);
            System.out.println("************************************************************");
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", THIS_INIT_CONT_FAC);
            env.put("java.naming.provider.url", THIS_PROV_URL);
            env.put("java.naming.security.authentication", THIS_SEC_AUTH);
            env.put("java.naming.security.principal", THIS_SEC_PRIN);
            env.put("java.naming.security.credentials", THIS_SEC_CRED);
            InitialLdapContext ctx = new InitialLdapContext(env, null);
            ctx.setRequestControls(new Control[]{new SortControl(new String[]{"sn"}, true)});
            System.out.println("Login Successful!");
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            System.out.println("this_searchbase=" + THIS_SEARCHBASE + " and filter is=" + THIS_FILTER);
            NamingEnumeration<SearchResult> results = ctx.search(THIS_SEARCHBASE, THIS_FILTER, constraints);
            int namecount = 0;
            System.out.println("Results : " + results);
            System.out.println("Pre-Hit ! ");
            while (results != null && results.hasMore()) {
                System.out.print("Hit ! ");
                SearchResult result = results.next();
                String dn = result.getName() + ", " + THIS_SEARCHBASE;
                System.out.println(" Result name dn:" + dn);
                Attributes attrs = ctx.getAttributes(dn, THIS_ATTRS);
                if (attrs == null) continue;
                System.out.print(++namecount + " : ");
                int i = 0;
                while (i < THIS_ATTRS.length) {
                    Attribute attr = attrs.get(THIS_ATTRS[i]);
                    if (attr != null) {
                        NamingEnumeration<?> e = attr.getAll();
                        while (e.hasMoreElements()) {
                            System.out.print((String)e.nextElement() + " ");
                        }
                    }
                    ++i;
                }
                System.out.println();
            }
            System.out.println("Total " + namecount + " Records");
            System.out.println("List All!");
        }
        catch (AuthenticationException ae) {
            ae.printStackTrace();
            System.out.println("Incorrect Password or UserName");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error accessing LDAP");
        }
    }
}

