/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.ab;

import com.iplanet.sso.SSOToken;
import com.sun.portal.providers.ProviderEditUtility;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.ab.AddressBookApplicationHelper;
import com.sun.portal.providers.ab.AddressBookProvider;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterDebug;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UWCABApplicationHelper
implements AddressBookApplicationHelper {
    ProviderContext pc = null;
    Properties ssoProps = null;
    protected String appName = "";
    public AddressBookProvider provider = null;
    public SSOAdapter ssoAdapter = null;
    public String charset = null;

    public void init(AddressBookProvider provider, SSOAdapter ssoAdapter) throws Exception {
        if (provider != null) {
            this.pc = provider.getProviderContext();
            this.provider = provider;
        }
        if (ssoAdapter != null) {
            this.ssoProps = ssoAdapter.getProperties();
            this.ssoAdapter = ssoAdapter;
        }
        SSOToken token = ssoAdapter.getSSOToken();
        this.charset = token.getProperty("CharSet");
        SSOAdapterDebug.logMessage((String)("UWCABApplicationHelper.init(): charset=" + this.charset));
    }

    public String getStartURL(AddressBookProvider provider, HttpServletRequest request) {
        StringBuffer clientURL = new StringBuffer();
        String abURL = "/?gotoUri=/abclient/AddressBook";
        String host = this.ssoProps.getProperty("host");
        String port = this.ssoProps.getProperty("clientPort", "80");
        String uwcContext = this.ssoProps.getProperty("uwcContext");
        String protocol = this.ssoProps.getProperty("clientProtocol", "http");
        clientURL.append(protocol + "://" + host + ":" + port);
        if (uwcContext == null) {
            this.warning("UWCABApplicationHelper.getStartURL(): uwcContext is null.  Defaulting to /");
            uwcContext = "/";
        }
        if (uwcContext != null) {
            if (uwcContext.substring(0).equals("/")) {
                clientURL.append(uwcContext);
            } else {
                clientURL.append("/" + uwcContext);
            }
        }
        clientURL.append(abURL);
        return clientURL.toString();
    }

    public StringBuffer getAppPrefsEdit(AddressBookProvider aprov, HttpServletRequest req, HttpServletResponse res) {
        StringBuffer content = new StringBuffer();
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        Map dpEditMap = null;
        String fontTag = "";
        try {
            List pflist = this.pc.getClientAndLocalePropertiesFilters();
            dpEditMap = this.pc.getCollectionProperty(aprov.getName(), "dpEditAttributes", pflist);
            fontTag = this.pc.getStringProperty(aprov.getName(), "fontFace1", "Sans-serif");
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            tagTable.put("isAppHandler", this.getName());
            ProviderEditUtility.setDefaultPresentation((String)aprov.getName(), (ProviderContext)aprov.getProviderContext(), tagTable);
        }
        catch (ProviderContextException pce) {
            this.error("Exception thrown retrieving values from the display profile\n", pce);
        }
        if (dpEditMap != null) {
            try {
                content.append(this.pc.getTemplate(this.provider.getName(), "edit-start.template", tagTable));
            }
            catch (ProviderContextException pce) {
                this.error("Exception thrown retrieving values from the display profile\n", pce);
            }
            Set entries = dpEditMap.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                this.message("UWCABApplicationHelper.getAppPrefsEdit():key=" + key + " value=" + value);
                StringTokenizer tok = new StringTokenizer(value, "|");
                while (tok.hasMoreElements()) {
                    String type = tok.nextToken();
                    String header = tok.nextToken();
                    content.append(ProviderEditUtility.createEditContent((String)type, (String)header, (String)key, (String)aprov.getName(), (ProviderContext)this.pc, (boolean)true));
                }
            }
            try {
                content.append(this.pc.getTemplate(this.provider.getName(), "edit-end.template", tagTable));
            }
            catch (ProviderContextException pce) {
                this.error("Exception thrown retrieving values from the display profile\n", pce);
            }
        }
        return content;
    }

    public URL processAppPrefsEdit(AddressBookProvider aprov, HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        URL url = null;
        Object props = null;
        Map dpEditMap = null;
        ProviderContext pc = aprov.getProviderContext();
        StringBuffer returnURL = new StringBuffer();
        List pflist = null;
        try {
            url = this.getAppHelperProcessURL(req, aprov);
            pflist = pc.getClientAndLocalePropertiesFilters();
            dpEditMap = pc.getCollectionProperty(aprov.getName(), "dpEditAttributes", pflist);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("UWCABApplicationHelper.processAppPrefsEdit():\n", (Throwable)pce);
        }
        if (dpEditMap != null) {
            Set entries = dpEditMap.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                StringTokenizer tok = new StringTokenizer(value, "|");
                String type = tok.nextToken();
                try {
                    this.message("UWCABApplicationHelper.processAppPrefsEdit(): key=" + key);
                    if (type.equals("string") || type.equals("select") || type.equals("password")) {
                        String reqString = ProviderEditUtility.getRequestParameter((String)key, (HttpServletRequest)req);
                        if (reqString.equals("")) continue;
                        if (pc.existsStringProperty(aprov.getName(), key, pflist)) {
                            pc.setStringProperty(aprov.getName(), key, reqString, pflist);
                            continue;
                        }
                        if (pc.existsStringProperty(aprov.getName(), key)) {
                            pc.setStringProperty(aprov.getName(), key, reqString);
                            continue;
                        }
                        this.warning("UWCABApplicationHelper.processAppPrefsEdit(): Unable to save key=" + key);
                        continue;
                    }
                    if (type.equals("int")) {
                        String reqNumber = ProviderEditUtility.getRequestParameter((String)key, (HttpServletRequest)req);
                        if (reqNumber.equals("")) continue;
                        if (pc.existsIntegerProperty(aprov.getName(), key, pflist)) {
                            pc.setIntegerProperty(aprov.getName(), key, Integer.parseInt(reqNumber), pflist);
                            continue;
                        }
                        if (pc.existsIntegerProperty(aprov.getName(), key)) {
                            pc.setIntegerProperty(aprov.getName(), key, Integer.parseInt(reqNumber));
                            continue;
                        }
                        this.warning("UWCABApplicationHelper.processAppPrefsEdit(): Unable to save key=" + key);
                        continue;
                    }
                    if (!type.equals("check")) continue;
                    String reqBool = ProviderEditUtility.getRequestParameter((String)key, (HttpServletRequest)req);
                    Boolean bool = null;
                    bool = reqBool.equals("") ? new Boolean("false") : new Boolean("true");
                    if (pc.existsBooleanProperty(aprov.getName(), key, pflist)) {
                        pc.setBooleanProperty(aprov.getName(), key, bool.booleanValue(), pflist);
                        continue;
                    }
                    if (pc.existsBooleanProperty(aprov.getName(), key)) {
                        pc.setBooleanProperty(aprov.getName(), key, bool.booleanValue());
                        continue;
                    }
                    this.warning("UWCABApplicationHelper.processAppPrefsEdit(): Unable to save key=" + key);
                }
                catch (ProviderContextException pce) {
                    throw new ProviderException("UWCABApplicationHelper.processAppPrefsEdit():\n", (Throwable)pce);
                }
            }
        }
        this.message("UWCABApplicationHelper::processAppPrefsEdit:  Return url = " + url.toString());
        return url;
    }

    public String getAppHelperEditLink(HttpServletRequest req, ProviderContext pc) {
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        StringBuffer link = new StringBuffer();
        try {
            link.append(pc.getDesktopURL(req));
        }
        catch (Exception e) {
            return "";
        }
        link.append("?action=edit&provider=");
        link.append(ProviderEditUtility.getRequestParameter((String)"provider", (HttpServletRequest)req));
        link.append("&targetprovider=" + this.provider.getName());
        link.append("&containerName=");
        link.append(ProviderEditUtility.getRequestParameter((String)"containerName", (HttpServletRequest)req));
        link.append("&appPref=" + this.getName());
        tagTable.put("editLink", link.toString());
        String content = null;
        try {
            String fontTag = pc.getStringProperty(this.provider.getName(), "fontFace1", "Sans-serif");
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            content = pc.getTemplate(this.provider.getName(), "edit-link.template", tagTable).toString();
            this.message("content = \n" + content.toString());
        }
        catch (Exception e) {
            this.error("unable to create hyperlink\n", e);
            content = "";
        }
        this.message("UWCABApplicationHelper: returned value is" + content.toString());
        return content;
    }

    public void setName(String name) {
        this.appName = name;
    }

    public String getName() {
        return this.appName;
    }

    protected URL getAppHelperProcessURL(HttpServletRequest req, AddressBookProvider prov) {
        ProviderContext pc = prov.getProviderContext();
        StringBuffer link = new StringBuffer();
        URL returnURL = null;
        try {
            link.append(pc.getDesktopURL(req));
        }
        catch (Exception e) {
            return null;
        }
        String provider = prov.editContainer;
        String targetProvider = prov.targetProvider;
        String containerName = prov.containerName;
        this.message("LDAPABApplicationHelper.getAppHelperProcessURL():     provider=" + provider + "\n                                                    targetProvider=" + targetProvider + "\n                                                    containerName=" + containerName);
        if (this.isEmpty(provider) || this.isEmpty(targetProvider) || this.isEmpty(containerName)) {
            this.warning("getAppHelperProcessURL():  Missing returnURL parameter and attempting to generate default desktop URL\n");
            try {
                returnURL = new URL(link.toString());
            }
            catch (Exception e) {
                this.warning("getAppHelperProcessURL():  Unable to generate default desktop URL\n", e);
                return null;
            }
        }
        link.append("?action=edit&provider=" + provider);
        link.append("&targetprovider=" + targetProvider);
        link.append("&containerName=" + containerName);
        try {
            returnURL = new URL(link.toString());
            this.message("LDAPABApplicationHelper:getAppHelperProcessURL():  returnURL =" + returnURL);
        }
        catch (Exception e) {
            this.error("Unable to create returnURL", e);
            return null;
        }
        return returnURL;
    }

    public String encode(String enc) {
        String result = "";
        try {
            result = URLEncoder.encode(enc, this.charset);
        }
        catch (UnsupportedEncodingException uee) {
            SSOAdapterDebug.logWarning((String)"UWCABApplicationHelper.encode():  Exception thrown encoding string. Returning unencoded string.", (Throwable)uee);
            return enc;
        }
        return result;
    }

    protected boolean isEmpty(String line) {
        return line == null || line.length() > 0;
    }

    public void error(String msg) {
        if (this.pc.isDebugErrorEnabled()) {
            this.pc.debugError((Object)msg);
        }
    }

    public void warning(String msg) {
        if (this.pc.isDebugWarningEnabled()) {
            this.pc.debugWarning((Object)msg);
        }
    }

    public void message(String msg) {
        if (this.pc.isDebugMessageEnabled()) {
            this.pc.debugMessage((Object)msg);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.pc.isDebugErrorEnabled()) {
            this.pc.debugError((Object)msg, t);
        }
    }

    public void warning(String msg, Throwable t) {
        if (this.pc.isDebugWarningEnabled()) {
            this.pc.debugWarning((Object)msg, t);
        }
    }

    public void message(String msg, Throwable t) {
        if (this.pc.isDebugMessageEnabled()) {
            this.pc.debugMessage((Object)msg, t);
        }
    }
}

