/*
 * Decompiled with CFR 0.152.
 */
package com.sun.addressbook.wabp;

import com.iplanet.iabs.iabsapi.Book;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.wabpc.WABPClientPStore;
import com.sun.addressbook.ABDebug;
import com.sun.addressbook.ABSession;
import com.sun.addressbook.ABStore;
import com.sun.addressbook.ABStoreException;
import com.sun.addressbook.AddressBook;
import com.sun.addressbook.MissingPropertiesException;
import com.sun.addressbook.OperationNotSupportedException;
import com.sun.addressbook.wabp.WabpAddressBook;

public class WabpABStore
extends ABStore {
    private WABPClientPStore wabpStore = null;
    private String host = null;
    private String port = null;
    private String protocol = null;
    private String user = null;
    private String password = null;
    private String contextURI = null;
    private String serverURL = null;
    private static final String CLASSNAME = "WabpABStore";

    public void init(ABSession session) throws MissingPropertiesException, ABStoreException {
        ABDebug.logMessage("WabpABStore: initialization");
        this.session = session;
        this.host = session.getProperty("ab.host");
        this.checkForMissingProperty(this.host);
        this.port = session.getProperty("ab.port");
        this.checkForMissingProperty(this.port);
        this.checkForIntegerProperty(this.port);
        this.protocol = session.getProperty("ab.protocol");
        this.checkForMissingProperty(this.protocol);
        this.user = session.getProperty("ab.userName");
        this.checkForMissingProperty(this.user);
        this.password = session.getProperty("ab.userPassword");
        this.checkForMissingProperty(this.password);
        this.contextURI = session.getProperty("ab.contextURI");
        this.checkForMissingProperty(this.contextURI);
        this.serverURL = this.protocol + "://" + this.host + ":" + this.port + "/" + this.contextURI + "/wabp/login.wabp?username=" + this.user + "&password=" + this.password;
        ABDebug.logMessage("WabpABStore: initialized store for " + this.user);
    }

    public void connect() throws ABStoreException {
        try {
            ABDebug.logMessage("WabpABStore: connnecting with user = " + this.user + " to " + this.serverURL);
            this.wabpStore = new WABPClientPStore(this.serverURL);
        }
        catch (PStoreException pe) {
            throw new ABStoreException("WabpABStore connection failed for " + this.user + " at " + this.serverURL + " : " + (Object)((Object)pe));
        }
        ABDebug.logMessage("WabpABStore: " + this.user + " connected.");
    }

    public void disconnect() throws ABStoreException {
        try {
            ABDebug.logMessage("WabpABStore: " + this.user + " requesting disconnect.");
            this.wabpStore.disconnect();
            this.wabpStore = null;
            ABDebug.logMessage("WabpABStore: " + this.user + " disconnected.");
        }
        catch (PStoreException pe) {
            throw new ABStoreException("WabpABStore connection termination failed : " + (Object)((Object)pe));
        }
    }

    public boolean isConnected() throws ABStoreException {
        ABDebug.logMessage("WabpABStore: " + this.user + " checking for connection.");
        return true;
    }

    public String[] getAddressBooks() throws ABStoreException, OperationNotSupportedException {
        String[] list = null;
        try {
            Book[] books = this.wabpStore.listBooks("abook");
            int count = books.length;
            list = new String[count];
            for (int i = 0; i < count; ++i) {
                String id = books[i].getEntryID();
                if (id == null) continue;
                list[i] = id;
                ABDebug.logMessage("WabpABStore: " + this.user + " found " + "Address Book: " + id);
            }
        }
        catch (PStoreException pe) {
            throw new ABStoreException("WabpABStore getAddressBooks() failed: " + (Object)((Object)pe));
        }
        return list;
    }

    protected String getDefaultAbID() throws ABStoreException {
        String id = null;
        try {
            Book book = this.wabpStore.getDefaultBook("abook");
            id = book.getEntryID();
        }
        catch (PStoreException pe) {
            throw new ABStoreException("WabpABStore getDefaultAbID() failed: " + (Object)((Object)pe));
        }
        ABDebug.logMessage("WabpABStore: " + this.user + " default " + "Address Book: " + id);
        return id;
    }

    public AddressBook openAddressBook(String abID) throws ABStoreException {
        ABDebug.logMessage("WabpABStore: " + this.user + " opening " + "Address Book: " + abID);
        return new WabpAddressBook(this, abID);
    }

    public void closeAddressBook(AddressBook ab) throws ABStoreException {
        ABDebug.logMessage("WabpABStore: " + this.user + " closing " + "Address Book: " + ab.getAbID());
    }

    protected void checkForMissingProperty(String property) throws MissingPropertiesException {
        if (property == null) {
            String msg = "WabpABStore setup failed, missing property: " + property;
            throw new MissingPropertiesException(msg);
        }
    }

    protected void checkForIntegerProperty(String property) throws MissingPropertiesException {
        try {
            Integer.parseInt(property);
        }
        catch (Exception e) {
            String msg = "WabpABStore setup failed, property is not an integer: " + property;
            throw new MissingPropertiesException(msg);
        }
    }

    protected WABPClientPStore getWABPClientPStore() {
        return this.wabpStore;
    }

    protected String getStoreUser() {
        return this.user;
    }
}

