/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.xslutil;

import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XSLIncludeResolver;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.OutputStream;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class XSLProcessor {
    private Templates _templates = null;
    private static final String TRANSLETS_JAR = "iabs-translets.jar";
    private static final String TRANSLETS_PACKAGE = "com.sun.iabs.translets";
    private static final String TRANSLETS_LIBPATH_PROPERTY = "com.sun.iabs.translets.libPath";

    public XSLProcessor(Document xslDoc, XSLIncludeResolver xslCache, XSLXMLLogHandler errorHandler, String id, boolean useTranslets) throws XSLProcessingException {
        try {
            this.init(xslDoc, xslCache, errorHandler, id, useTranslets);
        }
        catch (TransformerConfigurationException se) {
            throw new XSLProcessingException("XSLProcessor: " + se.getMessage());
        }
    }

    public XSLProcessor(Document xslDoc) throws XSLProcessingException {
        try {
            this.init(xslDoc, null, null, null, false);
        }
        catch (TransformerConfigurationException se) {
            throw new XSLProcessingException("XSLProcessor: " + se.getMessage());
        }
    }

    public void process(Document xmlDoc, OutputStream outputStream) throws XSLProcessingException {
        Transformer transformer = null;
        if (xmlDoc == null) {
            throw new XSLProcessingException("XSLProcessor: xmlDoc null");
        }
        if (outputStream == null) {
            throw new XSLProcessingException("XSLProcessor: outputStream null");
        }
        try {
            transformer = this._templates.newTransformer();
        }
        catch (TransformerConfigurationException tce) {
            throw new XSLProcessingException("XSLProcessor: transformer could not be created : " + tce.getMessage());
        }
        if (transformer == null) {
            throw new XSLProcessingException("XSLProcessor: _transformer null");
        }
        try {
            transformer.transform(new DOMSource(xmlDoc), new StreamResult(outputStream));
        }
        catch (TransformerException te) {
            throw new XSLProcessingException("XSLProcessor: transform failed (" + te.getMessage() + ")");
        }
    }

    public static void main(String[] args) {
        Document xmldoc = null;
        Document xsldoc = null;
        if (args.length != 2) {
            System.err.println("Usage: XSLProcessor <XML file> <XSLT file>");
            System.exit(1);
        }
        String xmlfilename = args[0];
        String xslfilename = args[1];
        XMLDOMBuilder parser = null;
        try {
            parser = new XMLDOMBuilder();
            xmldoc = parser.parse(xmlfilename);
        }
        catch (XMLProcessingException xe) {
            System.err.println("Couldn't parse " + xmlfilename + ":" + xe.getMessage());
            System.exit(1);
        }
        try {
            xsldoc = parser.parse(xslfilename);
        }
        catch (XMLProcessingException xe) {
            System.err.println("Couldn't parse " + xslfilename + ":" + xe.getMessage());
            System.exit(1);
        }
        XSLProcessor processor = null;
        try {
            processor = new XSLProcessor(xsldoc);
            processor.process(xmldoc, System.out);
        }
        catch (XSLProcessingException xe) {
            System.err.println("Couldn't process " + xslfilename + " : " + xe.getMessage());
            System.exit(1);
        }
    }

    private void init(Document xslDoc, XSLIncludeResolver xslCache, XSLXMLLogHandler errorHandler, String id, boolean useTranslets) throws TransformerConfigurationException {
        String destTransletsDir = null;
        if (useTranslets) {
            String key = "javax.xml.transform.TransformerFactory";
            String value = "org.apache.xalan.xsltc.trax.TransformerFactoryImpl";
            Properties props = System.getProperties();
            props.put(key, value);
            System.setProperties(props);
            destTransletsDir = props.getProperty(TRANSLETS_LIBPATH_PROPERTY);
            if (destTransletsDir == null) {
                throw new TransformerConfigurationException("Unable to determine the destination dir for XSLTC Translets.");
            }
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (useTranslets) {
            transformerFactory.setAttribute("translet-name", id);
            transformerFactory.setAttribute("package-name", TRANSLETS_PACKAGE);
        }
        if (errorHandler != null) {
            transformerFactory.setErrorListener(new XSLErrorHandler(errorHandler));
        }
        if (xslCache != null) {
            transformerFactory.setURIResolver(new XSLURIResolver(xslCache));
        }
        try {
            this._templates = transformerFactory.newTemplates(new DOMSource(xslDoc));
        }
        catch (TransformerConfigurationException se) {
            throw new TransformerConfigurationException("XSLProcessor: " + se.getMessage());
        }
    }

    private class XSLErrorHandler
    implements ErrorListener {
        private XSLXMLLogHandler _logHandler = null;

        XSLErrorHandler(XSLXMLLogHandler logHandler) {
            this._logHandler = logHandler;
        }

        private String getParseExceptionInfo(TransformerException te) {
            int lnum;
            String info = te.getMessageAndLocation();
            SourceLocator locator = te.getLocator();
            if (locator != null && (lnum = locator.getLineNumber()) != 0) {
                info = info + "(line = " + lnum + ")";
            }
            return info;
        }

        public void warning(TransformerException te) throws TransformerException {
            this._logHandler.error("Warning: " + this.getParseExceptionInfo(te));
        }

        public void error(TransformerException te) throws TransformerException {
            String message = "Error: " + this.getParseExceptionInfo(te);
            throw new TransformerException(message);
        }

        public void fatalError(TransformerException te) throws TransformerException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(te);
            throw new TransformerException(message);
        }
    }

    private class XSLURIResolver
    implements URIResolver {
        private XSLIncludeResolver _xslCache = null;

        XSLURIResolver(XSLIncludeResolver xslCache) {
            this._xslCache = xslCache;
        }

        public Source resolve(String href, String base) throws TransformerException {
            if (this._xslCache == null) {
                throw new TransformerException("XSLURIResolver: called without a cache " + href);
            }
            Document includeDoc = null;
            try {
                includeDoc = this._xslCache.getXSLInclude(href);
            }
            catch (XSLProcessingException xe) {
                throw new TransformerException("XSLURIResolver: Couldn't get " + href + " : " + xe.getMessage());
            }
            return new DOMSource(includeDoc);
        }
    }
}

