/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.xslutil;

import com.iplanet.xslui.xslutil.XMLErrorHandler;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLSAXParser {
    private XMLReader _xmlReader = null;

    public XMLSAXParser(ContentHandler contentHandler, XSLXMLLogHandler errorHandler) throws XMLProcessingException {
        if (contentHandler == null) {
            throw new XMLProcessingException("XMLSAXParser: no content Handler");
        }
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(false);
        spf.setNamespaceAware(false);
        try {
            SAXParser saxParser = spf.newSAXParser();
            this._xmlReader = saxParser.getXMLReader();
        }
        catch (Exception ex) {
            throw new XMLProcessingException("XMLSAXParser: can't get reader (" + ex.getMessage() + ")");
        }
        this._xmlReader.setContentHandler(contentHandler);
        if (errorHandler != null) {
            this._xmlReader.setErrorHandler(new XMLErrorHandler(errorHandler));
        }
    }

    public void parse(File xmlFile) throws XMLProcessingException {
        if (xmlFile == null) {
            throw new XMLProcessingException("File is null");
        }
        String uri = null;
        try {
            uri = xmlFile.toURL().toString();
        }
        catch (MalformedURLException mue) {
            throw new XMLProcessingException("XMLSAXParser: bad file name (" + mue.getMessage() + ")");
        }
        try {
            this._xmlReader.parse(uri);
        }
        catch (SAXException se) {
            throw new XMLProcessingException("XMLSAXParser: parsing error:" + se.getMessage());
        }
        catch (IOException ioe) {
            throw new XMLProcessingException("XMLSAXParser: io error:" + ioe.getMessage());
        }
    }

    public void parse(String path) throws XMLProcessingException {
        File xmlFile = null;
        if (path == null) {
            throw new XMLProcessingException("path is null");
        }
        if (path.length() == 0) {
            throw new XMLProcessingException("path is empty");
        }
        xmlFile = new File(path);
        this.parse(xmlFile);
    }
}

