/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.tools.StringUtils;
import com.iplanet.xslui.ui.Logging;
import java.io.File;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public abstract class XSLAuthFilter
implements Filter {
    protected String _config_filename = "xsl.properties";
    public static final String CONFIG_LOGFILE = "log.file";
    public static final String CONFIG_LOGLEVEL = "log.level";
    public static final String CONFIG_LOGCOMPONENTS = "log.components";
    public static final String CONFIG_CONFIGPATH_SUFFIX = ".configpath";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String LOGOUT = "logout";
    private PropertyReader _propertyReader;

    public void init(FilterConfig config) throws ServletException {
        File configPath;
        String configPathRoot = config.getInitParameter("configPath");
        ServletContext ctx = null;
        if (configPathRoot == null && (configPathRoot = (ctx = config.getServletContext()).getRealPath("/")) == null) {
            configPathRoot = "./";
        }
        if (!(configPath = new File(new File(configPathRoot, "local-conf"), "config")).isDirectory() && !(configPath = new File(configPathRoot, "WEB-INF/config")).isDirectory()) {
            throw new ServletException("XSLAuthFilter: can't open configuration dir " + configPath.toString());
        }
        try {
            this._propertyReader = new PropertyReader(configPath, this._config_filename);
        }
        catch (Exception ex) {
            throw new ServletException("XSLAuthFilter: can't open configuration file " + this._config_filename + " in " + configPath.toString() + " : " + ex.getMessage());
        }
        String sFile = this._propertyReader.getStringProperty(CONFIG_LOGFILE, "");
        int logLevel = this._propertyReader.getIntProperty(CONFIG_LOGLEVEL, 2);
        int logComponents = this._propertyReader.getIntProperty(CONFIG_LOGCOMPONENTS, 2);
        Logging logHandler = null;
        if (sFile.length() > 0) {
            File logFile = new File(sFile);
            logHandler = new Logging(logFile);
        } else {
            logHandler = new Logging(ctx);
        }
        Logging.setState(logLevel);
        Logging.setPackage(logComponents);
    }

    public PropertyReader getPropertyReader() {
        return this._propertyReader;
    }

    public static String getUserFromRequest(HttpServletRequest request) {
        String auth;
        int index;
        String user = null;
        String b64Auth = request.getHeader("Authorization");
        if (b64Auth != null && (index = (auth = StringUtils.b64Decode((String)(b64Auth = b64Auth.substring(6).trim()))).indexOf(":")) > 0) {
            user = auth.substring(0, index);
        }
        if (user == null) {
            user = request.getParameter(USER);
        }
        return user;
    }

    public static String getPasswordFromRequest(HttpServletRequest request) {
        String auth;
        int index;
        String pass = null;
        String b64Auth = request.getHeader("Authorization");
        if (b64Auth != null && (index = (auth = StringUtils.b64Decode((String)(b64Auth = b64Auth.substring(6).trim()))).indexOf(":")) > 0) {
            pass = auth.substring(index + 1);
        }
        if (pass == null) {
            pass = request.getParameter(PASSWORD);
        }
        return pass;
    }

    public static boolean invalidateSession(HttpServletRequest request) {
        String logout = request.getParameter(LOGOUT);
        return logout != null;
    }
}

