/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet.java2;

import com.iplanet.am.util.Debug;
import com.sun.portal.netfile.servlet.java2.NetFileResource;
import com.sun.portal.netfile.servlet.java2.SmbHandler;
import com.sun.portal.netfile.servlet.java2.XFileInterface;
import com.sun.portal.netfile.shared.NetFileException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import jcifs.Config;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;

class WinFile
implements XFileInterface {
    private Debug debug = null;
    private String machineEncoding;
    private int directoriesTraversed;
    private String winsServerIpAddress = "";
    private int smbPort;
    private String smbProtocolName;
    ArrayList searchResults = null;

    public WinFile(String encoding, String winsIp) throws NetFileException {
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
        this.machineEncoding = encoding;
        this.directoriesTraversed = 0;
        this.winsServerIpAddress = winsIp;
        this.smbPort = 139;
        this.smbProtocolName = "smb";
        this.writeDebug("WinFile: setting WINS server's IP to-" + this.winsServerIpAddress);
        Config.setProperty((String)"wins", (String)this.winsServerIpAddress);
        this.writeDebug("WinFile: setting machineEncoding to-" + this.machineEncoding);
        Config.setProperty((String)"jcifs.netbios.encoding", (String)this.machineEncoding);
    }

    private URL constructURL(String machine, String dir, SmbHandler handler) throws MalformedURLException {
        return new URL(this.smbProtocolName, machine, this.smbPort, dir, (URLStreamHandler)handler);
    }

    private URL constructURL(String domain, SmbHandler handler) throws MalformedURLException {
        return new URL(this.smbProtocolName, domain, this.smbPort, "", (URLStreamHandler)handler);
    }

    public String[] verifyHostType(String domain, String server, String userName, String password) throws NetFileException {
        if (domain != null) {
            SmbHandler handler = new SmbHandler(userName, password, domain);
            if ((domain = domain.trim()).equals("")) {
                return new String[]{"WIN", ""};
            }
            try {
                Config.setProperty((String)"jcifs.smb.client.disablePlainTextPasswords", (String)"false");
                URL hostUrl = this.constructURL(domain, handler);
                SmbFile file = (SmbFile)hostUrl.openConnection();
                String[] obj = file.list();
                if (obj != null) {
                    return new String[]{"NT", domain};
                }
                throw new NetFileException(2, "");
            }
            catch (SmbException smbe) {
                this.writeErrorDebug("SmbException in determining if domain/server name exists", (Exception)((Object)smbe));
                throw new NetFileException(2, "");
            }
            catch (IOException ioe) {
                this.writeErrorDebug("Exception in determining if domain/server name exists", ioe);
                throw new NetFileException();
            }
        }
        return new String[]{"WIN", ""};
    }

    public String getShares(String username, String password, String machine, String domain, NetFileResource nfRes) throws Exception, NetFileException {
        String shares = "";
        boolean accessible = false;
        try {
            SmbHandler handler = new SmbHandler(username, password, domain);
            URL sharesUrl = this.constructURL(machine, "/", handler);
            SmbFile file = (SmbFile)sharesUrl.openConnection();
            SmbFile[] files = file.listFiles();
            String shareName = "";
            for (int i = 0; i < files.length; ++i) {
                shareName = files[i].getName();
                if (!shareName.endsWith("$/")) {
                    shareName = shareName.substring(0, shareName.lastIndexOf("/"));
                    shares = shares + shareName + "\n";
                    continue;
                }
                accessible = this.isShareAccessible(username, password, machine, shareName = shareName.substring(0, shareName.length() - 1), domain, nfRes);
                if (!accessible) continue;
                shares = shares + shareName + "\n";
            }
            return shares;
        }
        catch (Exception ex) {
            this.writeErrorDebug("Exception getting shares", ex);
            if (ex instanceof SmbException) {
                SmbException se = (SmbException)((Object)ex);
                throw new NetFileException(7, this.getErrorString(se.getErrorClass(), se.getErrorCode(), nfRes));
            }
            if (ex instanceof NetFileException) {
                throw (NetFileException)ex;
            }
            return "ERROR:" + ex.getMessage();
        }
    }

    public String[] getDirectory(String username, String password, String machine, String share, String directory, String domain, NetFileResource nfRes) throws NetFileException {
        ArrayList fileListings = new ArrayList();
        try {
            SmbHandler handler = new SmbHandler(username, password, domain);
            URL listingUrl = this.constructURL(machine, "/" + share + directory + "/", handler);
            SmbFile file = (SmbFile)listingUrl.openConnection();
            SmbFile[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.extractFileInformation(files[i], fileListings);
            }
            int fileListingSize = fileListings.size();
            String[] totalListings = new String[fileListingSize];
            for (int i = 0; i < fileListingSize; ++i) {
                totalListings[i] = (String)fileListings.get(i);
            }
            String[] stringArray = totalListings;
            return stringArray;
        }
        catch (Exception e) {
            this.writeErrorDebug("Exception in getting the file listing", e);
            if (e instanceof SmbException) {
                SmbException se = (SmbException)((Object)e);
                throw new NetFileException(7, this.getErrorString(se.getErrorClass(), se.getErrorCode(), nfRes));
            }
            if (e instanceof NetFileException) {
                String msg = this.listingExceptionHandler((NetFileException)e, machine, share, domain, username, password, nfRes);
                throw new NetFileException(7, msg);
            }
            throw new NetFileException(7, nfRes.getString("wf.4"));
        }
        finally {
            fileListings = null;
        }
    }

    String listingExceptionHandler(NetFileException nfe, String machine, String share, String domain, String user_name, String password, NetFileResource nfRes) {
        String szErrCode = nfe.getMessage();
        String szErrMessage = nfRes.getString("wf.5");
        if (szErrCode == null || szErrCode.equals("")) {
            return "";
        }
        if (szErrCode.equalsIgnoreCase("ERRnosuchshare")) {
            szErrMessage = share + " " + nfRes.getString("wf.6");
        } else if (szErrCode.equalsIgnoreCase("ERRnoaccess")) {
            szErrMessage = share + "  " + nfRes.getString("wf.7");
        }
        return szErrMessage;
    }

    private void extractFileInformation(SmbFile file, List fileListings) throws Exception {
        String fileType = "";
        String fileLastModified = "";
        String fileName = "";
        if (file.isHidden()) {
            return;
        }
        if (file.isDirectory()) {
            fileType = "D";
            String name = file.getName();
            fileName = name.substring(0, name.lastIndexOf("/"));
        } else if (file.isFile()) {
            fileType = "-";
            fileName = file.getName();
        } else {
            this.writeErrorDebug("WinFile: file " + file.getName() + "is of Unknown type.");
            return;
        }
        Date d = new Date(file.lastModified());
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd yy, hh:mm a");
        sdf.setCalendar(new GregorianCalendar(TimeZone.getDefault()));
        fileLastModified = sdf.format(d);
        fileListings.add(fileType);
        fileListings.add(fileName);
        fileListings.add(new Long(file.length()).toString());
        fileListings.add(fileLastModified);
    }

    public String getFile(String username, String password, String machine, String share, String file, String directory, String domain, String localTempDir, NetFileResource nfRes) throws NetFileException {
        try {
            int n;
            Long randomNo = new Long(System.currentTimeMillis());
            if (file.startsWith("\"")) {
                file = file.substring(1, file.length());
            }
            String localTempFileName = localTempDir + "/" + randomNo.toString() + username.toUpperCase() + file;
            try {
                File localFile = new File(localTempDir);
                if (!localFile.exists()) {
                    localFile.mkdirs();
                }
            }
            catch (Exception e) {
                this.writeErrorDebug("Error creating temp directory", e);
                throw new NetFileException(500, nfRes.getString("wf.8"));
            }
            this.writeDebug("Local temporary file=" + localTempFileName);
            SmbHandler handler = new SmbHandler(username, password, domain);
            URL fromUrl = this.constructURL(machine, "/" + share + directory + "/" + file, handler);
            SmbFile from = (SmbFile)fromUrl.openConnection();
            SmbFileInputStream in = new SmbFileInputStream(from);
            FileOutputStream out = new FileOutputStream(localTempFileName);
            byte[] b = new byte[8192];
            while ((n = in.read(b)) >= 0) {
                out.write(b, 0, n);
            }
            in.close();
            out.close();
            return localTempFileName;
        }
        catch (Exception ex) {
            this.writeErrorDebug("Exception in obtaining the file " + file, ex);
            if (ex instanceof SmbException) {
                SmbException se = (SmbException)((Object)ex);
                throw new NetFileException(7, this.getErrorString(se.getErrorClass(), se.getErrorCode(), nfRes));
            }
            if (ex instanceof NetFileException) {
                throw (NetFileException)ex;
            }
            throw new NetFileException(7, nfRes.getString("wf.9"));
        }
    }

    public InputStream getInputStream(String username, String password, String domain, String machine, String share, String directory, String file, NetFileResource nfRes) throws NetFileException {
        try {
            SmbHandler handler = new SmbHandler(username, password, domain);
            URL fromUrl = this.constructURL(machine, "/" + share + directory + "/" + file, handler);
            SmbFile from = (SmbFile)fromUrl.openConnection();
            return new SmbFileInputStream(from);
        }
        catch (Exception ex) {
            this.writeErrorDebug("Exception in obtaining the InputStream for file-" + file, ex);
            if (ex instanceof SmbException) {
                SmbException se = (SmbException)((Object)ex);
                throw new NetFileException(7, this.getErrorString(se.getErrorClass(), se.getErrorCode(), nfRes));
            }
            if (ex instanceof NetFileException) {
                throw (NetFileException)ex;
            }
            throw new NetFileException(7, nfRes.getString("wf.9"));
        }
    }

    public OutputStream getOutputStream(String username, String password, String domain, String machine, String share, String directory, String file, NetFileResource nfRes) throws NetFileException {
        return this.getOutputStream(username, password, domain, machine, share, directory, file, nfRes, false);
    }

    public OutputStream getOutputStream(String username, String password, String domain, String machine, String share, String directory, String file, NetFileResource nfRes, boolean append) throws NetFileException {
        try {
            SmbHandler handler = new SmbHandler(username, password, domain);
            URL toUrl = this.constructURL(machine, "/" + share + directory + "/" + file, handler);
            SmbFile to = (SmbFile)toUrl.openConnection();
            if (append) {
                return new SmbFileOutputStream(to, true);
            }
            return new SmbFileOutputStream(to);
        }
        catch (Exception ex) {
            this.writeErrorDebug("Exception in obtaining the OutputStream for file-" + file, ex);
            if (ex instanceof SmbException) {
                SmbException se = (SmbException)((Object)ex);
                throw new NetFileException(7, this.getErrorString(se.getErrorClass(), se.getErrorCode(), nfRes));
            }
            if (ex instanceof NetFileException) {
                throw (NetFileException)ex;
            }
            throw new NetFileException(7, nfRes.getString("wf.15"));
        }
    }

    public String[] doSearch(String usernam, String passwrd, String machnam, String VMSnam, String pattern, String directory, String domainname, int maxsrchdir, NetFileResource nfRes) throws NetFileException {
        this.searchResults = new ArrayList();
        this.search(usernam, passwrd, machnam, VMSnam, pattern, directory, domainname, maxsrchdir, nfRes);
        if (this.directoriesTraversed > maxsrchdir) {
            String[] searchStr = new String[this.searchResults.size() + 1];
            searchStr[0] = "ERROR:" + nfRes.getString("maxSearch");
            for (int i = 1; i < searchStr.length; ++i) {
                searchStr[i] = (String)this.searchResults.get(i - 1);
            }
            return searchStr;
        }
        if (this.searchResults.size() == 0) {
            return new String[]{"        "};
        }
        String[] finalSearchResults = new String[this.searchResults.size()];
        for (int i = 0; i < finalSearchResults.length; ++i) {
            finalSearchResults[i] = (String)this.searchResults.get(i);
        }
        return finalSearchResults;
    }

    void search(String usernam, String passwrd, String machnam, String VMSnam, String pattern, String directory, String domainname, int maxsrchdir, NetFileResource nfRes) throws NetFileException {
        try {
            ++this.directoriesTraversed;
            this.writeDebug(this + ":Directory number being searched=" + this.directoriesTraversed);
            if (this.directoriesTraversed > maxsrchdir) {
                return;
            }
            String[] fileListing = this.getDirectory(usernam, passwrd, machnam, VMSnam, directory, domainname, nfRes);
            for (int i = 0; i < fileListing.length && this.directoriesTraversed <= maxsrchdir; i += 4) {
                if (fileListing[i].startsWith("ERROR:")) {
                    throw new NetFileException(7, nfRes.getString("error13"));
                }
                if (fileListing[i].equalsIgnoreCase("d")) {
                    String errorString = "";
                    String newDirectory = directory + "/" + fileListing[i + 1];
                    try {
                        this.search(usernam, passwrd, machnam, VMSnam, pattern, newDirectory, domainname, maxsrchdir, nfRes);
                    }
                    catch (NetFileException e) {
                        this.debug.error("Exception while searching", (Throwable)e);
                    }
                    if (fileListing[i + 1].indexOf(pattern) <= -1) continue;
                    this.searchResults.add("/" + VMSnam + newDirectory + "/" + errorString);
                    continue;
                }
                if (fileListing[i + 1].indexOf(pattern) <= -1) continue;
                this.searchResults.add("/" + VMSnam + directory + "/" + fileListing[i + 1]);
            }
        }
        catch (NetFileException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NetFileException(7, nfRes.getString("error13"));
        }
    }

    public String doCreateDirectory(String machine, String share, String username, String password, String domain, String parentDir, String dirToCreate, NetFileResource nfRes) throws NetFileException {
        try {
            SmbHandler handler = new SmbHandler(username, password, domain);
            URL mkdirUrl = this.constructURL(machine, "/" + share + parentDir + "/" + dirToCreate, handler);
            SmbFile dir = (SmbFile)mkdirUrl.openConnection();
            dir.mkdir();
            return nfRes.getString("warning52");
        }
        catch (Exception e) {
            this.writeErrorDebug("Problem in creating directory " + dirToCreate + " on machine " + machine, e);
            if (e instanceof SmbException) {
                SmbException se = (SmbException)((Object)e);
                throw new NetFileException(7, this.getErrorString(se.getErrorClass(), se.getErrorCode(), nfRes));
            }
            throw new NetFileException(7, nfRes.getString("could_not_create_directory"));
        }
    }

    public String doDeleteDirectory(String username, String password, String machine, String share, String directory, String domain, NetFileResource nfRes) throws NetFileException {
        try {
            SmbHandler handler = new SmbHandler(username, password, domain);
            URL deleteUrl = this.constructURL(machine, "/" + share + directory, handler);
            SmbFile deleteFile = (SmbFile)deleteUrl.openConnection();
            deleteFile.delete();
        }
        catch (Exception e) {
            this.writeErrorDebug("Problem in deleting folder " + directory + " on machine " + machine, e);
            if (e instanceof SmbException) {
                SmbException se = (SmbException)((Object)e);
                throw new NetFileException(7, this.getErrorString(se.getErrorClass(), se.getErrorCode(), nfRes));
            }
            throw new NetFileException(7, nfRes.getString("wf.13"));
        }
        return nfRes.getString("info5");
    }

    public String doDeleteFile(String username, String password, String machine, String share, String file, String directory, String domain, NetFileResource nfRes) throws NetFileException {
        try {
            SmbHandler handler = new SmbHandler(username, password, domain);
            URL deleteUrl = this.constructURL(machine, "/" + share + directory + "/" + file, handler);
            SmbFile deleteFile = (SmbFile)deleteUrl.openConnection();
            deleteFile.delete();
        }
        catch (Exception e) {
            this.writeErrorDebug("Problem in deleting file " + file + " on machine " + machine, e);
            if (e instanceof SmbException) {
                SmbException se = (SmbException)((Object)e);
                throw new NetFileException(7, this.getErrorString(se.getErrorClass(), se.getErrorCode(), nfRes));
            }
            throw new NetFileException(7, nfRes.getString("wf.14"));
        }
        return nfRes.getString("info5");
    }

    public void doRenameFile(String username, String password, String machine, String domain, String share, String directory, String oldFileName, String newFileName, NetFileResource nfRes) throws NetFileException {
        try {
            SmbHandler handler = new SmbHandler(username, password, domain);
            URL fromUrl = this.constructURL(machine, "/" + share + directory + "/" + oldFileName, handler);
            SmbFile from = (SmbFile)fromUrl.openConnection();
            URL toUrl = this.constructURL(machine, "/" + share + directory + "/" + newFileName, handler);
            SmbFile to = (SmbFile)toUrl.openConnection();
            from.renameTo(to);
        }
        catch (SmbException se) {
            throw new NetFileException(7, this.getErrorString(se.getErrorClass(), se.getErrorCode(), nfRes));
        }
        catch (Exception e) {
            throw new NetFileException(7, nfRes.getString("wf.16"));
        }
    }

    protected void writeDebug(String szMsg) {
        this.writeDebug(szMsg, null);
    }

    protected void writeDebug(String szMsg, Exception e) {
        if (this.debug != null && this.debug.messageEnabled()) {
            if (e != null) {
                this.debug.message(szMsg, (Throwable)e);
            } else {
                this.debug.message(szMsg);
            }
        }
    }

    protected void writeErrorDebug(String msg) {
        this.writeErrorDebug(msg, null);
    }

    protected void writeErrorDebug(String szError, Exception e) {
        if (this.debug != null) {
            if (e != null) {
                this.debug.error(szError, (Throwable)e);
            } else {
                this.debug.error(szError);
            }
        }
    }

    public String getErrorString(int errorClass, int errorCode, NetFileResource nfRes) {
        String result = "";
        block0 : switch (errorClass) {
            case 0: {
                result = result + nfRes.getString("SUCCESS");
                break;
            }
            case 1: {
                switch (errorCode) {
                    case 1: {
                        result = result + nfRes.getString("ERRDOS_badfunc");
                        break block0;
                    }
                    case 2: {
                        result = result + nfRes.getString("ERRDOS_badfile");
                        break block0;
                    }
                    case 3: {
                        result = result + nfRes.getString("ERRDOS_badpath");
                        break block0;
                    }
                    case 5: {
                        result = result + nfRes.getString("ERRDOS_noaccess");
                        break block0;
                    }
                    case 87: {
                        result = result + nfRes.getString("ERRDOS_badparm");
                        break block0;
                    }
                    case 123: {
                        result = result + nfRes.getString("ERRDOS_invname");
                        break block0;
                    }
                    case 145: {
                        result = result + nfRes.getString("ERRDOS_notempty");
                        break block0;
                    }
                    case 80: {
                        result = result + nfRes.getString("ERRDOS_filexists");
                        break block0;
                    }
                    case 6: {
                        result = result + nfRes.getString("ERRDOS_badfid");
                        break block0;
                    }
                    case 8: {
                        result = result + nfRes.getString("ERRDOS_nospace");
                        break block0;
                    }
                    case 32: {
                        result = result + nfRes.getString("ERRDOS_badshare");
                        break block0;
                    }
                    case 52: {
                        result = result + nfRes.getString("ERRDOS_dupname");
                        break block0;
                    }
                    case 21: {
                        result = result + nfRes.getString("ERRDOS_notready");
                        break block0;
                    }
                    case 67: {
                        result = result + nfRes.getString("ERRDOS_badnetname");
                        break block0;
                    }
                    case 183: {
                        result = result + nfRes.getString("ERRDOS_exists");
                        break block0;
                    }
                    case 231: {
                        result = result + nfRes.getString("ERRDOS_pipebusy");
                        break block0;
                    }
                    case 232: {
                        result = result + nfRes.getString("ERRDOS_nodata");
                        break block0;
                    }
                    case 233: {
                        result = result + nfRes.getString("ERRDOS_noproc");
                        break block0;
                    }
                    case 109: {
                        result = result + nfRes.getString("ERRDOS_brokenpipe");
                        break block0;
                    }
                    case 71: {
                        result = result + nfRes.getString("ERRDOS_nomoreconn");
                        break block0;
                    }
                }
                result = result + nfRes.getString("jcifs_noreason");
                break;
            }
            case 2: {
                switch (errorCode) {
                    case 1: {
                        result = result + nfRes.getString("ERRSRV_error");
                        break block0;
                    }
                    case 2: {
                        result = result + nfRes.getString("ERRSRV_badpw");
                        break block0;
                    }
                    case 5: {
                        result = result + nfRes.getString("ERRSRV_invnid");
                        break block0;
                    }
                    case 6: {
                        result = result + nfRes.getString("ERRSRV_invnetname");
                        break block0;
                    }
                    case 91: {
                        result = result + nfRes.getString("ERRSRV_baduid");
                        break block0;
                    }
                    case 4: {
                        result = result + nfRes.getString("ERRSRV_access");
                        break block0;
                    }
                    case 2239: {
                        result = result + nfRes.getString("ERRSRV_accountExpired");
                        break block0;
                    }
                    case 2240: {
                        result = result + nfRes.getString("ERRSRV_badClient");
                        break block0;
                    }
                    case 2241: {
                        result = result + nfRes.getString("ERRSRV_badLogonTime");
                        break block0;
                    }
                    case 2242: {
                        result = result + nfRes.getString("ERRSRV_passwordExpired");
                        break block0;
                    }
                }
                result = result + nfRes.getString("jcifs_noreason");
                break;
            }
            case 3: {
                switch (errorCode) {
                    case 19: {
                        result = result + nfRes.getString("ERRHRD_nowrite");
                        break block0;
                    }
                    case 21: {
                        result = result + nfRes.getString("ERRHRD_notready");
                        break block0;
                    }
                }
                result = result + nfRes.getString("jcifs_notready");
                break;
            }
            case 255: {
                result = result + nfRes.getString("ERRCMD");
                break;
            }
            case 16: {
                switch (errorCode) {
                    case 0: {
                        result = result + nfRes.getString("ERRRAP_NERR_Success");
                        break block0;
                    }
                    case 19: 
                    case 2114: {
                        result = result + nfRes.getString("ERRRAP_NERR_ServerNotStarted");
                        break block0;
                    }
                    case 2141: {
                        result = result + nfRes.getString("ERRRAP_NERR_BasicTransactConfig");
                        break block0;
                    }
                }
                result = result + nfRes.getString("jcifs_noreason");
                break;
            }
            case 32: {
                switch (errorCode) {
                    case 5000: {
                        result = result + nfRes.getString("ERRCLI_serverTimeout");
                        break block0;
                    }
                    case 5001: {
                        result = result + nfRes.getString("ERRCLI_badDialect");
                        break block0;
                    }
                    case 5002: {
                        result = result + nfRes.getString("ERRCLI_ioe");
                        break block0;
                    }
                    case 5003: {
                        result = result + nfRes.getString("ERRCLI_listFiles");
                        break block0;
                    }
                    case 5004: {
                        result = result + nfRes.getString("ERRCLI_unknownHost");
                        break block0;
                    }
                    case 5005: {
                        result = result + nfRes.getString("ERRCLI_inappro");
                        break block0;
                    }
                    case 5006: {
                        result = result + nfRes.getString("ERRCLI_unknownType");
                        break block0;
                    }
                }
                result = result + nfRes.getString("jcifs_noreason");
                break;
            }
            default: {
                result = result + "unknown error class: " + errorClass;
            }
        }
        return result;
    }

    public boolean isShareAccessible(String username, String password, String machine, String share, String domain, NetFileResource nfRes) {
        boolean returnValue = false;
        try {
            SmbHandler handler = new SmbHandler(username, password, domain);
            URL listingUrl = this.constructURL(machine, "/" + share + "/", handler);
            SmbFile file = (SmbFile)listingUrl.openConnection();
            SmbFile[] files = file.listFiles();
            returnValue = files != null;
        }
        catch (SmbException se) {
            this.debug.error("WinFile: share - " + share + " not accessible to user - " + username + "." + this.getErrorString(se.getErrorClass(), se.getErrorCode(), nfRes));
            returnValue = false;
        }
        catch (Exception e) {
            this.debug.error("WinFile: exception when checking for share accessibility," + e.toString());
            returnValue = false;
        }
        return returnValue;
    }
}

