/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines.xml.parser;

import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.engines.PageContent;
import com.sun.portal.rewriter.engines.xml.parser.XMLParseException;
import com.sun.portal.rewriter.engines.xml.parser.XMLParserListener;
import com.sun.portal.rewriter.engines.xml.parser.XMLReader;
import com.sun.portal.rewriter.engines.xml.parser.XMLReaderWrapper;
import com.sun.portal.rewriter.engines.xml.parser.XMLUtil;
import com.sun.portal.rewriter.rom.RuleSet;
import com.sun.portal.rewriter.util.Debug;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class XMLParser {
    private final XMLParserListener parserListener;
    private final XMLReader reader;
    public static final String STYLESHEET_PI = "xml-stylesheet";

    public XMLParser(PageContent aPageContent, RuleSet aRuleSet, Translator aTranslator) {
        this.reader = new XMLReaderWrapper(aPageContent, aRuleSet, aTranslator);
        this.parserListener = (XMLParserListener)((Object)this.reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse() {
        try {
            block9: while (!this.reader.atEOF()) {
                String str = XMLUtil.read(this.reader, '&');
                char ch = str.charAt(0);
                if (ch == '&') continue;
                switch (ch) {
                    case '<': {
                        this.scanSomeTag(false, null, new Properties());
                        continue block9;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block9;
                    }
                }
                XMLUtil.errorInvalidInput(this.reader.getSystemID(), this.reader.getLineNr(), "`" + ch + "' (0x" + Integer.toHexString(ch) + ')');
            }
            return;
        }
        catch (Exception e) {
            Debug.recordOriginalPageWarning("XML Parsing Exception ", e);
            return;
        }
        finally {
            this.parserListener.endParsing();
        }
    }

    protected void scanSomeTag(boolean allowCDATA, String defaultNamespace, Properties namespaces) throws XMLParseException, IOException {
        String str = XMLUtil.read(this.reader, '&');
        char ch = str.charAt(0);
        if (ch == '&') {
            XMLUtil.errorUnexpectedEntity(this.reader.getSystemID(), this.reader.getLineNr(), str);
        }
        switch (ch) {
            case '?': {
                this.processPI();
                break;
            }
            case '!': {
                this.processSpecialTag(allowCDATA);
                break;
            }
            default: {
                this.reader.unread(ch);
                this.processElement(defaultNamespace, namespaces);
            }
        }
    }

    protected void processPI() throws IOException, XMLParseException {
        String target = XMLUtil.scanIdentifier(this.reader);
        if (!STYLESHEET_PI.equals(target)) {
            XMLUtil.skipWhitespace(this.reader, null);
            XMLUtil.skipPI(this.reader);
            return;
        }
        XMLUtil.skipWhitespace(this.reader, null);
        while (true) {
            char ch;
            if ((ch = this.reader.read()) == '?') {
                char ch2 = this.reader.read();
                if (ch2 == '>') break;
                this.reader.unread(ch2);
            }
            this.reader.unread(ch);
            String key = XMLUtil.scanIdentifier(this.reader);
            XMLUtil.skipWhitespace(this.reader, null);
            if (!XMLUtil.read(this.reader, '&').equals("=")) {
                XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`='");
            }
            XMLUtil.skipWhitespace(this.reader, null);
            this.parserListener.startPI();
            String value = XMLUtil.scanString(this.reader, '&');
            if (key.equals("href")) {
                this.parserListener.endPI(value);
            }
            XMLUtil.skipWhitespace(this.reader, null);
        }
    }

    protected void processSpecialTag(boolean allowCDATA) throws IOException, XMLParseException {
        String str = XMLUtil.read(this.reader, '&');
        char ch = str.charAt(0);
        if (ch == '&') {
            XMLUtil.errorUnexpectedEntity(this.reader.getSystemID(), this.reader.getLineNr(), str);
        }
        switch (ch) {
            case '[': {
                if (allowCDATA) {
                    this.processCDATA();
                } else {
                    XMLUtil.errorUnexpectedCDATA(this.reader.getSystemID(), this.reader.getLineNr());
                }
                return;
            }
            case 'D': {
                this.processDocType();
                return;
            }
            case '-': {
                XMLUtil.skipComment(this.reader);
                return;
            }
        }
    }

    protected void processCDATA() throws IOException, XMLParseException {
        if (!XMLUtil.checkLiteral(this.reader, "CDATA[")) {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "<![[CDATA[");
        }
        XMLUtil.skipCDATA(this.reader);
    }

    protected void processDocType() throws IOException, XMLParseException {
        if (!XMLUtil.checkLiteral(this.reader, "OCTYPE")) {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "<!DOCTYPE");
            return;
        }
        XMLUtil.skipWhitespace(this.reader, null);
        String systemID = null;
        StringBuffer publicID = new StringBuffer();
        XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        char ch = this.reader.read();
        if (ch == 'P') {
            systemID = XMLUtil.scanPublicID(publicID, this.reader);
            XMLUtil.skipWhitespace(this.reader, null);
            ch = this.reader.read();
        } else if (ch == 'S') {
            systemID = XMLUtil.scanSystemID(this.reader);
            XMLUtil.skipWhitespace(this.reader, null);
            ch = this.reader.read();
        }
        if (ch == '[') {
            XMLUtil.skipWhitespace(this.reader, null);
            ch = this.reader.read();
        }
        if (ch == '<') {
            this.reader.unread('<');
            XMLUtil.skipTag(this.reader);
        } else if (ch != '>') {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`>'");
        }
        if (systemID != null) {
            Reader reader = this.reader.openStream(publicID.toString(), systemID);
            this.reader.startNewStream(reader);
            this.reader.setSystemID(systemID);
            this.reader.setPublicID(publicID.toString());
        }
    }

    protected void processElement(String defaultNamespace, Properties namespaces) throws IOException, XMLParseException {
        String key;
        int i;
        char ch;
        String fullName = XMLUtil.scanIdentifier(this.reader);
        this.parserListener.startElement(fullName);
        String name = fullName;
        XMLUtil.skipWhitespace(this.reader, null);
        int colonIndex = name.indexOf(58);
        if (colonIndex > 0) {
            name = name.substring(colonIndex + 1);
        }
        Vector<String> attrNames = new Vector<String>();
        Vector<String> attrValues = new Vector<String>();
        Vector<String> attrTypes = new Vector<String>();
        while ((ch = this.reader.read()) != '/' && ch != '>') {
            this.reader.unread(ch);
            this.processAttribute(attrNames, attrValues, attrTypes);
            XMLUtil.skipWhitespace(this.reader, null);
        }
        Properties extraAttributes = new Properties();
        Enumeration<Object> enumeration = extraAttributes.keys();
        while (enumeration.hasMoreElements()) {
            String key2 = (String)enumeration.nextElement();
            String value = extraAttributes.getProperty(key2);
            attrNames.addElement(key2);
            attrValues.addElement(value);
            attrTypes.addElement("CDATA");
        }
        for (i = 0; i < attrNames.size(); ++i) {
            key = (String)attrNames.elementAt(i);
            String value = (String)attrValues.elementAt(i);
            if (key.equals("xmlns")) {
                defaultNamespace = value;
                continue;
            }
            if (!key.startsWith("xmlns:")) continue;
            namespaces.put(key.substring(6), value);
        }
        for (i = 0; i < attrNames.size(); ++i) {
            key = (String)attrNames.elementAt(i);
            if (key.startsWith("xmlns")) continue;
            colonIndex = key.indexOf(58);
        }
        if (ch == '/') {
            if (this.reader.read() != '>') {
                XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`>'");
            }
            this.parserListener.endElement();
            return;
        }
        StringBuffer buffer = new StringBuffer(16);
        while (true) {
            String str;
            buffer.setLength(0);
            do {
                XMLUtil.skipWhitespace(this.reader, buffer);
            } while ((str = XMLUtil.read(this.reader, '&')).charAt(0) == '&' && str.charAt(1) != '#');
            if (str.charAt(0) == '<') {
                str = XMLUtil.read(this.reader, '\u0000');
                if (str.charAt(0) == '/') {
                    XMLUtil.skipWhitespace(this.reader, null);
                    str = XMLUtil.scanIdentifier(this.reader);
                    if (!str.equals(fullName)) {
                        XMLUtil.errorWrongClosingTag(this.reader.getSystemID(), this.reader.getLineNr(), name, str);
                    }
                    XMLUtil.skipWhitespace(this.reader, null);
                    if (this.reader.read() == '>') break;
                    XMLUtil.errorClosingTagNotEmpty(this.reader.getSystemID(), this.reader.getLineNr());
                    break;
                }
                this.reader.unread(str.charAt(0));
                this.scanSomeTag(true, defaultNamespace, (Properties)namespaces.clone());
                continue;
            }
            if (str.charAt(0) == '&') {
                ch = XMLUtil.processCharLiteral(str);
                buffer.append(ch);
            } else {
                this.reader.unread(str.charAt(0));
            }
            int readOffset = this.parserListener.getOffset();
            XMLUtil.skipContent(this.reader);
            this.parserListener.endPCData(readOffset);
        }
        this.parserListener.endElement();
    }

    protected void processAttribute(Vector attrNames, Vector attrValues, Vector attrTypes) throws IOException, XMLParseException {
        String key = XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        if (!XMLUtil.read(this.reader, '&').equals("=")) {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`='");
        }
        XMLUtil.skipWhitespace(this.reader, null);
        this.parserListener.startAttribute(key);
        String value = XMLUtil.scanString(this.reader, '&');
        this.parserListener.endAttribute(key, value);
        attrNames.addElement(key);
        attrValues.addElement(value);
        attrTypes.addElement("CDATA");
    }
}

