/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet.java1;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOToken;
import com.sun.portal.netfile.servlet.java1.FileOption;
import com.sun.portal.netfile.servlet.java1.NetFileException;
import com.sun.portal.netfile.servlet.java1.NetFileLogManager;
import com.sun.portal.netfile.servlet.java1.NetFileResource;
import com.sun.portal.netfile.servlet.java1.SmbHandler;
import com.sun.portal.netfile.servlet.java1.XFileInterface;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import jcifs.Config;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;

class WinFile
implements XFileInterface {
    private static Debug debug = null;
    private NetFileLogManager logManager = null;
    private String machineEncoding;
    private String machineEncodingOriginal;
    private SSOToken ssoToken = null;
    private int directoriesTraversed;
    private String winsServerIpAddress = "";
    private int smbPort;
    private String smbProtocolName;
    ArrayList searchResults = null;

    public WinFile(NetFileLogManager logMgr, String machineEncoding, SSOToken token) throws NetFileException {
        this.logManager = logMgr;
        this.machineEncodingOriginal = machineEncoding;
        this.ssoToken = token;
        this.directoriesTraversed = 0;
        FileOption filopt = new FileOption(this.logManager, machineEncoding, this.ssoToken);
        this.machineEncoding = this.getSmbNameForEncoding(machineEncoding);
        if (debug == null) {
            debug = Debug.getInstance((String)"srapNetFile");
        }
        String[] pathinfo = filopt.grepPlatinfo();
        this.winsServerIpAddress = pathinfo[0];
        this.smbPort = 139;
        this.smbProtocolName = "smb";
        debug.message("WinFile: setting WINS server's IP to-" + this.winsServerIpAddress);
        Config.setProperty((String)"wins", (String)this.winsServerIpAddress);
        debug.message("WinFile: setting machineEncoding to-" + machineEncoding);
        Config.setProperty((String)"jcifs.netbios.encoding", (String)machineEncoding);
    }

    private URL constructURL(String machine, String dir, SmbHandler handler) throws MalformedURLException {
        return new URL(this.smbProtocolName, machine, this.smbPort, dir, (URLStreamHandler)handler);
    }

    private URL constructURL(String domain, SmbHandler handler) throws MalformedURLException {
        return new URL(this.smbProtocolName, domain, this.smbPort, "", (URLStreamHandler)handler);
    }

    private String handleDirectoryNames(String dir) {
        String returnDir = dir;
        if (dir.indexOf("\\") != -1) {
            returnDir = dir.replace('\\', '/');
        }
        if (returnDir.startsWith("//")) {
            returnDir = returnDir.substring(1);
        }
        return returnDir;
    }

    public String[] verifyHostType(String domain, String server, String userName, String password) throws NetFileException {
        if (domain != null) {
            SmbHandler handler = new SmbHandler(userName, password, domain);
            if ((domain = domain.trim()).equals("")) {
                return new String[]{"WIN", ""};
            }
            try {
                Config.setProperty((String)"jcifs.smb.client.disablePlainTextPasswords", (String)"false");
                URL hostUrl = this.constructURL(domain, handler);
                SmbFile file = (SmbFile)hostUrl.openConnection();
                String[] obj = file.list();
                if (obj != null) {
                    return new String[]{"NT", domain};
                }
                throw new NetFileException(2, "");
            }
            catch (SmbException smbe) {
                debug.error("SmbException in determining if domain/server name exists", (Throwable)smbe);
                throw new NetFileException(2, "");
            }
            catch (IOException ioe) {
                debug.error("Exception in determining if domain/server name exists", (Throwable)ioe);
                throw new NetFileException();
            }
        }
        return new String[]{"WIN", ""};
    }

    public String getShares(String username, String password, String machine, String domain, NetFileResource nfRes) throws Exception, NetFileException {
        String shares = "";
        boolean accessible = false;
        try {
            SmbHandler handler = new SmbHandler(username, password, domain);
            URL sharesUrl = this.constructURL(machine, "/", handler);
            SmbFile file = (SmbFile)sharesUrl.openConnection();
            SmbFile[] files = file.listFiles();
            String shareName = "";
            for (int i = 0; i < files.length; ++i) {
                shareName = files[i].getName();
                if (!shareName.endsWith("$/")) {
                    shareName = shareName.substring(0, shareName.lastIndexOf("/"));
                    shares = shares + shareName + "\n";
                    continue;
                }
                accessible = this.isShareAccessible(username, password, machine, shareName = shareName.substring(0, shareName.length() - 1), domain, nfRes);
                if (!accessible) continue;
                shares = shares + shareName + "\n";
            }
            return shares;
        }
        catch (Exception ex) {
            debug.error("Exception getting shares", (Throwable)ex);
            if (ex instanceof SmbException) {
                SmbException se = (SmbException)((Object)ex);
                throw new Exception(this.getErrorString(se.getErrorClass(), se.getErrorCode(), nfRes));
            }
            return "ERROR:" + ex.getMessage();
        }
    }

    public String[] getDirectory(String username, String password, String machine, String share, String directory, String domain, NetFileResource nfRes) throws NetFileException {
        ArrayList fileListings = new ArrayList();
        try {
            SmbHandler handler = new SmbHandler(username, password, domain);
            directory = this.handleDirectoryNames(directory);
            URL listingUrl = this.constructURL(machine, "/" + share + directory + "/", handler);
            SmbFile file = (SmbFile)listingUrl.openConnection();
            SmbFile[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.extractFileInformation(files[i], fileListings);
            }
            int fileListingSize = fileListings.size();
            String[] totalListings = new String[fileListingSize];
            for (int i = 0; i < fileListingSize; ++i) {
                totalListings[i] = (String)fileListings.get(i);
            }
            String[] stringArray = totalListings;
            return stringArray;
        }
        catch (Exception e) {
            debug.error("Exception in getting the file listing", (Throwable)e);
            if (e instanceof SmbException) {
                SmbException se = (SmbException)((Object)e);
                throw new NetFileException(this.getErrorString(se.getErrorClass(), se.getErrorCode(), nfRes));
            }
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_get_listing_error");
        }
        finally {
            fileListings = null;
        }
    }

    private void extractFileInformation(SmbFile file, ArrayList fileListings) throws Exception {
        String fileType = "";
        String fileLastModified = "";
        String fileName = "";
        if (file.isHidden()) {
            return;
        }
        if (file.isDirectory()) {
            fileType = "D";
            String name = file.getName();
            fileName = name.substring(0, name.lastIndexOf("/"));
        } else if (file.isFile()) {
            fileType = "-";
            fileName = file.getName();
        } else {
            debug.error("WinFile: file " + file.getName() + "is of Unknown type.");
            return;
        }
        Date d = new Date(file.lastModified());
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd yy, hh:mm a");
        sdf.setCalendar(new GregorianCalendar(TimeZone.getDefault()));
        fileLastModified = sdf.format(d);
        fileListings.add(fileType);
        fileListings.add(fileName);
        fileListings.add(new Long(file.length()).toString());
        fileListings.add(fileLastModified);
    }

    public String getFile(String username, String password, String machine, String share, String file, String directory, String domain, String localTempDir, NetFileResource nfRes) throws NetFileException {
        try {
            int n;
            Long randomNo = new Long(System.currentTimeMillis());
            if (file.startsWith("\"")) {
                file = file.substring(1, file.length());
            }
            String localTempFileName = localTempDir + "/" + randomNo.toString() + username.toUpperCase() + file;
            SmbHandler handler = new SmbHandler(username, password, domain);
            directory = this.handleDirectoryNames(directory);
            URL fromUrl = this.constructURL(machine, "/" + share + directory + "/" + file, handler);
            SmbFile from = (SmbFile)fromUrl.openConnection();
            SmbFileInputStream in = new SmbFileInputStream(from);
            FileOutputStream out = new FileOutputStream(localTempFileName);
            byte[] b = new byte[8192];
            while ((n = in.read(b)) >= 0) {
                out.write(b, 0, n);
            }
            in.close();
            out.close();
            return localTempFileName;
        }
        catch (Exception ex) {
            debug.error("Exception in obtaining the file " + file, (Throwable)ex);
            if (ex instanceof SmbException) {
                SmbException se = (SmbException)((Object)ex);
                return "ERROR:" + this.getErrorString(se.getErrorClass(), se.getErrorCode(), nfRes);
            }
            return "ERROR:" + nfRes.getString("error21");
        }
    }

    public InputStream getInputStream(String username, String password, String domain, String machine, String share, String directory, String file, NetFileResource nfRes) throws NetFileException {
        try {
            SmbHandler handler = new SmbHandler(username, password, domain);
            directory = this.handleDirectoryNames(directory);
            URL fromUrl = this.constructURL(machine, "/" + share + directory + "/" + file, handler);
            debug.error("WinFile: getWinInputStream(), fromUrl--" + fromUrl.toString());
            SmbFile from = (SmbFile)fromUrl.openConnection();
            return new SmbFileInputStream(from);
        }
        catch (Exception ex) {
            debug.error("Exception in obtaining the InputStream for file " + file, (Throwable)ex);
            if (ex instanceof SmbException) {
                SmbException se = (SmbException)((Object)ex);
                throw new NetFileException(this.getErrorString(se.getErrorClass(), se.getErrorCode(), nfRes));
            }
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + nfRes.getString("error21"));
        }
    }

    public OutputStream getOutputStream(String username, String password, String domain, String machine, String share, String directory, String file, NetFileResource nfRes) throws NetFileException {
        return this.getOutputStream(username, password, domain, machine, share, directory, file, nfRes, false);
    }

    public OutputStream getOutputStream(String username, String password, String domain, String machine, String share, String directory, String file, NetFileResource nfRes, boolean append) throws NetFileException {
        try {
            SmbHandler handler = new SmbHandler(username, password, domain);
            directory = this.handleDirectoryNames(directory);
            URL toUrl = this.constructURL(machine, "/" + share + directory + "/" + file, handler);
            SmbFile to = (SmbFile)toUrl.openConnection();
            if (append) {
                return new SmbFileOutputStream(to, true);
            }
            return new SmbFileOutputStream(to);
        }
        catch (Exception e) {
            debug.error("Exception getting OutputStream for  file-" + file, (Throwable)e);
            if (e instanceof SmbException) {
                SmbException se = (SmbException)((Object)e);
                throw new NetFileException(this.getErrorString(se.getErrorClass(), se.getErrorCode(), nfRes));
            }
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + nfRes.getString("error21"));
        }
    }

    public String[] doSearch(String username, String password, String machine, String VMSnam, String pattern, String directory, String domain, int maxsrchdir, NetFileResource nfRes) throws NetFileException {
        this.searchResults = new ArrayList();
        this.search(username, password, machine, VMSnam, pattern, directory, domain, maxsrchdir, nfRes);
        if (this.directoriesTraversed > maxsrchdir) {
            String[] searchStr = new String[this.searchResults.size() + 1];
            searchStr[0] = "EXCEED:" + nfRes.getString("maxSearch");
            for (int i = 1; i < searchStr.length; ++i) {
                searchStr[i] = (String)this.searchResults.get(i - 1);
            }
            return searchStr;
        }
        if (this.searchResults.size() == 0) {
            return new String[]{"        "};
        }
        String[] finalSearchResults = new String[this.searchResults.size()];
        for (int i = 0; i < finalSearchResults.length; ++i) {
            finalSearchResults[i] = (String)this.searchResults.get(i);
        }
        return finalSearchResults;
    }

    void search(String username, String password, String machine, String VMSnam, String pattern, String directory, String domain, int maxsrchdir, NetFileResource nfRes) throws NetFileException {
        try {
            ++this.directoriesTraversed;
            debug.message(this + ":Directory number being searched=" + this.directoriesTraversed);
            if (this.directoriesTraversed > maxsrchdir) {
                return;
            }
            String[] fileListing = this.getDirectory(username, password, machine, VMSnam, directory, domain, nfRes);
            for (int i = 0; i < fileListing.length && this.directoriesTraversed <= maxsrchdir; i += 4) {
                if (fileListing[i].startsWith("ERROR:")) {
                    throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "error13", NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", VMSnam + directory + "/"});
                }
                if (fileListing[i].equalsIgnoreCase("d")) {
                    String errorString = "";
                    String newDirectory = directory + "/" + fileListing[i + 1];
                    try {
                        this.search(username, password, machine, VMSnam, pattern, newDirectory, domain, maxsrchdir, nfRes);
                    }
                    catch (NetFileException e) {
                        errorString = "(" + e.getMessage(nfRes) + ")";
                    }
                    if (fileListing[i + 1].indexOf(pattern) <= -1) continue;
                    this.searchResults.add("/" + VMSnam + newDirectory + "/" + errorString);
                    continue;
                }
                if (fileListing[i + 1].indexOf(pattern) <= -1) continue;
                this.searchResults.add("/" + VMSnam + directory + "/" + fileListing[i + 1]);
            }
        }
        catch (NetFileException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "error13", NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", VMSnam + directory + "/"});
        }
    }

    public String doCreateDirectory(String machine, String share, String username, String password, String domain, String parentDir, String dirToCreate, NetFileResource nfRes) throws NetFileException {
        try {
            SmbHandler handler = new SmbHandler(username, password, domain);
            parentDir = this.handleDirectoryNames(parentDir);
            URL mkdirUrl = this.constructURL(machine, "/" + share + parentDir + "/" + dirToCreate, handler);
            SmbFile dir = (SmbFile)mkdirUrl.openConnection();
            dir.mkdir();
            return nfRes.getString("warning52");
        }
        catch (Exception e) {
            debug.error("Problem in creating directory " + dirToCreate + " on machine " + machine, (Throwable)e);
            if (e instanceof SmbException) {
                SmbException se = (SmbException)((Object)e);
                throw new NetFileException(this.getErrorString(se.getErrorClass(), se.getErrorCode(), nfRes));
            }
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "could_not_create_directory");
        }
    }

    public String doDeleteFile(String username, String password, String machine, String share, String file, String directory, String domain, NetFileResource nfRes) throws NetFileException {
        try {
            SmbHandler handler = new SmbHandler(username, password, domain);
            directory = this.handleDirectoryNames(directory);
            URL deleteUrl = this.constructURL(machine, "/" + share + directory + "/" + file, handler);
            SmbFile deleteFile = (SmbFile)deleteUrl.openConnection();
            deleteFile.delete();
        }
        catch (Exception e) {
            debug.error("Problem in deleting file " + file + " on machine " + machine, (Throwable)e);
            if (e instanceof SmbException) {
                SmbException se = (SmbException)((Object)e);
                return "ERROR:" + this.getErrorString(se.getErrorClass(), se.getErrorCode(), nfRes);
            }
            return "ERROR:" + nfRes.getString("error_in_connection_to_server");
        }
        return nfRes.getString("info5");
    }

    public void doRenameFile(String username, String password, String machine, String domain, String share, String directory, String oldFileName, String newFileName, NetFileResource nfRes) throws NetFileException {
        try {
            SmbHandler handler = new SmbHandler(username, password, domain);
            directory = this.handleDirectoryNames(directory);
            URL fromUrl = this.constructURL(machine, "/" + share + directory + "/" + oldFileName, handler);
            SmbFile from = (SmbFile)fromUrl.openConnection();
            URL toUrl = this.constructURL(machine, "/" + share + directory + "/" + newFileName, handler);
            SmbFile to = (SmbFile)toUrl.openConnection();
            from.renameTo(to);
        }
        catch (SmbException se) {
            throw new NetFileException(this.getErrorString(se.getErrorClass(), se.getErrorCode(), nfRes));
        }
        catch (Exception e) {
            throw new NetFileException(nfRes.getString("renameError"));
        }
    }

    private String getSmbNameForEncoding(String encoding) {
        FileOption file_option = new FileOption(this.logManager, encoding, this.ssoToken);
        return file_option.getPlatformLocalisedString(encoding);
    }

    public String getErrorString(int errorClass, int errorCode, NetFileResource nfRes) {
        String result = "";
        block0 : switch (errorClass) {
            case 0: {
                result = result + nfRes.getString("SUCCESS");
                break;
            }
            case 1: {
                switch (errorCode) {
                    case 1: {
                        result = result + nfRes.getString("ERRDOS_badfunc");
                        break block0;
                    }
                    case 2: {
                        result = result + nfRes.getString("ERRDOS_badfile");
                        break block0;
                    }
                    case 3: {
                        result = result + nfRes.getString("ERRDOS_badpath");
                        break block0;
                    }
                    case 5: {
                        result = result + nfRes.getString("ERRDOS_noaccess");
                        break block0;
                    }
                    case 87: {
                        result = result + nfRes.getString("ERRDOS_badparm");
                        break block0;
                    }
                    case 123: {
                        result = result + nfRes.getString("ERRDOS_invname");
                        break block0;
                    }
                    case 145: {
                        result = result + nfRes.getString("ERRDOS_notempty");
                        break block0;
                    }
                    case 80: {
                        result = result + nfRes.getString("ERRDOS_filexists");
                        break block0;
                    }
                    case 6: {
                        result = result + nfRes.getString("ERRDOS_badfid");
                        break block0;
                    }
                    case 8: {
                        result = result + nfRes.getString("ERRDOS_nospace");
                        break block0;
                    }
                    case 32: {
                        result = result + nfRes.getString("ERRDOS_badshare");
                        break block0;
                    }
                    case 52: {
                        result = result + nfRes.getString("ERRDOS_dupname");
                        break block0;
                    }
                    case 21: {
                        result = result + nfRes.getString("ERRDOS_notready");
                        break block0;
                    }
                    case 67: {
                        result = result + nfRes.getString("ERRDOS_badnetname");
                        break block0;
                    }
                    case 183: {
                        result = result + nfRes.getString("ERRDOS_exists");
                        break block0;
                    }
                    case 231: {
                        result = result + nfRes.getString("ERRDOS_pipebusy");
                        break block0;
                    }
                    case 232: {
                        result = result + nfRes.getString("ERRDOS_nodata");
                        break block0;
                    }
                    case 233: {
                        result = result + nfRes.getString("ERRDOS_noproc");
                        break block0;
                    }
                    case 109: {
                        result = result + nfRes.getString("ERRDOS_brokenpipe");
                        break block0;
                    }
                    case 71: {
                        result = result + nfRes.getString("ERRDOS_nomoreconn");
                        break block0;
                    }
                }
                result = result + nfRes.getString("jcifs_noreason");
                break;
            }
            case 2: {
                switch (errorCode) {
                    case 1: {
                        result = result + nfRes.getString("ERRSRV_error");
                        break block0;
                    }
                    case 2: {
                        result = result + nfRes.getString("ERRSRV_badpw");
                        break block0;
                    }
                    case 5: {
                        result = result + nfRes.getString("ERRSRV_invnid");
                        break block0;
                    }
                    case 6: {
                        result = result + nfRes.getString("ERRSRV_invnetname");
                        break block0;
                    }
                    case 91: {
                        result = result + nfRes.getString("ERRSRV_baduid");
                        break block0;
                    }
                    case 4: {
                        result = result + nfRes.getString("ERRSRV_access");
                        break block0;
                    }
                    case 2239: {
                        result = result + nfRes.getString("ERRSRV_accountExpired");
                        break block0;
                    }
                    case 2240: {
                        result = result + nfRes.getString("ERRSRV_badClient");
                        break block0;
                    }
                    case 2241: {
                        result = result + nfRes.getString("ERRSRV_badLogonTime");
                        break block0;
                    }
                    case 2242: {
                        result = result + nfRes.getString("ERRSRV_passwordExpired");
                        break block0;
                    }
                }
                result = result + nfRes.getString("jcifs_noreason");
                break;
            }
            case 3: {
                switch (errorCode) {
                    case 19: {
                        result = result + nfRes.getString("ERRHRD_nowrite");
                        break block0;
                    }
                    case 21: {
                        result = result + nfRes.getString("ERRHRD_notready");
                        break block0;
                    }
                }
                result = result + nfRes.getString("jcifs_notready");
                break;
            }
            case 255: {
                result = result + nfRes.getString("ERRCMD");
                break;
            }
            case 16: {
                switch (errorCode) {
                    case 0: {
                        result = result + nfRes.getString("ERRRAP_NERR_Success");
                        break block0;
                    }
                    case 19: 
                    case 2114: {
                        result = result + nfRes.getString("ERRRAP_NERR_ServerNotStarted");
                        break block0;
                    }
                    case 2141: {
                        result = result + nfRes.getString("ERRRAP_NERR_BasicTransactConfig");
                        break block0;
                    }
                }
                result = result + nfRes.getString("jcifs_noreason");
                break;
            }
            case 32: {
                switch (errorCode) {
                    case 5000: {
                        result = result + nfRes.getString("ERRCLI_serverTimeout");
                        break block0;
                    }
                    case 5001: {
                        result = result + nfRes.getString("ERRCLI_badDialect");
                        break block0;
                    }
                    case 5002: {
                        result = result + nfRes.getString("ERRCLI_ioe");
                        break block0;
                    }
                    case 5003: {
                        result = result + nfRes.getString("ERRCLI_listFiles");
                        break block0;
                    }
                    case 5004: {
                        result = result + nfRes.getString("ERRCLI_unknownHost");
                        break block0;
                    }
                    case 5005: {
                        result = result + nfRes.getString("ERRCLI_inappro");
                        break block0;
                    }
                    case 5006: {
                        result = result + nfRes.getString("ERRCLI_unknownType");
                        break block0;
                    }
                }
                result = result + nfRes.getString("jcifs_noreason");
                break;
            }
            default: {
                result = result + "unknown error class: " + errorClass;
            }
        }
        return result;
    }

    public String doDeleteDirectory(String username, String password, String machine, String share, String directory, String domain, NetFileResource nfRes) throws NetFileException {
        throw new NetFileException("Delete directory operation is not supported");
    }

    public boolean isShareAccessible(String username, String password, String machine, String share, String domain, NetFileResource nfRes) {
        boolean returnValue = false;
        try {
            SmbHandler handler = new SmbHandler(username, password, domain);
            URL listingUrl = this.constructURL(machine, "/" + share + "/", handler);
            SmbFile file = (SmbFile)listingUrl.openConnection();
            SmbFile[] files = file.listFiles();
            returnValue = files != null;
        }
        catch (SmbException se) {
            debug.error("WinFile: share - " + share + " not accessible to user - " + username + "." + this.getErrorString(se.getErrorClass(), se.getErrorCode(), nfRes));
            returnValue = false;
        }
        catch (Exception e) {
            debug.error("WinFile: exception when checking for share accessibility," + e.toString());
            returnValue = false;
        }
        return returnValue;
    }
}

