/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeAddressEntries;
import com.aligo.messaging.exchange.ExchangeAddressEntry;
import com.aligo.messaging.exchange.ExchangeField;
import com.aligo.messaging.exchange.ExchangeFields;
import com.aligo.pim.PimBusyStatusType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchange.ExchangePimAddressEntryItems;
import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.ExchangePimFieldItems;
import com.aligo.pim.exchange.ExchangePimItem;
import com.aligo.pim.exchange.ExchangePimSession;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAddressEntryItems;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecipientItems;
import java.util.Date;

public class ExchangePimAddressEntryItem
extends ExchangePimItem
implements PimAddressEntryItem {
    private ExchangeAddressEntry _oAddressEntry;
    private ExchangeFields _oFields;
    private ExchangePimFieldItems m_oPimFieldItems;
    private String m_szId = new String();

    public ExchangePimAddressEntryItem(ExchangeAddressEntry _oAddressEntry, ExchangePimSession pimSession) throws ExchangePimException {
        super(pimSession);
        try {
            this._oAddressEntry = _oAddressEntry;
            this.m_szId = this.getExchangeAddressEntry().getId();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void setExchangeAddressEntry(ExchangeAddressEntry _oAddressEntry) throws ExchangePimException {
        try {
            this._oAddressEntry = _oAddressEntry;
            this.m_szId = this.getExchangeAddressEntry().getId();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public ExchangeAddressEntry getExchangeAddressEntry() {
        return this._oAddressEntry;
    }

    public String getName() throws ExchangePimException {
        try {
            return this.getExchangeAddressEntry().getName();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimAddressEntryItems getMembers() throws ExchangePimException {
        ExchangeAddressEntries exchangeAddressEntries;
        try {
            exchangeAddressEntries = this.getExchangeAddressEntry().getMembers();
        }
        catch (Exception e) {
            return null;
        }
        if (exchangeAddressEntries != null) {
            return new ExchangePimAddressEntryItems(exchangeAddressEntries, this.getPimSession());
        }
        return null;
    }

    public PimAddressEntryItems addMembers() throws ExchangePimException {
        throw new ExchangePimException(12L);
    }

    public String getID() throws ExchangePimException {
        return this.m_szId;
    }

    public PimBusyStatusType getBusyStatusType(Date startTime, Date endTime, int interval) throws ExchangePimException {
        try {
            if (!endTime.after(startTime)) {
                throw new ExchangePimException(13L);
            }
            long noOfMilliSeconds = endTime.getTime() - startTime.getTime();
            long noOfMinutes = noOfMilliSeconds / 60000L;
            if (noOfMinutes < (long)interval || interval < 1) {
                interval = (int)noOfMinutes;
            }
            if (interval < 1) {
                interval = 1;
            }
            int dummyInterval = 1;
            String freeBusy = this.getExchangeAddressEntry().getFreeBusy(startTime, endTime, dummyInterval);
            StringBuffer checkFreeString = new StringBuffer();
            StringBuffer checkTentativeString = new StringBuffer();
            int i = 0;
            while (i < interval) {
                checkFreeString.append("0");
                checkTentativeString.append("1");
                ++i;
            }
            if (freeBusy.indexOf(checkFreeString.toString()) > -1) {
                return PimBusyStatusType.FREE;
            }
            if (freeBusy.indexOf(checkTentativeString.toString()) > -1) {
                return PimBusyStatusType.TENTATIVE;
            }
            return PimBusyStatusType.BUSY;
        }
        catch (AligoExchangeException e) {
            return PimBusyStatusType.UNKNOWN;
        }
    }

    public ExchangeFields getExchangeFields() throws ExchangePimException {
        try {
            this._oFields = this.getExchangeAddressEntry().getFields();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
        return this._oFields;
    }

    public PimFieldItems getFieldItems() throws ExchangePimException {
        if (this.m_oPimFieldItems == null) {
            try {
                this.m_oPimFieldItems = new ExchangePimFieldItems(this.getExchangeFields(), this.getPimSession());
            }
            catch (Exception e) {
                throw new ExchangePimException(e);
            }
        } else {
            this.m_oPimFieldItems.setExchangeFields(this.getExchangeFields());
        }
        return this.m_oPimFieldItems;
    }

    public void delete() throws ExchangePimException {
        throw new ExchangePimException(11L);
    }

    public void delete(boolean flag) throws PimException {
    }

    public void update() throws ExchangePimException {
        try {
            this.getExchangeAddressEntry().update();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getEmailAddress() throws ExchangePimException {
        try {
            if (this.getExchangeFields().fieldExists(972947486)) {
                ExchangeField field = this.getExchangeFields().getItem(972947486);
                return (String)field.getValue();
            }
            return this.getExchangeAddressEntry().getAddress();
        }
        catch (AligoExchangeException e) {
            return "";
        }
    }

    public String getLastName() throws ExchangePimException {
        try {
            if (this.getExchangeFields().fieldExists(974192670)) {
                ExchangeField field = this.getExchangeFields().getItem(974192670);
                return (String)field.getValue();
            }
            return "";
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getFirstName() throws ExchangePimException {
        try {
            if (this.getExchangeFields().fieldExists(973471774)) {
                ExchangeField field = this.getExchangeFields().getItem(973471774);
                return (String)field.getValue();
            }
            return "";
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getAlternateFullName() throws PimException {
        return "";
    }

    public String getBusinessTelephoneNumber() throws ExchangePimException {
        try {
            if (this.getExchangeFields().fieldExists(973602846)) {
                ExchangeField field = this.getExchangeFields().getItem(973602846);
                return (String)field.getValue();
            }
            return "";
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getHomeTelephoneNumber() throws ExchangePimException {
        try {
            if (this.getExchangeFields().fieldExists(973668382)) {
                ExchangeField field = this.getExchangeFields().getItem(973668382);
                return (String)field.getValue();
            }
            return "";
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getMobileTelephoneNumber() throws ExchangePimException {
        try {
            if (this.getExchangeFields().fieldExists(974913566)) {
                ExchangeField field = this.getExchangeFields().getItem(974913566);
                return (String)field.getValue();
            }
            return "";
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getBusinessFaxNumber() throws ExchangePimException {
        try {
            if (this.getExchangeFields().fieldExists(975437854)) {
                ExchangeField field = this.getExchangeFields().getItem(975437854);
                return (String)field.getValue();
            }
            return "";
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getTitle() throws ExchangePimException {
        try {
            if (this.getExchangeFields().fieldExists(974585886)) {
                ExchangeField field = this.getExchangeFields().getItem(974585886);
                return (String)field.getValue();
            }
            return "";
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getCompanyName() throws ExchangePimException {
        try {
            if (this.getExchangeFields().fieldExists(974520350)) {
                ExchangeField field = this.getExchangeFields().getItem(974520350);
                return (String)field.getValue();
            }
            return "";
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getHomeStreet() throws ExchangePimException {
        try {
            if (this.getExchangeFields().fieldExists(979173406)) {
                ExchangeField field = this.getExchangeFields().getItem(979173406);
                return (String)field.getValue();
            }
            return "";
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getHomeCity() throws ExchangePimException {
        try {
            if (this.getExchangeFields().fieldExists(978911262)) {
                ExchangeField field = this.getExchangeFields().getItem(978911262);
                return (String)field.getValue();
            }
            return "";
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getHomeState() throws ExchangePimException {
        try {
            if (this.getExchangeFields().fieldExists(979107870)) {
                ExchangeField field = this.getExchangeFields().getItem(979107870);
                return (String)field.getValue();
            }
            return "";
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getHomeZip() throws ExchangePimException {
        try {
            if (this.getExchangeFields().fieldExists(979042334)) {
                ExchangeField field = this.getExchangeFields().getItem(979042334);
                return (String)field.getValue();
            }
            return "";
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getHomeCountry() throws ExchangePimException {
        try {
            if (this.getExchangeFields().fieldExists(978976798)) {
                ExchangeField field = this.getExchangeFields().getItem(978976798);
                return (String)field.getValue();
            }
            return "";
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getBusinessStreet() throws ExchangePimException {
        try {
            if (this.getExchangeFields().fieldExists(975765534)) {
                ExchangeField field = this.getExchangeFields().getItem(975765534);
                return (String)field.getValue();
            }
            return "";
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getBusinessCity() throws ExchangePimException {
        try {
            if (this.getExchangeFields().fieldExists(975634462)) {
                ExchangeField field = this.getExchangeFields().getItem(975634462);
                return (String)field.getValue();
            }
            return "";
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getBusinessState() throws ExchangePimException {
        try {
            if (this.getExchangeFields().fieldExists(975699998)) {
                ExchangeField field = this.getExchangeFields().getItem(975699998);
                return (String)field.getValue();
            }
            return "";
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getBusinessZip() throws ExchangePimException {
        try {
            if (this.getExchangeFields().fieldExists(975831070)) {
                ExchangeField field = this.getExchangeFields().getItem(975831070);
                return (String)field.getValue();
            }
            return "";
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getBusinessCountry() throws ExchangePimException {
        try {
            if (this.getExchangeFields().fieldExists(975568926)) {
                ExchangeField field = this.getExchangeFields().getItem(975568926);
                return (String)field.getValue();
            }
            return "";
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void send() throws ExchangePimException {
    }

    public PimMessageItem forward() throws ExchangePimException {
        return null;
    }

    public PimRecipientItems getRecipientItems() throws ExchangePimException {
        return null;
    }

    public void setEmailAddress(String emailAddress) throws ExchangePimException {
        throw new ExchangePimException(10L);
    }

    public void setLastName(String lastName) throws ExchangePimException {
        throw new ExchangePimException(10L);
    }

    public void setFirstName(String firstname) throws ExchangePimException {
        throw new ExchangePimException(10L);
    }

    public void setAlternateFullName(String alternateFullName) throws PimException {
    }

    public void setBusinessTelephoneNumber(String bTelNumber) throws ExchangePimException {
        throw new ExchangePimException(10L);
    }

    public void setHomeTelephoneNumber(String hTelNumber) throws ExchangePimException {
        throw new ExchangePimException(10L);
    }

    public void setMobileTelephoneNumber(String mTelNumber) throws ExchangePimException {
        throw new ExchangePimException(10L);
    }

    public void setBusinessFaxNumber(String bFaxNumber) throws ExchangePimException {
        throw new ExchangePimException(10L);
    }

    public void setTitle(String title) throws ExchangePimException {
        throw new ExchangePimException(10L);
    }

    public void setCompanyName(String companyName) throws ExchangePimException {
        throw new ExchangePimException(10L);
    }

    public void setHomeStreet(String hStreet) throws ExchangePimException {
        throw new ExchangePimException(10L);
    }

    public void setHomeCity(String hCity) throws ExchangePimException {
        throw new ExchangePimException(10L);
    }

    public void setHomeState(String hState) throws ExchangePimException {
        throw new ExchangePimException(10L);
    }

    public void setHomeZip(String hZip) throws ExchangePimException {
        throw new ExchangePimException(10L);
    }

    public void setHomeCountry(String hCountry) throws ExchangePimException {
        throw new ExchangePimException(10L);
    }

    public void setBusinessStreet(String bStreet) throws ExchangePimException {
        throw new ExchangePimException(10L);
    }

    public void setBusinessCity(String bCity) throws ExchangePimException {
        throw new ExchangePimException(10L);
    }

    public void setBusinessState(String bState) throws ExchangePimException {
        throw new ExchangePimException(10L);
    }

    public void setBusinessZip(String bZip) throws ExchangePimException {
        throw new ExchangePimException(10L);
    }

    public void setBusinessCountry(String bCountry) throws ExchangePimException {
        throw new ExchangePimException(10L);
    }
}

