/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.messaging.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeAddressEntries;
import com.aligo.messaging.exchange.ExchangeAddressEntry;
import com.aligo.messaging.exchange.ExchangeAddressEntryFilter;
import com.aligo.messaging.exchange.ExchangeAddressList;
import com.aligo.messaging.exchange.ExchangeAddressLists;
import com.aligo.messaging.exchange.ExchangeAppointmentItem;
import com.aligo.messaging.exchange.ExchangeField;
import com.aligo.messaging.exchange.ExchangeFields;
import com.aligo.messaging.exchange.ExchangeFolder;
import com.aligo.messaging.exchange.ExchangeInfoStore;
import com.aligo.messaging.exchange.ExchangeInfoStores;
import com.aligo.messaging.exchange.ExchangeMeetingItem;
import com.aligo.messaging.exchange.ExchangeMessage;
import com.aligo.messaging.exchange.auth.AligoAuthFactory;
import com.aligo.messaging.exchange.cdo.AddressEntryProxy;
import com.aligo.messaging.exchange.cdo.AddressListProxy;
import com.aligo.messaging.exchange.cdo.AddressListsProxy;
import com.aligo.messaging.exchange.cdo.AppointmentItemProxy;
import com.aligo.messaging.exchange.cdo.FieldProxy;
import com.aligo.messaging.exchange.cdo.FieldsProxy;
import com.aligo.messaging.exchange.cdo.FolderProxy;
import com.aligo.messaging.exchange.cdo.InfoStoreProxy;
import com.aligo.messaging.exchange.cdo.InfoStoresProxy;
import com.aligo.messaging.exchange.cdo.MeetingItemProxy;
import com.aligo.messaging.exchange.cdo.MessageProxy;
import com.aligo.messaging.exchange.cdo.Session;
import com.linar.jintegra.AuthInfo;
import com.linar.jintegra.AutomationException;
import com.linar.jintegra.Log;
import com.linar.ocxhost.Container;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import outlook.Application;
import outlook.MAPIFolder;
import outlook.Recipient;
import outlook._NameSpace;

public final class ExchangeSession {
    private boolean autoConnect;
    private boolean loggedOn;
    private Session _ocxSession;
    private static HashMap _oContainers = new HashMap();
    private String MAPI_SESSION = "MAPI.Session.1";
    private String domain;
    private String mailbox;
    private String password;
    private String server;
    private String user;
    private String ocxHostLocation;
    private String aligoAuthLocation;
    private String outlookLocation;
    private Application outlookApp;
    private _NameSpace outlookNs;
    private boolean outlookLogon;
    private boolean isAligoAuthUsed = false;
    private boolean isMailboxManipulationTried = false;
    private String m_szSuperUser;
    private static String m_szPreviousDomain;
    private static String m_szPreviousUser;
    private static String m_szPreviousPassword;
    static /* synthetic */ Class class$com$linar$jintegra$AuthInfo;

    public String getApplication() throws AligoExchangeException {
        return "Collaboration Data Objects";
    }

    public String getName() throws AligoExchangeException {
        try {
            return (String)this._ocxSession.getName();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeSession(String user, String password, String mailbox, String server, String domain, String ocxHostLocation, String aligoAuthLocation, String outlookLocation, boolean isAligoAuthUsed, String szSuperUser) throws AligoExchangeException, UnknownHostException {
        this.user = user;
        if (this.user == null) {
            this.user = "Administrator";
        }
        this.password = password;
        if (this.password == null) {
            this.password = "password";
        }
        this.mailbox = this.user;
        this.domain = domain;
        if (this.domain == null) {
            this.domain = "localhost";
        }
        this.server = server;
        if (this.server == null) {
            this.server = this.domain;
        }
        this.ocxHostLocation = ocxHostLocation;
        if (this.ocxHostLocation == null) {
            this.ocxHostLocation = this.server;
        }
        this.aligoAuthLocation = aligoAuthLocation;
        if (this.aligoAuthLocation == null) {
            this.aligoAuthLocation = this.ocxHostLocation;
        }
        this.outlookLocation = outlookLocation;
        this.isAligoAuthUsed = isAligoAuthUsed;
        this.autoConnect = true;
        this.loggedOn = false;
        this.outlookLogon = false;
        this.isMailboxManipulationTried = false;
        this.m_szSuperUser = szSuperUser;
        if (this.m_szSuperUser == null || this.m_szSuperUser.equals("")) {
            this.m_szSuperUser = "maxhost";
        }
    }

    public ExchangeSession(Session sessionHandle) {
        this._ocxSession = sessionHandle;
    }

    public void manipulateMailbox() throws AligoExchangeException {
        try {
            this._ocxSession.logoff();
            StringBuffer profileInfo = new StringBuffer(this.server);
            profileInfo.append("\n");
            String tempMailBox = this.m_szSuperUser;
            profileInfo.append(tempMailBox);
            this._ocxSession.logon(null, null, null, null, null, null, profileInfo.toString());
            ExchangeAddressList _oTempAddressList = this.getAddressList(0);
            ExchangeAddressEntries _oTempAddressEntries = _oTempAddressList.getAddressEntries();
            ExchangeAddressEntryFilter _oTempAddressEntryFilter = _oTempAddressEntries.getFilter();
            ExchangeFields _oTempFields = _oTempAddressEntryFilter.getFields();
            _oTempFields.add(973078558, this.user);
            ExchangeAddressEntry _oTempAddressEntry = _oTempAddressEntries.getFirst();
            if (_oTempAddressEntry == null) {
                throw new AligoExchangeException("AddressEntryItem with alias =" + this.user + " not found");
            }
            tempMailBox = _oTempAddressEntry.getName();
            this._ocxSession.logoff();
            this.mailbox = tempMailBox;
            this.logon();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    private Container getContainer(String location) throws IOException, UnknownHostException {
        Container container = (Container)_oContainers.get(location);
        if (container == null) {
            container = new Container(location);
            _oContainers.put(location, container);
        } else {
            try {
                container.create(this.MAPI_SESSION);
            }
            catch (ConnectException e) {
                try {
                    container = new Container(location);
                    _oContainers.put(location, container);
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
        }
        return container;
    }

    public void logon() throws AligoExchangeException, UnknownHostException {
        if (!this.loggedOn) {
            try {
                Class clazz = class$com$linar$jintegra$AuthInfo == null ? (class$com$linar$jintegra$AuthInfo = ExchangeSession.class$("com.linar.jintegra.AuthInfo")) : class$com$linar$jintegra$AuthInfo;
                synchronized (clazz) {
                    try {
                        AuthInfo.setDefault((String)this.domain, (String)this.user, (String)this.password);
                        Container _ocxContainer = this.getContainer(this.ocxHostLocation);
                        this._ocxSession = new Session(_ocxContainer.create(this.MAPI_SESSION));
                    }
                    catch (Exception e) {
                        if (m_szPreviousUser != null) {
                            AuthInfo.setDefault((String)m_szPreviousDomain, (String)m_szPreviousUser, (String)m_szPreviousPassword);
                        }
                        throw e;
                    }
                    m_szPreviousDomain = this.domain;
                    m_szPreviousUser = this.user;
                    m_szPreviousPassword = this.password;
                }
                StringBuffer profileInfo = new StringBuffer(this.server);
                profileInfo.append("\n");
                profileInfo.append(this.mailbox);
                this._ocxSession.logon(null, null, null, null, null, null, profileInfo.toString());
                if (this.isAligoAuthUsed) {
                    String szNTLMAuthenticate;
                    StringTokenizer ntlmTokenizer;
                    ExchangeAddressEntry _oAddressEntry = this.getCurrentUser();
                    ExchangeFields _oFields = _oAddressEntry.getFields();
                    ExchangeField _oField = _oFields.getItem(-2144927486);
                    String _oSid = (String)_oField.getValue();
                    AligoAuthFactory _oAligoAuthFactory = new AligoAuthFactory(this.aligoAuthLocation);
                    String[] userNameAuth = new String[]{this.user};
                    String[] passwordAuth = new String[]{this.password};
                    String[] domainAuth = new String[]{this.domain};
                    String[] mailboxAuth = new String[]{this.mailbox};
                    String[] sidAuth = new String[]{_oSid};
                    int iErrorCode = 0;
                    String returnCode = _oAligoAuthFactory.authenticateDebug(userNameAuth, passwordAuth, domainAuth, mailboxAuth, sidAuth);
                    StringTokenizer returnCodeTokenizer = new StringTokenizer(returnCode, ",");
                    if (returnCodeTokenizer.hasMoreTokens() && (ntlmTokenizer = new StringTokenizer(szNTLMAuthenticate = returnCodeTokenizer.nextToken(), "=")).hasMoreTokens()) {
                        ntlmTokenizer.nextToken();
                        iErrorCode = Integer.parseInt(ntlmTokenizer.nextToken());
                    }
                    if (iErrorCode != 0) {
                        AligoExchangeException ae;
                        switch (iErrorCode) {
                            case 1: {
                                ae = new AligoExchangeException(" Authenticating module has problems launching. The user need to have user level access in the machine. No authenticating authority available to launch. Please enable user level access in Win95/Win98. It can be set in control panel/network/access control/user level access control..");
                                ae.setCode(63);
                                break;
                            }
                            case 2: {
                                ae = new AligoExchangeException("Incorrect username, password or domain");
                                ae.setCode(1);
                                break;
                            }
                            case 3: {
                                ae = new AligoExchangeException("Dcom unsupported in this machine. If you are running Win95/Win98 but haven't installed DCOM95/DCOM98, please do so and try again.");
                                ae.setCode(64);
                                break;
                            }
                            case 4: {
                                ae = new AligoExchangeException("Unknown error occured");
                                ae.setCode(0);
                                break;
                            }
                            default: {
                                ae = new AligoExchangeException("Unknown error occured");
                                ae.setCode(0);
                            }
                        }
                        throw ae;
                    }
                }
                this.getInbox();
                if (this.outlookLocation != null) {
                    try {
                        this.outlookApp = new Application(this.outlookLocation);
                        this.outlookNs = this.outlookApp.getNamespace("MAPI");
                        this.outlookLogon = false;
                        this.outlookNs.logon(null, null, null, null);
                        this.outlookLogon = true;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                this.loggedOn = true;
            }
            catch (AligoExchangeException e) {
                if (!this.isMailboxManipulationTried) {
                    this.isMailboxManipulationTried = true;
                    int code = e.getCode();
                    if (code != 63 || code != 64 || code != 1 || code != 0) {
                        try {
                            this.manipulateMailbox();
                            return;
                        }
                        catch (Exception ae) {
                            throw new AligoExchangeException(ae);
                        }
                    }
                }
                throw e;
            }
            catch (UnknownHostException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AligoExchangeException(e);
            }
        }
        throw new AligoExchangeException("The session is already logged on.");
    }

    public void logoff() throws AligoExchangeException {
        if (this.loggedOn) {
            try {
                this._ocxSession.logoff();
                if (this.outlookLogon) {
                    try {
                        this.outlookNs.logoff();
                        this.outlookLogon = false;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                this.loggedOn = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String createConversationIndex() throws AligoExchangeException {
        try {
            return (String)this._ocxSession.createConversationIndex(null);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean compareIds(String id1, String id2) throws AligoExchangeException {
        try {
            return (Boolean)this._ocxSession.compareIDs(id1, id2);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String createConversationIndex(String parentIndex) throws AligoExchangeException {
        try {
            return (String)this._ocxSession.createConversationIndex(parentIndex);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeAddressEntry getCurrentUser() throws AligoExchangeException {
        try {
            AddressEntryProxy resultHandle = new AddressEntryProxy(this._ocxSession.getCurrentUser());
            return new ExchangeAddressEntry(resultHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeInfoStores getInfoStores() throws AligoExchangeException {
        try {
            this.checkStatus();
            InfoStoresProxy handle = new InfoStoresProxy(this._ocxSession.getInfoStores());
            return new ExchangeInfoStores(handle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeAddressEntry getAddressEntry(int entryId) throws AligoExchangeException {
        try {
            return new ExchangeAddressEntry(new AddressEntryProxy(this._ocxSession.getAddressEntry(new Integer(entryId))));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeAddressLists getAddressLists() throws AligoExchangeException {
        try {
            this.checkStatus();
            return new ExchangeAddressLists(new AddressListsProxy(this._ocxSession.getAddressLists()));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeAddressList getAddressList(int type) throws AligoExchangeException {
        try {
            this.checkStatus();
            return new ExchangeAddressList(new AddressListProxy(this._ocxSession.getAddressList(new Integer(type))));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeFolder getDrafts() throws AligoExchangeException {
        try {
            this.checkStatus();
            FolderProxy inboxFolder = new FolderProxy(this._ocxSession.getInbox());
            FieldsProxy exFields = new FieldsProxy(inboxFolder.getFields());
            FieldProxy exField = new FieldProxy(exFields.getItem(new Integer(920060162), null));
            String id = (String)exField.getValue();
            return new ExchangeFolder(new FolderProxy(this._ocxSession.getFolder(id, null)));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeFolder getInbox() throws AligoExchangeException {
        try {
            this.checkStatus();
            FolderProxy folderHandle = new FolderProxy(this._ocxSession.getInbox());
            return new ExchangeFolder(folderHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeFolder getOutbox() throws AligoExchangeException {
        try {
            this.checkStatus();
            FolderProxy folderHandle = new FolderProxy(this._ocxSession.getOutbox());
            return new ExchangeFolder(folderHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeFolder getCalendar() throws AligoExchangeException {
        try {
            return this.getDefaultFolder(0);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeFolder getContacts() throws AligoExchangeException {
        try {
            return this.getDefaultFolder(5);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public MAPIFolder getContacts(String user) throws AligoExchangeException {
        try {
            if (!this.outlookLogon) {
                return null;
            }
            Recipient recipient = this.outlookNs.createRecipient(user);
            boolean isResolved = recipient.resolve();
            if (isResolved) {
                return this.outlookNs.getSharedDefaultFolder(recipient, 10);
            }
            return null;
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public MAPIFolder getCalendar(String user) throws AligoExchangeException {
        try {
            if (!this.outlookLogon) {
                return null;
            }
            Recipient recipient = this.outlookNs.createRecipient(user);
            boolean isResolved = recipient.resolve();
            if (isResolved) {
                return this.outlookNs.getSharedDefaultFolder(recipient, 9);
            }
            return null;
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeFolder getFolder(String folderId, String storeId) throws AligoExchangeException {
        try {
            this.checkStatus();
            FolderProxy folderHandle = new FolderProxy(this._ocxSession.getFolder(folderId, storeId));
            return new ExchangeFolder(folderHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeFolder getDefaultFolder(int id) throws AligoExchangeException {
        if (id < 0) {
            id = 0;
        }
        try {
            this.checkStatus();
            FolderProxy folderHandle = new FolderProxy(this._ocxSession.getDefaultFolder(new Integer(id)));
            ExchangeFolder f = new ExchangeFolder(folderHandle);
            f.setFolderType(id);
            return f;
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public Object getMessage(String messageId, String storeId) throws AligoExchangeException {
        try {
            this.checkStatus();
            try {
                Object obj = this._ocxSession.getMessage(messageId, storeId);
                if (obj != null) {
                    MessageProxy mesgHandle = new MessageProxy(this._ocxSession.getMessage(messageId, storeId));
                    ExchangeMessage msg = new ExchangeMessage(mesgHandle);
                    if (msg.getClassType() == 27) {
                        MeetingItemProxy meetingHandle = new MeetingItemProxy(obj);
                        return new ExchangeMeetingItem(meetingHandle);
                    }
                    if (msg.getClassType() == 26) {
                        AppointmentItemProxy apptHandle = new AppointmentItemProxy(obj);
                        return new ExchangeAppointmentItem(apptHandle);
                    }
                    return msg;
                }
                return null;
            }
            catch (Exception notFound) {
                if (notFound instanceof AutomationException) {
                    int code = new Long(((AutomationException)notFound).getCode()).intValue();
                    if (code == -2147221233) {
                        return null;
                    }
                    throw new AligoExchangeException(notFound);
                }
                throw new AligoExchangeException(notFound);
            }
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public Object getMessage(String messageId) throws AligoExchangeException {
        return this.getMessage(messageId, null);
    }

    public ExchangeMessage getArticle(String articleId, String folderId) throws AligoExchangeException {
        try {
            return new ExchangeMessage(new MessageProxy(this._ocxSession.getArticle(articleId, folderId, null)));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeMessage getArticle(String articleId, String folderId, String infoStoreId) throws AligoExchangeException {
        try {
            return new ExchangeMessage(new MessageProxy(this._ocxSession.getArticle(articleId, folderId, infoStoreId)));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void deliverNow() throws AligoExchangeException {
        try {
            this._ocxSession.deliverNow();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getVersion() throws AligoExchangeException {
        try {
            return (String)this._ocxSession.getVersion();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getOperatingSystem() throws AligoExchangeException {
        try {
            return (String)this._ocxSession.getOperatingSystem();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean getOutOfOffice() throws AligoExchangeException {
        try {
            this.checkStatus();
            return (Boolean)this._ocxSession.getOutOfOffice();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setOutOfOffice(boolean status) throws AligoExchangeException {
        try {
            this.checkStatus();
            this._ocxSession.setOutOfOffice(new Boolean(status));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getOutOfOfficeText() throws AligoExchangeException {
        try {
            this.checkStatus();
            return (String)this._ocxSession.getOutOfOfficeText();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setOutOfOfficeText(String message) throws AligoExchangeException {
        try {
            this._ocxSession.setOutOfOfficeText(message);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeInfoStore getInfoStore() throws AligoExchangeException {
        try {
            return new ExchangeInfoStore(new InfoStoreProxy(this._ocxSession.getInfoStore(null)));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeInfoStore getInfoStore(String id) throws AligoExchangeException {
        try {
            return new ExchangeInfoStore(new InfoStoreProxy(this._ocxSession.getInfoStore(id)));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    Session getSessionHandle() throws AligoExchangeException {
        try {
            this.checkStatus();
            return this._ocxSession;
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    private void checkStatus() throws AligoExchangeException {
        try {
            String s = (String)this._ocxSession.getApplication();
        }
        catch (Exception e) {
            if (!this.autoConnect) {
                throw new AligoExchangeException("ExchangeSession: checkStatus() failed!");
            }
            try {
                this.loggedOn = false;
                this.logon();
            }
            catch (Exception ee) {
                throw new AligoExchangeException(ee);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Properties env = System.getProperties();
            String value = env.getProperty("LINAR_DEBUG");
            String logfile = env.getProperty("LINAR_DEBUG_FILE");
            if (value != null && value.equals("true")) {
                if (logfile == null) {
                    Log.logImmediately((int)3, (PrintStream)System.err);
                } else {
                    Log.logImmediately((int)3, (String)logfile);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

