/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.messaging.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeAddressEntry;
import com.aligo.messaging.exchange.ExchangeAttachments;
import com.aligo.messaging.exchange.ExchangeFields;
import com.aligo.messaging.exchange.ExchangeMeetingItem;
import com.aligo.messaging.exchange.ExchangeMessage;
import com.aligo.messaging.exchange.ExchangeMessages;
import com.aligo.messaging.exchange.ExchangeRecipients;
import com.aligo.messaging.exchange.ExchangeRecurrencePattern;
import com.aligo.messaging.exchange.cdo.AddressEntryProxy;
import com.aligo.messaging.exchange.cdo.AppointmentItem;
import com.aligo.messaging.exchange.cdo.AttachmentsProxy;
import com.aligo.messaging.exchange.cdo.FieldsProxy;
import com.aligo.messaging.exchange.cdo.MeetingItemProxy;
import com.aligo.messaging.exchange.cdo.MessageProxy;
import com.aligo.messaging.exchange.cdo.MessagesProxy;
import com.aligo.messaging.exchange.cdo.RecipientsProxy;
import com.aligo.messaging.exchange.cdo.RecurrencePatternProxy;
import com.linar.jintegra.AutomationException;
import java.util.Date;

public final class ExchangeAppointmentItem {
    private AppointmentItem _ocxAppointmentItem;

    ExchangeAppointmentItem(AppointmentItem appointmentHandle) {
        this._ocxAppointmentItem = appointmentHandle;
    }

    public int getDuration() throws AligoExchangeException {
        try {
            return (Integer)this._ocxAppointmentItem.getDuration();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getLocation() throws AligoExchangeException {
        try {
            return (String)this._ocxAppointmentItem.getLocation();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getFolderId() throws AligoExchangeException {
        try {
            return (String)this._ocxAppointmentItem.getFolderID();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setLocation(String location) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setLocation(location);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public Date getStartTime() throws AligoExchangeException {
        try {
            return (Date)this._ocxAppointmentItem.getStartTime();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setStartTime(Date time) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setStartTime(time);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public Date getEndTime() throws AligoExchangeException {
        try {
            return (Date)this._ocxAppointmentItem.getEndTime();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setEndTime(Date time) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setEndTime(time);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public int getMeetingResponseStatus() throws AligoExchangeException {
        try {
            return (Integer)this._ocxAppointmentItem.getMeetingResponseStatus();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeAddressEntry getOrganizer() throws AligoExchangeException {
        try {
            AddressEntryProxy returnHandle = new AddressEntryProxy(this._ocxAppointmentItem.getOrganizer());
            return new ExchangeAddressEntry(returnHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public int getMeetingStatus() throws AligoExchangeException {
        try {
            return (Integer)this._ocxAppointmentItem.getMeetingStatus();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setMeetingStatus(int value) throws AligoExchangeException {
        switch (value) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new AligoExchangeException("Invalid meeting type provided!");
            }
        }
        try {
            this._ocxAppointmentItem.setMeetingStatus(new Integer(value));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeMeetingItem respond(int respondType) throws AligoExchangeException {
        switch (respondType) {
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new AligoExchangeException("Invalid response type provided!");
            }
        }
        try {
            MeetingItemProxy meetingItemHandle = new MeetingItemProxy(this._ocxAppointmentItem.respond(new Integer(respondType)));
            return new ExchangeMeetingItem(meetingItemHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeRecurrencePattern getRecurrencePattern() throws AligoExchangeException {
        try {
            return new ExchangeRecurrencePattern(new RecurrencePatternProxy(this._ocxAppointmentItem.getRecurrencePattern()));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void clearRecurrencePattern() throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.clearRecurrencePattern();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void send(boolean saveCopy) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.send(new Boolean(saveCopy), null, null);
        }
        catch (Exception e) {
            if (e instanceof AutomationException) {
                AutomationException barf = (AutomationException)e;
                int code = new Long(barf.getCode()).intValue();
                if (code != -2147024809) {
                    throw new AligoExchangeException(e);
                }
            }
            throw new AligoExchangeException(e);
        }
    }

    public void send() throws AligoExchangeException {
        this.send(true);
    }

    public ExchangeMessage moveTo(String folderId, String storeId) throws AligoExchangeException {
        try {
            MessageProxy returnHandle = new MessageProxy(this._ocxAppointmentItem.moveTo(folderId, storeId));
            return new ExchangeMessage(returnHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeMessage copyTo(String folderId, String storeId) throws AligoExchangeException {
        try {
            MessageProxy returnHandle = new MessageProxy(this._ocxAppointmentItem.copyTo(folderId, storeId));
            return new ExchangeMessage(returnHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getId() throws AligoExchangeException {
        try {
            return (String)this._ocxAppointmentItem.getID();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean isRecurring() throws AligoExchangeException {
        try {
            return (Boolean)this._ocxAppointmentItem.getIsRecurring();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean isReminderSet() throws AligoExchangeException {
        try {
            return (Boolean)this._ocxAppointmentItem.getReminderSet();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public Date getReplyTime() throws AligoExchangeException {
        try {
            return (Date)this._ocxAppointmentItem.getReplyTime();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setReplyTime(Date time) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setReplyTime(time);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setResponseRequested(boolean value) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setResponseRequested(new Boolean(value));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void getResponseRequested() throws AligoExchangeException {
        try {
            ((Boolean)this._ocxAppointmentItem.getResponseRequested()).booleanValue();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void update() throws AligoExchangeException {
        this.update(true, false);
    }

    public void update(boolean makePermanent, boolean refreshObject) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.update(new Boolean(makePermanent), new Boolean(refreshObject));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void delete() throws AligoExchangeException {
        this.delete(false);
    }

    public void delete(boolean moveToDeletedItems) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.delete(new Boolean(moveToDeletedItems));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean isSameAs(ExchangeAppointmentItem appointment) throws AligoExchangeException {
        try {
            AppointmentItem otherHandle = appointment.getAppointmentItemHandle();
            return (Boolean)this._ocxAppointmentItem.isSameAs(otherHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    AppointmentItem getAppointmentItemHandle() {
        return this._ocxAppointmentItem;
    }

    public ExchangeFields getFields() throws AligoExchangeException {
        try {
            FieldsProxy resultHandle = new FieldsProxy(this._ocxAppointmentItem.getFields());
            return new ExchangeFields(resultHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeMessages getParent() throws AligoExchangeException {
        try {
            MessagesProxy resultHandle = new MessagesProxy(this._ocxAppointmentItem.getParent());
            return new ExchangeMessages(resultHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public int getBusyStatus() throws AligoExchangeException {
        try {
            return (Integer)this._ocxAppointmentItem.getBusyStatus();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public int getReminderMinutesBeforeStart() throws AligoExchangeException {
        try {
            return (Integer)this._ocxAppointmentItem.getReminderMinutesBeforeStart();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setReminderMinutesBeforeStart(int value) throws AligoExchangeException {
        if (value < 0) {
            throw new AligoExchangeException("Minutes must be a positive integer!");
        }
        try {
            this._ocxAppointmentItem.setReminderMinutesBeforeStart(new Integer(value));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setBusyStatus(int status) throws AligoExchangeException {
        switch (status) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new AligoExchangeException("Invalid status provided!");
            }
        }
        try {
            this._ocxAppointmentItem.setBusyStatus(new Integer(status));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean getAllDayEvent() throws AligoExchangeException {
        try {
            return (Boolean)this._ocxAppointmentItem.getAllDayEvent();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setAllDayEvent(boolean allDay) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setAllDayEvent(new Boolean(allDay));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeAttachments getAttachments() throws AligoExchangeException {
        try {
            AttachmentsProxy resultHandle = new AttachmentsProxy(this._ocxAppointmentItem.getAttachments());
            return new ExchangeAttachments(resultHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeRecipients getRecipients() throws AligoExchangeException {
        try {
            RecipientsProxy resultHandle = new RecipientsProxy(this._ocxAppointmentItem.getRecipients());
            return new ExchangeRecipients(resultHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getCategories() throws AligoExchangeException {
        try {
            return (String)this._ocxAppointmentItem.getCategories();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getConversationIndex() throws AligoExchangeException {
        try {
            return (String)this._ocxAppointmentItem.getConversationIndex();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setConversationIndex(String value) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setConversationIndex(value);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getConversationTopic() throws AligoExchangeException {
        try {
            return (String)this._ocxAppointmentItem.getConversationTopic();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setConversationTopic(String value) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setConversationTopic(value);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean getDeliveryReceipt() throws AligoExchangeException {
        try {
            return (Boolean)this._ocxAppointmentItem.getDeliveryReceipt();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setDeliveryReceipt(boolean value) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setDeliveryReceipt(new Boolean(value));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean getEncrypted() throws AligoExchangeException {
        try {
            return (Boolean)this._ocxAppointmentItem.getEncrypted();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setEncrypted(boolean value) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setEncrypted(new Boolean(value));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public int getImportance() throws AligoExchangeException {
        try {
            return (Integer)this._ocxAppointmentItem.getImportance();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setImportance(int value) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setImportance(new Integer(value));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean getReadReceipt() throws AligoExchangeException {
        try {
            return (Boolean)this._ocxAppointmentItem.getReadReceipt();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setReadReceipt(boolean value) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setReadReceipt(new Boolean(value));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeAddressEntry getSender() throws AligoExchangeException {
        try {
            AddressEntryProxy returnHandle = new AddressEntryProxy(this._ocxAppointmentItem.getSender());
            return new ExchangeAddressEntry(returnHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setSender(ExchangeAddressEntry sender) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setSender(sender.getAddressEntryHandle());
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public int getSensitivity() throws AligoExchangeException {
        try {
            return (Integer)this._ocxAppointmentItem.getSensitivity();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setSensitivity(int value) throws AligoExchangeException {
        switch (value) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new AligoExchangeException("Invalid value provided!");
            }
        }
        try {
            this._ocxAppointmentItem.setSensitivity(new Integer(value));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean getSent() throws AligoExchangeException {
        try {
            return (Boolean)this._ocxAppointmentItem.getSent();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setSent(boolean value) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setSent(new Boolean(value));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean getSigned() throws AligoExchangeException {
        try {
            return (Boolean)this._ocxAppointmentItem.getSigned();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setSigned(boolean value) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setSigned(new Boolean(value));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setSubject(String value) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setSubject(value);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getSubject() throws AligoExchangeException {
        try {
            return (String)this._ocxAppointmentItem.getSubject();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean getSubmitted() throws AligoExchangeException {
        try {
            return (Boolean)this._ocxAppointmentItem.getSubmitted();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setSubmitted(boolean value) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setSubmitted(new Boolean(value));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setText(String value) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setText(value);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getText() throws AligoExchangeException {
        try {
            return (String)this._ocxAppointmentItem.getText();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setTimeExpired(Date value) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setTimeExpired(value);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public Date getTimeExpired() throws AligoExchangeException {
        try {
            return (Date)this._ocxAppointmentItem.getTimeExpired();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setTimeReceived(Date value) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setTimeReceived(value);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public Date getTimeReceived() throws AligoExchangeException {
        try {
            return (Date)this._ocxAppointmentItem.getTimeReceived();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setTimeSent(Date value) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setTimeSent(value);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public Date getTimeSent() throws AligoExchangeException {
        try {
            return (Date)this._ocxAppointmentItem.getTimeSent();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setType(String value) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setType(value);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getType() throws AligoExchangeException {
        try {
            return (String)this._ocxAppointmentItem.getType();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setUnread(boolean value) throws AligoExchangeException {
        try {
            this._ocxAppointmentItem.setUnread(new Boolean(value));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean getUnread() throws AligoExchangeException {
        try {
            return (Boolean)this._ocxAppointmentItem.getUnread();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public int getSize() throws AligoExchangeException {
        try {
            return (Integer)this._ocxAppointmentItem.getSize();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public int getClassType() throws AligoExchangeException {
        try {
            return (Integer)this._ocxAppointmentItem.zz_getClass();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getStoreId() throws AligoExchangeException {
        try {
            return (String)this._ocxAppointmentItem.getStoreID();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public Date getTimeCreated() throws AligoExchangeException {
        try {
            return (Date)this._ocxAppointmentItem.getTimeCreated();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public Date getTimeLastModified() throws AligoExchangeException {
        try {
            return (Date)this._ocxAppointmentItem.getTimeLastModified();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getApplication() throws AligoExchangeException {
        return "Collaboration Data Objects";
    }
}

