/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.crypto;

import com.sun.portal.rewriter.util.StringHelper;
import java.security.SecureRandom;
import java.util.Vector;

public final class RandomString {
    private static final char[] NUMBERS_AND_LETTERS_ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] NONCONFUSING_ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'w', 'x', 'y', 'z', '2', '3', '4', '5', '6', '7', '8', '9'};
    private SecureRandom rand;
    private int repetition = -1;
    private char[] alphabet;
    private char[] firstAlphabet;
    private char[] lastAlphabet;
    private Vector requirements = null;
    private boolean[] touched = null;
    private int[] available = null;

    private RandomString(byte[] aSeedBytes) {
        this.rand = new SecureRandom(aSeedBytes);
        this.alphabet = NONCONFUSING_ALPHABET;
    }

    private void addRequirement(char[] alphabet, int num) {
        if (this.requirements == null) {
            this.requirements = new Vector();
        }
        this.requirements.add(new Requirement(alphabet, num));
    }

    private void setAlphabet(char[] alphabet) {
        if (alphabet == null) {
            throw new NullPointerException("Null alphabet");
        }
        if (alphabet.length == 0) {
            throw new ArrayIndexOutOfBoundsException("No characters in alphabet");
        }
        this.alphabet = alphabet;
    }

    public void setFirstAlphabet(char[] alphabet) {
        this.firstAlphabet = (char[])(alphabet == null || alphabet.length == 0 ? null : alphabet);
    }

    public void setLastAlphabet(char[] alphabet) {
        this.lastAlphabet = (char[])(alphabet == null || alphabet.length == 0 ? null : alphabet);
    }

    public void setMaxRepetition(int rep) {
        this.repetition = rep - 1;
    }

    public char[] getPassChars(char[] pass) {
        boolean verified = false;
        while (!verified) {
            int length = pass.length;
            for (int i = 0; i < length; ++i) {
                char[] useAlph = this.alphabet;
                if (i == 0 && this.firstAlphabet != null) {
                    useAlph = this.firstAlphabet;
                } else if (i == length - 1 && this.lastAlphabet != null) {
                    useAlph = this.lastAlphabet;
                }
                int size = RandomString.avoidRepetition(useAlph, pass, i, this.repetition, useAlph.length);
                pass[i] = useAlph[this.rand.nextInt(size)];
            }
            if (this.requirements != null) {
                this.applyRequirements(pass);
            }
            verified = true;
        }
        return pass;
    }

    private void applyRequirements(char[] pass) {
        int size = this.requirements.size();
        if (size > 0) {
            int length = pass.length;
            if (this.touched == null || this.touched.length < length) {
                this.touched = new boolean[length];
            }
            if (this.available == null || this.available.length < length) {
                this.available = new int[length];
            }
            for (int i = 0; i < length; ++i) {
                this.touched[i] = false;
            }
            for (int reqNum = 0; reqNum < size; ++reqNum) {
                Requirement req = (Requirement)this.requirements.elementAt(reqNum);
                int reqUsedInd = req.alphabet.length;
                int fufilledInd = 0;
                int availableInd = 0;
                for (int i = 0; i < length; ++i) {
                    if (RandomString.arrayContains(req.alphabet, pass[i]) && fufilledInd < req.num) {
                        ++fufilledInd;
                        this.touched[i] = true;
                        if (this.repetition < 0 || (reqUsedInd -= RandomString.moveto(req.alphabet, reqUsedInd, pass[i])) >= 0) continue;
                        reqUsedInd = req.alphabet.length;
                        continue;
                    }
                    if (this.touched[i]) continue;
                    this.available[availableInd] = i;
                    ++availableInd;
                }
                int toDo = req.num - fufilledInd;
                for (int i = 0; i < toDo && availableInd > 0; ++i) {
                    char passChar;
                    int slot = this.rand.nextInt(availableInd);
                    pass[this.available[slot]] = passChar = req.alphabet[this.rand.nextInt(reqUsedInd)];
                    this.touched[this.available[slot]] = true;
                    this.available[slot] = this.available[--availableInd];
                    if (this.repetition < 0 || (reqUsedInd -= RandomString.moveto(req.alphabet, reqUsedInd, passChar)) >= 0) continue;
                    reqUsedInd = req.alphabet.length;
                }
            }
        }
    }

    private static boolean arrayContains(char[] alph, char c) {
        for (int i = 0; i < alph.length; ++i) {
            if (alph[i] != c) continue;
            return true;
        }
        return false;
    }

    private static int avoidRepetition(char[] alph, char[] pass, int passSize, int repetition, int alphSize) {
        if (repetition > -1) {
            int repPos = 0;
            while ((repPos = RandomString.findRep(pass, repPos, passSize, repetition)) != -1) {
                alphSize -= RandomString.moveto(alph, alphSize, pass[repPos + repetition]);
                ++repPos;
            }
            if (alphSize == 0) {
                alphSize = alph.length;
            }
        }
        return alphSize;
    }

    private static int findRep(char[] pass, int start, int end, int length) {
        for (int i = start; i < end - length; ++i) {
            boolean onTrack = true;
            for (int j = 0; onTrack && j < length; ++j) {
                if (pass[i + j] == pass[end - length + j]) continue;
                onTrack = false;
            }
            if (!onTrack) continue;
            return i;
        }
        return -1;
    }

    private static int moveto(char[] alph, int numGood, char c) {
        int count = 0;
        for (int i = 0; i < numGood; ++i) {
            if (alph[i] != c) continue;
            char temp = alph[--numGood];
            alph[numGood] = alph[i];
            alph[i] = temp;
            ++count;
        }
        return count;
    }

    private String getPass(int length) {
        return new String(this.getPassChars(new char[length]));
    }

    public static String create(String aSeed) {
        if (aSeed == null || aSeed.length() < 8) {
            aSeed = "Use Nagendra" + aSeed + "as Password";
        }
        aSeed = StringHelper.searchAndReplace(aSeed, " ", "raja");
        char[] alphabet = NONCONFUSING_ALPHABET;
        char[] firstAlphabet = NUMBERS_AND_LETTERS_ALPHABET;
        char[] lastAlphabet = aSeed.toCharArray();
        Vector reqs = new Vector();
        int length = lastAlphabet.length > 8 || lastAlphabet.length < 6 ? 8 : lastAlphabet.length;
        RandomString randPass = new RandomString(aSeed.getBytes());
        randPass.setAlphabet(alphabet);
        randPass.setFirstAlphabet(firstAlphabet);
        randPass.setLastAlphabet(lastAlphabet);
        for (int i = 0; i < reqs.size(); ++i) {
            randPass.addRequirement(((String)reqs.elementAt(i)).toCharArray(), 1);
        }
        return randPass.getPass(length);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(RandomString.create("Nawrerwerwerewrewrewrwewrerwrwrewrewerwrwerwehgdurtxfgdsg"));
    }

    private static class Requirement {
        private char[] alphabet;
        private int num;

        public Requirement(char[] alphabet, int num) {
            this.alphabet = alphabet;
            this.num = num;
        }
    }
}

