/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.rom.html;

import com.sun.portal.rewriter.rom.Data;
import com.sun.portal.rewriter.rom.DataRule;
import com.sun.portal.rewriter.rom.html.Form;
import com.sun.portal.rewriter.test.util.SampleRuleObjects;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.re.Pattern;
import com.sun.portal.rewriter.util.xml.Node;

public final class FormRule
extends DataRule {
    private final Form form;
    private final Pattern[] nameSpec;
    private final Pattern[] fieldSpec;
    private final Pattern[] valuePatternSpec;

    public FormRule(Form aForm) {
        super(aForm);
        this.form = aForm;
        this.nameSpec = FormRule.createAttributeSpec(this.form.getName(), true);
        this.fieldSpec = FormRule.createAttributeSpec(this.form.getField(), true);
        this.valuePatternSpec = FormRule.createValuePatternSpec(this.form.getValuePatterns());
    }

    public FormRule(Node aNode) {
        this(new Form(aNode.getAttributeValue("name"), aNode.getAttributeValue("field"), aNode.getAttributeValue("valuePatterns"), aNode.getAttributeValue("source")));
    }

    public Pattern[] getParsedPatterns() {
        return this.valuePatternSpec;
    }

    public boolean plugableMatch(Data aMache) {
        if (!(aMache instanceof Form)) {
            return false;
        }
        Form valueObject = (Form)aMache;
        return FormRule.match(this.nameSpec, valueObject.getName()) && FormRule.match(this.fieldSpec, valueObject.getField());
    }

    public boolean isValid() {
        return FormRule.doBasicValidation(new String[]{this.form.getSource(), this.form.getName(), this.form.getField()});
    }

    public static void main(String[] args) {
        FormRule[] forms = SampleRuleObjects.defaultHTMLForms;
        for (int i = 0; i < forms.length; ++i) {
            Debug.println(forms[i].toXML());
        }
    }
}

