/*
 * Decompiled with CFR 0.152.
 */
package javax.portlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

public abstract class GenericPortlet
implements Portlet,
PortletConfig {
    private transient PortletConfig config;

    public void init(PortletConfig config) throws PortletException {
        this.config = config;
        this.init();
    }

    public void init() throws PortletException {
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        throw new PortletException("processAction method not implemented");
    }

    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setTitle(this.getTitle(request));
        this.doDispatch(request, response);
    }

    protected String getTitle(RenderRequest request) {
        String rtitle = (String)request.getAttribute("com.sun.portal.portlet.RBTITLE");
        if (rtitle != null && rtitle.length() > 0) {
            return rtitle;
        }
        String title = (String)request.getAttribute("com.sun.portal.portlet.DPTITLE");
        if (title != null && title.length() > 0 && !title.equalsIgnoreCase("javax.portlet.title")) {
            return title;
        }
        return this.config.getResourceBundle(request.getLocale()).getString("javax.portlet.title");
    }

    protected void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        WindowState state = request.getWindowState();
        PortletMode mode = request.getPortletMode();
        if (mode.equals(PortletMode.HELP)) {
            this.doHelp(request, response);
        } else if (!state.equals(WindowState.MINIMIZED)) {
            if (mode.equals(PortletMode.VIEW)) {
                this.doView(request, response);
            } else if (mode.equals(PortletMode.EDIT)) {
                this.doEdit(request, response);
            } else {
                throw new PortletException("unknown portlet mode: " + mode);
            }
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        throw new PortletException("doView method not implemented");
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        throw new PortletException("doEdit method not implemented");
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        throw new PortletException("doHelp method not implemented");
    }

    public PortletConfig getPortletConfig() {
        return this.config;
    }

    public void destroy() {
    }

    public String getPortletName() {
        return this.config.getPortletName();
    }

    public PortletContext getPortletContext() {
        return this.config.getPortletContext();
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return this.config.getResourceBundle(locale);
    }

    public String getInitParameter(String name) {
        return this.config.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.config.getInitParameterNames();
    }
}

