/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.portletwindow;

import com.sun.portal.container.ChannelMode;
import com.sun.portal.container.ChannelURLFactory;
import com.sun.portal.container.Container;
import com.sun.portal.container.ContentException;
import com.sun.portal.container.ErrorCode;
import com.sun.portal.container.WindowState;
import com.sun.portal.desktop.RequestThreadLocalizer;
import com.sun.portal.desktop.ServletContextThreadLocalizer;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.portletwindow.PortletWindowChannelURLFactory;
import com.sun.portal.providers.portletwindow.PortletWindowProviderUtils;
import com.sun.portal.providers.portletwindow.PortletWindowRequestReader;
import com.sun.portal.providers.window.WindowErrorCode;
import com.sun.portal.providers.window.WindowProvider;
import com.sun.portal.providers.window.WindowRequestReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletWindowProvider
extends WindowProvider {
    private static final char DELIMETER = '|';
    private static final String PAE_SERVLET = "/servlet/PortletAppEngineServlet";
    private static final String JAVAX_PORTLET_ENTITY_ID = "javax.portlet.entityID";
    private static final String JAVAX_PORTLET_TITLE = "javax.portlet.title";
    public static final String PORTLET_CONTAINER = "portlet_container";
    private Container _container = null;
    private WindowRequestReader _windowRequestReader = null;

    public void init(String n, HttpServletRequest req) throws ProviderException {
        super.init(n, req);
        ServletContext sc = ServletContextThreadLocalizer.get();
        this._container = (Container)sc.getAttribute(PORTLET_CONTAINER);
        this._windowRequestReader = new PortletWindowRequestReader();
    }

    public List getRoleList(HttpServletRequest request) throws ProviderException {
        ArrayList<String> rolesList = null;
        try {
            Map roleMap = this.getConfiguredRoleMap(request);
            if (roleMap != null) {
                Set roles = this.getProviderContext().getRoles();
                if (roles.isEmpty()) {
                    rolesList = Collections.EMPTY_LIST;
                } else {
                    rolesList = new ArrayList<String>();
                    Iterator i = roles.iterator();
                    while (i.hasNext()) {
                        String dsameRole = (String)i.next();
                        if (!roleMap.containsKey(dsameRole)) continue;
                        String logicalRole = (String)roleMap.get(dsameRole);
                        rolesList.add(logicalRole);
                    }
                }
            } else {
                rolesList = Collections.EMPTY_LIST;
            }
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("PortletWindowProvider.assembleContainerRequest(): couldn't check for exists on roleMap collection", pce);
        }
        return rolesList;
    }

    public Map getUserInfoMap(HttpServletRequest request) throws ProviderException {
        HashMap<String, String> userInfo = null;
        try {
            Map userInfoMap = this.getConfiguredUserInfoMap(request);
            if (userInfoMap != null) {
                userInfo = new HashMap<String, String>();
                Set keys = userInfoMap.keySet();
                Iterator i = keys.iterator();
                while (i.hasNext()) {
                    String dsameAttr = (String)i.next();
                    String portletAttr = (String)userInfoMap.get(dsameAttr);
                    String attrValue = this.getProviderContext().getStringAttribute(dsameAttr);
                    if (attrValue == null) continue;
                    userInfo.put(portletAttr, attrValue);
                }
            } else {
                userInfo = Collections.EMPTY_MAP;
            }
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("PortletWindowProvider.assembleContainerRequest(): couldn't check for exists on userInfoMap collection", pce);
        }
        return userInfo;
    }

    private Map getConfiguredRoleMap(HttpServletRequest req) throws ProviderContextException, ProviderException {
        return PortletWindowProviderUtils.getRoleMap(req, this.getName(), this.getProviderContext());
    }

    private Map getConfiguredUserInfoMap(HttpServletRequest req) throws ProviderContextException, ProviderException {
        return PortletWindowProviderUtils.getUserInfoMap(req, this.getName(), this.getProviderContext());
    }

    public Container getContainer(HttpServletRequest req) {
        return this._container;
    }

    public String getEntityID(HttpServletRequest request) throws ProviderException {
        return PortletWindowProviderUtils.getEntityID(request, this.getName(), this.getProviderContext());
    }

    public ChannelURLFactory getChannelURLFactory(String desktopURLPrefix, HttpServletRequest request) throws ProviderException {
        return new PortletWindowChannelURLFactory(desktopURLPrefix);
    }

    public WindowRequestReader getWindowRequestReader() throws ProviderException {
        return this._windowRequestReader;
    }

    public boolean isMarkupSupported(String contentType, String locale, ChannelMode mode, WindowState state) throws ProviderException {
        Map isEditableMap;
        boolean supported = false;
        if (ChannelMode.VIEW.equals((Object)mode)) {
            List supportedContentTypes = this.getListProperty("supportedContentTypes");
            if (supportedContentTypes.contains(contentType) || supportedContentTypes.contains("text/*") || supportedContentTypes.contains("*/*")) {
                supported = true;
            }
        } else if (ChannelMode.HELP.equals((Object)mode)) {
            String hu = null;
            Map hasHelpMap = this.getMapProperty("hasHelpByMimeType");
            if (hasHelpMap.containsKey(contentType)) {
                hu = (String)hasHelpMap.get(contentType);
            }
            if (hu != null && hu.length() > 0) {
                supported = true;
            }
        } else if (ChannelMode.EDIT.equals((Object)mode) && (isEditableMap = this.getMapProperty("isEditableByMimeType")).containsKey(contentType)) {
            supported = (Boolean)isEditableMap.get(contentType);
        }
        return supported;
    }

    public String getDefaultTitle() throws ProviderException {
        HttpServletRequest req = RequestThreadLocalizer.getRequest();
        HttpServletResponse res = RequestThreadLocalizer.getResponse();
        String entityID = this.getEntityID(req);
        String appName = "/" + entityID.substring(0, entityID.indexOf(124));
        ServletContext sctx = ServletContextThreadLocalizer.get().getContext(appName);
        RequestDispatcher rd = sctx.getRequestDispatcher(PAE_SERVLET);
        try {
            req.setAttribute(JAVAX_PORTLET_TITLE, (Object)"get");
            req.setAttribute(JAVAX_PORTLET_ENTITY_ID, (Object)entityID);
            rd.include((ServletRequest)req, (ServletResponse)res);
            String title = (String)req.getAttribute(JAVAX_PORTLET_TITLE);
            if (title != null && title.length() > 0) {
                return title;
            }
        }
        catch (ServletException se) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return PortletWindowProviderUtils.getTitle(this.getProviderContext(), this.getName());
    }

    protected ErrorCode getErrorCode(ContentException ex) {
        return WindowErrorCode.CONTENT_EXCEPTION;
    }
}

