/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet.java2;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netfile.servlet.java2.AddSystemHandler;
import com.sun.portal.netfile.servlet.java2.FtpFile;
import com.sun.portal.netfile.servlet.java2.FullFtpClient;
import com.sun.portal.netfile.servlet.java2.NetFileCompression;
import com.sun.portal.netfile.servlet.java2.NetFileContext;
import com.sun.portal.netfile.servlet.java2.NetFileContextImpl;
import com.sun.portal.netfile.servlet.java2.NetFileLogManager;
import com.sun.portal.netfile.servlet.java2.NetFileResource;
import com.sun.portal.netfile.servlet.java2.NetFileResponseGenerator;
import com.sun.portal.netfile.servlet.java2.NetFileServlet;
import com.sun.portal.netfile.servlet.java2.NetFileUserProfileHandler;
import com.sun.portal.netfile.servlet.java2.NetWareFile;
import com.sun.portal.netfile.servlet.java2.NfsFile;
import com.sun.portal.netfile.servlet.java2.RequestProcessor;
import com.sun.portal.netfile.servlet.java2.SendFile;
import com.sun.portal.netfile.servlet.java2.XFileFactory;
import com.sun.portal.netfile.servlet.java2.XFileInterface;
import com.sun.portal.netfile.shared.NetFileException;
import com.sun.portal.netfile.transport.NetFileRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SerializedRequestProcessor
implements RequestProcessor {
    public Debug debug = null;
    public NetFileLogManager logMgr = null;
    public String[] pathInfo = null;
    private String version = null;
    private static HashMap resourceMap = new HashMap();
    private SSOTokenManager manager = null;
    public static boolean isEncoded = Boolean.valueOf(SystemProperties.get((String)"com.iplanet.am.cookie.encode", (String)"false"));

    public SerializedRequestProcessor() {
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
    }

    public SerializedRequestProcessor(String ver) {
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
        this.version = ver;
    }

    public String getProtocolVersion() {
        return this.version;
    }

    public static synchronized void setResourceMap(String locale, String bundle, NetFileResource nfRes) {
        Object obj;
        if (resourceMap.containsKey(locale.trim() + bundle.trim()) && (obj = resourceMap.get(locale.trim() + bundle.trim())) != null) {
            return;
        }
        resourceMap.put(locale.trim() + bundle.trim(), nfRes);
    }

    public static NetFileResource getResourceMap(String locale, String bundle) {
        Object obj;
        if (resourceMap.containsKey(locale.trim() + bundle.trim()) && (obj = resourceMap.get(locale + bundle)) != null) {
            return (NetFileResource)obj;
        }
        return null;
    }

    public void processRequest(HttpServletRequest req, HttpServletResponse res, SSOToken ssoToken) throws NetFileException, StreamCorruptedException {
        ArrayList<SSOToken> nfReqData = new ArrayList<SSOToken>();
        ObjectInputStream oistream = null;
        ObjectOutputStream oostream = null;
        Object responseData = null;
        NetFileContextImpl nfContext = null;
        NetFileResource nfRes = null;
        NetFileResponseGenerator nfRespGen = null;
        try {
            oistream = this.fetchInputStream(req);
            oostream = this.fetchOutputStream(res);
        }
        catch (Exception e) {
            this.debug.error("\n Exception in getting streams in SerializedRequestProcessor::processRequest", (Throwable)e);
            if (oostream != null) {
                nfRespGen = new NetFileResponseGenerator(req, res, nfReqData, responseData);
                nfRespGen.createDefaultFailureResponse();
                nfRespGen.setResponseObject("<html>Could not obtain the input/output stream. Request not processed. <br>If the problem persists, please contact your administrator</html>");
                nfRespGen.generateResponse(oostream);
            }
            return;
        }
        try {
            this.unmarshallRequestData(oistream, nfReqData);
        }
        catch (OptionalDataException ode) {
            this.debug.error("\n Optional Data Exception in SerializedRequestProcessor::processRequest" + ode.getMessage());
            throw new NetFileException(6, ode.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            this.debug.error("\n Class not found in SerializedRequestProcessor::processRequest" + cnfe.getMessage());
            throw new NetFileException(6, cnfe.getMessage());
        }
        catch (IOException ioe) {
            this.debug.error("\n IOException in SerializedRequestProcessor::processRequest" + ioe.getMessage());
            throw new NetFileException(6, ioe.getMessage());
        }
        if (ssoToken == null) {
            ssoToken = this.extractSession(req);
        }
        if (!this.isSessionValid(req, ssoToken, nfReqData)) {
            if (oostream != null) {
                if (this.debug.messageEnabled()) {
                    this.debug.error("Session is invalid");
                }
                nfRespGen = new NetFileResponseGenerator(req, res, nfReqData, responseData);
                nfRespGen.createDefaultResponse();
                nfRespGen.setResponseType(952);
                nfRespGen.setResponseObject("Session is not valid. Please close NetFile, login to Portal server and enter NetFile.");
                nfRespGen.generateResponse(oostream);
            }
            return;
        }
        if (this.logMgr == null) {
            this.createLogManager(ssoToken);
        }
        Integer iReqType = (Integer)nfReqData.get(3);
        nfReqData.add(ssoToken);
        nfContext = new NetFileContextImpl(ssoToken);
        nfContext.determineHTMLCharset(req);
        if (iReqType != 901) {
            this.pathInfo = this.grepPlatInfo(nfReqData);
        }
        if ((nfRes = SerializedRequestProcessor.getResourceMap(nfContext.getUserLocale().toString(), "srapNetFileServletJava2")) == null) {
            if (this.debug.messageEnabled()) {
                this.debug.message("NetFile resource object for bundle srapNetFileServletJava2 not found in resource map for locale " + nfContext.getUserLocale().toString());
            }
            nfRes = new NetFileResource("srapNetFileServletJava2", nfContext.getUserLocale().toString());
        } else if (this.debug.messageEnabled()) {
            this.debug.message("NetFile resource object for bundle srapNetFileServletJava2 found in resource map for locale " + nfContext.getUserLocale().toString());
        }
        res.setHeader("Cache-Control", "max-age=0");
        res.setHeader("Content-type", "application/octet-stream");
        try {
            nfRespGen = new NetFileResponseGenerator(req, res, nfReqData, responseData);
            nfRespGen.createDefaultResponse();
            responseData = this.handleRequest(iReqType, nfReqData, nfContext, nfRes, nfRespGen);
            nfRespGen.generateResponse(oostream);
        }
        catch (NetFileException nfe) {
            if (nfRespGen == null) {
                nfRespGen = new NetFileResponseGenerator(req, res, nfReqData, responseData);
            }
            nfRespGen.createDefaultFailureResponse();
            nfRespGen.setResponseObject(nfe.getMessage());
            nfRespGen.generateResponse(oostream);
        }
    }

    private void unmarshallRequestData(ObjectInputStream ois, List nfReqVec) throws OptionalDataException, ClassNotFoundException, IOException {
        if (ois != null && nfReqVec != null) {
            this.debug.message("Valid Stream and Request Data obtained");
        }
        NetFileRequest nfReq = (NetFileRequest)ois.readObject();
        nfReqVec.add(nfReq.getRequestId());
        nfReqVec.add(nfReq.getSessionId());
        nfReqVec.add(nfReq.getUserId());
        nfReqVec.add(new Integer(nfReq.getRequestType()));
        Object obj = nfReq.getRequestObject();
        nfReqVec.add(obj);
        Object params = nfReq.getRequestParams();
        nfReqVec.add(params);
        if (this.debug.messageEnabled()) {
            this.debug.message("\n Request Data: " + (String)nfReqVec.get(0) + (String)nfReqVec.get(1) + (String)nfReqVec.get(2) + nfReqVec.get(3).toString());
        }
    }

    private ObjectInputStream fetchInputStream(HttpServletRequest req) throws StreamCorruptedException, IOException {
        return new ObjectInputStream((InputStream)req.getInputStream());
    }

    private ObjectOutputStream fetchOutputStream(HttpServletResponse res) throws StreamCorruptedException, IOException {
        return new ObjectOutputStream((OutputStream)res.getOutputStream());
    }

    private Object handleRequest(Integer reqType, List nfReqData, NetFileContext nfContext, NetFileResource nfRes, NetFileResponseGenerator respGen) throws NetFileException {
        Object o = null;
        Object i18nObj = null;
        NetFileUserProfileHandler nfProfileHandler = null;
        AddSystemHandler addSysHandler = null;
        if (this.debug.messageEnabled()) {
            this.debug.message("\n Request Type Received: " + reqType.toString());
        }
        switch (reqType) {
            case 651: {
                addSysHandler = new AddSystemHandler(this.pathInfo, this.logMgr, nfContext, nfRes);
                o = addSysHandler.addSystem(nfReqData);
                respGen.setNetFileResponse(o);
                break;
            }
            case 653: {
                this.addShare(nfReqData, respGen, nfContext, nfRes);
                break;
            }
            case 655: {
                this.doLog(nfRes.getString("srpLog.1"));
                nfProfileHandler = new NetFileUserProfileHandler((SSOToken)nfReqData.get(6), nfContext, nfRes);
                nfProfileHandler.saveSessionData(nfReqData);
                this.doLog(nfRes.getString("srpLog.2"));
                break;
            }
            case 601: {
                this.getFilesList(nfReqData, respGen, nfContext, nfRes);
                break;
            }
            case 551: {
                CompressFile cmpresFile = new CompressFile(this.pathInfo, this.logMgr);
                cmpresFile.compressFile(nfReqData, respGen, nfContext, nfRes);
                break;
            }
            case 501: {
                MailFile mailFile = new MailFile(this.pathInfo, this.logMgr);
                mailFile.mailFile(nfReqData, respGen, nfContext, nfRes);
                break;
            }
            case 607: {
                DownloadDirectory downloadDir = new DownloadDirectory(this.pathInfo, this.logMgr);
                downloadDir.downloadFolder(nfReqData, respGen, nfContext, nfRes);
                break;
            }
            case 608: {
                RenameFile renameFile = new RenameFile(this.pathInfo, this.logMgr);
                renameFile.rename(nfReqData, respGen, nfContext, nfRes);
                break;
            }
            case 610: {
                DeletingHelper deletingFileHelper = new DeletingHelper(this.pathInfo, this.logMgr);
                deletingFileHelper.deleteFile(nfReqData, respGen, nfContext, nfRes);
                break;
            }
            case 613: {
                DeletingHelper deletingFolderHelper = new DeletingHelper(this.pathInfo, this.logMgr);
                deletingFolderHelper.deleteFolder(nfReqData, respGen, nfContext, nfRes);
                break;
            }
            case 609: {
                CreateDirectory newDir = new CreateDirectory(this.pathInfo, this.logMgr);
                newDir.createDir(nfReqData, respGen, nfContext, nfRes);
                break;
            }
            case 701: {
                FileSearchHandler srchFile = new FileSearchHandler(this.pathInfo, this.logMgr);
                srchFile.searchFile(nfReqData, respGen, nfContext, nfRes);
                break;
            }
            case 611: {
                FileExistenceVerifier fileVerfy = new FileExistenceVerifier(this.pathInfo, this.logMgr);
                fileVerfy.verifyForUpload(nfReqData, respGen, nfContext, nfRes);
                break;
            }
            case 612: {
                Hashtable data = (Hashtable)nfReqData.get(4);
                String fileName = (String)data.get("FileName");
                String userName = (String)data.get("UserID");
                String shareName = (String)data.get("ShareName");
                String directory = (String)data.get("Dir");
                String machine = (String)data.get("SystemName");
                boolean retVal = this.doCleanUp(fileName);
                respGen.setResponseObject(new Boolean(retVal));
                String functionName = nfRes.getString("cleanTempFileLog");
                if (retVal) {
                    respGen.setResponseType(2001);
                    this.doLog(nfRes.getString("successLog.1", new Object[]{functionName, fileName, userName, machine, shareName, directory}));
                    break;
                }
                respGen.setResponseType(2100);
                this.doLog(nfRes.getString("failureLog.1", new Object[]{functionName, fileName, userName, machine, shareName, directory}));
                break;
            }
            case 901: {
                nfProfileHandler = new NetFileUserProfileHandler((SSOToken)nfReqData.get(6), nfContext, nfRes);
                nfProfileHandler.setPathInfo(this.pathInfo);
                Hashtable sessionData = nfProfileHandler.getSessionPreferences();
                if (sessionData == null) {
                    this.doLog(nfRes.getString("srpLog.3"));
                    throw new NetFileException(6, nfRes.getString("srp.1"));
                }
                respGen.setResponseObject(sessionData);
                String szUserlocale = nfContext.getUserLocale().toString();
                i18nObj = this.fetchI18NBucket("srapNetFileAppletJava2", szUserlocale);
                respGen.setResponseObject(i18nObj);
                respGen.setResponseType(2001);
                this.doLog(nfRes.getString("srpLog.4"));
            }
        }
        return o;
    }

    private void getFilesList(List nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) throws NetFileException {
        String szDir;
        Hashtable data = (Hashtable)nfReqData.get(4);
        String szPwd = (String)data.get("SharePwd");
        if (szPwd == null) {
            szPwd = (String)data.get("Pwd");
        }
        szDir = (szDir = (String)data.get("Dir")) == null ? "" : "/" + szDir;
        String szCharSet = (String)data.get("CharSet");
        if (this.debug.messageEnabled()) {
            this.debug.message("Listing for Directory " + szDir);
        }
        String shareName = (String)data.get("ShareName");
        String systemName = (String)data.get("SystemName");
        String userId = (String)data.get("UserID");
        String functionName = nfRes.getString("getFileListingLog");
        try {
            DirectoryListingHandler dirListHandler = new DirectoryListingHandler(this.pathInfo, this.logMgr);
            String[] returnTxt = dirListHandler.expandDir(userId, szPwd, systemName, (String)data.get("NTDomName"), (String)data.get("SysType"), shareName, szDir, nfRes, (SSOToken)nfReqData.get(6), szCharSet);
            nfRespGen.setResponseObject(returnTxt);
            nfRespGen.setResponseType(2001);
            this.doLog(nfRes.getString("successLog.2", new Object[]{functionName, userId, systemName, shareName, szDir}));
            return;
        }
        catch (Exception e) {
            this.debug.error("Exception in getting files list, SerializedRequestProcessor:getFilesList", (Throwable)e);
            nfRespGen.setResponseObject("ERROR:" + e.getMessage());
            nfRespGen.setResponseType(2100);
            this.doLog(nfRes.getString("failureLog.2", new Object[]{functionName, userId, systemName, shareName, szDir}));
            return;
        }
    }

    private Object fetchI18NBucket(String szBundle, String szLocale) throws NetFileException {
        NetFileResource nfRes = null;
        try {
            nfRes = SerializedRequestProcessor.getResourceMap(szLocale, szBundle);
            if (nfRes == null) {
                if (this.debug.messageEnabled()) {
                    this.debug.message("NetFile resource object for bundle " + szBundle + " not found in resource map for locale " + szLocale);
                }
                nfRes = new NetFileResource(szBundle, szLocale);
            } else if (this.debug.messageEnabled()) {
                this.debug.message("NetFile resource object for bundle " + szBundle + " found in resource map for locale " + szLocale);
            }
            return nfRes.populatei18nBucket(szBundle, szLocale);
        }
        catch (Exception e) {
            this.debug.error("Error in fetchI18NBucket", (Throwable)e);
            throw new NetFileException(6, e.getMessage());
        }
    }

    private void addShare(List nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) {
        Hashtable data = (Hashtable)nfReqData.get(4);
        String szCharSet = (String)data.get("CharSet");
        if (this.debug.messageEnabled()) {
            this.debug.message("Char Set to be used is " + szCharSet);
        }
        String shareName = (String)data.get("ShareName");
        String sysType = (String)data.get("SysType");
        String userId = (String)data.get("UserID");
        String machine = (String)data.get("SystemName");
        String functionName = nfRes.getString("addShareLog");
        String directory = (String)data.get("Dir");
        try {
            if ((sysType.equalsIgnoreCase("WIN") || sysType.equalsIgnoreCase("NT")) && (shareName == null || shareName.equals(""))) {
                XFileInterface winFileInterface = XFileFactory.getInstance().newXFileInstance(sysType, szCharSet, this.pathInfo[0]);
                String szShares = winFileInterface.getShares(userId, (String)data.get("Pwd"), machine, (String)data.get("NTDomName"), nfRes);
                nfRespGen.setResponseObject(szShares);
                nfRespGen.setResponseType(2001);
                this.doLog(nfRes.getString("successLog.2", new Object[]{functionName, userId, machine, shareName, directory}));
                return;
            }
            DirectoryListingHandler dirListHandler = new DirectoryListingHandler(this.pathInfo, this.logMgr);
            String[] returnTxt = dirListHandler.expandDir(userId, (String)data.get("SharePwd"), machine, (String)data.get("NTDomName"), sysType, shareName, "", nfRes, (SSOToken)nfReqData.get(6), szCharSet);
            nfRespGen.setResponseObject(returnTxt);
            nfRespGen.setResponseType(2001);
            this.doLog(nfRes.getString("successLog.2", new Object[]{functionName, userId, machine, shareName, directory}));
            return;
        }
        catch (NetFileException nfe) {
            this.doLog(nfRes.getString("failureLog.2", new Object[]{functionName, userId, machine, shareName, directory}));
            if (nfe.getErrorCode() == 1) {
                nfRespGen.setResponseObject(nfRes.getString("srp.8"));
            } else {
                nfRespGen.setResponseObject(nfe.getMessage());
            }
            nfRespGen.setResponseType(2100);
            return;
        }
        catch (Exception e) {
            this.doLog(nfRes.getString("failureLog.2", new Object[]{functionName, userId, machine, shareName, directory}));
            nfRespGen.setResponseObject(e.getMessage());
            nfRespGen.setResponseType(2100);
            return;
        }
    }

    private String[] grepPlatInfo(List nfReqData) {
        String[] pathinfo = new String[2];
        Hashtable data = (Hashtable)nfReqData.get(4);
        Object value = data.get("sunPortalNetFileWINSServer");
        if (value != null) {
            pathinfo[0] = (String)value;
        }
        if ((value = data.get("sunPortalNetFileMimetypesConfigFileLocation")) != null) {
            pathinfo[1] = (String)value;
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("Paths are " + pathinfo[0] + "\n" + pathinfo[1]);
        }
        return pathinfo;
    }

    private boolean doCleanUp(String szLocalFileName) {
        if (szLocalFileName == null) {
            return false;
        }
        try {
            File localFile = new File(szLocalFileName);
            if (localFile.exists()) {
                if (this.debug.messageEnabled()) {
                    this.debug.message("Deleting file " + localFile.getAbsolutePath());
                }
                localFile.delete();
            }
            return true;
        }
        catch (Exception e) {
            if (this.debug.messageEnabled()) {
                this.debug.message("Exception in deleting temp file", (Throwable)e);
            }
            return false;
        }
    }

    private SSOToken extractSession(HttpServletRequest req) {
        try {
            if (this.manager == null) {
                this.manager = SSOTokenManager.getInstance();
            }
            return this.manager.createSSOToken(req);
        }
        catch (SSOException sSOException) {
            return null;
        }
    }

    public boolean isSessionValid(HttpServletRequest req, SSOToken token, List nfReqData) {
        String nfid = null;
        String session = null;
        Cookie[] cookie = req.getCookies();
        if (cookie == null) {
            return false;
        }
        if (token == null) {
            return false;
        }
        if (nfReqData.get(1) == null) {
            return false;
        }
        nfid = (String)nfReqData.get(1);
        if (nfid == null) {
            return false;
        }
        for (int i = 0; i < cookie.length; ++i) {
            if (!cookie[i].getName().equalsIgnoreCase(SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro"))) continue;
            session = cookie[i].getValue();
        }
        if (session == null || session.equals("")) {
            return false;
        }
        if (isEncoded) {
            session = URLDecoder.decode(session);
        }
        if (session.equals(nfid)) {
            try {
                if (this.manager == null) {
                    this.manager = SSOTokenManager.getInstance();
                }
                return this.manager.isValidToken(token);
            }
            catch (Exception e) {
                this.debug.error("Exception in determining if session is valid", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private void createLogManager(SSOToken ssoToken) {
        String tokenId = ssoToken.getTokenID().toString();
        try {
            Object obj = NetFileServlet.logManagerCache.get(tokenId);
            if (obj == null) {
                NetFileLogManager logMgr = new NetFileLogManager(ssoToken);
                NetFileServlet.logManagerCache.put(tokenId, logMgr);
                this.logMgr = logMgr;
            } else {
                this.logMgr = (NetFileLogManager)obj;
            }
        }
        catch (Exception e) {
            this.debug.error("Unable to create LogManager for ssoToken - " + tokenId);
        }
    }

    private void doLog(String msg) {
        if (this.logMgr == null) {
            return;
        }
        this.logMgr.doLog(msg);
    }

    class FileExistenceVerifier {
        String[] pathInfo = null;
        NetFileLogManager logMgr = null;
        DirectoryListingHandler listHandler = null;

        public FileExistenceVerifier(String[] platInfo, NetFileLogManager log) {
            this.pathInfo = platInfo;
            this.logMgr = log;
            this.listHandler = new DirectoryListingHandler(platInfo, log);
        }

        public void verifyForUpload(List nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) {
            try {
                boolean fileExists = this.isFileExists(nfReqData, nfRespGen, nfContext, nfRes);
                boolean canWrite = this.isDirWriteable(nfReqData, nfRespGen, nfContext, nfRes);
                if (fileExists) {
                    nfRespGen.setResponseObject(new Integer(2002));
                    nfRespGen.setResponseType(2001);
                    return;
                }
                if (!canWrite) {
                    nfRespGen.setResponseObject(new Integer(2004));
                    nfRespGen.setResponseType(2001);
                    return;
                }
                nfRespGen.setResponseObject(new Integer(2003));
                nfRespGen.setResponseType(2001);
            }
            catch (Exception e) {
                nfRespGen.setResponseObject(e.getMessage());
                nfRespGen.setResponseType(2100);
            }
        }

        private boolean isFileExists(List nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) throws NetFileException {
            Hashtable data = (Hashtable)nfReqData.get(4);
            String szCharSet = (String)data.get("CharSet");
            String usernam = (String)data.get("UserID");
            String passwrd = (String)data.get("SharePwd");
            String machnam = (String)data.get("SystemName");
            String machtyp = (String)data.get("SysType");
            String VMSnam = (String)data.get("ShareName");
            String dir = (String)data.get("Dir");
            String file_name = (String)data.get("FileName");
            String domainname = (String)data.get("NTDomName");
            SSOToken ssoToken = (SSOToken)nfReqData.get(6);
            String functionName = nfRes.getString("isFileExistsLog");
            String[] sa_listing = null;
            try {
                sa_listing = this.listHandler.expandDir(usernam, passwrd, machnam, domainname, machtyp, VMSnam, dir, nfRes, ssoToken, szCharSet);
            }
            catch (NetFileException nfe) {
                throw nfe;
            }
            catch (Exception e) {
                SerializedRequestProcessor.this.debug.error("Exception in getting the listing", (Throwable)e);
                throw new NetFileException(2100, nfRes.getString("srp.7"));
            }
            for (int i = 1; i < sa_listing.length; i += 4) {
                if (!file_name.equals(sa_listing[i])) continue;
                SerializedRequestProcessor.this.doLog(nfRes.getString("successLog.1", new Object[]{functionName, file_name, usernam, machnam, VMSnam, dir}));
                return true;
            }
            return false;
        }

        private boolean isDirWriteable(List nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) {
            return true;
        }
    }

    class DirectoryListingHandler {
        String[] pathInfo = null;
        NetFileLogManager logMgr = null;

        public DirectoryListingHandler(String[] platInfo, NetFileLogManager log) {
            this.pathInfo = platInfo;
            this.logMgr = log;
        }

        private String[] expandDir(String usernam, String passwrd, String machnam, String domainname, String machtyp, String share, String dir, NetFileResource nfRes, SSOToken ssoToken, String s_machine_encoding) throws Exception {
            if (!machtyp.equalsIgnoreCase("")) {
                if (machtyp.indexOf("NETWARE", 0) >= 0) {
                    NetWareFile netwaredir = new NetWareFile(s_machine_encoding);
                    return netwaredir.getFTPDir(usernam, passwrd, machnam, share, dir, nfRes);
                }
                if (machtyp.indexOf("WIN", 0) >= 0 || machtyp.indexOf("NT", 0) >= 0) {
                    XFileInterface winFileInterface = XFileFactory.getInstance().newXFileInstance(machtyp, s_machine_encoding, this.pathInfo[0]);
                    return winFileInterface.getDirectory(usernam, passwrd, machnam, share, dir, domainname, nfRes);
                }
                if (machtyp.indexOf("FTP", 0) >= 0) {
                    FtpFile gff = new FtpFile(s_machine_encoding);
                    return gff.getFTPDir(usernam, passwrd, machnam, share, dir, nfRes);
                }
                if (machtyp.indexOf("NFS", 0) >= 0) {
                    NfsFile gnf = new NfsFile(s_machine_encoding);
                    return gnf.getNFSDir(usernam, passwrd, share, machnam, dir, "", nfRes);
                }
            }
            if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                SerializedRequestProcessor.this.debug.message("Expand over");
            }
            return null;
        }
    }

    class DeletingHelper {
        String[] pathInfo = null;
        NetFileLogManager logMgr = null;

        public DeletingHelper(String[] platInfo, NetFileLogManager log) {
            this.pathInfo = platInfo;
            this.logMgr = log;
        }

        void recursiveDeleteFolder(DirectoryListingHandler dirListHandler, NetFileResponseGenerator nfRespGen, String usernam, String passwrd, String machnam, String domainname, String machtyp, String VMSnam, String dir, NetFileResource nfRes, SSOToken ssoToken, String szCharSet) {
            int index = 0;
            String functionName = nfRes.getString("deleteFileLog");
            try {
                NfsFile nf;
                FtpFile ff;
                String txt;
                NetWareFile nwf;
                String[] returnTxt = dirListHandler.expandDir(usernam, passwrd, machnam, domainname, machtyp, VMSnam, dir, nfRes, ssoToken, szCharSet);
                if (returnTxt.length > 0) {
                    while (index < returnTxt.length && returnTxt[index] != null) {
                        String entryType = returnTxt[index++];
                        String entryName = returnTxt[index++];
                        index += 2;
                        if (entryType.equals("-")) {
                            if (machtyp.indexOf("NETWARE", 0) >= 0) {
                                nwf = new NetWareFile(szCharSet);
                                txt = nwf.delFTPFile(usernam, passwrd, machnam, VMSnam, entryName, dir, nfRes);
                            } else if (machtyp.indexOf("FTP", 0) >= 0) {
                                ff = new FtpFile(szCharSet);
                                txt = ff.delFTPFile(usernam, passwrd, machnam, VMSnam, entryName, dir, nfRes);
                            } else if (machtyp.indexOf("NFS", 0) >= 0) {
                                nf = new NfsFile(szCharSet);
                                txt = nf.delNFSFile(usernam, passwrd, VMSnam, machnam, entryName, dir, nfRes);
                            }
                            SerializedRequestProcessor.this.doLog(nfRes.getString("successLog.1", new Object[]{functionName, entryName, usernam, machnam, VMSnam, dir}));
                            continue;
                        }
                        if (!entryType.equalsIgnoreCase("d")) continue;
                        this.recursiveDeleteFolder(dirListHandler, nfRespGen, usernam, passwrd, machnam, domainname, machtyp, VMSnam + dir, "/" + entryName, nfRes, ssoToken, szCharSet);
                    }
                }
                if (machtyp.indexOf("NETWARE", 0) >= 0) {
                    nwf = new NetWareFile(szCharSet);
                    txt = nwf.delFTPFolder(usernam, passwrd, machnam, VMSnam, dir, nfRes);
                } else if (machtyp.indexOf("FTP", 0) >= 0) {
                    ff = new FtpFile(szCharSet);
                    txt = ff.delFTPFolder(usernam, passwrd, machnam, VMSnam, dir, nfRes);
                } else if (machtyp.indexOf("NFS", 0) >= 0) {
                    nf = new NfsFile(szCharSet);
                    int tmpIndex = dir.lastIndexOf("/");
                    String tmp1 = dir.substring(0, tmpIndex + 1);
                    String tmp2 = dir.substring(tmpIndex + 1);
                    txt = nf.delNFSFile(usernam, passwrd, VMSnam, machnam, tmp2, tmp1, nfRes);
                }
            }
            catch (Exception e) {
                nfRespGen.setResponseObject(e.getMessage());
                nfRespGen.setResponseType(2100);
                SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.2", new Object[]{functionName, usernam, machnam, VMSnam, dir}));
                return;
            }
        }

        void deleteFolder(List nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) {
            Hashtable data = (Hashtable)nfReqData.get(4);
            String szCharSet = (String)data.get("CharSet");
            String usernam = (String)data.get("UserID");
            String passwrd = (String)data.get("SharePwd");
            String machnam = (String)data.get("SystemName");
            String machtyp = (String)data.get("SysType");
            String VMSnam = (String)data.get("ShareName");
            String dir = (String)data.get("Dir");
            String domainname = (String)data.get("NTDomName");
            SSOToken ssoToken = (SSOToken)nfReqData.get(6);
            String functionName = nfRes.getString("deleteFolderLog");
            String txt = "";
            DirectoryListingHandler dirListHandler = new DirectoryListingHandler(this.pathInfo, this.logMgr);
            try {
                if (machtyp.equalsIgnoreCase("")) {
                    nfRespGen.setResponseObject("ERROR:" + nfRes.getString("error6"));
                    nfRespGen.setResponseType(2100);
                    return;
                }
                if (machtyp.indexOf("WIN", 0) >= 0 || machtyp.indexOf("NT", 0) >= 0) {
                    XFileInterface winFileInterface = XFileFactory.getInstance().newXFileInstance(machtyp, szCharSet, this.pathInfo[0]);
                    txt = winFileInterface.doDeleteDirectory(usernam, passwrd, machnam, VMSnam, dir, domainname, nfRes);
                } else {
                    this.recursiveDeleteFolder(dirListHandler, nfRespGen, usernam, passwrd, machnam, domainname, machtyp, VMSnam, dir, nfRes, ssoToken, szCharSet);
                }
                SerializedRequestProcessor.this.doLog(nfRes.getString("successLog.2", new Object[]{functionName, usernam, machnam, VMSnam, dir}));
            }
            catch (NetFileException nfe) {
                nfRespGen.setResponseObject(nfe.getMessage());
                nfRespGen.setResponseType(2100);
                SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.2", new Object[]{functionName, usernam, machnam, VMSnam, dir}));
                return;
            }
        }

        void deleteFile(List nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) {
            Hashtable data = (Hashtable)nfReqData.get(4);
            String szCharSet = (String)data.get("CharSet");
            String usernam = (String)data.get("UserID");
            String passwrd = (String)data.get("SharePwd");
            String machnam = (String)data.get("SystemName");
            String machtyp = (String)data.get("SysType");
            String VMSnam = (String)data.get("ShareName");
            String dir = (String)data.get("Dir");
            Vector cachechk = (Vector)data.get("DeleteFiles");
            String domainname = (String)data.get("NTDomName");
            String txt = "";
            String mainfilename = "";
            String functionName = nfRes.getString("deleteFileLog");
            try {
                if (cachechk.size() > 0) {
                    for (int fil = 0; fil < cachechk.size(); ++fil) {
                        mainfilename = (String)cachechk.elementAt(fil);
                        if (machtyp.equalsIgnoreCase("")) {
                            nfRespGen.setResponseObject("ERROR:" + nfRes.getString("error6"));
                            nfRespGen.setResponseType(2100);
                            return;
                        }
                        if (machtyp.indexOf("NETWARE", 0) >= 0) {
                            NetWareFile n = new NetWareFile(szCharSet);
                            txt = n.delFTPFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, nfRes);
                        } else if (machtyp.indexOf("WIN", 0) >= 0 || machtyp.indexOf("NT", 0) >= 0) {
                            XFileInterface winFileInterface = XFileFactory.getInstance().newXFileInstance(machtyp, szCharSet, this.pathInfo[0]);
                            txt = winFileInterface.doDeleteFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, domainname, nfRes);
                        } else if (machtyp.indexOf("FTP", 0) >= 0) {
                            FtpFile gff = new FtpFile(szCharSet);
                            txt = gff.delFTPFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, nfRes);
                        } else if (machtyp.indexOf("NFS", 0) >= 0) {
                            NfsFile gfs = new NfsFile(szCharSet);
                            txt = gfs.delNFSFile(usernam, passwrd, VMSnam, machnam, mainfilename, dir, nfRes);
                        }
                        SerializedRequestProcessor.this.doLog(nfRes.getString("successLog.1", new Object[]{functionName, mainfilename, usernam, machnam, VMSnam, dir}));
                    }
                }
            }
            catch (NetFileException nfe) {
                SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.1", new Object[]{functionName, mainfilename, usernam, machnam, VMSnam, dir}));
                nfRespGen.setResponseObject(nfe.getMessage());
                nfRespGen.setResponseType(2100);
                return;
            }
            catch (Exception e) {
                SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.1", new Object[]{functionName, mainfilename, usernam, machnam, VMSnam, dir}));
                nfRespGen.setResponseObject(e.getMessage());
                nfRespGen.setResponseType(2100);
                return;
            }
        }
    }

    class CreateDirectory {
        String[] pathInfo = null;
        NetFileLogManager logMgr = null;

        public CreateDirectory(String[] platInfo, NetFileLogManager log) {
            this.pathInfo = platInfo;
            this.logMgr = log;
        }

        void createDir(List nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) {
            Hashtable data = (Hashtable)nfReqData.get(4);
            String szCharSet = (String)data.get("CharSet");
            String usernam = (String)data.get("UserID");
            String passwrd = (String)data.get("SharePwd");
            String machnam = (String)data.get("SystemName");
            String machtyp = (String)data.get("SysType");
            String VMSnam = (String)data.get("ShareName");
            String dir = (String)data.get("Dir");
            String newdir = (String)data.get("NewDirName");
            String domainname = (String)data.get("NTDomName");
            String functionName = nfRes.getString("createDirLog");
            String returnTxt = "";
            String exerr = "";
            try {
                if (machtyp.indexOf("WIN", 0) >= 0 || machtyp.indexOf("NT", 0) >= 0) {
                    XFileInterface winFileInterface = XFileFactory.getInstance().newXFileInstance(machtyp, szCharSet, this.pathInfo[0]);
                    returnTxt = winFileInterface.doCreateDirectory(machnam, VMSnam, usernam, passwrd, domainname, dir, newdir, nfRes);
                    nfRespGen.setResponseObject(returnTxt);
                    nfRespGen.setResponseType(2001);
                    SerializedRequestProcessor.this.doLog(nfRes.getString("successLog.3", new Object[]{functionName, newdir, usernam, machnam, VMSnam, dir}));
                    return;
                }
                if (machtyp.indexOf("FTP", 0) >= 0) {
                    String oldftpdir = VMSnam + dir;
                    StringBuffer buftxt = new StringBuffer();
                    try {
                        String theLine;
                        FullFtpClient fc = new FullFtpClient(machnam, szCharSet);
                        fc.login(usernam, passwrd);
                        fc.cd(oldftpdir);
                        fc.mkdir(newdir);
                        fc.setMachineToAccess(machnam);
                        BufferedReader theList = new BufferedReader(new InputStreamReader(fc.list()));
                        while ((theLine = theList.readLine()) != null) {
                            buftxt.append(theLine).append("\n");
                        }
                        returnTxt = buftxt.toString();
                        theList.close();
                        fc.closeServer();
                        nfRespGen.setResponseObject(returnTxt);
                        nfRespGen.setResponseType(2001);
                        SerializedRequestProcessor.this.doLog(nfRes.getString("successLog.3", new Object[]{functionName, newdir, usernam, machnam, VMSnam, dir}));
                    }
                    catch (IOException ex) {
                        exerr = ex.toString();
                    }
                } else {
                    if (machtyp.indexOf("NFS", 0) >= 0) {
                        NfsFile nfsFile = new NfsFile(szCharSet);
                        returnTxt = nfsFile.mkdir(machnam, VMSnam, usernam, passwrd, dir, newdir, nfRes);
                        nfRespGen.setResponseObject(returnTxt);
                        nfRespGen.setResponseType(2001);
                        SerializedRequestProcessor.this.doLog(nfRes.getString("successLog.3", new Object[]{functionName, newdir, usernam, machnam, VMSnam, dir}));
                        return;
                    }
                    if (machtyp.indexOf("NETWARE", 0) >= 0) {
                        String oldnetwaredir = VMSnam + dir;
                        StringBuffer buftxt = new StringBuffer();
                        try {
                            String theLine;
                            FullFtpClient fc = new FullFtpClient(machnam, szCharSet);
                            fc.login(usernam, passwrd);
                            fc.cd(oldnetwaredir);
                            fc.mkdir(newdir);
                            fc.setMachineToAccess(machnam);
                            BufferedReader theList = new BufferedReader(new InputStreamReader(fc.list()));
                            while ((theLine = theList.readLine()) != null) {
                                buftxt.append(theLine).append("\n");
                            }
                            returnTxt = buftxt.toString();
                            theList.close();
                            fc.closeServer();
                            nfRespGen.setResponseObject(returnTxt);
                            nfRespGen.setResponseType(2001);
                            SerializedRequestProcessor.this.doLog(nfRes.getString("successLog.3", new Object[]{functionName, newdir, usernam, machnam, VMSnam, dir}));
                        }
                        catch (IOException ex) {
                            exerr = ex.toString();
                        }
                    } else {
                        nfRespGen.setResponseObject("ERROR:" + newdir + nfRes.getString("error3"));
                        nfRespGen.setResponseType(2100);
                        SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.3", new Object[]{functionName, newdir, usernam, machnam, VMSnam, dir}));
                        return;
                    }
                }
                if (exerr.indexOf("File exists", 0) >= 0 || exerr.indexOf("550", 0) >= 0) {
                    nfRespGen.setResponseObject("ERROR:" + newdir + nfRes.getString("error6"));
                    nfRespGen.setResponseType(2100);
                    SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.3", new Object[]{functionName, newdir, usernam, machnam, VMSnam, dir}));
                    return;
                }
                if (exerr.indexOf("LoginException", 0) >= 0 || exerr.indexOf("password", 0) >= 0) {
                    nfRespGen.setResponseObject("ERROR:" + newdir + nfRes.getString("error6"));
                    nfRespGen.setResponseType(2100);
                    SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.3", new Object[]{functionName, newdir, usernam, machnam, VMSnam, dir}));
                    return;
                }
                if (exerr.indexOf("errsrv", 0) >= 0 || exerr.indexOf("fail", 0) >= 0) {
                    nfRespGen.setResponseObject("ERROR:" + newdir + nfRes.getString("error6"));
                    nfRespGen.setResponseType(2100);
                    SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.3", new Object[]{functionName, newdir, usernam, machnam, VMSnam, dir}));
                    return;
                }
                if (exerr.indexOf("errdos", 0) >= 0 || exerr.indexOf("fail", 0) >= 0) {
                    nfRespGen.setResponseObject("ERROR:" + newdir + nfRes.getString("error6"));
                    nfRespGen.setResponseType(2100);
                    SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.3", new Object[]{functionName, newdir, usernam, machnam, VMSnam, dir}));
                    return;
                }
                if (exerr.indexOf("smbclient: not found", 0) >= 0) {
                    nfRespGen.setResponseObject("ERROR:" + newdir + nfRes.getString("error35"));
                    nfRespGen.setResponseType(2100);
                    SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.3", new Object[]{functionName, newdir, usernam, machnam, VMSnam, dir}));
                    return;
                }
            }
            catch (NetFileException nfe) {
                SerializedRequestProcessor.this.debug.error("Error creating directory", (Throwable)nfe);
                nfRespGen.setResponseObject(nfe.getMessage());
                nfRespGen.setResponseType(2100);
                SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.3", new Object[]{functionName, newdir, usernam, machnam, VMSnam, dir}));
                return;
            }
            catch (Exception e) {
                nfRespGen.setResponseObject(e.getMessage());
                nfRespGen.setResponseType(2100);
                SerializedRequestProcessor.this.debug.error("Error creating directory", (Throwable)e);
                SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.3", new Object[]{functionName, newdir, usernam, machnam, VMSnam, dir}));
            }
        }
    }

    class FileSearchHandler {
        String[] pathInfo = null;
        NetFileLogManager logMgr = null;

        public FileSearchHandler(String[] platInfo, NetFileLogManager log) {
            this.pathInfo = platInfo;
            this.logMgr = log;
        }

        void searchFile(List nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) {
            Hashtable data = (Hashtable)nfReqData.get(4);
            String machnam = (String)data.get("SystemName");
            String usernam = (String)data.get("UserID");
            String machtyp = (String)data.get("SysType");
            String VMSnam = (String)data.get("ShareName");
            String passwrd = (String)data.get("SharePwd");
            String searchpattern = (String)data.get("SearchPattern");
            String dir = (String)data.get("Dir");
            String domainname = (String)data.get("NTDomName");
            int maxsrchdir = (Integer)data.get("MaxSearchDir");
            String szCharSet = (String)data.get("CharSet");
            String functionName = nfRes.getString("searchFileLog");
            String newname = "";
            String[] txt = new String[100];
            if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                SerializedRequestProcessor.this.debug.message("Searching username=" + usernam + ",machname=" + machnam + ",domain=" + domainname + ",machtype=" + machtyp + ",dir_nam=" + dir + ",VMSname=" + VMSnam + ",search_pattern=" + searchpattern + ",maxsearchdir=" + maxsrchdir);
            }
            try {
                newname = machtyp.indexOf("WIN", 0) >= 0 || machtyp.indexOf("NT", 0) >= 0 ? VMSnam + dir : (machtyp.indexOf("NETWARE", 0) >= 0 ? VMSnam + "/" + dir : VMSnam + "/" + dir);
                if (newname.indexOf("//", 0) >= 0) {
                    newname = newname.replace('/', ' ');
                }
                if (machtyp.indexOf("WIN", 0) >= 0 || machtyp.indexOf("NT", 0) >= 0) {
                    XFileInterface winFileInterface = XFileFactory.getInstance().newXFileInstance(machtyp, szCharSet, this.pathInfo[0]);
                    txt = winFileInterface.doSearch(usernam, passwrd, machnam, VMSnam, searchpattern, dir, domainname, maxsrchdir, nfRes);
                    SerializedRequestProcessor.this.doLog(nfRes.getString("successLog.3", new Object[]{functionName, searchpattern, usernam, machnam, VMSnam, dir}));
                } else if (machtyp.indexOf("FTP", 0) >= 0) {
                    FtpFile srpat = new FtpFile(szCharSet);
                    if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                        SerializedRequestProcessor.this.debug.message("Starting FTP search in directory " + dir + " of VMS " + VMSnam + " with pattern " + searchpattern);
                    }
                    txt = srpat.searchFTPDir(usernam, passwrd, machnam, VMSnam, searchpattern, dir, maxsrchdir, nfRes);
                    SerializedRequestProcessor.this.doLog(nfRes.getString("successLog.3", new Object[]{functionName, searchpattern, usernam, machnam, VMSnam, dir}));
                } else if (machtyp.indexOf("NETWARE", 0) >= 0) {
                    NetWareFile srpat = new NetWareFile(szCharSet);
                    txt = srpat.searchFTPDir(usernam, passwrd, machnam, VMSnam, searchpattern, dir, maxsrchdir, nfRes);
                    SerializedRequestProcessor.this.doLog(nfRes.getString("successLog.3", new Object[]{functionName, searchpattern, usernam, machnam, VMSnam, dir}));
                } else if (machtyp.indexOf("NFS", 0) >= 0) {
                    NfsFile nfsFile = new NfsFile(szCharSet);
                    txt = nfsFile.search(usernam, passwrd, machnam, VMSnam, searchpattern, dir, domainname, maxsrchdir, nfRes);
                    if (txt.length == 0) {
                        txt = new String[]{"    "};
                    }
                    SerializedRequestProcessor.this.doLog(nfRes.getString("successLog.3", new Object[]{functionName, searchpattern, usernam, machnam, VMSnam, dir}));
                } else {
                    nfRespGen.setResponseObject("ERROR:" + nfRes.getString("error1"));
                    nfRespGen.setResponseType(2100);
                    SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.3", new Object[]{functionName, searchpattern, usernam, machnam, VMSnam, dir}));
                }
            }
            catch (NetFileException nfe) {
                nfRespGen.setResponseObject(nfe.getMessage());
                nfRespGen.setResponseType(2100);
                SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.3", new Object[]{functionName, searchpattern, usernam, machnam, VMSnam, dir}));
                return;
            }
            catch (Exception e) {
                SerializedRequestProcessor.this.debug.error("Exception searching files", (Throwable)e);
                nfRespGen.setResponseObject("ERROR: " + e.getMessage());
                nfRespGen.setResponseType(2100);
                SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.3", new Object[]{functionName, searchpattern, usernam, machnam, VMSnam, dir}));
                return;
            }
            nfRespGen.setResponseType(2001);
            nfRespGen.setResponseObject(txt);
            if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                SerializedRequestProcessor.this.debug.message("Search over");
            }
        }
    }

    class MailFile {
        String[] pathInfo = null;
        NetFileLogManager logMgr = null;

        public MailFile(String[] platInfo, NetFileLogManager log) {
            this.pathInfo = platInfo;
            this.logMgr = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void mailFile(List nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) {
            Hashtable data = (Hashtable)nfReqData.get(4);
            String szCharSet = (String)data.get("CharSet");
            String usernam = (String)data.get("UserID");
            String passwrd = (String)data.get("SharePwd");
            String machnam = (String)data.get("SystemName");
            String machtyp = (String)data.get("SysType");
            String VMSnam = (String)data.get("ShareName");
            String dir = (String)data.get("Dir");
            String tempdir = (String)data.get("sunPortalNetFileTempDir");
            String domainname = (String)data.get("NTDomName");
            String szTo = (String)data.get("ToAddress");
            String szFrom = (String)data.get("FromAddress");
            String szReplyTo = (String)data.get("ReplyToAddress");
            String szCc = (String)data.get("CcAddress");
            String szBcc = (String)data.get("BccAddress");
            String szSubject = (String)data.get("Subject");
            String szMessage = (String)data.get("Message");
            String szMailServer = (String)data.get("MailServer");
            SSOToken ssoToken = (SSOToken)nfReqData.get(6);
            Vector v_files_to_send = (Vector)data.get("FileNames");
            String functionName = nfRes.getString("mailFileLog");
            HashMap<String, String> m_files_to_send = new HashMap<String, String>();
            String fileNameList = "";
            try {
                if (v_files_to_send == null || v_files_to_send.size() <= 0) {
                    throw new NetFileException(500, nfRes.getString("srp.4"));
                }
                for (int fil_mail = 0; fil_mail < v_files_to_send.size(); ++fil_mail) {
                    String filename = (String)v_files_to_send.elementAt(fil_mail);
                    String result = this.openFile(usernam, passwrd, machnam, domainname, machtyp, dir, VMSnam, (String)v_files_to_send.get(fil_mail), tempdir, nfRes, szCharSet, ssoToken);
                    if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                        SerializedRequestProcessor.this.debug.message("Obtained file " + filename + " for mailing");
                    }
                    if (result.startsWith("ERROR:")) {
                        nfRespGen.setResponseType(2100);
                        nfRespGen.setResponseObject(result);
                        SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.1", new Object[]{functionName, filename, usernam, machnam, VMSnam, dir}));
                        return;
                    }
                    fileNameList = fileNameList + filename + ", ";
                    m_files_to_send.put(result, filename);
                }
                SendFile sendfil = new SendFile();
                String result = sendfil.sendAttachedFile(szTo, szFrom, szReplyTo, szCc, szBcc, szMailServer, szSubject, szMessage, m_files_to_send, "1", nfContext.getHTMLCharset(), nfRes, "");
                if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                    SerializedRequestProcessor.this.debug.message("Number of attachments to be sent is " + m_files_to_send.size());
                }
                nfRespGen.setResponseType(2001);
                nfRespGen.setResponseObject(result);
                SerializedRequestProcessor.this.doLog(nfRes.getString("successLog.3", new Object[]{functionName, fileNameList, usernam, machnam, VMSnam, dir}));
                return;
            }
            catch (NetFileException nfe) {
                SerializedRequestProcessor.this.debug.error("Error mailing file", (Throwable)nfe);
                nfRespGen.setResponseType(2100);
                nfRespGen.setResponseObject(nfe.getMessage());
                SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.2", new Object[]{functionName, usernam, machnam, VMSnam, dir}));
                return;
            }
            catch (Exception e) {
                SerializedRequestProcessor.this.debug.error("Error mailing file", (Throwable)e);
                nfRespGen.setResponseType(2100);
                nfRespGen.setResponseObject("ERROR: " + nfRes.getString("error4"));
                SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.2", new Object[]{functionName, usernam, machnam, VMSnam, dir}));
                return;
            }
            finally {
                this.deleteFiles(m_files_to_send);
            }
        }

        private void deleteFiles(Map mapTempFiles) {
            if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                SerializedRequestProcessor.this.debug.message("Deleting temporary mail files");
            }
            Iterator it = mapTempFiles.keySet().iterator();
            while (it.hasNext()) {
                try {
                    String s_filename = (String)it.next();
                    File delFil = new File(s_filename);
                    if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                        SerializedRequestProcessor.this.debug.message("Deleting :" + delFil.getAbsolutePath());
                    }
                    if (!delFil.exists()) continue;
                    delFil.delete();
                }
                catch (Exception e) {
                    SerializedRequestProcessor.this.debug.error("Exception deleting temporary file for mailing", (Throwable)e);
                }
            }
        }

        private String openFile(String username, String password, String machname, String domain, String machtype, String dir_nam, String VMSname, String mainfilenam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket, String szCharSet, SSOToken ssoToken) throws NetFileException {
            String usernam = username;
            String passwrd = password;
            String machnam = machname;
            String machtyp = machtype;
            String VMSnam = VMSname;
            String dir = dir_nam;
            String tempdir = tmpdir;
            String domainname = domain;
            String mainfilename = "";
            String txt = "";
            try {
                File fLocalTemp = new File(tmpdir);
                if (!fLocalTemp.exists()) {
                    fLocalTemp.mkdirs();
                }
            }
            catch (Exception e) {
                SerializedRequestProcessor.this.debug.error("Error creating temp directory", (Throwable)e);
                throw new NetFileException(500, nfr_user_locale_i18n_bucket.getString("srp.5"));
            }
            try {
                mainfilename = mainfilenam;
                if (machtyp.equalsIgnoreCase("")) {
                    throw new NetFileException();
                }
                if (machtyp.indexOf("NETWARE", 0) >= 0) {
                    NetWareFile nf = new NetWareFile(szCharSet);
                    txt = nf.getFTPFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, tempdir, nfr_user_locale_i18n_bucket, ssoToken.getTokenID().toString());
                } else if (machtyp.indexOf("WIN", 0) >= 0 || machtyp.indexOf("NT", 0) >= 0) {
                    if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                        SerializedRequestProcessor.this.debug.message("Getting " + mainfilename);
                    }
                    XFileInterface winFileInterface = XFileFactory.getInstance().newXFileInstance(machtyp, szCharSet, this.pathInfo[0]);
                    txt = winFileInterface.getFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, domainname, tempdir, nfr_user_locale_i18n_bucket);
                    if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                        SerializedRequestProcessor.this.debug.message("Got " + mainfilename);
                    }
                } else if (machtyp.indexOf("FTP", 0) >= 0) {
                    if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                        SerializedRequestProcessor.this.debug.message("Getting(" + mainfilename + ")");
                    }
                    FtpFile gff = new FtpFile(szCharSet);
                    txt = gff.getFTPFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, tempdir, nfr_user_locale_i18n_bucket, ssoToken.getTokenID().toString());
                } else if (machtyp.indexOf("NFS", 0) >= 0) {
                    NfsFile gfs = new NfsFile(szCharSet);
                    txt = gfs.getNFSFile(usernam, passwrd, VMSnam, machnam, mainfilename, dir, tempdir, nfr_user_locale_i18n_bucket, ssoToken.getTokenID().toString());
                }
                if (txt.indexOf("FileNotFound", 0) >= 0) {
                    throw new NetFileException(500, nfr_user_locale_i18n_bucket.getString("srp.6"));
                }
                if (txt.toUpperCase().indexOf("ERROR", 0) >= 0) {
                    throw new NetFileException(500, nfr_user_locale_i18n_bucket.getString("srp.6"));
                }
            }
            catch (Exception e) {
                txt = "ERROR:" + e.getMessage();
                SerializedRequestProcessor.this.debug.error("Problem getting file", (Throwable)e);
            }
            return txt;
        }
    }

    class CompressFile {
        String[] pathInfo = null;
        NetFileLogManager logMgr = null;

        public CompressFile(String[] platInfo, NetFileLogManager log) {
            this.pathInfo = platInfo;
            this.logMgr = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void compressFile(List nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) {
            Hashtable data = (Hashtable)nfReqData.get(4);
            String usernam = (String)data.get("UserID");
            String passwrd = (String)data.get("SharePwd");
            String machnam = (String)data.get("SystemName");
            String machtyp = (String)data.get("SysType");
            String VMSnam = (String)data.get("ShareName");
            String dir = (String)data.get("Dir");
            String tempdir = (String)data.get("sunPortalNetFileTempDir");
            String domainname = (String)data.get("NTDomName");
            String szCompressMethod = (String)data.get("CompressMethod");
            Integer compressionLevel = (Integer)data.get("CompressionLevel");
            Vector cachechk = (Vector)data.get("FileNames");
            String szCharSet = (String)data.get("CharSet");
            String text = "";
            String erroredFiles = "";
            if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                SerializedRequestProcessor.this.debug.message("Temporary directory=" + tempdir);
            }
            String mainfile_name = "";
            String functionName = nfRes.getString("compressFileLog");
            try {
                try {
                    if (machtyp.equalsIgnoreCase("")) {
                        throw new NetFileException();
                    }
                    if (cachechk == null || cachechk.size() <= 0) {
                        if (!SerializedRequestProcessor.this.debug.messageEnabled()) throw new NetFileException();
                        SerializedRequestProcessor.this.debug.message("No files selected for compression");
                        throw new NetFileException();
                    }
                    if (cachechk.size() > 0) {
                        for (int fil_zip = 0; fil_zip < cachechk.size(); ++fil_zip) {
                            InputStream instream;
                            OutputStream outstream;
                            Object gpc;
                            NfsFile nfsFile;
                            block39: {
                                Object var31_32;
                                FtpFile gff = null;
                                NetWareFile nwfile = null;
                                nfsFile = null;
                                gpc = null;
                                outstream = null;
                                instream = null;
                                if (szCompressMethod.equalsIgnoreCase("gzip")) {
                                    mainfile_name = (String)cachechk.elementAt(fil_zip) + ".gz";
                                } else if (szCompressMethod.equalsIgnoreCase("zip")) {
                                    mainfile_name = (String)cachechk.elementAt(fil_zip) + ".zip";
                                }
                                if (machtyp.indexOf("FTP", 0) >= 0) {
                                    SerializedRequestProcessor.this.debug.message(szCompressMethod + " Processing of file " + (String)cachechk.elementAt(fil_zip));
                                    gff = new FtpFile(szCharSet);
                                    instream = gff.getInputFTPStream(usernam, passwrd, machnam, VMSnam, (String)cachechk.elementAt(fil_zip), dir, nfRes);
                                    outstream = gff.getOutputFTPStream(usernam, passwrd, machnam, VMSnam, mainfile_name, dir, nfRes);
                                } else if (machtyp.indexOf("NETWARE", 0) >= 0) {
                                    SerializedRequestProcessor.this.debug.message(szCompressMethod + " Processing of file " + (String)cachechk.elementAt(fil_zip));
                                    nwfile = new NetWareFile(szCharSet);
                                    instream = nwfile.getInputFTPStream(usernam, passwrd, machnam, VMSnam, (String)cachechk.elementAt(fil_zip), dir, nfRes);
                                    outstream = nwfile.getOutputFTPStream(usernam, passwrd, machnam, VMSnam, mainfile_name, dir, nfRes);
                                } else if (machtyp.indexOf("NFS", 0) >= 0) {
                                    SerializedRequestProcessor.this.debug.message(szCompressMethod + " Processing of file " + (String)cachechk.elementAt(fil_zip));
                                    nfsFile = new NfsFile(szCharSet);
                                    instream = nfsFile.getNFSInputStream(usernam, passwrd, VMSnam, machnam, (String)cachechk.elementAt(fil_zip), dir, nfRes);
                                    outstream = nfsFile.getNFSOutputStream(usernam, passwrd, machnam, VMSnam, mainfile_name, dir, nfRes);
                                } else {
                                    if (machtyp.indexOf("WIN", 0) < 0 && machtyp.indexOf("NT", 0) < 0) break;
                                    SerializedRequestProcessor.this.debug.message(szCompressMethod + " Processing of file " + (String)cachechk.elementAt(fil_zip));
                                    XFileInterface winFileInterface = XFileFactory.getInstance().newXFileInstance(machtyp, szCharSet, this.pathInfo[0]);
                                    instream = winFileInterface.getInputStream(usernam, passwrd, domainname, machnam, VMSnam, dir, (String)cachechk.elementAt(fil_zip), nfRes);
                                    outstream = winFileInterface.getOutputStream(usernam, passwrd, domainname, machnam, VMSnam, dir, mainfile_name, nfRes);
                                }
                                try {
                                    try {
                                        NetFileCompression nfComp = new NetFileCompression();
                                        nfComp.setCompressMethod(szCompressMethod);
                                        nfComp.setCompressLevel(compressionLevel);
                                        nfComp.doCompress(instream, outstream, cachechk.elementAt(fil_zip));
                                        SerializedRequestProcessor.this.doLog(nfRes.getString("successLog.1", new Object[]{functionName, mainfile_name, usernam, machnam, VMSnam, dir}));
                                    }
                                    catch (Exception e) {
                                        SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.1", new Object[]{functionName, mainfile_name, usernam, machnam, VMSnam, dir}));
                                        text = "ERROR:";
                                        SerializedRequestProcessor.this.debug.error("Error in compressing file " + (String)cachechk.get(fil_zip) + "to host " + machnam, (Throwable)e);
                                        if (fil_zip >= cachechk.size()) {
                                            erroredFiles = erroredFiles + (String)cachechk.get(fil_zip) + "<br>";
                                            throw new NetFileException(500, nfRes.getString("srp.2", new Object[]{erroredFiles}));
                                        }
                                        erroredFiles = erroredFiles + (String)cachechk.get(fil_zip) + "<br>";
                                        var31_32 = null;
                                        if (gff != null) {
                                            gff.closeFtpFile();
                                            continue;
                                        }
                                        if (nwfile != null) {
                                            nwfile.closeFtpFile();
                                            continue;
                                        }
                                        if (nfsFile != null) {
                                            nfsFile.closeNfsFile();
                                            continue;
                                        }
                                        if (gpc == null) continue;
                                        if (instream != null) {
                                            instream.close();
                                        }
                                        if (outstream == null) continue;
                                        outstream.close();
                                        continue;
                                    }
                                    var31_32 = null;
                                    if (gff != null) {
                                        gff.closeFtpFile();
                                        continue;
                                    }
                                    if (nwfile == null) break block39;
                                }
                                catch (Throwable throwable) {
                                    var31_32 = null;
                                    if (gff != null) {
                                        gff.closeFtpFile();
                                        throw throwable;
                                    }
                                    if (nwfile != null) {
                                        nwfile.closeFtpFile();
                                        throw throwable;
                                    }
                                    if (nfsFile != null) {
                                        nfsFile.closeNfsFile();
                                        throw throwable;
                                    }
                                    if (gpc == null) throw throwable;
                                    if (instream != null) {
                                        instream.close();
                                    }
                                    if (outstream == null) throw throwable;
                                    outstream.close();
                                    throw throwable;
                                }
                                nwfile.closeFtpFile();
                                continue;
                            }
                            if (nfsFile != null) {
                                nfsFile.closeNfsFile();
                                continue;
                            }
                            if (gpc == null) continue;
                            if (instream != null) {
                                instream.close();
                            }
                            if (outstream == null) continue;
                            outstream.close();
                        }
                    }
                    Object var33_34 = null;
                    if (text.startsWith("ERROR:")) {
                        return;
                    }
                    nfRespGen.setResponseType(2001);
                    nfRespGen.setResponseObject(nfRes.getString("info9"));
                    return;
                }
                catch (Exception e) {
                    SerializedRequestProcessor.this.debug.error("Exception compressing file", (Throwable)e);
                    text = "ERROR:";
                    nfRespGen.setResponseType(2100);
                    if (e instanceof NetFileException) {
                        nfRespGen.setResponseObject(e.getMessage());
                    } else {
                        nfRespGen.setResponseObject(nfRes.getString("srp.3"));
                    }
                    SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.1", new Object[]{functionName, mainfile_name, usernam, machnam, VMSnam, dir}));
                    Object var33_35 = null;
                    if (text.startsWith("ERROR:")) {
                        return;
                    }
                    nfRespGen.setResponseType(2001);
                    nfRespGen.setResponseObject(nfRes.getString("info9"));
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var33_36 = null;
                if (text.startsWith("ERROR:")) {
                    throw throwable;
                }
                nfRespGen.setResponseType(2001);
                nfRespGen.setResponseObject(nfRes.getString("info9"));
                return;
            }
        }
    }

    class DownloadDirectory {
        String[] pathInfo = null;
        NetFileLogManager logMgr = null;
        String fileListingToLog = "";

        public DownloadDirectory(String[] platInfo, NetFileLogManager log) {
            this.pathInfo = platInfo;
            this.logMgr = log;
        }

        void downloadFolder(List nfReqData, NetFileResponseGenerator respGen, NetFileContext nfContext, NetFileResource nfRes) {
            String username = "";
            String machine = "";
            String share = "";
            String directory = "";
            String functionName = nfRes.getString("dirListLog");
            try {
                Hashtable data = (Hashtable)nfReqData.get(4);
                username = (String)data.get("UserID");
                machine = (String)data.get("SystemName");
                share = (String)data.get("ShareName");
                directory = (String)data.get("Dir");
                String[] files = this.getFilesInDirectory(nfReqData, data, nfContext, nfRes);
                respGen.setResponseType(2001);
                respGen.setResponseObject(files);
                SerializedRequestProcessor.this.doLog(nfRes.getString("successLog.3", new Object[]{functionName, this.fileListingToLog, username, machine, share, directory}));
                return;
            }
            catch (NetFileException nfe) {
                respGen.setResponseObject(nfe.getMessage());
                respGen.setResponseType(2100);
                SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.2", new Object[]{functionName, username, machine, share, directory}));
                return;
            }
            catch (Exception e) {
                respGen.setResponseObject(e.getMessage());
                respGen.setResponseType(2100);
                SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.2", new Object[]{functionName, username, machine, share, directory}));
                return;
            }
        }

        String[] getFilesInDirectory(List nfReqData, Hashtable data, NetFileContext nfContext, NetFileResource nfRes) throws NetFileException {
            String username = (String)data.get("UserID");
            String password = (String)data.get("SharePwd");
            String machine = (String)data.get("SystemName");
            String type = (String)data.get("SysType");
            String share = (String)data.get("ShareName");
            String directory = (String)data.get("Dir");
            String domain = (String)data.get("NTDomName");
            String szCharSet = (String)data.get("CharSet");
            SSOToken ssoToken = (SSOToken)nfReqData.get(6);
            String[] file_listing = null;
            try {
                String s_name;
                String s_type;
                DirectoryListingHandler dirListHandler = new DirectoryListingHandler(this.pathInfo, this.logMgr);
                String[] listing = dirListHandler.expandDir(username, password, machine, domain, type, share, directory, nfRes, ssoToken, szCharSet);
                if (listing == null) {
                    throw new NetFileException();
                }
                if (listing[0] == null) {
                    throw new NetFileException();
                }
                if (listing[0].startsWith("ERROR:")) {
                    throw new NetFileException();
                }
                if (listing.length % 4 != 0) {
                    throw new NetFileException();
                }
                ArrayList<String> v_files_in_directory = new ArrayList<String>();
                for (int i_index = 0; i_index < listing.length && (s_type = listing[i_index]) != null && (s_name = listing[i_index + 1]) != null; i_index += 4) {
                    if (s_type.equals("-")) {
                        v_files_in_directory.add(s_name);
                        if (i_index + 4 >= listing.length) {
                            SerializedRequestProcessor.this.debug.message("breaking");
                            break;
                        }
                    }
                    int i_listing_size = v_files_in_directory.size();
                    file_listing = new String[i_listing_size];
                    String fileName = "";
                    for (int i = 0; i < i_listing_size; ++i) {
                        file_listing[i] = fileName = (String)v_files_in_directory.get(i);
                        this.fileListingToLog = this.fileListingToLog + fileName + ", ";
                    }
                }
                return file_listing;
            }
            catch (Exception thr) {
                throw new NetFileException();
            }
        }
    }

    class RenameFile {
        String[] pathInfo = null;
        NetFileLogManager logMgr = null;

        public RenameFile(String[] platInfo, NetFileLogManager log) {
            this.pathInfo = platInfo;
            this.logMgr = log;
        }

        void rename(List nfReqData, NetFileResponseGenerator nfResp, NetFileContext nfContext, NetFileResource nfRes) throws NetFileException {
            Hashtable data = (Hashtable)nfReqData.get(4);
            String username = (String)data.get("UserID");
            String password = (String)data.get("SharePwd");
            String machine = (String)data.get("SystemName");
            String type = (String)data.get("SysType");
            String share = (String)data.get("ShareName");
            String oldName = (String)data.get("OldFileName");
            String newName = (String)data.get("NewFileName");
            String directory = (String)data.get("Dir");
            String domain = (String)data.get("NTDomName");
            String szCharSet = (String)data.get("CharSet");
            String functionName = nfRes.getString("renameFileLog");
            try {
                if (type.equalsIgnoreCase("WIN") || type.equalsIgnoreCase("NT")) {
                    XFileInterface winFileInterface = XFileFactory.getInstance().newXFileInstance(type, szCharSet, this.pathInfo[0]);
                    winFileInterface.doRenameFile(username, password, machine, domain, share, directory, oldName, newName, nfRes);
                } else if (type.equalsIgnoreCase("FTP")) {
                    FtpFile ftpFile = new FtpFile(szCharSet);
                    ftpFile.rename(username, password, machine, share, directory, oldName, newName, nfRes);
                } else if (type.equalsIgnoreCase("NFS")) {
                    NfsFile nfsFile = new NfsFile(szCharSet);
                    nfsFile.rename(username, password, machine, share, directory, oldName, newName, nfRes);
                } else if (type.equalsIgnoreCase("NETWARE")) {
                    NetWareFile nwFile = new NetWareFile(szCharSet);
                    nwFile.rename(username, password, machine, share, directory, oldName, newName, nfRes);
                }
            }
            catch (NetFileException nfe) {
                nfResp.setResponseObject(nfe.getMessage());
                nfResp.setResponseType(2100);
                SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.1", new Object[]{functionName, oldName, username, machine, share, directory}));
                return;
            }
            catch (Exception e) {
                nfResp.setResponseObject(e.getMessage());
                nfResp.setResponseType(2100);
                SerializedRequestProcessor.this.doLog(nfRes.getString("failureLog.1", new Object[]{functionName, oldName, username, machine, share, directory}));
                return;
            }
            SerializedRequestProcessor.this.doLog(nfRes.getString("successLog.1", new Object[]{functionName, oldName, username, machine, share, directory}));
            nfResp.setResponseObject("File Renamed");
            nfResp.setResponseType(2001);
        }
    }
}

