/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet.java2;

import com.iplanet.am.util.Debug;
import com.sun.nfs.XFileExtensionAccessor;
import com.sun.portal.netfile.servlet.java2.NetFileResource;
import com.sun.portal.netfile.shared.NetFileException;
import com.sun.xfile.XFile;
import com.sun.xfile.XFileInputStream;
import com.sun.xfile.XFileOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

class NfsFile {
    private Debug debug;
    public static boolean SHOULD_HAVE_READ_PERMISSION = true;
    public static boolean SHOULD_NOT_HAVE_READ_PERMISSION = false;
    public static final String encoding = "UTF8";
    private static final int[] ia_unable_to_login = new int[]{-1, -1};
    private String s_machine_encoding;
    private XFileInputStream instream = null;
    private XFileOutputStream outstream = null;
    private int i_number_of_directories_traversed;

    public native int[] getUserInfo(String var1) throws Exception;

    private native boolean doNativeAuth(String var1, String var2) throws Exception;

    NfsFile(String s_machine_encoding) {
        this.s_machine_encoding = s_machine_encoding;
        this.i_number_of_directories_traversed = 0;
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
    }

    NfsFile(String s_machine_encoding, int authPort) {
        this(s_machine_encoding);
    }

    int[] getUserIDs(String user_name, String password, NetFileResource resourceBundle) throws NetFileException {
        int[] i_ids = ia_unable_to_login;
        try {
            i_ids = this.getUserInfo(new String(user_name.getBytes(), encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new NetFileException(500, resourceBundle.getString("nf.1"));
        }
        catch (Exception e) {
            throw new NetFileException(500, resourceBundle.getString("nf.11"));
        }
        if (i_ids[0] == -1) {
            throw new NetFileException(500, resourceBundle.getString("nf.2"));
        }
        return i_ids;
    }

    String mkdir(String machine, String share, String user_name, String password, String target_dir, String directory_to_create, NetFileResource resourceBundle) throws NetFileException {
        try {
            if (!this.doAuthenticate(user_name, password, resourceBundle)) {
                throw new NetFileException(500, resourceBundle.getString("nf.2"));
            }
            int[] i_ids = this.getUserIDs(user_name, password, resourceBundle);
            XFile xf_parent_dir = this.getXFile(share, machine, target_dir, true, SHOULD_HAVE_READ_PERMISSION, i_ids, resourceBundle);
            if (!xf_parent_dir.canWrite()) {
                throw new NetFileException(500, resourceBundle.getString("nf.7", new Object[]{xf_parent_dir.getPath()}));
            }
            XFile xfile = this.getXFile(share, machine, target_dir + "/" + directory_to_create, false, SHOULD_NOT_HAVE_READ_PERMISSION, i_ids, resourceBundle);
            if (!xfile.mkdir()) {
                throw new NetFileException(500, resourceBundle.getString("nf.4"));
            }
        }
        catch (Exception e) {
            if (e instanceof NetFileException) {
                throw (NetFileException)e;
            }
            throw new NetFileException(500, resourceBundle.getString("nf.4"));
        }
        return resourceBundle.getString("warning52");
    }

    String[] getNFSDir(String username, String password, String VMSnam, String machname, String dir_nam, String tmpdir, NetFileResource resourceBundle) throws NetFileException {
        if (!this.doAuthenticate(username, password, resourceBundle)) {
            throw new NetFileException(500, resourceBundle.getString("nf.2"));
        }
        int[] i_ids = this.getUserIDs(username, password, resourceBundle);
        XFile xfile = this.getXFile(VMSnam, machname, dir_nam, true, SHOULD_HAVE_READ_PERMISSION, i_ids, resourceBundle);
        String[] sa_files_list = xfile.list();
        String[] sa_listing = null;
        if (sa_files_list == null) {
            throw new NetFileException(500, resourceBundle.getString("nf.5"));
        }
        sa_listing = new String[sa_files_list.length * 4];
        int j = 0;
        for (int i = 0; i < sa_files_list.length; ++i) {
            XFile xf_curr_file = new XFile(xfile, sa_files_list[i]);
            sa_listing[j] = xf_curr_file.isFile() ? "-" : "d";
            sa_listing[++j] = xf_curr_file.getName();
            sa_listing[++j] = new Long(xf_curr_file.length()).toString();
            Date d = new Date(xf_curr_file.lastModified());
            SimpleDateFormat sdf = new SimpleDateFormat("MMM dd yy, hh:mm a");
            sdf.setCalendar(new GregorianCalendar(TimeZone.getDefault()));
            sa_listing[++j] = sdf.format(d);
            ++j;
        }
        if (sa_listing == null) {
            throw new NetFileException(500, resourceBundle.getString("nf.5"));
        }
        return sa_listing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    String getNFSFile(String username, String password, String VMSname, String machname, String mainfilename, String dir_nam, String tmpdir, NetFileResource resourceBundle, String usersession) throws NetFileException {
        String string;
        File temp_file;
        block10: {
            temp_file = null;
            byte[] buffer = new byte[8192];
            if (!this.doAuthenticate(username, password, resourceBundle)) {
                throw new NetFileException(500, resourceBundle.getString("nf.2"));
            }
            int[] i_ids = this.getUserIDs(username, password, resourceBundle);
            this.writeDebug("Getting file " + machname + ":" + VMSname + dir_nam + "/" + mainfilename);
            XFile xfile = this.getXFile(VMSname, machname, dir_nam + "/" + mainfilename, true, SHOULD_HAVE_READ_PERMISSION, i_ids, resourceBundle);
            XFileInputStream xfis_file = new XFileInputStream(xfile);
            Long time = new Long(System.currentTimeMillis());
            String s_temp_file = tmpdir + "/" + time.toString() + username.toUpperCase() + mainfilename;
            temp_file = new File(s_temp_file);
            temp_file.createNewFile();
            FileOutputStream fops_tmp = new FileOutputStream(temp_file);
            int c = 0;
            while ((c = xfis_file.read(buffer)) > -1) {
                fops_tmp.write(buffer, 0, c);
            }
            fops_tmp.close();
            xfis_file.close();
            fops_tmp = null;
            xfis_file = null;
            xfile = null;
            time = null;
            temp_file = null;
            this.writeDebug("Got " + machname + ":" + VMSname + dir_nam + "/" + mainfilename);
            string = s_temp_file;
            Object var21_22 = null;
            if (temp_file == null) break block10;
            try {
                temp_file.delete();
            }
            catch (Exception e2) {
                // empty catch block
            }
            temp_file = null;
        }
        return string;
        catch (Exception e) {
            String string2;
            block12: {
                try {
                    this.writeErrorDebug("Error in putting NFS File", e);
                    string2 = "ERROR:" + e.getMessage();
                    Object var21_23 = null;
                    if (temp_file == null) break block12;
                }
                catch (Throwable throwable) {
                    block14: {
                        Object var21_24 = null;
                        if (temp_file == null) break block14;
                        try {
                            temp_file.delete();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        temp_file = null;
                    }
                    throw throwable;
                }
                try {
                    temp_file.delete();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                temp_file = null;
            }
            return string2;
        }
    }

    String[] search(String usernam, String passwrd, String machnam, String VMSnam, String pattern, String dir_nam, String domainname, int maxsrchdir, NetFileResource resourceBundle) throws NetFileException {
        return this.search(usernam, passwrd, machnam, VMSnam, pattern, dir_nam, maxsrchdir, resourceBundle);
    }

    String[] search(String usernam, String passwrd, String machnam, String VMSnam, String pattern, String dir_nam, int maxsrchdir, NetFileResource resourceBundle) throws NetFileException {
        if (!this.doAuthenticate(usernam, passwrd, resourceBundle)) {
            throw new NetFileException(500, resourceBundle.getString("nf.2"));
        }
        int[] i_ids = this.getUserIDs(usernam, passwrd, resourceBundle);
        XFile xfile = this.getXFile(VMSnam, machnam, dir_nam, true, false, i_ids, resourceBundle);
        String s_prefix = "nfs://" + machnam;
        int i_prefix_length = s_prefix.length();
        if (xfile.isFile()) {
            throw new NetFileException(500, resourceBundle.getString("nf.6"));
        }
        ArrayList v_search_results = new ArrayList();
        int i_directories_searched = 0;
        this.search(xfile, ++i_directories_searched, maxsrchdir, i_prefix_length, v_search_results, pattern, i_ids, resourceBundle);
        if (this.i_number_of_directories_traversed > maxsrchdir) {
            String[] searchResults = new String[v_search_results.size() + 1];
            searchResults[0] = "ERROR:" + resourceBundle.getString("maxSearch");
            for (int j = 1; j < searchResults.length; ++j) {
                searchResults[j] = (String)v_search_results.get(j - 1);
            }
            return searchResults;
        }
        String[] sa_resulsts = new String[v_search_results.size()];
        for (int i = 0; i < v_search_results.size(); ++i) {
            sa_resulsts[i] = (String)v_search_results.get(i);
            this.writeDebug("Search result:" + sa_resulsts[i]);
        }
        return sa_resulsts;
    }

    void search(XFile xfile, int i_directories_searched, int maxsrchdir, int i_prefix_length, ArrayList v_search_results, String pattern, int[] i_ids, NetFileResource resourceBundle) throws NetFileException {
        ++this.i_number_of_directories_traversed;
        if (this.i_number_of_directories_traversed > maxsrchdir) {
            return;
        }
        if (xfile.isFile()) {
            throw new NetFileException(500, resourceBundle.getString("nf.6"));
        }
        String[] sa_contents = xfile.list();
        String s_path = xfile.toString();
        this.writeDebug("Searching:" + s_path);
        if (sa_contents == null) {
            v_search_results.add("Permission denied :" + s_path.substring(i_prefix_length, s_path.length()));
        } else {
            for (int i = 0; i < sa_contents.length && this.i_number_of_directories_traversed <= maxsrchdir; ++i) {
                String s_current_path = s_path + "/" + sa_contents[i];
                XFile x_file = null;
                try {
                    x_file = this.getXFile(s_current_path, true, false, i_ids, resourceBundle);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (sa_contents[i].indexOf(pattern) > -1) {
                    String path = x_file.toString().substring(i_prefix_length, x_file.toString().length());
                    if (x_file.isDirectory()) {
                        path = path + "/";
                    }
                    v_search_results.add(path);
                }
                if (!x_file.isDirectory()) continue;
                if (x_file.canRead()) {
                    this.search(x_file, ++i_directories_searched, maxsrchdir, i_prefix_length, v_search_results, pattern, i_ids, resourceBundle);
                    continue;
                }
                v_search_results.add("Permission denied :" + x_file.toString().substring(i_prefix_length, x_file.toString().length()));
            }
        }
    }

    String delNFSFile(String username, String password, String VMSname, String machname, String mainfilename, String dir_nam, NetFileResource resourceBundle) throws NetFileException {
        if (!this.doAuthenticate(username, password, resourceBundle)) {
            throw new NetFileException(500, resourceBundle.getString("nf.2"));
        }
        try {
            int[] i_ids = this.getUserIDs(username, password, resourceBundle);
            XFile xf_parent_directory = this.getXFile(VMSname, machname, dir_nam, true, SHOULD_HAVE_READ_PERMISSION, i_ids, resourceBundle);
            if (!xf_parent_directory.canWrite()) {
                throw new NetFileException(500, resourceBundle.getString("nf.3") + resourceBundle.getString("nf.7", new Object[]{xf_parent_directory.getPath()}));
            }
            XFile xf_file = this.getXFile(VMSname, machname, dir_nam + "/" + mainfilename, true, SHOULD_HAVE_READ_PERMISSION, i_ids, resourceBundle);
            if (!xf_file.canWrite()) {
                throw new NetFileException(500, resourceBundle.getString("nf.3") + resourceBundle.getString("nf.7", new Object[]{xf_parent_directory.getPath()}));
            }
            xf_file.delete();
        }
        catch (Exception e) {
            this.writeErrorDebug("Error in putting NFS File", e);
            return "ERROR:" + e.getMessage();
        }
        return resourceBundle.getString("info5");
    }

    private String getFileURL(String VMSnam, String machname, String dir_nam) {
        StringBuffer sb_file_pointer = new StringBuffer("nfs://");
        sb_file_pointer.append(machname);
        sb_file_pointer.append(VMSnam);
        sb_file_pointer.append(dir_nam);
        return sb_file_pointer.toString();
    }

    public XFileOutputStream getNFSOutputStream(String username, String password, String machname, String VMSname, String remotefil_arg, String dir_nam, NetFileResource resourceBundle) throws Exception, NetFileException {
        return this.getNFSOutputStream(username, password, machname, VMSname, remotefil_arg, dir_nam, false, resourceBundle);
    }

    public XFileOutputStream getNFSOutputStream(String username, String password, String machname, String VMSname, String remotefil_arg, String dir_nam, boolean append, NetFileResource resourceBundle) throws Exception, NetFileException {
        if (!this.doAuthenticate(username, password, resourceBundle)) {
            throw new NetFileException(500, resourceBundle.getString("nf.2"));
        }
        int[] i_ids = this.getUserIDs(username, password, resourceBundle);
        XFile xf_parent_dir = this.getXFile(VMSname, machname, dir_nam, true, SHOULD_HAVE_READ_PERMISSION, i_ids, resourceBundle);
        if (!xf_parent_dir.canWrite()) {
            throw new NetFileException(500, resourceBundle.getString("nf.7", new Object[]{xf_parent_dir.getPath()}));
        }
        XFile xfile = this.getXFile(VMSname, machname, dir_nam + "/" + remotefil_arg, false, SHOULD_NOT_HAVE_READ_PERMISSION, i_ids, resourceBundle);
        this.outstream = append ? new XFileOutputStream(xfile, append) : new XFileOutputStream(xfile);
        return this.outstream;
    }

    public XFileInputStream getNFSInputStream(String username, String password, String VMSname, String machname, String mainfilename, String dir_nam, NetFileResource resourceBundle) throws Exception, NetFileException {
        if (!this.doAuthenticate(username, password, resourceBundle)) {
            throw new NetFileException(500, resourceBundle.getString("nf.2"));
        }
        int[] i_ids = this.getUserIDs(username, password, resourceBundle);
        this.writeDebug("Getting file " + machname + ":" + VMSname + dir_nam + "/" + mainfilename);
        XFile xfile = this.getXFile(VMSname, machname, dir_nam + "/" + mainfilename, true, SHOULD_HAVE_READ_PERMISSION, i_ids, resourceBundle);
        this.instream = new XFileInputStream(xfile);
        return this.instream;
    }

    public void closeNfsFile() throws IOException {
        if (this.instream != null) {
            this.instream.close();
        }
        if (this.outstream != null) {
            this.outstream.close();
        }
        this.instream = null;
        this.outstream = null;
    }

    private XFile getXFile(String s_nfs_url, boolean b_file_should_exist, boolean b_is_read_allowed, int[] i_ids, NetFileResource resourceBundle) throws NetFileException {
        XFile xfile = new XFile(s_nfs_url);
        XFileExtensionAccessor nfsx = new XFileExtensionAccessor(xfile);
        int i_uid = i_ids[0];
        int i_gid = i_ids[1];
        int[] i_gids = new int[]{i_gid};
        nfsx.loginUGID(i_uid, i_gid, i_gids);
        if (b_file_should_exist) {
            if (!xfile.exists()) {
                this.writeDebug(xfile.toString() + "," + xfile.getPath() + " does not exist");
                throw new NetFileException(500, resourceBundle.getString("nf.8", new Object[]{xfile.getPath()}));
            }
            this.writeDebug(xfile.getPath() + " exists");
        }
        if (b_is_read_allowed && !xfile.canRead()) {
            throw new NetFileException(500, resourceBundle.getString("nf.9", new Object[]{xfile.getPath()}));
        }
        return xfile;
    }

    private XFile getXFile(String VMSName, String machname, String file, boolean b_file_should_exist, boolean b_is_read_allowed, int[] i_ids, NetFileResource resourceBundle) throws NetFileException {
        this.writeDebug("Machine=" + machname + ",Share=" + VMSName + ",file=" + file);
        if (!VMSName.startsWith("/")) {
            VMSName = "/" + VMSName;
        }
        if (!file.startsWith("/")) {
            file = "/" + file;
        }
        this.writeDebug("Machine=" + machname + ",Share=" + VMSName + ",file=" + file);
        String s_nfs_url = this.getFileURL(VMSName, machname, file);
        this.writeDebug("File URL supplied to WebNFS is " + s_nfs_url);
        return this.getXFile(s_nfs_url, b_file_should_exist, b_is_read_allowed, i_ids, resourceBundle);
    }

    void rename(String username, String password, String machine, String share, String directory, String old_file_name, String new_file_name, NetFileResource resourceBundle) throws NetFileException {
        if (!this.doAuthenticate(username, password, resourceBundle)) {
            throw new NetFileException(500, resourceBundle.getString("nf.2"));
        }
        try {
            int[] i_ids = this.getUserIDs(username, password, resourceBundle);
            XFile xf_parent_directory = this.getXFile(share, machine, directory, true, SHOULD_HAVE_READ_PERMISSION, i_ids, resourceBundle);
            if (!xf_parent_directory.canWrite()) {
                throw new NetFileException(500, resourceBundle.getString("nf.10") + resourceBundle.getString("nf.7", new Object[]{xf_parent_directory.getPath()}));
            }
            XFile xf_file = this.getXFile(share, machine, directory + "/" + old_file_name, true, SHOULD_HAVE_READ_PERMISSION, i_ids, resourceBundle);
            if (!xf_file.canWrite()) {
                throw new NetFileException(500, resourceBundle.getString("nf.10") + resourceBundle.getString("nf.7", new Object[]{xf_parent_directory.getPath()}));
            }
            XFile xf_renamed_file = new XFile(xf_parent_directory, new_file_name);
            if (xf_renamed_file.exists()) {
                this.writeDebug(xf_renamed_file + " exists");
                if (!xf_renamed_file.canWrite()) {
                    throw new NetFileException(500, resourceBundle.getString("nf.7", new Object[]{xf_parent_directory.getPath()}));
                }
            }
            xf_file.renameTo(xf_renamed_file);
        }
        catch (Exception e) {
            this.writeErrorDebug("Error in putting NFS File", e);
            if (e instanceof NetFileException) {
                throw (NetFileException)e;
            }
            throw new NetFileException(500, resourceBundle.getString("nf.10") + resourceBundle.getString("nf.7", new Object[]{directory}));
        }
    }

    boolean doAuthenticate(String username, String passwd, NetFileResource resourceBundle) throws NetFileException {
        try {
            String osname = System.getProperty("os.name");
            if (this.debug.messageEnabled()) {
                this.debug.message("OS detected is:" + osname);
            }
            if (osname.indexOf("Linux") != -1 || osname.indexOf("SunOS") != -1) {
                if (this.debug.messageEnabled()) {
                    this.debug.message("Trying to do Native UNIX Auth");
                }
                boolean ret = false;
                ret = this.doNativeAuth(username, passwd);
                if (this.debug.messageEnabled()) {
                    this.debug.message("Native Auth code returned: " + ret);
                }
                return ret;
            }
            if (this.debug.messageEnabled()) {
                this.debug.message("Not UNIX OS, so not authenticating");
            }
            return true;
        }
        catch (Exception e) {
            this.writeErrorDebug("NfsFile, Exception while authenticating, ", e);
            return false;
        }
    }

    protected void writeDebug(String szMsg) {
        this.writeDebug(szMsg, null);
    }

    protected void writeDebug(String szMsg, Exception e) {
        if (this.debug != null && this.debug.messageEnabled()) {
            if (e != null) {
                this.debug.message(szMsg, (Throwable)e);
            } else {
                this.debug.message(szMsg);
            }
        }
    }

    protected void writeErrorDebug(String szError, Exception e) {
        if (this.debug != null) {
            if (e != null) {
                this.debug.error(szError, (Throwable)e);
            } else {
                this.debug.error(szError);
            }
        }
    }

    static {
        if (System.getProperty("os.name").indexOf("indows") == -1) {
            System.loadLibrary("getpwnam2");
        }
    }
}

