/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet.java2;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenListener;
import com.sun.portal.netfile.servlet.java2.FileOpenProcessor;
import com.sun.portal.netfile.servlet.java2.FileUploadProcessor;
import com.sun.portal.netfile.servlet.java2.RequestProcessor;
import com.sun.portal.netfile.servlet.java2.SerializedRequestProcessor;
import com.sun.portal.netfile.shared.NetFileException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public class NetFileServlet
extends HttpServlet {
    private static Vector interface_ip = null;
    private static final String LOCAL_HOST_IP = "127.0.0.1";
    private static final String DOWN_INTERFACE_IP = "0.0.0.0";
    private static Hashtable interface_server_cache = new Hashtable();
    public static Hashtable logManagerCache = new Hashtable();
    public static Hashtable uploadProcCache = new Hashtable();
    public static Hashtable tempDirCache = null;
    public static NetFileSessionClean nfSessClean = null;
    private Debug debug = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        tempDirCache = new Hashtable();
        NetFileServlet.runIfconfigA();
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
        nfSessClean = new NetFileSessionClean();
    }

    public static Vector getInterfaceIPs() {
        return interface_ip;
    }

    public static Object getInterface(String serverName) {
        if (serverName == null) {
            return null;
        }
        return interface_server_cache.get(serverName);
    }

    public static void setInterface(String nameOfServer, String nameOfInterface) {
        interface_server_cache.put(nameOfServer, nameOfInterface);
    }

    private static final void runIfconfigA() {
        boolean isWin = System.getProperty("os.name").toLowerCase().indexOf("window") != -1;
        boolean isLinux = System.getProperty("os.name").toLowerCase().indexOf("linux") != -1;
        try {
            Runtime rt = Runtime.getRuntime();
            Process ifconfig = isWin ? rt.exec("ipconfig -all") : rt.exec("ifconfig -a");
            Object s = null;
            boolean count = false;
            InputStream ifconfig_input_stream = ifconfig.getInputStream();
            InputStream ifconfig_error_stream = ifconfig.getErrorStream();
            BufferedReader ifconfig_br = new BufferedReader(new InputStreamReader(ifconfig_input_stream));
            String output_line = null;
            int index_of_inet = -1;
            String octet_1 = null;
            String octet_2 = null;
            String octet_3 = null;
            String octet_4 = null;
            int i_octet_1 = -1;
            int i_octet_2 = -1;
            int i_octet_3 = -1;
            int i_octet_4 = -1;
            interface_ip = new Vector();
            while ((output_line = ifconfig_br.readLine()) != null) {
                if (isWin) {
                    String ip;
                    int ipaddrindx = output_line.indexOf("IP Address", 0);
                    int icolonindx = output_line.indexOf(":", 0);
                    if (ipaddrindx < 0 || icolonindx < 0 || (ip = output_line.substring(icolonindx + 2).trim()).equals(LOCAL_HOST_IP) || ip.equals(DOWN_INTERFACE_IP)) continue;
                    StringTokenizer ip_octets = new StringTokenizer(ip, ".");
                    try {
                        octet_1 = ip_octets.nextToken();
                        octet_2 = ip_octets.nextToken();
                        octet_3 = ip_octets.nextToken();
                        octet_4 = ip_octets.nextToken();
                        i_octet_1 = Integer.parseInt(octet_1);
                        i_octet_2 = Integer.parseInt(octet_2);
                        i_octet_3 = Integer.parseInt(octet_3);
                        i_octet_4 = Integer.parseInt(octet_4);
                        interface_ip.add(ip);
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (output_line.indexOf("inet6") > -1 || (index_of_inet = output_line.indexOf("inet")) < 0) continue;
                StringTokenizer tokens = new StringTokenizer(output_line);
                tokens.nextToken();
                String ip = tokens.nextToken();
                if (isLinux && ip.indexOf("addr:") > -1) {
                    ip = ip.substring(5);
                }
                if (ip.equals(LOCAL_HOST_IP) || ip.equals(DOWN_INTERFACE_IP)) continue;
                StringTokenizer ip_octets = new StringTokenizer(ip, ".");
                try {
                    octet_1 = ip_octets.nextToken();
                    octet_2 = ip_octets.nextToken();
                    octet_3 = ip_octets.nextToken();
                    octet_4 = ip_octets.nextToken();
                    i_octet_1 = Integer.parseInt(octet_1);
                    i_octet_2 = Integer.parseInt(octet_2);
                    i_octet_3 = Integer.parseInt(octet_3);
                    i_octet_4 = Integer.parseInt(octet_4);
                    interface_ip.add(ip);
                }
                catch (Exception e) {}
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.writeDebug("\n Reached doGet() \n");
        this.handleRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.writeDebug("\n Reached doPost() \n");
        this.handleRequest(request, response);
    }

    public void destroy() {
        logManagerCache = null;
        interface_server_cache = null;
    }

    void handleRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block7: {
            RequestProcessor reqProc = null;
            try {
                this.writeDebug("Reached Handle Request \n");
                try {
                    reqProc = this.fetchProtocolHandler(req);
                    if (reqProc == null) {
                        this.writeErrorResponse(req, res, "Invalid Request.");
                        return;
                    }
                }
                catch (Exception e) {
                    this.writeDebug("NetFileServlet::Exception in request processor", e);
                    throw new NetFileException(3, e.getMessage());
                }
                reqProc.processRequest(req, res, null);
                return;
            }
            catch (NetFileException nfe) {
                this.writeErrorDebug("NetFileException in handleRequest of NetFileServlet", nfe);
                if (reqProc != null) {
                    reqProc = null;
                }
            }
            catch (Exception e) {
                this.writeErrorDebug("Exception in handleRequest of NetFileServlet", e);
                if (reqProc == null) break block7;
                reqProc = null;
            }
        }
    }

    RequestProcessor fetchProtocolHandler(HttpServletRequest request) throws NetFileException {
        try {
            String version = request.getHeader("NetFileProtocolVersion");
            this.writeDebug("\n Protocol Version is:" + version);
            if (version == null) {
                String queryString = request.getQueryString();
                Hashtable queryData = HttpUtils.parseQueryString((String)queryString);
                String[] streamType = (String[])queryData.get("stream");
                String[] action = (String[])queryData.get("action");
                String[] id = (String[])queryData.get("id");
                if (action[0].equals("upload")) {
                    if (streamType[0].equals("plain")) {
                        Object object = uploadProcCache.get(id[0]);
                        if (object == null) {
                            object = new FileUploadProcessor("HTTP_JAVA2_PLAIN" + id[0]);
                            uploadProcCache.put(id[0], object);
                        }
                        return (RequestProcessor)object;
                    }
                } else if (action[0].equals("open") && streamType[0].equals("object")) {
                    return new FileOpenProcessor("HTTP_JAVA2_OBJECT");
                }
            }
            if (version.endsWith("HTTP_JAVA_SERIALIZE")) {
                return new SerializedRequestProcessor(version);
            }
        }
        catch (Exception e) {
            this.writeErrorDebug("NetFileServlet: Invalid request", e);
            throw new NetFileException(3, "Error in getting version information." + e.getMessage());
        }
        return null;
    }

    private void writeErrorResponse(HttpServletRequest request, HttpServletResponse response, String errMsg) throws IOException {
        Locale defaultLocale = Locale.getDefault();
        ResourceBundle userResources = ResourceBundle.getBundle("srapNetFileServletJava2", defaultLocale);
    }

    protected void writeDebug(String szMsg) {
        this.writeDebug(szMsg, null);
    }

    protected void writeDebug(String szMsg, Exception e) {
        if (this.debug != null && this.debug.messageEnabled()) {
            if (e != null) {
                this.debug.message(szMsg, (Throwable)e);
            } else {
                this.debug.message(szMsg);
            }
        }
    }

    protected void writeErrorDebug(String szError, Exception e) {
        if (this.debug != null) {
            if (e != null) {
                this.debug.error(szError, (Throwable)e);
            } else {
                this.debug.error(szError);
            }
        }
    }

    public static void putTempDirCache(String ssoToken, String szTempDir) {
        tempDirCache.put(ssoToken, szTempDir);
    }

    public static NetFileSessionClean getNetFileSessionCleaner() {
        return nfSessClean;
    }

    class NetFileSessionClean
    implements SSOTokenListener {
        NetFileSessionClean() {
        }

        private boolean doCleanUp(String szLocalFileName) {
            if (szLocalFileName == null) {
                return false;
            }
            try {
                File localFile = new File(szLocalFileName);
                File tempFile = null;
                if (localFile.exists()) {
                    File[] filesList = localFile.listFiles();
                    for (int i = 0; i < filesList.length; ++i) {
                        tempFile = filesList[i];
                        if (tempFile.exists()) {
                            tempFile.delete();
                        }
                        tempFile = null;
                    }
                    localFile.delete();
                }
                return true;
            }
            catch (Exception e) {
                if (NetFileServlet.this.debug.messageEnabled()) {
                    NetFileServlet.this.debug.message("Exception in deleting temp file", (Throwable)e);
                }
                return false;
            }
        }

        public void ssoTokenChanged(SSOTokenEvent event) {
            String szTempDir = "";
            try {
                SSOToken token = event.getToken();
                String tokenId = token.getTokenID().toString();
                int type = event.getType();
                switch (type) {
                    case 1: 
                    case 2: 
                    case 3: {
                        try {
                            logManagerCache.remove(tokenId);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        szTempDir = tempDirCache.get(tokenId).toString();
                        if (szTempDir == null && szTempDir.trim().length() != 0 && szTempDir.equals("null")) break;
                        this.doCleanUp(szTempDir);
                        if (!NetFileServlet.this.debug.messageEnabled()) break;
                        NetFileServlet.this.debug.message("Deleting temporary directory location " + szTempDir + " for " + tokenId);
                    }
                }
            }
            catch (Exception e) {
                NetFileServlet.this.debug.message("Exception in deleting temporary directory ", (Throwable)e);
            }
        }
    }
}

