/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet.java2;

import com.iplanet.am.util.Debug;
import com.sun.portal.netfile.servlet.java2.NetFileServlet;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.net.TelnetInputStream;
import sun.net.TelnetOutputStream;
import sun.net.TransferProtocolClient;

public class FullFtpClient
extends TransferProtocolClient {
    private String machineName = null;
    private static final String HOST_NOT_FOUND = "Server Address could not be resolved";
    private static final String HOST_NO_MATCH = "Server IP Address does not match an network address of iPS";
    public static final int FTP_PORT = 21;
    static int FTP_SUCCESS = 1;
    static int FTP_TRY_AGAIN = 2;
    static int FTP_ERROR = 3;
    private Socket sock = null;
    private boolean replyPending = false;
    private boolean binaryMode = true;
    String user = null;
    String password = null;
    String command;
    int lastReplyCode;
    public String welcomeMsg;
    public String machine_encoding = "UTF8";
    OutputStreamWriter opsw_server;
    protected static Debug debug = null;

    private void setDebug() {
        if (debug == null) {
            debug = Debug.getInstance((String)"srapNetFile");
        }
    }

    public FullFtpClient(String host, String machine_encoding) throws IOException {
        this(host, 21, machine_encoding);
    }

    public FullFtpClient(String host, int port, String machine_encoding) throws IOException {
        this.setDebug();
        this.machine_encoding = machine_encoding;
        this.openServerOnPort(host, port);
    }

    public void cdup() throws IOException {
        this.issueCommandCheck("CDUP");
    }

    public void mkdir(String s) throws IOException {
        this.issueCommandCheck("MKD " + s);
    }

    public void rmdir(String s) throws IOException {
        this.issueCommandCheck("RMD " + s);
    }

    public void delete(String s) throws IOException {
        this.issueCommandCheck("DELE " + s);
    }

    public void rename(String old_name, String new_name) throws IOException {
        this.issueCommandCheck("RNFR " + old_name);
        this.issueCommandCheck("RNTO " + new_name);
    }

    public String pwd() throws IOException {
        this.issueCommandCheck("PWD");
        StringBuffer result = new StringBuffer();
        Enumeration e = this.serverResponse.elements();
        while (e.hasMoreElements()) {
            result.append((String)e.nextElement());
        }
        return result.toString();
    }

    public TelnetOutputStream put(String filename) throws IOException {
        this.sock = this.openDataConnection("STOR " + filename);
        return new TelnetOutputStream(this.sock.getOutputStream(), this.binaryMode);
    }

    public TelnetOutputStream append(String filename) throws IOException {
        this.sock = this.openDataConnection("APPE " + filename);
        return new TelnetOutputStream(this.sock.getOutputStream(), this.binaryMode);
    }

    public TelnetInputStream list() throws IOException {
        this.sock = this.openDataConnection("LIST");
        return new TelnetInputStream(this.sock.getInputStream(), this.binaryMode);
    }

    public void cd(String remoteDirectory) throws IOException {
        this.issueCommandCheck("CWD " + remoteDirectory);
    }

    public void binary() throws IOException {
        this.issueCommandCheck("TYPE I");
        this.binaryMode = true;
    }

    public void ascii() throws IOException {
        this.issueCommandCheck("TYPE A");
        this.binaryMode = false;
    }

    public TelnetInputStream nlist() throws IOException {
        Socket s = this.openDataConnection("NLST -a");
        return new TelnetInputStream(s.getInputStream(), false);
    }

    public TelnetInputStream list(boolean list_al) throws IOException {
        Socket s = this.openDataConnection("LIST -al");
        return new TelnetInputStream(s.getInputStream(), false);
    }

    public TelnetInputStream list(String filename) throws IOException {
        Socket s = this.openDataConnection("LIST -al " + filename);
        return new TelnetInputStream(s.getInputStream(), false);
    }

    public void quit() throws IOException {
        if (this.serverIsOpen()) {
            this.issueCommand("QUIT");
            this.closeServer();
        }
    }

    public void login(String user, String password) throws IOException {
        if (!this.serverIsOpen()) {
            throw new IOException("not connected to host");
        }
        this.user = user;
        this.password = password;
        if (this.issueCommand("USER " + user) == FTP_ERROR) {
            throw new IOException("user");
        }
        if (password != null && this.issueCommand("PASS " + password) == FTP_ERROR) {
            throw new IOException("password");
        }
        for (int i = 0; i < this.serverResponse.size(); ++i) {
            String l = (String)this.serverResponse.elementAt(i);
            if (l == null) continue;
            if (l.charAt(3) != '-') break;
            l = l.substring(4);
            this.welcomeMsg = this.welcomeMsg == null ? l : this.welcomeMsg + l;
        }
    }

    public TelnetInputStream get(String filename) throws IOException {
        try {
            this.sock = this.openDataConnection("RETR " + filename);
        }
        catch (FileNotFoundException fileException) {
            StringTokenizer t = new StringTokenizer(filename, "/");
            String pathElement = null;
            while (t.hasMoreElements()) {
                pathElement = t.nextToken();
                if (!t.hasMoreElements()) break;
                try {
                    this.cd(pathElement);
                }
                catch (IOException e) {
                    throw fileException;
                }
            }
            if (pathElement != null) {
                this.sock = this.openDataConnection("RETR " + pathElement);
            }
            throw fileException;
        }
        return new TelnetInputStream(this.sock.getInputStream(), this.binaryMode);
    }

    protected Socket openDataConnection(String s) throws IOException {
        int FTP_ERROR = 3;
        int numOtherNames = 0;
        boolean count = false;
        Socket dataSocket = null;
        ServerSocket dataServerSock = null;
        InetAddress theAddress = null;
        int foundFlag = 0;
        byte[] abyte0 = null;
        String interfaceIP_touse = null;
        String ftpServerName = null;
        Vector ipaddresses = null;
        InetAddress otherName = null;
        ftpServerName = (String)this.getMachineToAccess();
        if (ftpServerName != null) {
            try {
                interfaceIP_touse = (String)NetFileServlet.getInterface(ftpServerName);
            }
            catch (NullPointerException npe) {
                this.writeDebug("Interface to use for " + ftpServerName + " not cached. Interface determination started.");
            }
            if (interfaceIP_touse != null) {
                dataSocket = this.openCachedDataConnection(s, interfaceIP_touse);
                return dataSocket;
            }
        }
        if ((ipaddresses = NetFileServlet.getInterfaceIPs()) == null) {
            IOException ftpprotocolexception1 = new IOException("NO INTERFACES");
            throw ftpprotocolexception1;
        }
        interfaceIP_touse = this.findInterface(ftpServerName, ipaddresses);
        if (interfaceIP_touse.equalsIgnoreCase(HOST_NO_MATCH)) {
            this.writeDebug(ftpServerName + " does not match any subnetwork of iPS. Going ahead and trying on all interfaces");
            numOtherNames = ipaddresses.size();
        } else if (interfaceIP_touse.equalsIgnoreCase(HOST_NOT_FOUND)) {
            this.writeDebug(ftpServerName + " could not be resolved/found. Going ahead and trying on all interfaces");
            numOtherNames = ipaddresses.size();
        } else {
            numOtherNames = 1;
            dataSocket = this.openCachedDataConnection(s, interfaceIP_touse);
            NetFileServlet.setInterface(ftpServerName, interfaceIP_touse);
            return dataSocket;
        }
        this.writeDebug("Number of Interfaces available:  " + numOtherNames);
        do {
            theAddress = otherName = InetAddress.getByName((String)ipaddresses.get(numOtherNames - 1));
            abyte0 = theAddress.getAddress();
            boolean boundFlag = false;
            while (!boundFlag) {
                try {
                    dataServerSock = new ServerSocket(0, 1, theAddress);
                    foundFlag = 1;
                    boundFlag = true;
                }
                catch (BindException be) {
                    this.writeDebug("Could not bind on HostAddress " + theAddress.getHostAddress() + ". Address is " + theAddress.getAddress());
                    foundFlag = 0;
                }
            }
            String s1 = "PORT ";
            for (int i = 0; i < abyte0.length; ++i) {
                s1 = s1 + (abyte0[i] & 0xFF) + ",";
            }
            s1 = s1 + (dataServerSock.getLocalPort() >>> 8 & 0xFF) + "," + (dataServerSock.getLocalPort() & 0xFF);
            this.writeDebug("Port Command Issued: " + s1);
            this.writeDebug("Host Name Socket is listening on: " + dataServerSock.getInetAddress().getHostName());
            this.writeDebug("Port Socket is listening on: " + dataServerSock.getLocalPort());
            this.writeDebug("IP Address socket is listening on: " + dataServerSock.getInetAddress().getHostAddress());
            if (this.issueCommand(s1) == FTP_ERROR) {
                this.writeDebug("Port Command Failed");
                IOException ftpprotocolexception = new IOException("PORT");
                if (dataServerSock != null) {
                    dataServerSock.close();
                }
                foundFlag = FTP_ERROR;
                throw ftpprotocolexception;
            }
            if (this.issueCommand(s) == FTP_ERROR) {
                this.writeDebug("Data Command sent. Output data from FTP Server not received.");
                foundFlag = 0;
                if (--numOtherNames != 0 || foundFlag == 1) continue;
                IOException ftpprotocolexception = new IOException("HOST");
                this.writeDebug(ftpprotocolexception.getMessage());
                if (dataServerSock == null) continue;
                dataServerSock.close();
                continue;
            }
            this.writeDebug("Output Data has arrived. So accepting it");
            dataSocket = dataServerSock.accept();
            dataServerSock.close();
            NetFileServlet.setInterface((String)this.getMachineToAccess(), (String)ipaddresses.get(numOtherNames - 1));
            foundFlag = 1;
        } while (foundFlag == 0 && numOtherNames != 0);
        return dataSocket;
    }

    protected Socket openCachedDataConnection(String s, String interface_touse) throws IOException {
        int FTP_ERROR = 3;
        boolean boundFlag = false;
        ServerSocket dataServerSock = null;
        Socket dataSocket = null;
        byte[] abyte0 = null;
        InetAddress theAddress = InetAddress.getByName(interface_touse);
        abyte0 = theAddress.getAddress();
        while (!boundFlag) {
            try {
                dataServerSock = new ServerSocket(0, 1, theAddress);
                boundFlag = true;
            }
            catch (BindException be) {
                this.writeDebug("Could not bind on HostAddress " + theAddress.getHostAddress() + ".  Address is " + theAddress.getAddress());
            }
        }
        String s1 = "PORT ";
        for (int i = 0; i < abyte0.length; ++i) {
            s1 = s1 + (abyte0[i] & 0xFF) + ",";
        }
        if (this.issueCommand(s1 = s1 + (dataServerSock.getLocalPort() >>> 8 & 0xFF) + "," + (dataServerSock.getLocalPort() & 0xFF)) == FTP_ERROR) {
            this.writeDebug("Port Command Failed");
            IOException ftpprotocolexception = new IOException("PORT");
            if (dataServerSock != null) {
                dataServerSock.close();
            }
            throw ftpprotocolexception;
        }
        if (this.issueCommand(s) == FTP_ERROR) {
            this.writeDebug("Data Command sent. Output data from FTP Server not received.");
            IOException ftpprotocolexception = new IOException("HOST");
            if (dataServerSock != null) {
                dataServerSock.close();
            }
            throw ftpprotocolexception;
        }
        this.writeDebug("Data has arrived. So accepting it");
        dataSocket = dataServerSock.accept();
        dataServerSock.close();
        return dataSocket;
    }

    public void setMachineToAccess(String machName) {
        this.machineName = machName;
    }

    public Object getMachineToAccess() {
        return this.machineName;
    }

    protected String findInterface(String nameOfServer, Vector interfaceIPs) {
        InetAddress[] inetAddr = null;
        try {
            inetAddr = InetAddress.getAllByName(nameOfServer);
        }
        catch (UnknownHostException uhe) {
            this.writeDebug("Unknown host", uhe);
            return HOST_NOT_FOUND;
        }
        if (inetAddr == null) {
            return HOST_NOT_FOUND;
        }
        for (int interfacesCount = 0; interfacesCount < interfaceIPs.size() - 1; ++interfacesCount) {
            for (int serversCount = inetAddr.length; serversCount > 0; --serversCount) {
                String serverIPAddr = inetAddr[serversCount - 1].getHostAddress();
                String interfaceIPAddr = (String)interfaceIPs.get(interfacesCount);
                if (!serverIPAddr.substring(0, serverIPAddr.lastIndexOf(".")).equalsIgnoreCase(interfaceIPAddr.substring(0, interfaceIPAddr.lastIndexOf(".")))) continue;
                return interfaceIPAddr;
            }
        }
        return HOST_NO_MATCH;
    }

    protected int issueCommand(String cmd) throws IOException {
        int reply;
        this.command = cmd;
        if (this.replyPending && this.readReply() == FTP_ERROR) {
            debug.error("Error reading FTP pending reply\n");
        }
        this.replyPending = false;
        do {
            this.sendServer(cmd + "\r\n");
            reply = this.readReply();
            if (!debug.messageEnabled()) continue;
            if (cmd.indexOf("PASS") < 0) {
                debug.message("Reply Code received is " + this.lastReplyCode + " for " + cmd);
                continue;
            }
            debug.message("Reply Code received is " + this.lastReplyCode + " for PASS");
        } while (reply == FTP_TRY_AGAIN);
        return reply;
    }

    protected void issueCommandCheck(String cmd) throws IOException {
        if (this.issueCommand(cmd) != FTP_SUCCESS) {
            throw new IOException(cmd);
        }
    }

    protected int readReply() throws IOException {
        this.lastReplyCode = this.readServerResponse();
        switch (this.lastReplyCode / 100) {
            case 1: {
                this.replyPending = true;
            }
            case 2: 
            case 3: {
                return FTP_SUCCESS;
            }
            case 5: {
                if (this.lastReplyCode == 530) {
                    if (this.user == null) {
                        throw new IOException("Not logged in");
                    }
                    return FTP_ERROR;
                }
                if (this.lastReplyCode == 550) {
                    throw new FileNotFoundException(this.command + ": " + this.getResponseString());
                }
                if (this.lastReplyCode != 553) break;
                throw new FileNotFoundException(this.command + ": " + this.getResponseString());
            }
        }
        return FTP_ERROR;
    }

    public void openServer(String host) throws IOException {
        int port = 21;
        this.openServer(host, port);
    }

    public void openServerOnPort(String host, int port) throws IOException {
        this.openServer(host, port);
        if (this.readReply() == FTP_ERROR) {
            throw new IOException("Welcome message");
        }
    }

    public void openServer(String server, int port) throws IOException, UnknownHostException {
        block4: {
            try {
                if (this.serverSocket != null) {
                    this.quit();
                }
                this.serverSocket = this.doConnect(server, port);
                this.opsw_server = new OutputStreamWriter(this.serverSocket.getOutputStream(), this.machine_encoding);
                this.serverInput = new BufferedInputStream(this.serverSocket.getInputStream());
            }
            catch (Exception e) {
                this.writeDebug("Exception in opening connection to FTP server", e);
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (!(e instanceof UnknownHostException)) break block4;
                throw (UnknownHostException)e;
            }
        }
    }

    public void closeDataConnection() {
        try {
            if (this.sock != null) {
                this.sock.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sock = null;
    }

    public void closeServer() {
        if (!this.serverIsOpen()) {
            return;
        }
        try {
            if (this.opsw_server != null) {
                this.opsw_server.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.serverInput != null) {
                this.serverInput.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closeDataConnection();
        this.serverSocket = null;
        this.serverInput = null;
        this.opsw_server = null;
        this.writeDebug("Connection to FTP server closed");
    }

    public void sendServer(String cmd) {
        try {
            this.opsw_server.write(cmd);
            this.opsw_server.flush();
        }
        catch (Exception e) {
            this.writeDebug("Exception in sending command to the server", e);
        }
    }

    protected void writeDebug(String szMsg) {
        this.writeDebug(szMsg, null);
    }

    protected void writeDebug(String szMsg, Exception e) {
        if (debug != null && debug.messageEnabled()) {
            if (e != null) {
                debug.message(szMsg, (Throwable)e);
            } else {
                debug.message(szMsg);
            }
        }
    }

    protected void writeErrorDebug(String szError, Exception e) {
        if (debug != null) {
            if (e != null) {
                debug.error(szError, (Throwable)e);
            } else {
                debug.error(szError);
            }
        }
    }
}

