/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet.java2;

import com.iplanet.am.util.Debug;
import com.sun.portal.netfile.servlet.java2.FullFtpClient;
import com.sun.portal.netfile.servlet.java2.NetFileResource;
import com.sun.portal.netfile.shared.NetFileException;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import sun.net.TelnetInputStream;
import sun.net.TelnetOutputStream;

class FtpFile {
    private NetFileResource nfRes = null;
    protected Debug debug = null;
    protected String szEncoding;
    protected FullFtpClient ffc = null;
    protected int intDirsTraversed = 0;
    protected ArrayList alSearchResults = new ArrayList();

    FtpFile(String szMachineEncoding) {
        this.szEncoding = szMachineEncoding;
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
    }

    String[] searchFTPDir(String usernam, String passwrd, String machnam, String VMSnam, String pattern, String dir_nam, int maxsrchdir, NetFileResource nfrUsrResBundle) throws NetFileException {
        this.nfRes = nfrUsrResBundle;
        this.ffc = this.initialiseFtpClient(usernam, passwrd, machnam, VMSnam, dir_nam);
        this.search(usernam, passwrd, machnam, VMSnam, pattern, dir_nam, maxsrchdir, nfrUsrResBundle);
        if (this.intDirsTraversed > maxsrchdir) {
            String[] searchResults = new String[this.alSearchResults.size() + 1];
            searchResults[0] = "ERROR:" + nfrUsrResBundle.getString("maxSearch");
            for (int j = 1; j < searchResults.length; ++j) {
                searchResults[j] = (String)this.alSearchResults.get(j - 1);
            }
            return searchResults;
        }
        if (this.alSearchResults.size() == 0) {
            return new String[]{"        "};
        }
        String[] sa_results = new String[this.alSearchResults.size()];
        for (int j = 0; j < sa_results.length; ++j) {
            sa_results[j] = (String)this.alSearchResults.get(j);
        }
        return sa_results;
    }

    void search(String usernam, String passwrd, String machnam, String VMSnam, String pattern, String dir_nam, int maxsrchdir, NetFileResource nfrUsrResBundle) throws NetFileException {
        try {
            ++this.intDirsTraversed;
            this.writeDebug("Directory number being searched = " + this.intDirsTraversed, null);
            if (this.intDirsTraversed > maxsrchdir) {
                return;
            }
            String[] sa_file_listing = this.getFTPDir(usernam, passwrd, machnam, VMSnam, dir_nam, nfrUsrResBundle, false);
            if (sa_file_listing == null || sa_file_listing.length < 0) {
                return;
            }
            for (int i = 0; i < sa_file_listing.length && this.intDirsTraversed <= maxsrchdir && sa_file_listing[i] != null; i += 4) {
                if (sa_file_listing[i].equalsIgnoreCase("d")) {
                    String s_error = "";
                    String s_directory = dir_nam + "/" + sa_file_listing[i + 1];
                    try {
                        this.writeDebug("Changing to directory " + s_directory + " to search", null);
                        this.search(usernam, passwrd, machnam, VMSnam, pattern, s_directory, maxsrchdir, nfrUsrResBundle);
                    }
                    catch (NetFileException nfe) {
                        if (this.intDirsTraversed < maxsrchdir) continue;
                        throw nfe;
                    }
                    catch (Exception e) {
                        this.writeErrorDebug("Exception in searching directory " + s_directory + " in " + VMSnam, e);
                        s_error = "(" + nfrUsrResBundle.getString("error13") + ")";
                    }
                    if (sa_file_listing[i + 1].indexOf(pattern) <= -1) continue;
                    this.alSearchResults.add("/" + VMSnam + s_directory + "/" + s_error);
                    continue;
                }
                if (sa_file_listing[i + 1].indexOf(pattern) <= -1) continue;
                this.writeDebug("Adding " + sa_file_listing[i + 1] + " to search results", null);
                this.alSearchResults.add("/" + VMSnam + dir_nam + "/" + sa_file_listing[i + 1]);
            }
        }
        catch (NetFileException nfe) {
            if (this.intDirsTraversed >= maxsrchdir) {
                throw nfe;
            }
        }
        catch (Exception e) {
            this.writeErrorDebug("Exception in searching " + VMSnam + dir_nam + "/", e);
            throw new NetFileException(500, nfrUsrResBundle.getString("ff.1", new Object[]{VMSnam, dir_nam}));
        }
    }

    InputStream getInputFTPStream(String usernam, String passwrd, String machnam, String VMSnam, String mainfilenam, String dir_nam, NetFileResource nfrUsrResBundle) throws NetFileException {
        Exception e = null;
        TelnetInputStream ftpin = null;
        this.nfRes = nfrUsrResBundle;
        try {
            this.ffc = this.initialiseFtpClient(usernam, passwrd, machnam, VMSnam, dir_nam);
            ftpin = this.ffc.get(mainfilenam);
        }
        catch (Exception ex) {
            e = ex;
            this.performFinalProcessing(e, "Exceptione obtaining the FTP file", this.ffc);
        }
        return ftpin;
    }

    OutputStream getOutputFTPStream(String usernam, String passwrd, String machnam, String VMSnam, String remotefil_arg, String dir_nam, NetFileResource nfrUsrResBundle) throws NetFileException {
        return this.getOutputFTPStream(usernam, passwrd, machnam, VMSnam, remotefil_arg, dir_nam, nfrUsrResBundle, false);
    }

    OutputStream getOutputFTPStream(String usernam, String passwrd, String machnam, String VMSnam, String remotefil_arg, String dir_nam, NetFileResource nfrUsrResBundle, boolean append) throws NetFileException {
        Exception e = null;
        TelnetOutputStream ftpout = null;
        this.nfRes = nfrUsrResBundle;
        try {
            this.ffc = this.initialiseFtpClient(usernam, passwrd, machnam, VMSnam, dir_nam);
            ftpout = append ? this.ffc.append(remotefil_arg) : this.ffc.put(remotefil_arg);
        }
        catch (Exception ex) {
            e = ex;
            this.performFinalProcessing(e, "Could upload file", this.ffc);
        }
        return ftpout;
    }

    void closeFtpFile() {
        try {
            if (this.ffc != null) {
                this.ffc.quit();
            }
            this.ffc = null;
        }
        catch (IOException ioe) {
            this.ffc = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    String getFTPFile(String usernam, String passwrd, String machnam, String VMSnam, String mainfilenam, String dir_nam, String tmpdir, NetFileResource nfrUsrResBundle, String usersession) throws NetFileException {
        String mknodfilename;
        block24: {
            ByteArrayOutputStream buftxt;
            FilterOutputStream bos;
            InputStream instream;
            FullFtpClient nfFtpClient;
            Exception e;
            block23: {
                int c;
                mknodfilename = "";
                String txtouting = "";
                e = null;
                nfFtpClient = null;
                instream = null;
                bos = null;
                buftxt = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                this.nfRes = nfrUsrResBundle;
                Long random = new Long(System.currentTimeMillis());
                mknodfilename = tmpdir + "/" + random.toString() + usernam.toUpperCase() + mainfilenam;
                File newfil = new File(mknodfilename);
                if (newfil.exists()) {
                    newfil.delete();
                }
                bos = new BufferedOutputStream(new FileOutputStream(newfil));
                nfFtpClient = this.initialiseFtpClient(usernam, passwrd, machnam, VMSnam, dir_nam);
                instream = nfFtpClient.get(mainfilenam);
                while ((c = instream.read(buffer)) > -1) {
                    ((BufferedOutputStream)bos).write(buffer, 0, c);
                    buftxt.write(buffer, 0, c);
                }
                instream.close();
                ((BufferedOutputStream)bos).flush();
                bos.close();
                txtouting = buftxt.toString();
                if (!txtouting.startsWith("ERROR:") && txtouting.indexOf(nfrUsrResBundle.getString("permissiondenied")) < 0 && txtouting.indexOf(nfrUsrResBundle.getString("nosuchfile")) < 0) break block23;
                String string = "ERROR:" + nfrUsrResBundle.getString("error6");
                Object var23_23 = null;
                try {
                    if (instream != null) {
                        instream.close();
                    }
                    if (bos != null) {
                        bos.close();
                    }
                    if (buftxt != null) {
                        buftxt.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return string;
            }
            Object var23_24 = null;
            try {
                if (instream != null) {
                    instream.close();
                }
                if (bos != null) {
                    bos.close();
                }
                if (buftxt != null) {
                    buftxt.close();
                }
                break block24;
            }
            catch (IOException ioe) {}
            break block24;
            {
                catch (Exception ex) {
                    e = ex;
                    this.performFinalProcessing(e, nfrUsrResBundle.getString("ff.4"), nfFtpClient);
                    Object var23_25 = null;
                    try {
                        if (instream != null) {
                            instream.close();
                        }
                        if (bos != null) {
                            bos.close();
                        }
                        if (buftxt != null) {
                            buftxt.close();
                        }
                        break block24;
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (Throwable throwable) {
                Object var23_26 = null;
                try {
                    if (instream != null) {
                        instream.close();
                    }
                    if (bos != null) {
                        bos.close();
                    }
                    if (buftxt != null) {
                        buftxt.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return mknodfilename;
    }

    String delFTPFile(String username, String password, String machine, String share, String szDelFileName, String directory, NetFileResource nfrUsrResBundle) throws NetFileException {
        FullFtpClient fullFtpClient = null;
        Exception e = null;
        this.nfRes = nfrUsrResBundle;
        try {
            fullFtpClient = this.initialiseFtpClient(username, password, machine, share, directory);
            fullFtpClient.delete(szDelFileName);
            fullFtpClient.closeServer();
        }
        catch (Exception ex) {
            e = ex;
            this.performFinalProcessing(e, nfrUsrResBundle.getString("ff.5", new Object[]{szDelFileName}), fullFtpClient);
        }
        return nfrUsrResBundle.getString("FileDeleted");
    }

    String delFTPFolder(String username, String password, String machine, String share, String directory, NetFileResource nfrUsrResBundle) throws NetFileException {
        FullFtpClient fullFtpClient = null;
        Exception e = null;
        this.nfRes = nfrUsrResBundle;
        try {
            fullFtpClient = this.initialiseFtpClient(username, password, machine, share, directory);
            fullFtpClient.cdup();
            String tmp = directory.substring(directory.lastIndexOf("/") + 1);
            fullFtpClient.rmdir(tmp);
            fullFtpClient.closeServer();
        }
        catch (Exception ex) {
            e = ex;
            this.performFinalProcessing(e, nfrUsrResBundle.getString("ff.5", new Object[]{directory}), fullFtpClient);
        }
        return "FolderDeleted";
    }

    public String[] getFTPDir(String username, String password, String machname, String VMSname, String dirS, NetFileResource nfrUsrResBundle) throws NetFileException {
        return this.getFTPDir(username, password, machname, VMSname, dirS, nfrUsrResBundle, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getFTPDir(String username, String password, String machname, String VMSname, String dirS, NetFileResource nfrUsrResBundle, boolean closeConn) throws NetFileException {
        FullFtpClient full_ftp_client = null;
        Exception e = null;
        String[] file_listing = new String[]{};
        this.nfRes = nfrUsrResBundle;
        try {
            if (this.ffc == null) {
                full_ftp_client = this.initialiseFtpClient(username, password, machname, VMSname, dirS);
            } else {
                full_ftp_client = this.ffc;
                full_ftp_client.cd(VMSname + dirS);
            }
            List names_list = this.getNamesList(full_ftp_client);
            List full_listing = this.getList(full_ftp_client, false);
            String[][] listing = this.processListings(names_list, full_listing);
            int number_of_files = names_list.size();
            file_listing = new String[number_of_files * 4];
            int j = 0;
            for (int i = 0; i < number_of_files; ++i) {
                if (listing[i][1].equals("..") || listing[i][1].startsWith(".")) continue;
                file_listing[j++] = listing[i][0];
                file_listing[j++] = listing[i][1];
                file_listing[j++] = listing[i][3];
                file_listing[j++] = listing[i][2];
            }
        }
        catch (Exception ex) {
            e = ex;
        }
        finally {
            if (closeConn) {
                try {
                    full_ftp_client.quit();
                }
                catch (Exception ge) {}
            }
        }
        this.performFinalProcessing(e, nfrUsrResBundle.getString("ff.6"), full_ftp_client);
        return file_listing;
    }

    private List getNamesList(FullFtpClient full_ftp_client) throws Exception {
        return this.getList(full_ftp_client, true);
    }

    private List getList(FullFtpClient full_ftp_client, boolean names_only) throws Exception {
        if (full_ftp_client == null) {
            throw new IllegalArgumentException("null full ftp client");
        }
        TelnetInputStream list = null;
        ArrayList<String> v_list = new ArrayList<String>();
        list = names_only ? full_ftp_client.nlist() : full_ftp_client.list(true);
        InputStreamReader ipsr_list = new InputStreamReader((InputStream)list, this.szEncoding);
        BufferedReader br_list = new BufferedReader(ipsr_list);
        String s_input_line = null;
        while ((s_input_line = br_list.readLine()) != null) {
            v_list.add(s_input_line);
        }
        br_list.close();
        ipsr_list.close();
        list.close();
        s_input_line = null;
        br_list = null;
        ipsr_list = null;
        list = null;
        return v_list;
    }

    private String[][] processListings(List v_file_names, List v_full_listing) throws Exception {
        int listing_size = v_full_listing.size();
        if (listing_size <= 0) {
            return new String[0][];
        }
        String last_entry = (String)v_full_listing.get(listing_size - 1);
        boolean is_windows = !last_entry.startsWith("-") && !last_entry.startsWith("d") && !last_entry.startsWith("l") && !last_entry.startsWith("d") && !last_entry.startsWith("b") && !last_entry.startsWith("c") && !last_entry.startsWith("p") && !last_entry.startsWith("s") && !last_entry.startsWith("D");
        String[][] listing = null;
        listing = is_windows ? this.processMSDirectoryListingType(v_file_names, v_full_listing) : this.processUnixDirectoryListingType(v_file_names, v_full_listing);
        return listing;
    }

    private void mergeListing(List fileListing, List fullListing) {
        int fileIndex = 0;
        int listingIndex = 0;
        while (fileIndex < fileListing.size()) {
            String fileName = (String)fileListing.get(fileIndex);
            String fullListingRow = (String)fullListing.get(listingIndex);
            if (fullListingRow.indexOf(fileName) == -1) {
                do {
                    fullListing.remove(listingIndex);
                } while ((fullListingRow = (String)fullListing.get(listingIndex)).indexOf(fileName) == -1);
                --fileIndex;
                --listingIndex;
            }
            ++fileIndex;
            ++listingIndex;
        }
    }

    private String getModifiedDateFormat(String modifiedTime) {
        Date d;
        if (modifiedTime.indexOf(45) != -1) {
            SimpleDateFormat format = new SimpleDateFormat("MM-dd-yy hh:mma");
            format.setCalendar(new GregorianCalendar(TimeZone.getDefault()));
            try {
                d = format.parse(modifiedTime);
            }
            catch (Exception e) {
                this.debug.error("Exception: ", (Throwable)e);
                return null;
            }
        } else {
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault());
            String[] strArray = new String[3];
            StringTokenizer stok = new StringTokenizer(modifiedTime, " ");
            int tokenCount = stok.countTokens();
            for (int i = 0; i < tokenCount; ++i) {
                strArray[i] = stok.nextToken();
            }
            calendar.set(2, this.getMonthCode(strArray[0]));
            calendar.set(5, Integer.parseInt(strArray[1]));
            String dateStr = strArray[2];
            if (dateStr.indexOf(":") != -1) {
                int colonIndex = dateStr.indexOf(":");
                String hourStr = dateStr.substring(0, colonIndex);
                String minuteStr = dateStr.substring(colonIndex + 1).trim();
                calendar.set(11, Integer.parseInt(hourStr));
                calendar.set(12, Integer.parseInt(minuteStr));
            } else {
                calendar.set(1, Integer.parseInt(dateStr.trim()));
            }
            d = calendar.getTime();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd yy, hh:mm a");
        sdf.setCalendar(new GregorianCalendar(TimeZone.getDefault()));
        return sdf.format(d);
    }

    public int getMonthCode(String month) {
        int monthCode = -1;
        if (month.equalsIgnoreCase("jan")) {
            monthCode = 0;
        } else if (month.equalsIgnoreCase("feb")) {
            monthCode = 1;
        } else if (month.equalsIgnoreCase("mar")) {
            monthCode = 2;
        } else if (month.equalsIgnoreCase("apr")) {
            monthCode = 3;
        } else if (month.equalsIgnoreCase("may")) {
            monthCode = 4;
        } else if (month.equalsIgnoreCase("jun")) {
            monthCode = 5;
        } else if (month.equalsIgnoreCase("jul")) {
            monthCode = 6;
        } else if (month.equalsIgnoreCase("aug")) {
            monthCode = 7;
        } else if (month.equalsIgnoreCase("sep")) {
            monthCode = 8;
        } else if (month.equalsIgnoreCase("oct")) {
            monthCode = 9;
        } else if (month.equalsIgnoreCase("nov")) {
            monthCode = 10;
        } else if (month.equalsIgnoreCase("dec")) {
            monthCode = 11;
        }
        return monthCode;
    }

    private String[][] processUnixDirectoryListingType(List v_file_names, List v_full_listing) throws Exception {
        if (v_file_names.size() != v_full_listing.size()) {
            this.mergeListing(v_file_names, v_full_listing);
        }
        int number_of_files = v_file_names.size();
        int full_listing_length = v_full_listing.size();
        String[][] listing = new String[number_of_files][4];
        String file_name = null;
        String full_listing_row = null;
        int i = number_of_files - 1;
        int j = full_listing_length - 1;
        while (i >= 0) {
            listing[i][1] = file_name = (String)v_file_names.get(i);
            full_listing_row = (String)v_full_listing.get(j);
            listing[i][0] = full_listing_row.charAt(0) == 'd' ? "d" : full_listing_row.charAt(0) + "";
            int k = -1;
            if (listing[i][0].equals("l")) {
                k = full_listing_row.indexOf(file_name + " ->") - 1;
                listing[i][1] = file_name = full_listing_row.substring(k, full_listing_row.length());
            } else {
                k = full_listing_row.lastIndexOf(file_name) - 1;
            }
            while (k >= 0 && full_listing_row.charAt(k) == ' ') {
                --k;
            }
            int end_of_date = k + 1;
            while (k >= 0 && full_listing_row.charAt(k) != ' ') {
                --k;
            }
            while (k >= 0 && full_listing_row.charAt(k) == ' ') {
                --k;
            }
            while (k >= 0 && full_listing_row.charAt(k) != ' ') {
                --k;
            }
            while (k >= 0 && full_listing_row.charAt(k) == ' ') {
                --k;
            }
            while (k >= 0 && full_listing_row.charAt(k) != ' ') {
                --k;
            }
            listing[i][2] = this.getModifiedDateFormat(full_listing_row.substring(k + 1, end_of_date));
            while (k >= 0 && full_listing_row.charAt(k) == ' ') {
                --k;
            }
            int end_of_length = k + 1;
            while (k >= 0 && full_listing_row.charAt(k) != ' ') {
                --k;
            }
            listing[i][3] = full_listing_row.substring(k + 1, end_of_length);
            --i;
            --j;
        }
        return listing;
    }

    private String[][] processMSDirectoryListingType(List v_file_names, List v_full_listing) throws Exception {
        int number_of_files = v_file_names.size();
        String[][] listing = new String[number_of_files][4];
        String full_listing_row = null;
        for (int i = number_of_files - 1; i >= 0; --i) {
            int j;
            listing[i][1] = (String)v_file_names.get(i);
            full_listing_row = (String)v_full_listing.get(i);
            if (full_listing_row.indexOf("<DIR>") > 0) {
                listing[i][3] = "0";
                listing[i][0] = "d";
            } else {
                listing[i][0] = "-";
            }
            for (j = 0; j < full_listing_row.length() && full_listing_row.charAt(j) != ' '; ++j) {
            }
            while (j < full_listing_row.length() && full_listing_row.charAt(j) == ' ') {
                ++j;
            }
            while (j < full_listing_row.length() && full_listing_row.charAt(j) != ' ') {
                ++j;
            }
            listing[i][2] = this.getModifiedDateFormat(full_listing_row.substring(0, j));
            if (listing[i][3] != null) continue;
            int start_of_length = -1;
            while (j < full_listing_row.length() && full_listing_row.charAt(j) == ' ') {
                ++j;
            }
            start_of_length = j;
            while (j < full_listing_row.length() && full_listing_row.charAt(j) != ' ') {
                ++j;
            }
            listing[i][3] = full_listing_row.substring(start_of_length, j);
        }
        return listing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void rename(String username, String password, String machine, String share, String directory, String szOldName, String szNewName, NetFileResource nfrUsrResBundle) throws NetFileException {
        block12: {
            FullFtpClient fullFtpClient = null;
            Exception e = null;
            this.nfRes = nfrUsrResBundle;
            fullFtpClient = this.initialiseFtpClient(username, password, machine, share, directory);
            fullFtpClient.rename(szOldName, szNewName);
            Object var13_11 = null;
            try {
                if (fullFtpClient != null) {
                    fullFtpClient.closeServer();
                }
                break block12;
            }
            catch (Exception e1) {}
            break block12;
            {
                catch (Exception ex) {
                    e = ex;
                    if (ex instanceof FileNotFoundException) {
                        throw new NetFileException(500, this.nfRes.getString("ff.7", new Object[]{szNewName}));
                    }
                    this.performFinalProcessing(e, "Could not rename file " + szOldName, fullFtpClient);
                    Object var13_12 = null;
                    try {
                        if (fullFtpClient != null) {
                            fullFtpClient.closeServer();
                        }
                        break block12;
                    }
                    catch (Exception e1) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                try {
                    if (fullFtpClient != null) {
                        fullFtpClient.closeServer();
                    }
                }
                catch (Exception e1) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void performFinalProcessing(Exception ex, String szDebugMsg, FullFtpClient ffc) throws NetFileException {
        if (ex != null) {
            try {
                if (ffc != null) {
                    ffc.closeServer();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.writeDebug(szDebugMsg, ex);
            if (ex instanceof FileNotFoundException) {
                throw new NetFileException(500, this.nfRes.getString("ff.8"));
            }
            if (ex instanceof NetFileException) {
                throw (NetFileException)ex;
            }
            throw new NetFileException(500, this.nfRes.getString("ff.9"));
        }
    }

    protected FullFtpClient initialiseFtpClient(String username, String password, String machine, String share, String directory) throws NetFileException {
        FullFtpClient ffc = null;
        try {
            ffc = new FullFtpClient(machine, this.szEncoding);
            ffc.setMachineToAccess(machine);
        }
        catch (Exception ioe) {
            this.writeDebug("Failed to Bind on Port 21 to host: " + machine, ioe);
            throw new NetFileException(500, this.nfRes.getString("ff.10", new Object[]{machine}));
        }
        try {
            ffc.login(username, password);
        }
        catch (Exception e) {
            this.writeDebug("Login error to " + machine, e);
            throw new NetFileException(500, this.nfRes.getString("ff.11", new Object[]{machine}));
        }
        try {
            ffc.cd(share + directory);
        }
        catch (FileNotFoundException fnfe) {
            this.writeDebug("Cannot change to directory " + share + directory, fnfe);
            throw new NetFileException(500, this.nfRes.getString("ff.12", new Object[]{share, directory}));
        }
        catch (Exception ioe) {
            this.writeDebug("Cannot change to directory " + share + directory, ioe);
            throw new NetFileException(500, this.nfRes.getString("ff.13", new Object[]{share, directory}));
        }
        try {
            ffc.binary();
        }
        catch (Exception ioe) {
            this.writeDebug("Cannot change mode to binary", ioe);
            throw new NetFileException(500, this.nfRes.getString("ff.14"));
        }
        return ffc;
    }

    protected void writeDebug(String szMsg, Exception e) {
        if (this.debug != null && this.debug.messageEnabled()) {
            if (e != null) {
                this.debug.message(szMsg, (Throwable)e);
            } else {
                this.debug.message(szMsg);
            }
        }
    }

    protected void writeErrorDebug(String szError, Exception e) {
        if (this.debug != null) {
            if (e != null) {
                this.debug.error(szError, (Throwable)e);
            } else {
                this.debug.error(szError);
            }
        }
    }
}

