/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet.java2;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netfile.servlet.java2.FtpFile;
import com.sun.portal.netfile.servlet.java2.NetFileContext;
import com.sun.portal.netfile.servlet.java2.NetFileContextImpl;
import com.sun.portal.netfile.servlet.java2.NetFileLogManager;
import com.sun.portal.netfile.servlet.java2.NetFileResource;
import com.sun.portal.netfile.servlet.java2.NetFileServlet;
import com.sun.portal.netfile.servlet.java2.NetFileURLDecoder;
import com.sun.portal.netfile.servlet.java2.NetWareFile;
import com.sun.portal.netfile.servlet.java2.NfsFile;
import com.sun.portal.netfile.servlet.java2.RequestProcessor;
import com.sun.portal.netfile.servlet.java2.SerializedRequestProcessor;
import com.sun.portal.netfile.servlet.java2.WinFile;
import com.sun.portal.netfile.servlet.java2.XFileFactory;
import com.sun.portal.netfile.servlet.java2.XFileInterface;
import com.sun.portal.netfile.shared.NetFileException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileUploadProcessor
implements RequestProcessor {
    private Debug debug = null;
    private NetFileLogManager logManager = null;
    private SSOTokenManager manager = null;
    private NetFileResource resourceBundle = null;
    private String version = "";
    private String uploadIdentifier = "";
    private HashMap storedMetaData = null;
    byte[] buffer = new byte[8192];
    private OutputStream uploadStream = null;
    private Object fileObject = null;
    private static final String RESP_STR = "OK.";
    private static final String SNO_STR = "SNo";
    private static boolean isEncoded = Boolean.valueOf(SystemProperties.get((String)"com.iplanet.am.cookie.encode", (String)"false"));

    public FileUploadProcessor() {
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
    }

    public FileUploadProcessor(String version) {
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
        this.version = version;
    }

    public String getProtocolVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processRequest(HttpServletRequest request, HttpServletResponse response, SSOToken ssoToken) throws NetFileException, StreamCorruptedException {
        block24: {
            block23: {
                block22: {
                    nfContext = null;
                    inputStream = null;
                    outputStream = null;
                    output = "";
                    try {
                        try {
                            this.manager = SSOTokenManager.getInstance();
                            if (ssoToken == null) {
                                ssoToken = this.extractSession(request);
                            }
                            nfContext = new NetFileContextImpl(ssoToken);
                            inputStream = request.getInputStream();
                            outputStream = this.getOutputStream(response);
                            if (!this.validateSession(request, ssoToken, nfContext)) {
                                this.writeDebug("Session is invalid - " + ssoToken.getTokenID().toString());
                                var12_8 = null;
                                break block22;
                            }
                            if (this.logManager == null) {
                                this.createLogManager(ssoToken);
                            }
                            this.readUploadIdentifier(inputStream);
                            getData = this.readMetaData(inputStream);
                            sequenceNo = new Integer((String)getData.get("SNo"));
                            this.writeDebug("Sequence number is " + sequenceNo);
                            if (sequenceNo == 1) {
                                this.storedMetaData = getData;
                                locale = (String)this.storedMetaData.get("Locale");
                                this.resourceBundle = this.getUserLocaleBundle(locale);
                            } else {
                                if (sequenceNo == -888) {
                                    this.writeOutputMessage(outputStream, "OK.");
                                    this.doClose(sequenceNo);
                                    break block23;
                                }
                                this.storedMetaData.remove("SNo");
                                this.storedMetaData.put("SNo", getData.get("SNo"));
                            }
                            output = this.uploadFile(this.storedMetaData, inputStream, this.resourceBundle);
                            this.writeOutputMessage(outputStream, output);
                            break block24;
                        }
                        catch (Exception e) {
                            this.writeErrorDebug("Exception while uploading file - ", e);
                            output = e instanceof NetFileException != false ? e.getMessage() : "ERROR: " + this.resourceBundle.getString("error18");
                            this.writeOutputMessage(outputStream, output);
                            var12_11 = null;
                            try {
                                if (outputStream != null) {
                                    outputStream.close();
                                }
                                if (inputStream == null) return;
                                inputStream.close();
                                return;
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                            return;
                        }
                    }
                    catch (Throwable var11_22) {
                        block25: {
                            var12_12 = null;
                            ** try [egrp 2[TRYBLOCK] [8 : 376->399)] { 
lbl60:
                            // 1 sources

                            if (outputStream != null) {
                                outputStream.close();
                            }
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            break block25;
lbl65:
                            // 1 sources

                            catch (IOException ioe) {
                                // empty catch block
                            }
                        }
                        inputStream = null;
                        outputStream = null;
                        throw var11_22;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [8 : 376->399)] { 
lbl73:
                // 1 sources

                if (outputStream != null) {
                    outputStream.close();
                }
                if (inputStream == null) return;
                inputStream.close();
                return;
lbl78:
                // 1 sources

                catch (IOException ioe) {
                    // empty catch block
                }
                return;
            }
            var12_9 = null;
            ** try [egrp 2[TRYBLOCK] [8 : 376->399)] { 
lbl84:
            // 1 sources

            if (outputStream != null) {
                outputStream.close();
            }
            if (inputStream == null) return;
            inputStream.close();
            return;
lbl89:
            // 1 sources

            catch (IOException ioe) {
                // empty catch block
            }
            return;
        }
        var12_10 = null;
        ** try [egrp 2[TRYBLOCK] [8 : 376->399)] { 
lbl95:
        // 1 sources

        if (outputStream != null) {
            outputStream.close();
        }
        if (inputStream == null) return;
        inputStream.close();
        return;
lbl100:
        // 1 sources

        catch (IOException ioe) {
            // empty catch block
        }
    }

    private OutputStream getOutputStream(HttpServletResponse response) throws IOException {
        response.setContentType("application/octet-stream");
        return response.getOutputStream();
    }

    private void writeOutputMessage(OutputStream outputStream, String output) {
        try {
            byte[] byteArray = output.getBytes("ISO-8859-1");
            outputStream.write(byteArray);
            outputStream.flush();
        }
        catch (Exception e) {
            this.writeErrorDebug("Exception while writing status to client, ", e);
        }
    }

    private void readUploadIdentifier(InputStream inputStream) throws IOException {
        byte[] uploadIdBytes = new byte[128];
        inputStream.read(uploadIdBytes);
        this.uploadIdentifier = new String(uploadIdBytes);
    }

    private HashMap readMetaData(InputStream inputStream) throws IOException {
        int metaDataSizeStart = this.uploadIdentifier.indexOf("NFUP") + "NFUP".length();
        int metaDataSizeEnd = this.uploadIdentifier.indexOf("END");
        String metaDataSizeString = this.uploadIdentifier.substring(metaDataSizeStart, metaDataSizeEnd);
        int metaDataSize = Integer.parseInt(metaDataSizeString);
        HashMap<String, String> metaDataHashMap = new HashMap<String, String>();
        byte[] metaDataBytes = new byte[metaDataSize + 1];
        inputStream.read(metaDataBytes);
        String metaDataString = new String(metaDataBytes, "UTF-8");
        StringTokenizer stok = new StringTokenizer(metaDataString, "\n");
        NetFileURLDecoder decoder = new NetFileURLDecoder();
        String token = "";
        String name = "";
        String value = "";
        while (stok.hasMoreTokens()) {
            token = stok.nextToken();
            int index = token.indexOf("=");
            if (index == -1) continue;
            name = token.substring(0, index);
            value = token.substring(index + 1);
            value = decoder.decode(value, "UTF8");
            metaDataHashMap.put(name, value);
        }
        return metaDataHashMap;
    }

    private String uploadFile(HashMap metaData, InputStream inputStream, NetFileResource nfRes) throws NetFileException {
        String returnStr = "";
        Integer seqNo = new Integer((String)metaData.get(SNO_STR));
        OutputStream streamToServer = null;
        try {
            streamToServer = this.getOutputStream(metaData, nfRes);
            this.readWriteBytes(inputStream, streamToServer);
            returnStr = RESP_STR;
            if (seqNo == -999) {
                this.doLog(nfRes.getString("successLog.4"));
                this.writeDebug("Upload file result on sequence " + seqNo + " is " + returnStr);
            }
            this.doClose(seqNo);
        }
        catch (Exception e) {
            returnStr = "ERROR:" + e.getMessage();
            this.writeErrorDebug("Error uploading file - ", e);
            this.doLog(nfRes.getString("failureLog.4"));
            this.doClose(-777);
            if (e instanceof NetFileException) {
                throw new NetFileException(500, returnStr);
            }
            throw new NetFileException(500, "ERROR: " + nfRes.getString("error18"));
        }
        return returnStr;
    }

    private OutputStream getOutputStream(HashMap metaData, NetFileResource nfRes) throws Exception {
        String sysType = (String)metaData.get("SysType");
        if (sysType.equals("FTP") || sysType.equals("NETWARE")) {
            return this.createOutputStream(metaData, nfRes);
        }
        if (this.uploadStream == null) {
            this.uploadStream = this.createOutputStream(metaData, nfRes);
        }
        return this.uploadStream;
    }

    private OutputStream createOutputStream(HashMap metaData, NetFileResource nfRes) throws Exception {
        String remoteFileName = (String)metaData.get("FileName");
        String userName = (String)metaData.get("UserID");
        String share = (String)metaData.get("ShareName");
        String password = (String)metaData.get("SharePwd");
        String machine = (String)metaData.get("SystemName");
        String machineType = (String)metaData.get("SysType");
        String domain = (String)metaData.get("NTDomName");
        String directory = (String)metaData.get("Dir");
        String machineEncoding = (String)metaData.get("CharSet");
        Integer seqNo = new Integer((String)metaData.get(SNO_STR));
        String winsIP = (String)metaData.get("sunPortalNetFileWINSServer");
        OutputStream outputStream = null;
        if (machineType.indexOf("WIN", 0) >= 0 || machineType.indexOf("NT", 0) >= 0) {
            XFileInterface winFileInterface = null;
            if (this.fileObject == null) {
                winFileInterface = XFileFactory.getInstance().newXFileInstance(machineType, machineEncoding, winsIP);
                this.fileObject = winFileInterface;
            } else {
                winFileInterface = (XFileInterface)this.fileObject;
            }
            if (seqNo != 1) {
                this.writeDebug("Creating the output stream in append mode.");
                outputStream = winFileInterface.getOutputStream(userName, password, domain, machine, share, directory, remoteFileName, nfRes);
            } else {
                this.writeDebug("Creating the output stream.");
                outputStream = winFileInterface.getOutputStream(userName, password, domain, machine, share, directory, remoteFileName, nfRes);
            }
        } else if (machineType.indexOf("FTP", 0) >= 0 || machineType.indexOf("NETWARE", 0) >= 0) {
            FtpFile ftpFile = new FtpFile(machineEncoding);
            this.fileObject = ftpFile;
            if (seqNo != 1) {
                this.writeDebug("Creating the output stream in append mode.");
                outputStream = ftpFile.getOutputFTPStream(userName, password, machine, share, remoteFileName, directory, nfRes, true);
            } else {
                this.writeDebug("Creating the output stream.");
                outputStream = ftpFile.getOutputFTPStream(userName, password, machine, share, remoteFileName, directory, nfRes);
            }
        } else if (machineType.indexOf("NFS", 0) >= 0) {
            NfsFile nfsfile = null;
            if (this.fileObject == null) {
                nfsfile = new NfsFile(machineEncoding);
                this.fileObject = nfsfile;
            } else {
                nfsfile = (NfsFile)this.fileObject;
            }
            if (seqNo != 1) {
                this.writeDebug("Creating the output stream in append mode.");
                outputStream = nfsfile.getNFSOutputStream(userName, password, machine, share, remoteFileName, directory, true, nfRes);
            } else {
                this.writeDebug("Creating the output stream.");
                outputStream = nfsfile.getNFSOutputStream(userName, password, machine, share, remoteFileName, directory, nfRes);
            }
        }
        return outputStream;
    }

    private void doClose(int sequenceNo) {
        Object obj;
        if (this.fileObject instanceof FtpFile || this.fileObject instanceof NetWareFile) {
            try {
                if (this.uploadStream != null) {
                    BufferedOutputStream outStream = (BufferedOutputStream)this.uploadStream;
                    outStream.flush();
                    outStream.close();
                }
                FtpFile ftpFile = (FtpFile)this.fileObject;
                ftpFile.ffc.closeDataConnection();
                ftpFile.ffc.quit();
                this.fileObject = null;
                this.writeDebug("Output stream closed to server.");
            }
            catch (IOException ioe) {
                this.writeErrorDebug("Exception in closing stream to server on sequence " + sequenceNo, ioe);
            }
        }
        if ((sequenceNo == -777 || sequenceNo == -888 || sequenceNo == -999) && this.fileObject != null && (this.fileObject instanceof WinFile || this.fileObject instanceof NfsFile)) {
            try {
                if (this.uploadStream != null) {
                    this.uploadStream.flush();
                    this.uploadStream.close();
                    this.writeDebug("Output stream closed to server.");
                }
            }
            catch (Exception ex) {
                this.writeErrorDebug("Exception deleting file ", ex);
            }
        }
        if ((sequenceNo == -888 || sequenceNo == -777) && (obj = this.storedMetaData.get("FileName")) != null) {
            this.deleteFile();
        }
        if (sequenceNo == -777 || sequenceNo == -888 || sequenceNo == -999) {
            String tokenId = this.version.substring("HTTP_JAVA2_PLAIN".length());
            NetFileServlet.uploadProcCache.remove(tokenId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readWriteBytes(InputStream inputStream, OutputStream streamToServer) throws IOException {
        int len = 0;
        try {
            while ((len = inputStream.read(this.buffer)) != -1) {
                streamToServer.write(this.buffer, 0, len);
            }
            streamToServer.flush();
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        if (inputStream == null) return;
        inputStream.close();
        return;
    }

    private void deleteFile() {
        String fileName = (String)this.storedMetaData.get("FileName");
        String userName = (String)this.storedMetaData.get("UserID");
        String share = (String)this.storedMetaData.get("ShareName");
        String password = (String)this.storedMetaData.get("SharePwd");
        String machine = (String)this.storedMetaData.get("SystemName");
        String domain = (String)this.storedMetaData.get("NTDomName");
        String directory = (String)this.storedMetaData.get("Dir");
        String machineEncoding = (String)this.storedMetaData.get("CharSet");
        String type = (String)this.storedMetaData.get("SysType");
        try {
            if (type.equals("FTP") || type.equals("NETWARE")) {
                FtpFile ftpFile = new FtpFile(machineEncoding);
                ftpFile.delFTPFile(userName, password, machine, share, fileName, directory, this.resourceBundle);
            } else if (type.equals("NFS")) {
                NfsFile nfsFile = (NfsFile)this.fileObject;
                nfsFile.delNFSFile(userName, password, share, machine, fileName, directory, this.resourceBundle);
            } else if (type.equals("WIN") || type.equals("NT")) {
                XFileInterface fileInterface = (XFileInterface)this.fileObject;
                fileInterface.doDeleteFile(userName, password, machine, share, fileName, directory, domain, this.resourceBundle);
            }
        }
        catch (Exception e) {
            this.writeErrorDebug("Exception in deleting file " + fileName, e);
        }
    }

    private boolean validateSession(HttpServletRequest req, SSOToken ssoToken, NetFileContext nfContext) {
        String nfid = null;
        String session = null;
        nfid = req.getHeader("nfid");
        Cookie[] cookie = req.getCookies();
        if (cookie == null) {
            return false;
        }
        if (nfid == null) {
            return false;
        }
        for (int i = 0; i < cookie.length; ++i) {
            if (!cookie[i].getName().equalsIgnoreCase(SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro"))) continue;
            session = cookie[i].getValue();
        }
        if (session == null || session.equals("")) {
            return false;
        }
        if (isEncoded) {
            session = URLDecoder.decode(session);
        }
        if (session.equals(nfid)) {
            try {
                if (ssoToken == null) {
                    return false;
                }
                return nfContext.isSessionValid(ssoToken) && nfContext.isExecutable(ssoToken);
            }
            catch (Exception e) {
                this.writeErrorDebug("General Exception in NetFile upload", e);
                return false;
            }
        }
        return false;
    }

    private SSOToken extractSession(HttpServletRequest req) {
        try {
            if (this.manager == null) {
                this.manager = SSOTokenManager.getInstance();
            }
            return this.manager.createSSOToken(req);
        }
        catch (SSOException sSOException) {
            return null;
        }
    }

    private NetFileResource getUserLocaleBundle(String locale) throws Exception {
        NetFileResource nfRes = null;
        nfRes = SerializedRequestProcessor.getResourceMap(locale, "srapNetFileServletJava2");
        if (nfRes == null) {
            this.writeDebug("NetFile resource object for bundle srapNetFileServletJava2 not found in resource map for locale " + locale);
            nfRes = new NetFileResource("srapNetFileServletJava2", locale);
        } else {
            this.writeDebug("NetFile resource object for bundle srapNetFileServletJava2 found in resource map for locale " + locale);
        }
        return nfRes;
    }

    private void createLogManager(SSOToken ssoToken) {
        String tokenId = ssoToken.getTokenID().toString();
        try {
            Object obj = NetFileServlet.logManagerCache.get(tokenId);
            if (obj == null) {
                this.logManager = new NetFileLogManager(ssoToken);
                NetFileServlet.logManagerCache.put(tokenId, this.logManager);
            } else {
                this.logManager = (NetFileLogManager)obj;
            }
        }
        catch (Exception e) {
            this.writeErrorDebug("Unable to create LogManager for ssoToken - " + tokenId, e);
        }
    }

    protected void writeDebug(String szMsg) {
        this.writeDebug(szMsg, null);
    }

    protected void writeDebug(String szMsg, Exception e) {
        if (this.debug != null && this.debug.messageEnabled()) {
            if (e != null) {
                this.debug.message(szMsg, (Throwable)e);
            } else {
                this.debug.message(szMsg);
            }
        }
    }

    protected void writeErrorDebug(String szError, Exception e) {
        if (this.debug != null) {
            if (e != null) {
                this.debug.error(szError, (Throwable)e);
            } else {
                this.debug.error(szError);
            }
        }
    }

    private void doLog(String msg) {
        if (this.logManager == null) {
            return;
        }
        String functionName = this.resourceBundle.getString("uploadFileLog");
        String remoteFileName = (String)this.storedMetaData.get("FileName");
        String userName = (String)this.storedMetaData.get("UserID");
        String share = (String)this.storedMetaData.get("ShareName");
        String machine = (String)this.storedMetaData.get("SystemName");
        String directory = (String)this.storedMetaData.get("Dir");
        Object[] obj = new Object[]{functionName, remoteFileName, userName, machine, share, directory};
        this.logManager.doLog(msg + "  " + this.resourceBundle.getString("successLog.5", obj));
    }
}

