/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.i18n;

import com.sun.portal.rewriter.util.ConfigManager;
import com.sun.portal.rewriter.util.collections.CollectionHelper;
import com.sun.portal.rewriter.util.collections.ListMap;
import java.util.Properties;

public final class EncodingHelper {
    private static ListMap java2IANAEncodingMap;
    private static ListMap IANA2JavaEncodingMap;

    public static void init(String aResourceLocation) {
        if (aResourceLocation != null) {
            Properties lMap = ConfigManager.readProps(aResourceLocation);
            java2IANAEncodingMap = CollectionHelper.processMAPValues(lMap, "|;:");
            IANA2JavaEncodingMap = CollectionHelper.invertArrayValueMAP(java2IANAEncodingMap);
        }
    }

    public static String findEquivalentJAVAEncoding(String aIANAEncoding) {
        Object matcheObject;
        if (aIANAEncoding != null && (matcheObject = IANA2JavaEncodingMap.matchesWith(aIANAEncoding)) != null) {
            return (String)IANA2JavaEncodingMap.get(matcheObject);
        }
        return aIANAEncoding;
    }

    public static String findEquivalentIANAEncoding(String aJavaEncoding) {
        Object matcheObject;
        if (aJavaEncoding != null && (matcheObject = java2IANAEncodingMap.matchesWith(aJavaEncoding)) != null) {
            return ((String[])java2IANAEncodingMap.get(matcheObject))[0];
        }
        return aJavaEncoding;
    }
}

