/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines.js;

import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.engines.AbstractRewriter;
import com.sun.portal.rewriter.engines.PageContent;
import com.sun.portal.rewriter.engines.RewriterBroker;
import com.sun.portal.rewriter.engines.js.parser.JSParser;
import com.sun.portal.rewriter.util.Constants;
import com.sun.portal.rewriter.util.StringHelper;

public final class JSRewriter
extends AbstractRewriter {
    public JSRewriter(RewriterBroker aRewriterBroker) {
        super(aRewriterBroker, "application/x-javascript");
    }

    public final void plugableRewriter(PageContent aPageContent, Translator aTranslator) {
        new JSParser(aPageContent, this.getRuleSet(), aTranslator, this).parse();
    }

    public final void endRewriting(PageContent aPageContent, Translator aTranslator) {
        String jsFunctionsDefination = aTranslator.getLookAheadInfo().readJSFunctions(aTranslator);
        if (jsFunctionsDefination.length() != 0) {
            aPageContent.getResultBuffer().append(jsFunctionsDefination);
        }
    }

    public String translateURL(String aURI, Translator aTranslator) {
        return aTranslator.translate(aURI);
    }

    public final String translateEXPRESSION(String aJSExpression, Translator aTranslator) {
        String expContent = StringHelper.normalize(aJSExpression);
        if (expContent.length() == 0) {
            return aJSExpression;
        }
        int htmlEntityIndex = JSRewriter.parseForHTMLEntityIndex(expContent);
        char zeroChar = expContent.charAt(0);
        if (htmlEntityIndex == -1 && (zeroChar == '\"' || zeroChar == '\'' || zeroChar == '\\')) {
            int plusIndex = aJSExpression.indexOf(43);
            if (plusIndex != -1) {
                String firstPart = aJSExpression.substring(0, plusIndex);
                String[] parts = StringHelper.regExpSplit(firstPart, "");
                String urlPart = parts[1];
                if (urlPart.length() > 0 && (urlPart.startsWith("/") || urlPart.startsWith(".") || urlPart.regionMatches(true, 0, "http://", 0, 7) && urlPart.length() > 7 || urlPart.regionMatches(true, 0, "https://", 0, 8) && urlPart.length() > 8 || !urlPart.regionMatches(true, 0, "http", 0, 4))) {
                    StringBuffer sb = new StringBuffer(aJSExpression.length());
                    sb.append(aTranslator.translate(firstPart));
                    sb.append(aJSExpression.substring(plusIndex));
                    return sb.toString();
                }
            } else {
                return this.translateURL(aJSExpression, aTranslator);
            }
        }
        StringBuffer sb = new StringBuffer(aJSExpression.length());
        sb.append(aTranslator.getJSFunctionSpec().getExpressionFunctionName()).append('(').append(aJSExpression).append(')');
        aTranslator.getLookAheadInfo().addJSFunction(aTranslator.getJSFunctionSpec().getExpressionFunctionName());
        return sb.toString();
    }

    public String translateDHTML(String aDHTMLContent, Translator aTranslator) {
        String bHTMLContent = aDHTMLContent;
        char startChar = bHTMLContent.charAt(0);
        while ((Character.isWhitespace(startChar) || startChar == Constants.DOUBLE_QUOTES_CHAR || startChar == Constants.SINGLE_QUOTES_CHAR || startChar == Constants.ESCAPE_FORWARD_SLASH_CHAR) && (bHTMLContent = startChar == Constants.ESCAPE_FORWARD_SLASH_CHAR && bHTMLContent.length() >= "\\n".length() ? bHTMLContent.substring("\\n".length()) : bHTMLContent.substring(1)).length() != 0) {
            startChar = bHTMLContent.charAt(0);
        }
        if (bHTMLContent.length() == 0) {
            return aDHTMLContent;
        }
        StringBuffer sb = new StringBuffer(aDHTMLContent.length());
        int trimIndex = aDHTMLContent.indexOf(bHTMLContent);
        if (trimIndex > 0) {
            sb.append(aDHTMLContent.substring(0, trimIndex));
        }
        int appendedIndex = 0;
        if (!bHTMLContent.startsWith("<")) {
            bHTMLContent = "<" + bHTMLContent;
            appendedIndex = 1;
        }
        sb.append(this.getRewriterBroker().getInstance("text/html").rewrite(bHTMLContent, aTranslator).substring(appendedIndex));
        return sb.toString();
    }

    public final String translateDJS(String aDJSContent, Translator aTranslator) {
        String[] split = this.trimDJSQuotes(aDJSContent);
        if (StringHelper.startsWithIgnoreCase(split[1], "http:") || StringHelper.startsWithIgnoreCase(split[1], "https:") || split[1].startsWith("/") || split[1].startsWith(".")) {
            return aTranslator.translate(aDJSContent);
        }
        int i = split[1].indexOf(40);
        int j = split[1].indexOf(46);
        int k = split[1].indexOf(61);
        int l = split[1].indexOf(43);
        int m = split[1].indexOf(63);
        boolean isLocation = split[1].startsWith("location");
        if (isLocation || i != -1 || j != -1 || k != -1 || l != -1) {
            if (m == -1) {
                return this.doDJSRewrite(aDJSContent, aTranslator);
            }
            if (m < l && m < k && m < j) {
                return aTranslator.translate(aDJSContent);
            }
        }
        return this.doDJSRewrite(aDJSContent, aTranslator);
    }

    private String doDJSRewrite(String aDJSContent, Translator aTranslator) {
        String[] splitted = this.trimDJSQuotes(aDJSContent);
        String lResult = this.rewrite(splitted[1], aTranslator);
        return splitted[0] + lResult + splitted[2];
    }

    public final String translateSYSTEM(String aSystemVariable, Translator aTranslator) {
        StringBuffer lResultBuffer = new StringBuffer(aTranslator.getJSFunctionSpec().getSystemFunctionName());
        lResultBuffer.append("(");
        int i = aSystemVariable.lastIndexOf(".");
        if (i != -1) {
            lResultBuffer.append(aSystemVariable.substring(0, i));
        } else {
            lResultBuffer.append("null");
        }
        lResultBuffer.append(", ").append("'").append(aSystemVariable).append("', ");
        lResultBuffer.append(aSystemVariable);
        lResultBuffer.append(')');
        aTranslator.getLookAheadInfo().addJSFunction(aTranslator.getJSFunctionSpec().getSystemFunctionName());
        return lResultBuffer.toString();
    }

    private static int parseForHTMLEntityIndex(String expContent) {
        int queryIndex;
        int htmlEntityIndex = expContent.indexOf("&#");
        if (htmlEntityIndex != -1 && (queryIndex = expContent.indexOf("?")) != -1 && queryIndex < htmlEntityIndex) {
            htmlEntityIndex = -1;
        }
        return htmlEntityIndex;
    }

    private String[] trimDJSQuotes(String aDJSContent) {
        String lDJSContent = aDJSContent.trim();
        String[] lResult = new String[]{"", aDJSContent, ""};
        if (lDJSContent.startsWith("\"") || lDJSContent.startsWith("'")) {
            int quoteBegin = aDJSContent.indexOf(lDJSContent.charAt(0)) + 1;
            lResult[0] = aDJSContent.substring(0, quoteBegin);
            lResult[1] = aDJSContent.substring(quoteBegin).trim();
            String endChar = lResult[1].substring(lResult[1].length() - 1);
            if (endChar.charAt(0) == lDJSContent.charAt(0)) {
                lResult[2] = aDJSContent.substring(aDJSContent.lastIndexOf(endChar));
                lResult[1] = lResult[1].substring(0, lResult[1].length() - 1);
            }
        }
        return lResult;
    }
}

