/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.cal.socs;

import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.VAlarm;
import com.sun.portal.wireless.taglibs.base.Util;
import com.sun.portal.wireless.taglibs.cal.socs.ReminderBean;

public class EmailReminderBean
extends ReminderBean {
    private VAlarm alarm = null;

    public EmailReminderBean(VAlarm aAlarm) {
        super(aAlarm);
        this.alarm = aAlarm;
    }

    public String getString() {
        return this.toString();
    }

    public String toString() {
        return super.toString() + ":" + this.getEmailAttendee();
    }

    public void setEmailAttendee(String addrListSt) {
        try {
            Attendee[] attendees = this.alarm.getAttendees();
            if (attendees != null && attendees.length > 0) {
                for (int i = 0; i < attendees.length; ++i) {
                    this.alarm.removeAttendee(attendees[i]);
                }
            }
            if (addrListSt.indexOf("MAILTO") == -1) {
                addrListSt = "MAILTO:" + addrListSt;
            }
            Attendee att = new Attendee("INDIVIDUAL", addrListSt);
            this.alarm.addAttendee(att);
            this.alarm.setAction("EMAIL");
        }
        catch (Exception ex) {
            Util.logError((String)"ReminderBean.setAttendee(): Not able to create attendee(s)", (Throwable)ex);
        }
    }

    public boolean isEmailAttendeeEmpty() {
        String email = this.getEmailAttendee();
        return email == null || email.trim().equals("");
    }

    public String getEmailAttendee() {
        StringBuffer result = new StringBuffer();
        String delimiter = ",";
        Attendee[] addrList = this.alarm.getAttendees();
        if (addrList != null) {
            for (int i = 0; i < addrList.length; ++i) {
                String tmp;
                String addr = addrList[i].getValue();
                Util.logMessage((String)("Attendee = " + addr));
                if (addr.length() >= 7 && (tmp = addr.substring(0, 7)).equalsIgnoreCase("Mailto:")) {
                    addr = addr.substring(7);
                }
                result.append(addr);
                if (i == addrList.length - 1) continue;
                result.append(delimiter);
            }
        }
        return result.toString();
    }

    public void setReminderNote(String note) throws Exception {
        if (note == null) {
            note = "";
        }
        this.alarm.setDescription(note);
    }

    public String getReminderNote() {
        return this.alarm.getDescription();
    }
}

