/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.ab;

import com.sun.addressbook.Element;
import com.sun.addressbook.Entry;
import com.sun.addressbook.Group;
import com.sun.portal.wireless.taglibs.ab.ABBaseCommandTag;
import com.sun.portal.wireless.taglibs.ab.ABContext;
import com.sun.portal.wireless.taglibs.ab.ContactDB;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.jsp.JspException;

public class ABAddTag
extends ABBaseCommandTag {
    public boolean execute() throws JspException {
        Element element = this.getElement();
        if (!this.requiredPropertiesExist(element)) {
            return false;
        }
        ContactDB contactDB = this.getContactDB();
        if (element.getElementType() == 2) {
            Entry searchEntry = new Entry();
            searchEntry.setCn(element.getCn());
            searchEntry.setElementType(2);
            contactDB.refreshAB();
            List elements = contactDB.searchABook(searchEntry, null, null, null, null, true);
            if (elements == null || elements.size() > 0) {
                ABContext.warningLog("ABAddTag: Group name not unique");
                this.getABContext().setErrorCode("AB_003");
                return false;
            }
        }
        if (!contactDB.addElementToABook(element)) {
            ABContext.warningLog("ABAddTag: Add address book entry failed");
            this.getABContext().setErrorCode("");
            return false;
        }
        String members = null;
        if (element.getElementType() == 2 && (members = (String)element.getProperty("members")) == null) {
            members = (String)element.getProperty("addmembers");
        }
        if (members != null) {
            Entry searchEntry = new Entry();
            searchEntry.setCn(element.getCn());
            searchEntry.setElementType(2);
            contactDB.refreshAB();
            List elements = contactDB.searchABook(searchEntry, null, null, null, null, true);
            if (elements == null || elements.size() != 1) {
                ABContext.warningLog("ABAddTag: Add address book entry failed");
                this.getABContext().setErrorCode("");
                return false;
            }
            Group group = (Group)elements.get(0);
            if (group.getElementType() != 2) {
                ABContext.warningLog("ABAddTag: Add address book entry failed");
                this.getABContext().setErrorCode("");
                return false;
            }
            StringTokenizer tok = new StringTokenizer(members, ",");
            while (tok.hasMoreTokens()) {
                Element elemToAdd = this.getABContext().getMemberchoice(Integer.parseInt(tok.nextToken()));
                contactDB.addElementToGroup(elemToAdd, group);
            }
        }
        return true;
    }
}

