/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.impl;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.sun.comclient.calendar.CalendarSession;
import com.sun.comclient.calendar.CalendarStore;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterDebug;
import com.sun.ssoadapter.SSOAdapterException;
import com.sun.ssoadapter.ValidationException;
import java.util.Properties;
import java.util.StringTokenizer;

public class ExchangeCalendarSSOAdapter
extends SSOAdapter {
    protected CalendarSession calSession;
    protected CalendarStore calStore;
    protected static String CALENDAR_DEFAULT_PROTOCOL = "http";
    protected static String serviceClass = "com.sun.ssoadapter.calendar.pim.APimCalStore";

    public void init(String adapterName, SSOToken token, Properties adapterProperties) throws SSOAdapterException {
        super.init(adapterName, token, adapterProperties);
        if (adapterProperties.getProperty("validate", "false").equals("true")) {
            try {
                this.validate();
            }
            catch (ValidationException ve) {
                throw new SSOAdapterException(ve.getLocalizedMessage("ssoadapter", this.locale), true);
            }
        }
    }

    public void validate() throws ValidationException {
        String hostString;
        String portString = this.adapterProperties.getProperty("port");
        if (portString != null && portString.length() > 0) {
            try {
                int portInt = Integer.parseInt(portString);
            }
            catch (Exception e) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("invalidPort");
                throw ve;
            }
        }
        if ((hostString = this.adapterProperties.getProperty("host")) == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingHost");
            throw ve;
        }
        String uidString = this.adapterProperties.getProperty("uid");
        if (uidString == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingUid");
            throw ve;
        }
        String passwordString = this.adapterProperties.getProperty("password");
        if (passwordString == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingPassword");
            throw ve;
        }
        String winDomainString = this.adapterProperties.getProperty("winDomain");
        if (winDomainString == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingWinDomain");
            throw ve;
        }
        String clientPortString = this.adapterProperties.getProperty("clientPort");
        if (clientPortString != null && clientPortString.length() > 0) {
            try {
                int portInt = Integer.parseInt(clientPortString);
            }
            catch (Exception e) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("invalidClientPort");
                throw ve;
            }
        }
    }

    public boolean isAvailable() {
        return this.calStore != null && this.calStore.isConnected();
    }

    public Object getConnection() {
        CalendarStore obj = null;
        try {
            obj = this.getCalStore();
        }
        catch (Exception e) {
            SSOAdapterDebug.logMessage(this.identifier + " failed to get connection. ", e);
        }
        if (obj != null) {
            SSOAdapterDebug.logMessage(this.identifier + " connected to store");
        }
        return obj;
    }

    public CalendarStore getCalStore() throws Exception {
        if (this.isAvailable()) {
            return this.calStore;
        }
        this.calSession = this.getCalSession();
        if (this.calSession == null) {
            return null;
        }
        String host = this.adapterProperties.getProperty("host");
        this.calStore = this.calSession.getStore(serviceClass);
        this.calStore.connect(host);
        return this.calStore;
    }

    public CalendarSession getCalSession() throws Exception {
        if (this.calSession != null) {
            return this.calSession;
        }
        String host = this.adapterProperties.getProperty("host");
        String password = this.adapterProperties.getProperty("password");
        String uid = this.adapterProperties.getProperty("uid");
        if (host == null || password == null || uid == null) {
            return null;
        }
        String protocol = this.adapterProperties.getProperty("protocol", CALENDAR_DEFAULT_PROTOCOL);
        String domain = this.adapterProperties.getProperty("winDomain");
        String ocxHost = this.adapterProperties.getProperty("ocxHost", host);
        String pimInterfaceType = this.adapterProperties.getProperty("pimInterfaceType", "cdo");
        String usersDn = this.adapterProperties.getProperty("usersDn", "CN=Users");
        String hostDn = this.adapterProperties.getProperty("hostDn", "DC=[HOST]");
        String rootSuffix = this.adapterProperties.getProperty("rootSuffix", "");
        String webdavProtocol = this.adapterProperties.getProperty("webdavProtocol", "http");
        String webdavPort = this.adapterProperties.getProperty("webdavPort", "80");
        String webdavCustomTaskFilter = this.adapterProperties.getProperty("webdavCustomTaskFilter", "true");
        String activeDirectoryLdapPort = this.adapterProperties.getProperty("activeDirectoryLdapPort", "389");
        Properties props = new Properties();
        if (uid != null) {
            props.put("cal.user", uid);
        }
        if (password != null) {
            props.put("cal.password", password);
        }
        if (protocol != null) {
            props.put("cal.protocol", protocol);
        }
        if (domain != null) {
            props.put("cal.exchange.domain", domain);
        }
        if (ocxHost != null) {
            props.put("cal.exchange.ocxhost", ocxHost);
        }
        if (pimInterfaceType != null) {
            props.put("cal.exchange.pimInterfaceType", pimInterfaceType);
        }
        if (webdavProtocol != null) {
            props.put("cal.exchange.webdavProtocol", webdavProtocol);
        }
        if (webdavPort != null) {
            props.put("cal.exchange.webdavPort", webdavPort);
        }
        if (webdavCustomTaskFilter != null) {
            props.put("cal.exchange.webdavCustomTaskFilter", webdavCustomTaskFilter);
        }
        if (activeDirectoryLdapPort != null) {
            props.put("cal.exchange.activeDirectoryLdapPort", activeDirectoryLdapPort);
        }
        if (SSOAdapterDebug.messageEnabled()) {
            props.put("cal.pim.debug", "true");
        }
        props.put("cal.pim.service", "exchange");
        if (usersDn == null || usersDn.equals("")) {
            usersDn = "CN=Users";
        }
        StringTokenizer strTok = new StringTokenizer(host, ".");
        String unQualifiedHost = host;
        if (strTok.hasMoreTokens()) {
            unQualifiedHost = strTok.nextToken();
        }
        String computedHostDn = "DC=" + unQualifiedHost;
        if (hostDn != null || hostDn.equals("")) {
            int indexStart = hostDn.indexOf("[");
            int indexEnd = hostDn.indexOf("]", indexStart);
            computedHostDn = indexStart > -1 && indexEnd > -1 ? hostDn.substring(0, indexStart) + unQualifiedHost + hostDn.substring(indexEnd + 1) : hostDn;
        }
        if (rootSuffix == null || rootSuffix.equals("")) {
            rootSuffix = "";
            while (strTok.hasMoreTokens()) {
                rootSuffix = rootSuffix + "DC=" + strTok.nextToken();
                if (!strTok.hasMoreTokens()) continue;
                rootSuffix = rootSuffix + ",";
            }
        }
        String usersBaseDn = usersDn + "," + computedHostDn + "," + rootSuffix;
        SSOAdapterDebug.logMessage("ExchangeCalendarSSOAdapter:usersBaseDn=" + usersBaseDn);
        if (usersBaseDn != null) {
            props.put("cal.exchange.usersBaseDn", usersBaseDn);
        }
        this.calSession = CalendarSession.getInstance((Properties)props);
        return this.calSession;
    }

    public boolean closeConnection() {
        boolean retval = true;
        try {
            this.calStore.disconnect();
            this.calStore = null;
            this.calSession = null;
        }
        catch (Exception e) {
            retval = false;
        }
        SSOAdapterDebug.logMessage(this.identifier + " closed connection to store");
        return retval;
    }

    public void ssoTokenChanged(SSOTokenEvent evt) {
        try {
            int evtType = evt.getType();
            if (this.calStore != null) {
                this.calStore.disconnect();
            }
            this.calStore = null;
            this.calSession = null;
        }
        catch (Exception e) {
            SSOAdapterDebug.logMessage(this.identifier + " failed to close connection " + "to store ", e);
            return;
        }
        SSOAdapterDebug.logMessage(this.identifier + " closed connection to store");
    }
}

