/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.calendar.pim;

import com.aligo.pim.PimContainerType;
import com.aligo.pim.PimFactory;
import com.aligo.pim.PimUserInfoParameter;
import com.aligo.pim.interfaces.PimContainer;
import com.aligo.pim.interfaces.PimUserInfo;
import com.aligo.pim.lotus.LotusPimAddressEntryItem;
import com.linar.jintegra.Log;
import com.sun.comclient.calendar.CalendarException;
import com.sun.comclient.calendar.CalendarSession;
import com.sun.comclient.calendar.CalendarStore;
import com.sun.comclient.calendar.CalendarStoreException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.ICalendar;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.URLName;
import com.sun.ssoadapter.calendar.pim.APimCalendar;
import java.io.BufferedReader;
import java.io.InputStream;
import java.util.Properties;
import java.util.TimeZone;

public class APimCalStore
extends CalendarStore {
    PimContainer pimContainer = null;
    PimUserInfo pimUserInfo;
    boolean connected = false;
    String calid = null;

    public APimCalStore(CalendarSession session) {
        super(session);
        TimeZone tz = session.getTimeZone();
        if (tz == null) {
            session.setTimeZone(TimeZone.getDefault());
        }
    }

    protected void connectURL(URLName url) throws CalendarStoreException {
        try {
            CalendarSession session = this.getSession();
            String pimService = session.getProperty("cal.pim.service", "exchange");
            boolean debugEnabled = new Boolean(session.getProperty("cal.pim.debug", "false"));
            String username = url.getUsername();
            String password = url.getPassword();
            String host = url.getHost();
            int port = url.getPort();
            if (pimService.equalsIgnoreCase("exchange")) {
                String NTDomain = session.getProperty("cal.exchange.domain");
                String pimInterfaceType = session.getProperty("cal.exchange.pimInterfaceType", "cdo");
                if (pimInterfaceType != null && pimInterfaceType.equals("webdav")) {
                    String usersBaseDn = session.getProperty("cal.exchange.usersBaseDn");
                    String webdavProtocol = session.getProperty("cal.exchange.webdavProtocol");
                    String webdavPort = session.getProperty("cal.exchange.webdavPort");
                    boolean webdavTaskFilter = new Boolean(session.getProperty("cal.exchange.webdavCustomTaskFilter", "true"));
                    String activeDirectoryLdapPort = session.getProperty("cal.exchange.activeDirectoryLdapPort");
                    this.pimContainer = PimFactory.getContainer((PimContainerType)PimContainerType.EXCHANGE_WEBDAV);
                    this.pimUserInfo = this.pimContainer.addUserInfo();
                    this.pimUserInfo.set(PimUserInfoParameter.EXCHANGE_MAILBOX, username);
                    String webdav_url = webdavProtocol + "://" + host + ":" + webdavPort;
                    this.pimUserInfo.set(PimUserInfoParameter.EXCHANGE_WEBDAV_URL, webdav_url);
                    if (debugEnabled) {
                        System.out.println("webdav_url=" + webdav_url);
                    }
                    this.pimUserInfo.set(PimUserInfoParameter.JNDI_LDAP_SERVER, host);
                    String ldapUserName = NTDomain + "\\" + username;
                    if (debugEnabled) {
                        System.out.println("ldap userName=" + ldapUserName + " usersBaseDn=" + usersBaseDn);
                    }
                    this.pimUserInfo.set(PimUserInfoParameter.JNDI_LDAP_USERNAME, ldapUserName);
                    this.pimUserInfo.set(PimUserInfoParameter.JNDI_LDAP_PASSWORD, password);
                    this.pimUserInfo.set(PimUserInfoParameter.JNDI_LDAP_PORT, activeDirectoryLdapPort);
                    this.pimUserInfo.set(PimUserInfoParameter.JNDI_LDAP_AB_BASE, usersBaseDn);
                    this.pimUserInfo.set(PimUserInfoParameter.JNDI_LDAP_TRY_ANONYMOUS_FALLBACK, "true");
                    if (webdavTaskFilter) {
                        this.pimUserInfo.set(PimUserInfoParameter.EXCHANGE_WEBDAV_SPECIAL_TASK_FILTER, "true");
                    }
                } else {
                    String ocxhost = session.getProperty("cal.exchange.ocxhost", host);
                    this.pimContainer = PimFactory.getContainer((PimContainerType)PimContainerType.EXCHANGE);
                    this.pimUserInfo = this.pimContainer.addUserInfo();
                    this.pimUserInfo.set(PimUserInfoParameter.EXCHANGE_OCXHOST_LOCATION, ocxhost);
                    this.pimUserInfo.set(PimUserInfoParameter.EXCHANGE_NT_DOMAIN, NTDomain);
                    this.pimUserInfo.set(PimUserInfoParameter.EXCHANGE_SERVER, host);
                    if (debugEnabled) {
                        Log.logImmediately((int)3, (String)"/tmp/ocxhost.log");
                    }
                }
                if (debugEnabled) {
                    this.pimUserInfo.set(PimUserInfoParameter.DEBUG, "true");
                }
                this.pimUserInfo.set(PimUserInfoParameter.EXCHANGE_USERNAME, username);
                this.pimUserInfo.set(PimUserInfoParameter.EXCHANGE_PASSWORD, password);
            } else if (pimService.equalsIgnoreCase("notes")) {
                String ltpaToken;
                this.pimContainer = PimFactory.getContainer((PimContainerType)PimContainerType.LOTUS);
                this.pimUserInfo = this.pimContainer.addUserInfo();
                if (debugEnabled) {
                    this.pimUserInfo.set(PimUserInfoParameter.DEBUG, "true");
                }
                if (port > 0) {
                    host = host + ":" + port;
                }
                if ((username == null || username.equals("") || username.equalsIgnoreCase("sso")) && (ltpaToken = session.getProperty("lotus.ltpatoken.value", "")) != null && !ltpaToken.equals("")) {
                    this.pimUserInfo.set(PimUserInfoParameter.LOTUS_LTPA_TOKEN, ltpaToken);
                    username = "sso";
                    password = "sso";
                }
                this.pimUserInfo.set(PimUserInfoParameter.LOTUS_USERNAME, username);
                this.pimUserInfo.set(PimUserInfoParameter.LOTUS_PASSWORD, password);
                this.pimUserInfo.set(PimUserInfoParameter.LOTUS_SERVER, host);
            } else {
                throw new CalendarStoreException("Unknown service specified");
            }
            this.pimContainer.logon();
            this.connected = true;
            this.calid = username;
            if (this.pimContainer.getCurrentUser() != null) {
                this.calid = this.pimContainer.getCurrentUser().getName();
            }
            if (pimService.equalsIgnoreCase("notes")) {
                LotusPimAddressEntryItem addrItem = (LotusPimAddressEntryItem)this.pimContainer.getCurrentUser();
                String mailFileName = addrItem.getMailFileName();
                session.setProperty("lotus.mailFileName", mailFileName);
                int i = mailFileName.lastIndexOf("/");
                int j = mailFileName.lastIndexOf("\\");
                int k = i > j ? i : j;
                String userName = null;
                if (k > 0) {
                    userName = mailFileName.substring(k + 1);
                }
                if (userName != null) {
                    session.setProperty("lotus.sso.user", userName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CalendarStoreException(e.getMessage());
        }
    }

    public void disconnect() throws CalendarStoreException {
        try {
            this.pimContainer.logoff();
            this.connected = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CalendarStoreException(e.getMessage());
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void importCalendar(String cid, DateTime start, DateTime end, String contentFormat, InputStream inputStream) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Method importCalendar() not supported");
    }

    public void importCalendar(String cid, String contentFormat, InputStream inputStream) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Method importCalendar() not supported");
    }

    public BufferedReader exportCalendar(String cid, DateTime start, DateTime end, String contentFormat) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Method exportCalendar() not supported");
    }

    public BufferedReader exportCalendar(String cid, DateTime start, DateTime end, String contentFormat, String host, int port) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Method exportCalendar() not supported");
    }

    public void deleteCalendar(String cid) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Method deleteCalendar() not supported");
    }

    public ICalendar createCalendar(String cid, Properties props) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Method createCalendar() not supported");
    }

    public ICalendar createCalendar(String cid) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Method createCalendar() not supported");
    }

    public ICalendar[] searchCalendars(String searchFilter) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Method searchCalendar() not supported");
    }

    public ICalendar[] searchCalendars(String searchString, int searchOpt, int maxResults) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Method searchCalendar() not supported");
    }

    public ICalendar[] searchCalendars(String searchFilter, Properties requestProperties) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("This method searchCalendars(..) is not supported");
    }

    public ICalendar[] searchCalendars(String searchString, int searchOpt, int maxResults, Properties requestProperties) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("This method searchCalendars(..) is not supported");
    }

    public ICalendar[] getCalendars() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Method getCalendars() not supported");
    }

    public String[] getSubscribedCalenders() throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Method getSubscribedCalendars() not supported");
    }

    public String verifyCalendarId(String cid) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Method verifyCalendarId(String) not supported");
    }

    protected String getDefaultCalendarId() {
        return this.calid;
    }

    protected ICalendar loadCalendar(String calId) throws CalendarStoreException {
        try {
            return new APimCalendar(this, calId);
        }
        catch (CalendarException cex) {
            cex.printStackTrace();
            throw new CalendarStoreException(cex.getMessage());
        }
    }

    protected void unloadCalendar(ICalendar cal) throws CalendarStoreException {
    }

    public PimContainer getPimContainer() {
        return this.pimContainer;
    }
}

