/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.ab.pim;

import com.aligo.pim.PimContainerType;
import com.aligo.pim.PimFactory;
import com.aligo.pim.PimFolderType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimAddressBook;
import com.aligo.pim.interfaces.PimContainer;
import com.aligo.pim.interfaces.PimFolders;
import com.aligo.pim.interfaces.PimUserInfo;
import com.sun.addressbook.ABSession;
import com.sun.addressbook.ABStore;
import com.sun.addressbook.ABStoreException;
import com.sun.addressbook.AddressBook;
import com.sun.addressbook.MissingPropertiesException;
import com.sun.addressbook.OperationNotSupportedException;
import com.sun.ssoadapter.ab.pim.JPimABConstants;
import com.sun.ssoadapter.ab.pim.JPimAddressBook;
import com.sun.ssoadapter.ab.pim.SchemaElements;

public class JPimABStore
extends ABStore
implements JPimABConstants {
    private PimContainer pimContainer = null;
    protected PimAddressBook topLevelPimAB = null;
    private SchemaElements schemaElements = new SchemaElements();

    public SchemaElements getSchemaElements() {
        return this.schemaElements;
    }

    protected PimContainerType getPimContainerType(ABSession session) {
        return PimContainerType.EXCHANGE;
    }

    public void init(ABSession session) throws ABStoreException, MissingPropertiesException {
        if (this.schemaElements.getAllCommonPropertyNames() == null) {
            throw new MissingPropertiesException("Cannot find PropertiesMap: EntryAndContactItem");
        }
        PimContainerType containerType = this.getPimContainerType(session);
        try {
            this.pimContainer = PimFactory.getContainer((PimContainerType)containerType);
        }
        catch (Exception e) {
            throw new ABStoreException(e.toString());
        }
        this.session = session;
        try {
            PimUserInfo pimUserInfo = this.pimContainer.addUserInfo();
            this.init(session, pimUserInfo);
        }
        catch (PimException pe) {
            throw new ABStoreException("PimUserInfo set failed: " + (Object)((Object)pe));
        }
    }

    public void init(ABSession session, PimUserInfo pimC) throws MissingPropertiesException {
    }

    public void connect() throws ABStoreException {
        if (this.pimContainer == null) {
            throw new ABStoreException("PimContainer == null");
        }
        String abType = this.session.getProperty("ab.type");
        PimFolderType type = this.getFolderType(abType);
        try {
            this.pimContainer.logon();
            this.postConnect(this.pimContainer);
            this.topLevelPimAB = (PimAddressBook)this.pimContainer.getFolder(type);
        }
        catch (PimException pe) {
            pe.printStackTrace();
            throw new ABStoreException("Connect failed: " + (Object)((Object)pe));
        }
    }

    protected void postConnect(PimContainer pimContainer) throws ABStoreException {
    }

    public void disconnect() throws ABStoreException {
        if (this.pimContainer == null) {
            throw new ABStoreException("PimContainer == null");
        }
        try {
            this.pimContainer.logoff();
        }
        catch (PimException pe) {
            throw new ABStoreException("Disconnect failed: " + (Object)((Object)pe));
        }
    }

    public boolean isConnected() throws ABStoreException {
        return true;
    }

    public String[] getAddressBooks() throws ABStoreException, OperationNotSupportedException {
        String[] list = null;
        try {
            PimFolders folders = this.topLevelPimAB.getFolders();
            int count = folders.getCount();
            list = new String[count];
            for (int i = 0; i < count; ++i) {
                String id;
                list[i] = id = folders.getFolder(i).getID();
            }
        }
        catch (PimException pe) {
            pe.printStackTrace();
            throw new ABStoreException("getAddressBooks() failed: " + (Object)((Object)pe));
        }
        return list;
    }

    protected String getDefaultAbID() throws ABStoreException {
        return "";
    }

    protected PimFolderType getFolderType(String id) {
        PimFolderType type = PimFolderType.PERSONAL_ADDRESS_BOOK;
        if (id != null) {
            if (id.equalsIgnoreCase("pab")) {
                type = PimFolderType.PERSONAL_ADDRESS_BOOK;
            } else if (id.equalsIgnoreCase("gal")) {
                type = PimFolderType.GLOBAL_ADDRESS_BOOK;
            }
        }
        return type;
    }

    public AddressBook openAddressBook(String abID) throws ABStoreException {
        String abType = this.session.getProperty("ab.type");
        PimFolderType type = this.getFolderType(abType);
        try {
            this.topLevelPimAB = (PimAddressBook)this.pimContainer.getFolder(type);
        }
        catch (PimException pie) {
            pie.printStackTrace();
            throw new ABStoreException("open address book getFolder() failed: " + (Object)((Object)pie));
        }
        PimAddressBook pBook = this.topLevelPimAB;
        if (abID != null && !abID.trim().equals("")) {
            try {
                PimFolders pimFolders = pBook.getFolders();
                pBook = (PimAddressBook)pimFolders.getFolder(abID);
            }
            catch (PimException pe) {
                pe.printStackTrace();
                throw new ABStoreException("getFolder() failed: " + (Object)((Object)pe));
            }
        }
        JPimAddressBook aBook = new JPimAddressBook(this, pBook, abID);
        return aBook;
    }

    public void closeAddressBook(AddressBook ab) throws ABStoreException {
        ab = null;
    }
}

