/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.ab.exchange;

import com.aligo.pim.PimContainerType;
import com.aligo.pim.PimUserInfoParameter;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimAddressBook;
import com.aligo.pim.interfaces.PimFolders;
import com.aligo.pim.interfaces.PimUserInfo;
import com.sun.addressbook.ABSession;
import com.sun.addressbook.ABStoreException;
import com.sun.addressbook.AddressBook;
import com.sun.addressbook.MissingPropertiesException;
import com.sun.ssoadapter.ab.exchange.ExchangeAddressBook;
import com.sun.ssoadapter.ab.pim.JPimABStore;
import java.util.StringTokenizer;

public class ExchangeABStore
extends JPimABStore {
    public PimContainerType getPimContainerType(ABSession session) {
        String pimInterfaceType = session.getProperty("ab.pimInterfaceType");
        if (pimInterfaceType != null && pimInterfaceType.equals("webdav")) {
            return PimContainerType.EXCHANGE_WEBDAV;
        }
        return PimContainerType.EXCHANGE;
    }

    public void init(ABSession session, PimUserInfo pimU) throws MissingPropertiesException {
        String userName = session.getProperty("ab.userName");
        String userPasswd = session.getProperty("ab.userPassword");
        String userDomain = session.getProperty("ab.userDomain");
        String jPimHost = session.getProperty("ab.host");
        String jPimPort = session.getProperty("ab.port");
        String ocxHost = session.getProperty("ab.ocxhost");
        String authHost = session.getProperty("ab.authhost");
        String pimInterfaceType = session.getProperty("ab.pimInterfaceType");
        String usersBaseDn = session.getProperty("ab.usersBaseDn");
        if (userName == null) {
            throw new MissingPropertiesException("Cannot connect to JPim server:: Missing Property: ab.userName");
        }
        if (userPasswd == null) {
            throw new MissingPropertiesException("Cannot connect to JPim server:: Missing Property: ab.userPassword");
        }
        if (jPimHost == null) {
            throw new MissingPropertiesException("Cannot connect to JPim server:: Missing Property: ab.host");
        }
        if (jPimPort == null) {
            jPimPort = "80";
        }
        if (userDomain == null) {
            throw new MissingPropertiesException("Cannot connect to JPim server:: Missing Property: ab.userDomain");
        }
        pimU.set(PimUserInfoParameter.DEBUG, "true");
        if (pimInterfaceType != null && pimInterfaceType.equals("webdav")) {
            pimU.set(PimUserInfoParameter.EXCHANGE_USERNAME, userName);
            pimU.set(PimUserInfoParameter.EXCHANGE_PASSWORD, userPasswd);
            pimU.set(PimUserInfoParameter.EXCHANGE_MAILBOX, userName);
            String webdav_url = "http://" + jPimHost + ":" + jPimPort;
            pimU.set(PimUserInfoParameter.EXCHANGE_WEBDAV_URL, webdav_url);
            String ldapUserName = userDomain + "\\" + userName;
            if (usersBaseDn == null || usersBaseDn.equals("")) {
                String ubaseDn = "CN=Users";
                StringTokenizer strTok = new StringTokenizer(jPimHost, ".");
                while (strTok.hasMoreTokens()) {
                    ubaseDn = ubaseDn + ",DC=" + strTok.nextToken();
                }
                usersBaseDn = ubaseDn;
            }
            System.out.println("ldap userName=" + ldapUserName + " usersBaseDn=" + usersBaseDn);
            pimU.set(PimUserInfoParameter.JNDI_LDAP_SERVER, jPimHost);
            pimU.set(PimUserInfoParameter.JNDI_LDAP_USERNAME, ldapUserName);
            pimU.set(PimUserInfoParameter.JNDI_LDAP_PASSWORD, userPasswd);
            pimU.set(PimUserInfoParameter.JNDI_LDAP_PORT, "389");
            pimU.set(PimUserInfoParameter.JNDI_LDAP_AB_BASE, usersBaseDn);
            pimU.set(PimUserInfoParameter.JNDI_LDAP_TRY_ANONYMOUS_FALLBACK, "true");
        } else {
            pimU.set(PimUserInfoParameter.EXCHANGE_USERNAME, userName);
            pimU.set(PimUserInfoParameter.EXCHANGE_PASSWORD, userPasswd);
            pimU.set(PimUserInfoParameter.EXCHANGE_NT_DOMAIN, userDomain);
            pimU.set(PimUserInfoParameter.EXCHANGE_SERVER, jPimHost);
            if (ocxHost != null) {
                pimU.set(PimUserInfoParameter.EXCHANGE_OCXHOST_LOCATION, ocxHost);
            }
            if (authHost != null) {
                pimU.set(PimUserInfoParameter.EXCHANGE_ALIGOAUTH_LOCATION, authHost);
            }
        }
        boolean debugEnabled = new Boolean(session.getProperty("ab.pim.debug"));
        if (debugEnabled) {
            pimU.set(PimUserInfoParameter.DEBUG, "true");
        }
    }

    public AddressBook openAddressBook(String abID) throws ABStoreException {
        PimAddressBook pBook = this.topLevelPimAB;
        if (abID != null && !abID.trim().equals("")) {
            try {
                PimFolders pimFolders = pBook.getFolders();
                pBook = (PimAddressBook)pimFolders.getFolder(abID);
            }
            catch (PimException pe) {
                pe.printStackTrace();
                throw new ABStoreException("getFolder() failed: " + (Object)((Object)pe));
            }
        }
        ExchangeAddressBook aBook = new ExchangeAddressBook(this, pBook, abID);
        return aBook;
    }
}

